/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.controls;

import java.util.Arrays;
import java.util.List;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ILatchable;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.signals.OneLogicInPin;
import thunderheadeng.units.UnitDouble;

public class TimeDelayCtrl
extends AControl
implements ILatchable {
    static final long serialVersionUID = 1L;
    private UnitDouble d_timeDelay;
    private IInPin d_inPin;
    private IOutPin d_outPin;

    public TimeDelayCtrl(UnitDouble unitDouble) {
        this.d_timeDelay = unitDouble;
        this.d_inPin = new OneLogicInPin(this);
        this.d_outPin = new LogicOutPin(this);
    }

    @Override
    protected String getDefaultName() {
        return Intl.intl("tdelay");
    }

    @Override
    public boolean latches(ILogicOutPin iLogicOutPin) {
        return false;
    }

    @Override
    public Object clone() {
        TimeDelayCtrl timeDelayCtrl = (TimeDelayCtrl)super.clone();
        timeDelayCtrl.d_inPin = (IInPin)this.d_inPin.clone(timeDelayCtrl);
        timeDelayCtrl.d_outPin = (IOutPin)this.d_outPin.clone(timeDelayCtrl);
        return timeDelayCtrl;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TimeDelayCtrl)) {
            return false;
        }
        TimeDelayCtrl timeDelayCtrl = (TimeDelayCtrl)object;
        return super.equals(object) && this.d_timeDelay.equals(timeDelayCtrl.d_timeDelay) && this.d_inPin.equals(timeDelayCtrl.d_inPin);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 141726698 + this.d_inPin.hashCode() + this.d_timeDelay.hashCode();
    }

    @Override
    public boolean isEquiv(Object object) {
        return this.equals(object);
    }

    @Override
    public boolean isWire() {
        return this.d_timeDelay.getValue(SI.SECOND) == 0.0;
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_outPin);
    }

    public void setTimeDelay(UnitDouble unitDouble) {
        this.d_timeDelay = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getTimeDelay() {
        return this.d_timeDelay;
    }
}

