/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.controls;

import java.util.Arrays;
import java.util.List;
import pyrosim.Intl;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ILatchable;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.signals.OneLogicInPin;

public class LatchCtrl
extends AControl
implements ILatchable {
    static final long serialVersionUID = 1L;
    private IInPin d_inPin = new OneLogicInPin(this);
    private LogicOutPin d_outPin = new LogicOutPin(this);

    @Override
    protected String getDefaultName() {
        return Intl.intl("latch");
    }

    @Override
    public boolean latches(ILogicOutPin iLogicOutPin) {
        return true;
    }

    @Override
    public boolean isWire() {
        if (this.getInputPin().getConnections().size() == 1) {
            CustomCtrl customCtrl;
            ISignalSource iSignalSource = this.getInputPin().getConnectedSources().iterator().next();
            if (iSignalSource instanceof Timer) {
                return true;
            }
            if (iSignalSource instanceof CustomCtrl ? (customCtrl = (CustomCtrl)iSignalSource).getTripValues().size() == 1 && customCtrl.getInputPin().getConnections().size() == 1 && customCtrl.getInputPin().getConnections().iterator().next() instanceof Clock : iSignalSource instanceof LatchCtrl) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        LatchCtrl latchCtrl = (LatchCtrl)super.clone();
        latchCtrl.d_inPin = (IInPin)this.d_inPin.clone(latchCtrl);
        latchCtrl.d_outPin = (LogicOutPin)this.d_outPin.clone(latchCtrl);
        return latchCtrl;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof LatchCtrl)) {
            return false;
        }
        LatchCtrl latchCtrl = (LatchCtrl)object;
        return super.equals(object) && this.d_inPin.equals(latchCtrl.d_inPin);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 210174 + this.d_inPin.hashCode();
    }

    @Override
    public boolean isEquiv(Object object) {
        return this.equals(object);
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_outPin);
    }
}

