/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.controls;

import java.util.Arrays;
import java.util.List;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.signals.AOneDoubleInPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.LogicOutPin;
import thunderheadeng.units.UnitDouble;

public class DeadbandCtrl
extends AControl {
    static final long serialVersionUID = 1L;
    public static final int TRIP_LOWER = 0;
    public static final int TRIP_UPPER = 1;
    private IInPin d_inPin;
    private IOutPin d_outPin;
    private int d_tripDir;
    private UnitDouble d_lowerBound;
    private UnitDouble d_upperBound;

    public DeadbandCtrl() {
        this(0, null, null);
    }

    public DeadbandCtrl(int n, UnitDouble unitDouble, UnitDouble unitDouble2) {
        this.d_tripDir = n;
        this.d_lowerBound = unitDouble;
        this.d_upperBound = unitDouble2;
        this.d_inPin = new AOneDoubleInPin(this){
            static final long serialVersionUID = -8988340789408151109L;

            @Override
            public void updateInputUnit(Unit unit) {
                DeadbandCtrl.this.d_lowerBound = DeadbandCtrl.this.d_lowerBound.reinterpret(unit);
                DeadbandCtrl.this.d_upperBound = DeadbandCtrl.this.d_upperBound.reinterpret(unit);
                DeadbandCtrl.this.changedEvt(new Object[0]);
            }

            @Override
            protected void changeInputUnit(Unit unit) {
                DeadbandCtrl.this.d_lowerBound = new UnitDouble(DeadbandCtrl.this.d_lowerBound.getValueNoUnit(), unit);
                DeadbandCtrl.this.d_upperBound = new UnitDouble(DeadbandCtrl.this.d_upperBound.getValueNoUnit(), unit);
                DeadbandCtrl.this.changedEvt(new Object[0]);
            }
        };
        this.d_outPin = new LogicOutPin(this);
    }

    @Override
    protected String getDefaultName() {
        return Intl.intl("deadband");
    }

    @Override
    public Object clone() {
        DeadbandCtrl deadbandCtrl = (DeadbandCtrl)super.clone();
        deadbandCtrl.d_inPin = (IInPin)this.d_inPin.clone(deadbandCtrl);
        deadbandCtrl.d_outPin = (IOutPin)this.d_outPin.clone(deadbandCtrl);
        return deadbandCtrl;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DeadbandCtrl)) {
            return false;
        }
        DeadbandCtrl deadbandCtrl = (DeadbandCtrl)object;
        return super.equals(object) && this.d_tripDir == deadbandCtrl.d_tripDir && this.d_lowerBound.equals(deadbandCtrl.d_lowerBound) && this.d_upperBound.equals(deadbandCtrl.d_upperBound) && this.d_inPin.equals(deadbandCtrl.d_inPin);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 215774 + this.d_inPin.hashCode() + this.d_tripDir + this.d_lowerBound.hashCode() + this.d_upperBound.hashCode();
    }

    @Override
    public boolean isEquiv(Object object) {
        return this.equals(object);
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_outPin);
    }

    @Override
    public boolean isWire() {
        return false;
    }

    public int getTripDirection() {
        return this.d_tripDir;
    }

    public UnitDouble getLowerBound() {
        return this.d_lowerBound;
    }

    public UnitDouble getUpperBound() {
        return this.d_upperBound;
    }
}

