/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.controls;

import java.util.Arrays;
import java.util.List;
import pyrosim.Intl;
import pyrosim.domain.INamed;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.Util;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ILatchable;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.signals.OneLogicInPin;

public class ControlBridge
extends AControl
implements INamed,
ILatchable {
    static final long serialVersionUID = 1L;
    private IInPin d_inPin = new OneLogicInPin(this);
    private IOutPin d_outPin = new LogicOutPin(this);

    public ControlBridge(String string) {
        super(string);
    }

    @Override
    protected String getDefaultName() {
        return Intl.intl("bridge");
    }

    @Override
    public boolean latches(ILogicOutPin iLogicOutPin) {
        return Util.inputLatches(this.d_inPin);
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_outPin);
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public Object clone() {
        ControlBridge controlBridge = (ControlBridge)super.clone();
        controlBridge.d_inPin = (IInPin)this.d_inPin.clone(controlBridge);
        controlBridge.d_outPin = (IOutPin)this.d_outPin.clone(controlBridge);
        return controlBridge;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ControlBridge)) {
            return false;
        }
        ControlBridge controlBridge = (ControlBridge)object;
        return super.equals(object) && this.d_inPin.equals(controlBridge.d_inPin);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 153696506 + this.d_inPin.hashCode();
    }

    @Override
    public boolean isEquiv(Object object) {
        return this.equals(object);
    }

    @Override
    public boolean isWire() {
        return true;
    }

    @Override
    public void setName(String string) {
        ISignalSource iSignalSource;
        this.pauseUpdates();
        super.setName(string);
        ISignalSource iSignalSource2 = iSignalSource = !this.d_inPin.getConnections().isEmpty() ? this.d_inPin.getConnectedSources().iterator().next() : null;
        if (iSignalSource instanceof IControl) {
            ((IControl)iSignalSource).setName(string);
        }
        this.resumeUpdates();
    }
}

