/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import pyrosim.domain.TimeFunction;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class TempRegulation
implements Serializable {
    static final long serialVersionUID = 1L;
    public final UnitDouble d_netHeatFlux;
    public final UnitDouble d_temperature;
    public final UnitDouble d_heatFlux;
    public final TimeFunction d_rampup;
    public final double d_emissivity;
    public final UnitDouble d_htCoef;
    public final ThermalBCs d_thermalBCs;
    public final boolean d_logarithmic;
    public final boolean d_calculatedTemp;

    private TempRegulation(ThermalBCs thermalBCs, UnitDouble unitDouble, boolean bl, boolean bl2) {
        this.d_thermalBCs = thermalBCs;
        this.d_htCoef = unitDouble;
        this.d_logarithmic = bl;
        this.d_calculatedTemp = bl2;
        this.d_netHeatFlux = null;
        this.d_temperature = null;
        this.d_heatFlux = null;
        this.d_rampup = null;
        this.d_emissivity = 0.0;
    }

    public static TempRegulation newNetHeatFluxTR(UnitDouble unitDouble, double d, UnitDouble unitDouble2, boolean bl) {
        return new TempRegulation(new ThermalBCs(unitDouble, null, null, null, d, TempRegulation.getDefaultAdiabatic()), unitDouble2, bl, TempRegulation.getDefaultCalculatedTemp());
    }

    public static TempRegulation newFixedHeatFluxTR(UnitDouble unitDouble, UnitDouble unitDouble2, TimeFunction timeFunction, double d, UnitDouble unitDouble3, boolean bl) {
        return new TempRegulation(new ThermalBCs(null, unitDouble, unitDouble2, timeFunction, d, TempRegulation.getDefaultAdiabatic()), unitDouble3, bl, TempRegulation.getDefaultCalculatedTemp());
    }

    public static TempRegulation newFixedTempTR(UnitDouble unitDouble, double d, UnitDouble unitDouble2, boolean bl) {
        return new TempRegulation(new ThermalBCs(null, unitDouble, null, null, d, TempRegulation.getDefaultAdiabatic()), unitDouble2, bl, TempRegulation.getDefaultCalculatedTemp());
    }

    public static TempRegulation newCalcTempTR(double d, UnitDouble unitDouble, boolean bl) {
        return new TempRegulation(new ThermalBCs(null, null, null, null, d, TempRegulation.getDefaultAdiabatic()), unitDouble, bl, true);
    }

    public static TempRegulation newDefault() {
        return new TempRegulation(new ThermalBCs(null, null, null, null, TempRegulation.getDefaultEmissivity(), TempRegulation.getDefaultAdiabatic()), TempRegulation.getDefaultHtCoef(), TempRegulation.getDefaultLog(), TempRegulation.getDefaultCalculatedTemp());
    }

    public static TempRegulation newAdiabaticTR(UnitDouble unitDouble, boolean bl) {
        return new TempRegulation(new ThermalBCs(null, null, null, null, 1.0, true), unitDouble, bl, TempRegulation.getDefaultCalculatedTemp());
    }

    public static double getDefaultEmissivity() {
        return 0.9;
    }

    public static UnitDouble getDefaultHtCoef() {
        return null;
    }

    public static boolean getDefaultLog() {
        return false;
    }

    public static boolean getDefaultAdiabatic() {
        return false;
    }

    public static boolean getDefaultCalculatedTemp() {
        return false;
    }

    public static TempRegulation legacyDefaultTR() {
        return new TempRegulation(new ThermalBCs(null, null, SIUS.newud(0.0, 33), TimeFunction.newDefault(), 0.9, false), null, false, false);
    }

    public boolean isNetHeatFluxTR() {
        return this.d_thermalBCs.d_netHeatFlux != null;
    }

    public boolean isAdiabaticTR() {
        return this.d_thermalBCs.d_adiabatic;
    }

    public boolean isFixedTempTR() {
        return !this.isNetHeatFluxTR() && !this.isAdiabaticTR() && !this.isGrossFluxTR();
    }

    public boolean isCalcTempTR() {
        return this.d_calculatedTemp;
    }

    public boolean isGrossFluxTR() {
        return this.d_thermalBCs.d_heatFlux != null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TempRegulation)) {
            return false;
        }
        TempRegulation tempRegulation = (TempRegulation)object;
        return theUtil.equal(this.d_htCoef, tempRegulation.d_htCoef) && this.d_logarithmic == tempRegulation.d_logarithmic && this.d_thermalBCs.equals(tempRegulation.d_thermalBCs);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        UnitDouble unitDouble = this.d_heatFlux;
        if (objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 63 && this.d_heatFlux.getValueNoUnit() == 0.0) {
            unitDouble = null;
        }
        if (this.d_thermalBCs == null) {
            try {
                Util.assignFinalField(this, "d_thermalBCs", new ThermalBCs(this.d_netHeatFlux, this.d_temperature, unitDouble, this.d_rampup, this.d_emissivity, false));
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
    }

    public static class ThermalBCs
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_temperature;
        public final UnitDouble d_heatFlux;
        public final UnitDouble d_netHeatFlux;
        public final double d_emissivity;
        public final TimeFunction d_rampup;
        public final boolean d_adiabatic;

        public ThermalBCs(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, TimeFunction timeFunction, double d, boolean bl) {
            this.d_temperature = unitDouble2;
            this.d_heatFlux = unitDouble3;
            this.d_netHeatFlux = unitDouble;
            this.d_emissivity = d;
            this.d_rampup = timeFunction;
            this.d_adiabatic = bl;
        }

        public int hashCode() {
            int n = 7;
            n = 31 * n + theUtil.hashCode(this.d_temperature);
            n = 31 * n + theUtil.hashCode(this.d_heatFlux);
            n = 31 * n + theUtil.hashCode(this.d_netHeatFlux);
            n = 31 * n + theUtil.hashCode(this.d_rampup);
            n = 31 * n + theUtil.hashCode(this.d_emissivity);
            n = 31 * n + theUtil.hashCode(this.d_adiabatic);
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ThermalBCs)) {
                return false;
            }
            ThermalBCs thermalBCs = (ThermalBCs)object;
            return theUtil.equal(this.d_temperature, thermalBCs.d_temperature) && theUtil.equal(this.d_heatFlux, thermalBCs.d_heatFlux) && theUtil.equal(this.d_netHeatFlux, thermalBCs.d_netHeatFlux) && theUtil.equal(this.d_rampup, thermalBCs.d_rampup) && this.d_emissivity == thermalBCs.d_emissivity && this.d_adiabatic == thermalBCs.d_adiabatic;
        }
    }
}

