/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.jscience.physics.units.SI;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.domain.boundcond.mat.ThermalProps;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.HeatRelease;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISlip;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.TempRegulation;
import thunderheadeng.units.UnitDouble;

public class SurfaceTest
extends TestCase {
    private final String MATERIAL1 = "MAT1";
    private final String MATERIAL2 = "MAT2";
    private final String MATERIAL3 = "MAT3";
    private final String MATERIAL4 = "MAT4";

    public void testNullSurface() {
        Surface surface = new Surface(null, null, null);
        SurfaceTest.assertNull((Object)surface.getName());
        SurfaceTest.assertNull((Object)surface.getColor());
        SurfaceTest.assertNull((Object)surface.getAppearance());
    }

    public void testSurfDesc() {
        Surface surface = new Surface(null, null, null);
        SurfaceTest.assertNotNull((Object)surface.getSurfDesc());
        surface.setSurfDesc(new LayeredSurfDesc(IGeometry.DEFAULT, ISlip.DEFAULT, new Fuel.MaterialReac(), new SurfComposition(), new SpecInjList(), new ParticleInjection(), false, null, TempRegulation.newDefault()));
        SurfaceTest.assertTrue((boolean)(surface.getSurfDesc() instanceof LayeredSurfDesc));
        SurfaceTest.assertNotNull((Object)((LayeredSurfDesc)surface.getSurfDesc()).d_iReac);
        SurfaceTest.assertNotNull((Object)((LayeredSurfDesc)surface.getSurfDesc()).d_partInj);
        SurfaceTest.assertNotNull((Object)((LayeredSurfDesc)surface.getSurfDesc()).d_surfComp);
        surface.setSurfDesc(new InFlowSurfDesc(new AirFlow(), TempRegulation.newDefault()));
        SurfaceTest.assertTrue((boolean)(surface.getSurfDesc() instanceof InFlowSurfDesc));
        SurfaceTest.assertNotNull((Object)((InFlowSurfDesc)surface.getSurfDesc()).d_airFlow);
        surface.setSurfDesc(new BurnerSurfDesc(new HeatRelease(), new ParticleInjection(), TempRegulation.newDefault(), IGeometry.DEFAULT));
        SurfaceTest.assertTrue((boolean)(surface.getSurfDesc() instanceof BurnerSurfDesc));
        SurfaceTest.assertNotNull((Object)((BurnerSurfDesc)surface.getSurfDesc()).d_heatRelease);
        SurfaceTest.assertNotNull((Object)((BurnerSurfDesc)surface.getSurfDesc()).d_partInj);
        surface.setSurfDesc(new BlowerSurfDesc(TempRegulation.newDefault(), new AirFlow(), new ParticleInjection(), IGeometry.DEFAULT));
        SurfaceTest.assertTrue((boolean)(surface.getSurfDesc() instanceof BlowerSurfDesc));
        SurfaceTest.assertNotNull((Object)((BlowerSurfDesc)surface.getSurfDesc()).d_tempReg);
        SurfaceTest.assertNotNull((Object)((BlowerSurfDesc)surface.getSurfDesc()).d_partInj);
        SurfaceTest.assertNotNull((Object)((BlowerSurfDesc)surface.getSurfDesc()).d_airFlow);
    }

    public void testSurfComposition() {
        Material material = new Material("MAT1", new SolidPyrolysis(), new ThermalProps());
        Material material2 = new Material("MAT2", new SolidPyrolysis(), new ThermalProps());
        Material material3 = new Material("MAT3", new SolidPyrolysis(), new ThermalProps());
        Material material4 = new Material("MAT4", new SolidPyrolysis(), new ThermalProps());
        SurfComposition.SurfLayer.SurfComponent surfComponent = new SurfComposition.SurfLayer.SurfComponent(1.0, material);
        SurfComposition.SurfLayer.SurfComponent surfComponent2 = new SurfComposition.SurfLayer.SurfComponent(2.0, material2);
        SurfComposition.SurfLayer.SurfComponent surfComponent3 = new SurfComposition.SurfLayer.SurfComponent(3.0, material3);
        SurfComposition.SurfLayer.SurfComponent surfComponent4 = new SurfComposition.SurfLayer.SurfComponent(4.0, material4);
        ArrayList<SurfComposition.SurfLayer.SurfComponent> arrayList = new ArrayList<SurfComposition.SurfLayer.SurfComponent>(2);
        arrayList.add(surfComponent);
        arrayList.add(surfComponent2);
        ArrayList<SurfComposition.SurfLayer.SurfComponent> arrayList2 = new ArrayList<SurfComposition.SurfLayer.SurfComponent>(2);
        arrayList2.add(surfComponent3);
        arrayList2.add(surfComponent4);
        ArrayList<SurfComposition.SurfLayer.SurfComponent> arrayList3 = new ArrayList<SurfComposition.SurfLayer.SurfComponent>(2);
        arrayList3.add(surfComponent);
        arrayList3.add(surfComponent3);
        ArrayList<SurfComposition.SurfLayer.SurfComponent> arrayList4 = new ArrayList<SurfComposition.SurfLayer.SurfComponent>(2);
        arrayList4.add(surfComponent);
        arrayList4.add(surfComponent2);
        arrayList4.add(surfComponent3);
        arrayList4.add(surfComponent4);
        SurfComposition.SurfLayer surfLayer = new SurfComposition.SurfLayer(new UnitDouble(1.0, SI.METER), arrayList);
        SurfComposition.SurfLayer surfLayer2 = new SurfComposition.SurfLayer(new UnitDouble(1.0, SI.METER), arrayList2);
        SurfComposition.SurfLayer surfLayer3 = new SurfComposition.SurfLayer(new UnitDouble(1.0, SI.METER), arrayList3);
        SurfComposition.SurfLayer surfLayer4 = new SurfComposition.SurfLayer(new UnitDouble(1.0, SI.METER), arrayList4);
        ArrayList<SurfComposition.SurfLayer> arrayList5 = new ArrayList<SurfComposition.SurfLayer>();
        arrayList5.add(surfLayer);
        arrayList5.add(surfLayer2);
        ArrayList<SurfComposition.SurfLayer> arrayList6 = new ArrayList<SurfComposition.SurfLayer>();
        arrayList6.add(surfLayer3);
        arrayList6.add(surfLayer4);
        ArrayList<SurfComposition.SurfLayer> arrayList7 = new ArrayList<SurfComposition.SurfLayer>();
        arrayList7.add(surfLayer);
        arrayList7.add(surfLayer3);
        ArrayList<SurfComposition.SurfLayer> arrayList8 = new ArrayList<SurfComposition.SurfLayer>();
        arrayList8.add(surfLayer);
        arrayList8.add(surfLayer2);
        arrayList8.add(surfLayer3);
        arrayList8.add(surfLayer4);
        TimeFunction timeFunction = TimeFunction.newDefault();
        SurfComposition surfComposition = new SurfComposition(new UnitDouble(5.0, SI.METER), timeFunction, new Backing.Exposed(), null, arrayList5);
        SurfComposition surfComposition2 = new SurfComposition(new UnitDouble(5.0, SI.METER), timeFunction, new Backing.Exposed(), null, arrayList6);
        SurfComposition surfComposition3 = new SurfComposition(new UnitDouble(5.0, SI.METER), timeFunction, new Backing.Exposed(), null, arrayList7);
        SurfComposition surfComposition4 = new SurfComposition(new UnitDouble(5.0, SI.METER), timeFunction, new Backing.Exposed(), null, arrayList8);
        Surface surface = new Surface(null, null, null, SurfaceTest.newDesc(surfComposition));
        Surface surface2 = new Surface(null, null, null, SurfaceTest.newDesc(surfComposition2));
        Surface surface3 = new Surface(null, null, null, SurfaceTest.newDesc(surfComposition3));
        Surface surface4 = new Surface(null, null, null, SurfaceTest.newDesc(surfComposition4));
        SurfaceTest.assertTrue((((LayeredSurfDesc)surface.getSurfDesc()).d_surfComp.d_layers.size() == 2 ? 1 : 0) != 0);
        SurfaceTest.assertTrue((((LayeredSurfDesc)surface2.getSurfDesc()).d_surfComp.d_layers.size() == 2 ? 1 : 0) != 0);
        SurfaceTest.assertTrue((((LayeredSurfDesc)surface3.getSurfDesc()).d_surfComp.d_layers.size() == 2 ? 1 : 0) != 0);
        SurfaceTest.assertTrue((((LayeredSurfDesc)surface4.getSurfDesc()).d_surfComp.d_layers.size() == 4 ? 1 : 0) != 0);
        SurfaceTest.assertTrue((((LayeredSurfDesc)surface.getSurfDesc()).d_surfComp.d_layers.get(0).getComponents().size() == 2 ? 1 : 0) != 0);
        SurfaceTest.assertTrue((((LayeredSurfDesc)surface.getSurfDesc()).d_surfComp.d_layers.get(1).getComponents().size() == 2 ? 1 : 0) != 0);
        SurfaceTest.assertTrue((((LayeredSurfDesc)surface2.getSurfDesc()).d_surfComp.d_layers.get(0).getComponents().size() == 2 ? 1 : 0) != 0);
        SurfaceTest.assertTrue((((LayeredSurfDesc)surface2.getSurfDesc()).d_surfComp.d_layers.get(1).getComponents().size() == 4 ? 1 : 0) != 0);
        SurfaceTest.assertTrue((((LayeredSurfDesc)surface3.getSurfDesc()).d_surfComp.d_layers.get(0).getComponents().size() == 2 ? 1 : 0) != 0);
        SurfaceTest.assertTrue((((LayeredSurfDesc)surface3.getSurfDesc()).d_surfComp.d_layers.get(1).getComponents().size() == 2 ? 1 : 0) != 0);
        SurfaceTest.assertTrue((((LayeredSurfDesc)surface4.getSurfDesc()).d_surfComp.d_layers.get(0).getComponents().size() == 2 ? 1 : 0) != 0);
        SurfaceTest.assertTrue((((LayeredSurfDesc)surface4.getSurfDesc()).d_surfComp.d_layers.get(1).getComponents().size() == 2 ? 1 : 0) != 0);
        SurfaceTest.assertTrue((((LayeredSurfDesc)surface4.getSurfDesc()).d_surfComp.d_layers.get(2).getComponents().size() == 2 ? 1 : 0) != 0);
        SurfaceTest.assertTrue((((LayeredSurfDesc)surface4.getSurfDesc()).d_surfComp.d_layers.get(3).getComponents().size() == 4 ? 1 : 0) != 0);
    }

    private static ISurfDesc newDesc(SurfComposition surfComposition) {
        return new LayeredSurfDesc(IGeometry.DEFAULT, ISlip.DEFAULT, new Fuel.MaterialReac(), surfComposition, null, null, false, null, TempRegulation.newDefault());
    }
}

