/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.util.Util;
import thunderheadeng.gui.ColorIcon;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatUtil;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class Surface
extends NamedPyroObject
implements IMaterial,
IDirectDependent,
ICustomFDSPropsContainer {
    static final long serialVersionUID = 1L;
    public static final Object EVT_APPEARANCE = new Object();
    public static final Object EVT_COLOR = new Object();
    public static final Object EVT_FYI = new Object();
    private MatAttrs d_defAttrs = new MatAttrs();
    private Material d_appearance;
    @SkipDep
    private transient Icon[] d_icons = null;
    private ISurfDesc d_surfDesc = null;
    private String d_fyi;
    private CustomFDSProps d_customFDSProps;

    public static ISurfDesc newBasicDesc() {
        return new SurfDescStatic.Inert();
    }

    public static boolean isBasicDesc(ISurfDesc iSurfDesc) {
        return iSurfDesc instanceof SurfDescStatic.Inert;
    }

    public Surface(String string) {
        this(string, new Color(255, 204, 102), null);
    }

    public Surface(String string, Color color, Material material) {
        this(string, color, material, Surface.newBasicDesc());
    }

    public Surface(String string, Color color, Material material, ISurfDesc iSurfDesc) {
        super(string);
        this.d_appearance = material;
        this.d_surfDesc = iSurfDesc;
        this.d_fyi = "";
        this.d_customFDSProps = CustomFDSProps.EMPTY;
        this.setColor(color);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_customFDSProps == null) {
            this.d_customFDSProps = CustomFDSProps.EMPTY;
        }
    }

    @Override
    public Surface clone() {
        Surface surface = (Surface)super.clone();
        return surface;
    }

    @Override
    public IMatAttrs getAttributes() {
        if (this.d_appearance != null) {
            return this.d_appearance.getAttributes();
        }
        return this.d_defAttrs;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Surface)) {
            return false;
        }
        Surface surface = (Surface)object;
        return super.equals(object) && this.d_defAttrs != null && surface.d_defAttrs != null && MatUtil.makeImagesHashable(this.d_defAttrs).equals(surface.d_defAttrs) && Surface.equal(this.d_appearance, surface.d_appearance) && this.d_surfDesc.equals(surface.d_surfDesc) && this.d_customFDSProps.equals(surface.d_customFDSProps);
    }

    private static boolean equal(Material material, Material material2) {
        return material == null ? material2 == null : material.pseudoEquals(material2);
    }

    @Override
    public void getCustomFDSTypes(Collection<String> collection) {
        collection.add("SURF");
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String string) {
        return this.d_customFDSProps;
    }

    @Override
    public void setCustomFDSProps(String string, CustomFDSProps customFDSProps) {
        this.d_customFDSProps = customFDSProps;
        this.changedEvt(new Object[0]);
    }

    public void setSurfDesc(ISurfDesc iSurfDesc) {
        this.d_surfDesc = iSurfDesc;
        this.changedEvt(new Object[0]);
    }

    public ISurfDesc getSurfDesc() {
        return this.d_surfDesc;
    }

    public Color getColor() {
        return this.d_defAttrs.getDiffuseColorWithOpacity();
    }

    public void setColor(Color color) {
        if (this.getColor().equals(color)) {
            return;
        }
        this.d_defAttrs = this.d_defAttrs.applyColorToDiffuseAndOpacity(color);
        this.changedEvt(EVT_COLOR);
    }

    public Material getAppearance() {
        return this.d_appearance;
    }

    public void setAppearance(Material material) {
        if (this.d_appearance == material) {
            return;
        }
        this.d_appearance = material;
        this.changedEvt(EVT_APPEARANCE);
    }

    public String getFYI() {
        return this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(EVT_FYI);
    }

    @Override
    public boolean changedEvt(Object ... objectArray) {
        if (objectArray.length == 0 || theUtil.contains(EVT_COLOR, objectArray) || theUtil.contains(EVT_APPEARANCE, objectArray)) {
            this.invalidateIcon();
        }
        return super.changedEvt(objectArray);
    }

    private void invalidateIcon() {
        this.d_icons = null;
    }

    public Icon[] getIcons(int n, int n2) {
        if (this.d_icons == null) {
            Material material = this.getAppearance();
            int n3 = 3;
            if (material != null) {
                this.d_icons = PyroGuiUtil.getIcons(material, n, n2, n3, guiUtil.ImageFilter.NORMAL, guiUtil.ImageFilter.DISABLED);
            } else {
                ColorIcon colorIcon = new ColorIcon(this.getColor(), n, n2, n3);
                this.d_icons = new Icon[]{colorIcon, colorIcon};
            }
        }
        return this.d_icons;
    }

    public boolean isPredefined() {
        for (PredefSurf predefSurf : PredefSurf.values()) {
            if (!this.isPredefined(predefSurf)) continue;
            return true;
        }
        return false;
    }

    public boolean isPredefined(PredefSurf predefSurf) {
        return theUtil.equal(this.getName(), predefSurf.name());
    }

    @Override
    public String toString() {
        return "Surface: " + this.getName() + " (" + this.d_fyi + ")";
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        depList.add(DLink.WEAK, (IPyroObject)this.d_appearance);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof Material) {
            Util.keepIfNullOr(set, Material.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject == this.d_appearance) {
            return new AReplaceRefTask<Material>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(Material material) {
                    Surface.this.setAppearance(material);
                }
            };
        }
        return EmptyTask.INSTANCE;
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        if (iPyroObject == this.d_appearance) {
            return GeomUtil.taskChanged(this);
        }
        return EmptyTask.INSTANCE;
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(Material.class);
    }
}

