/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.awt.Color;
import junit.framework.TestCase;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;

public class SurfListTest
extends TestCase {
    private Surface[] d_mats = new Surface[5];
    private String[] d_names = new String[5];
    private static final int NUM_MATS = 5;
    private SurfaceManager d_list;

    public SurfListTest(String string) {
        super(string);
        for (int i = 0; i < 5; ++i) {
            this.d_names[i] = "Material_" + i;
            this.d_mats[i] = new Surface(this.d_names[i], new Color((float)i / 5.0f, (float)i / 5.0f, (float)i / 5.0f), null);
        }
    }

    protected void setUp() {
        this.d_list = new SurfaceManager();
        this.d_list.addPredefined();
    }

    protected void tearDown() {
        this.d_list = null;
        System.gc();
    }

    public void test_allCount() {
        int n = this.d_list.getMembers().size();
        SurfaceManager surfaceManager = (SurfaceManager)this.d_list.clone();
        for (int i = 0; i < 5; ++i) {
            surfaceManager.add(this.d_mats[i]);
        }
        SurfListTest.assertEquals((int)(5 + n), (int)surfaceManager.getMembers().size());
        SurfListTest.assertEquals((int)n, (int)this.d_list.getMembers().size());
    }

    public void testSingleLevelAddGet_empty() {
        SurfListTest.assertEquals(null, this.d_list.get(this.d_names[0]));
    }

    public void testSingleLevelAddGet_single() {
        this.d_list.add(this.d_mats[0]);
        SurfListTest.assertEquals((Object)this.d_mats[0], this.d_list.get(this.d_names[0]));
    }

    public void testSingleLevelAddGet_multi() {
        int n;
        for (n = 0; n < 5; ++n) {
            this.d_list.add(this.d_mats[n]);
        }
        for (n = 0; n < 5; ++n) {
            SurfListTest.assertEquals((Object)this.d_mats[n], this.d_list.get(this.d_names[n]));
        }
    }

    public void testMultiLevelAddGet_single() {
        this.d_list.add(this.d_mats[0]);
        SurfaceManager surfaceManager = (SurfaceManager)this.d_list.clone();
        SurfListTest.assertEquals((Object)this.d_mats[0], surfaceManager.get(this.d_names[0]));
    }

    public void testMultiLevelAddGet_complex() {
        int n;
        for (int i = 0; i < 3; ++i) {
            this.d_list.add(this.d_mats[i]);
        }
        SurfaceManager surfaceManager = (SurfaceManager)this.d_list.clone();
        for (n = 3; n < 5; ++n) {
            surfaceManager.add(this.d_mats[n]);
        }
        for (n = 3; n < 5; ++n) {
            SurfListTest.assertEquals((Object)this.d_mats[n], surfaceManager.get(this.d_names[n]));
        }
    }

    public void testRemove() {
        int n;
        int n2;
        for (n2 = 0; n2 < 5; ++n2) {
            this.d_list.add(this.d_mats[n2]);
        }
        n2 = 0;
        this.d_list.remove(this.d_mats[n2]);
        for (n = 0; n < 5; ++n) {
            if (n != n2) {
                SurfListTest.assertEquals((Object)this.d_mats[n], this.d_list.get(this.d_names[n]));
                continue;
            }
            SurfListTest.assertEquals(null, this.d_list.get(this.d_names[n]));
        }
        n2 = 4;
        this.d_list.remove(this.d_mats[n2]);
        for (n = 0; n < 5; ++n) {
            if (n != n2 && n != 0) {
                SurfListTest.assertEquals((Object)this.d_mats[n], this.d_list.get(this.d_names[n]));
                continue;
            }
            SurfListTest.assertEquals(null, this.d_list.get(this.d_names[n]));
        }
        n2 = 2;
        this.d_list.remove(this.d_mats[n2]);
        for (n = 0; n < 5; ++n) {
            if (n != n2 && n != 0 && n != 4) {
                SurfListTest.assertEquals((Object)this.d_mats[n], this.d_list.get(this.d_names[n]));
                continue;
            }
            SurfListTest.assertEquals(null, this.d_list.get(this.d_names[n]));
        }
    }
}

