/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.SpeciesInjection;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.util.Util;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class SpecInjList
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    public static final int MASS_FLUX = 0;
    public static final int MASS_FRACTION = 1;
    public final int injType;
    private final Map<ExSpec, SpeciesInjection> d_injections;

    public SpecInjList() {
        this(0, new ArrayList<SpeciesInjection>(0));
    }

    public SpecInjList(int n, List<SpeciesInjection> list) {
        this.injType = n;
        this.d_injections = new LinkedIdentityHashMap<ExSpec, SpeciesInjection>(list.size());
        for (SpeciesInjection speciesInjection : list) {
            this.d_injections.put(speciesInjection.species, speciesInjection);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!(this.d_injections instanceof LinkedIdentityHashMap)) {
            try {
                theUtil.assignFinalField(this, SpecInjList.class, "d_injections", new LinkedIdentityHashMap<ExSpec, SpeciesInjection>(this.d_injections));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + theUtil.hashCode(this.injType);
        n = 31 * n + theUtil.hashCode(this.d_injections);
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SpecInjList)) {
            return false;
        }
        SpecInjList specInjList = (SpecInjList)object;
        return this.injType == specInjList.injType && Util.identityMapsEqual(this.d_injections, specInjList.d_injections);
    }

    public Collection<SpeciesInjection> getInjections() {
        return this.d_injections.values();
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        depList.add(DLink.WEAK, this.d_injections.keySet());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        Util.keepIfNullOr(set, ExSpec.class);
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        if (!this.d_injections.containsKey(iPyroObject)) {
            return null;
        }
        return new AUndoableTask(){
            private SpeciesInjection d_inj;
            private boolean d_replAdded;

            @Override
            public void undo() {
                if (this.d_replAdded) {
                    SpecInjList.this.d_injections.remove(iPyroObject2);
                }
                SpecInjList.this.d_injections.put(this.d_inj.species, this.d_inj);
            }

            @Override
            public void run() {
                this.d_inj = (SpeciesInjection)SpecInjList.this.d_injections.remove(iPyroObject);
                if (iPyroObject2 != null && !SpecInjList.this.d_injections.containsKey(iPyroObject2)) {
                    SpeciesInjection speciesInjection = new SpeciesInjection((ExSpec)iPyroObject2, this.d_inj.val, this.d_inj.func);
                    SpecInjList.this.d_injections.put((ExSpec)iPyroObject2, speciesInjection);
                    this.d_replAdded = true;
                } else {
                    this.d_replAdded = false;
                }
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        return EmptyTask.INSTANCE;
    }
}

