/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class ParticleInjection
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    private Particle d_particle;
    public final int d_numPartsPerCell;
    private Object d_massFlux;
    public final UnitDouble d_dtInsert;

    public ParticleInjection() {
        this(null, 1, new TimeBasedValue<UnitDouble>(new UnitDouble(0.0, SIUS.unit(45)), TimeFunction.newDefault()), new UnitDouble(0.01, SI.SECOND));
    }

    public ParticleInjection(Particle particle, int n, TimeBasedValue<UnitDouble> timeBasedValue, UnitDouble unitDouble) {
        this.d_particle = particle;
        this.d_numPartsPerCell = n;
        this.d_massFlux = timeBasedValue;
        this.d_dtInsert = unitDouble;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ParticleInjection)) {
            return false;
        }
        ParticleInjection particleInjection = (ParticleInjection)object;
        return this.d_numPartsPerCell == particleInjection.d_numPartsPerCell && theUtil.equal(this.d_particle, particleInjection.d_particle) && theUtil.equal(this.d_massFlux, particleInjection.d_massFlux);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (PyroSimObjectInputStream.getVersion(objectInputStream) < 38 && this.d_massFlux != null) {
            assert (this.d_massFlux instanceof UnitDouble);
            UnitDouble unitDouble = (UnitDouble)this.d_massFlux;
            this.d_massFlux = new TimeBasedValue<UnitDouble>(unitDouble, TimeFunction.newDefault());
        }
    }

    private Object readResolve() throws ObjectStreamException {
        UnitDouble unitDouble = this.d_dtInsert == null ? SIUS.newud(0.01, 2) : this.d_dtInsert;
        return new ParticleInjection(this.d_particle, this.d_numPartsPerCell, this.getMassFlux(), unitDouble);
    }

    public Particle getParticle() {
        return this.d_particle;
    }

    public TimeBasedValue<UnitDouble> getMassFlux() {
        return (TimeBasedValue)this.d_massFlux;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        depList.add(DLink.WEAK, (IPyroObject)this.d_particle);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        Util.keepIfNullOr(set, Particle.class);
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject != this.d_particle) {
            return null;
        }
        return new AReplaceRefTask<Particle>((Object)iPyroObject, (Object)iPyroObject2){

            @Override
            protected void set(Particle particle) {
                ParticleInjection.this.d_particle = particle;
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        return EmptyTask.INSTANCE;
    }
}

