/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.domain.boundcond.surf.AOutFlowSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISlip;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.domain.boundcond.surf.ZonePath;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.util.Util;
import thunderheadeng.util.theUtil;

public class LayeredSurfDesc
extends AOutFlowSurfDesc {
    static final long serialVersionUID = 1L;
    public final TempRegulation d_temperature;
    public final Fuel.IReaction d_iReac;
    public final SurfComposition d_surfComp;
    public final SpecInjList d_specInj;
    public final boolean d_burnAway;
    public final ZonePath d_leakPath;
    public final ISlip d_slip;
    public final Geometry d_geom;

    public LayeredSurfDesc() {
        this(IGeometry.DEFAULT, new Fuel.MaterialReac(), new SurfComposition(), null, null, false, null, TempRegulation.newDefault());
    }

    public LayeredSurfDesc(IGeometry iGeometry, Fuel.IReaction iReaction, SurfComposition surfComposition, SpecInjList specInjList, ParticleInjection particleInjection, boolean bl, ZonePath zonePath, TempRegulation tempRegulation) {
        this(iGeometry, null, iReaction, surfComposition, specInjList, particleInjection, bl, zonePath, tempRegulation);
    }

    public LayeredSurfDesc(IGeometry iGeometry, ISlip iSlip, Fuel.IReaction iReaction, SurfComposition surfComposition, SpecInjList specInjList, ParticleInjection particleInjection, boolean bl, ZonePath zonePath, TempRegulation tempRegulation) {
        super(particleInjection, iGeometry);
        this.d_specInj = specInjList;
        this.d_iReac = iReaction;
        this.d_surfComp = surfComposition;
        this.d_burnAway = bl;
        this.d_leakPath = zonePath;
        this.d_temperature = tempRegulation;
        this.d_slip = iSlip;
        this.d_geom = Geometry.FLAT;
    }

    @Override
    public int hashCode() {
        int n = 7;
        n = 31 * n + super.hashCode();
        n = 31 * n + theUtil.hashCode((Object)this.d_geom);
        n = 31 * n + theUtil.hashCode(this.d_iReac);
        n = 31 * n + theUtil.hashCode(this.d_surfComp);
        n = 31 * n + theUtil.hashCode(this.d_specInj);
        n = 31 * n + theUtil.hashCode(this.d_burnAway);
        n = 31 * n + theUtil.hashCode(this.d_leakPath);
        n = 31 * n + theUtil.hashCode(this.d_temperature);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof LayeredSurfDesc)) {
            return false;
        }
        LayeredSurfDesc layeredSurfDesc = (LayeredSurfDesc)object;
        return super.equals(object) && this.d_geom.equals((Object)layeredSurfDesc.d_geom) && this.d_iReac.equals(layeredSurfDesc.d_iReac) && this.d_surfComp.equals(layeredSurfDesc.d_surfComp) && theUtil.equal(this.d_specInj, layeredSurfDesc.d_specInj) && this.d_burnAway == layeredSurfDesc.d_burnAway && theUtil.equal(this.d_leakPath, layeredSurfDesc.d_leakPath) && this.d_temperature.equals(layeredSurfDesc.d_temperature);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (PyroSimObjectInputStream.getVersion(objectInputStream) < 38) {
            try {
                Util.assignFinalField(this, "d_slip", ISlip.DEFAULT);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
        if (this.d_temperature == null) {
            try {
                Util.assignFinalField(this, "d_temperature", TempRegulation.newDefault());
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
        if (this.d_geometry == null) {
            try {
                Util.assignFinalField(this, "d_geometry", IGeometry.DEFAULT);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
        if (PyroSimObjectInputStream.getVersion(objectInputStream) < 70 && this.d_temperature.isFixedTempTR()) {
            TempRegulation tempRegulation = TempRegulation.newCalcTempTR(this.d_temperature.d_thermalBCs.d_emissivity, this.d_temperature.d_htCoef, this.d_temperature.d_logarithmic);
            try {
                Util.assignFinalField(this, "d_temperature", tempRegulation);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
    }

    public static enum Geometry {
        FLAT,
        CYLINDRICAL,
        SPHERICAL;

    }
}

