/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.ObjectStreamException;
import java.io.Serializable;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public interface ISlip
extends Serializable {
    public static final ISlip DEFAULT = new RoughSlip(SIUS.newud(0.0, 0));
    public static final FreeSlip FREE_SLIP = new FreeSlip();
    public static final NoSlip NO_SLIP = new NoSlip();

    public static class RoughSlip
    implements ISlip {
        static final long serialVersionUID = 1L;
        public final UnitDouble roughness;

        public RoughSlip(UnitDouble unitDouble) {
            this.roughness = unitDouble;
        }

        public int hashCode() {
            int n = 7;
            n = 31 * n + theUtil.hashCode(this.roughness);
            return n;
        }

        public boolean equals(Object object) {
            return object instanceof RoughSlip && ((RoughSlip)object).roughness.equals(this.roughness);
        }
    }

    public static class NoSlip
    implements ISlip {
        static final long serialVersionUID = 1L;

        private NoSlip() {
        }

        private Object readResolve() throws ObjectStreamException {
            return NO_SLIP;
        }
    }

    public static class FreeSlip
    implements ISlip {
        static final long serialVersionUID = 1L;

        private FreeSlip() {
        }

        private Object readResolve() throws ObjectStreamException {
            return FREE_SLIP;
        }
    }
}

