/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import pyrosim.Intl;
import pyrosim.domain.variant.Variant;
import pyrosim.io.PyroSimObjectInputStream;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public interface IGeometry
extends Serializable {
    public static final Default DEFAULT = new Default();
    public static final Cartesian CARTESIAN = new Cartesian(null, null, null);
    public static final Spherical SPHERICAL = new Spherical(null, null);
    public static final Cylindrical CYLINDRICAL = new Cylindrical(null, null, null);

    public String getName();

    public static class Cylindrical
    extends Spherical {
        static final long serialVersionUID = 1L;
        public final Variant lengthVar;
        @Deprecated
        public final UnitDouble length;

        public Cylindrical(UnitDouble unitDouble, UnitDouble unitDouble2, Variant variant) {
            super(unitDouble, unitDouble2);
            this.lengthVar = variant;
            this.length = null;
        }

        @Override
        public int hashCode() {
            int n = 7;
            n = 31 * n + super.hashCode();
            n = 31 * n + theUtil.hashCode(this.lengthVar);
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Cylindrical)) {
                return false;
            }
            return super.equals(object) && theUtil.equal(this.lengthVar, ((Cylindrical)object).lengthVar);
        }

        @Override
        public String getName() {
            return Intl.intl("Cylindrical");
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 108) {
                try {
                    theUtil.assignFinalField(this, Cylindrical.class, "lengthVar", Variant.constant(this.length));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    public static class Spherical
    implements IGeometry {
        static final long serialVersionUID = 1L;
        public final UnitDouble innerRadius;
        public final UnitDouble radius;

        public Spherical(UnitDouble unitDouble, UnitDouble unitDouble2) {
            this.innerRadius = unitDouble;
            this.radius = unitDouble2;
        }

        public int hashCode() {
            int n = 7;
            n = 31 * n + theUtil.hashCode(this.innerRadius);
            n = 31 * n + theUtil.hashCode(this.radius);
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Spherical)) {
                return false;
            }
            Spherical spherical = (Spherical)object;
            return theUtil.equal(this.innerRadius, spherical.innerRadius) && theUtil.equal(this.radius, spherical.radius);
        }

        @Override
        public String getName() {
            return Intl.intl("Spherical");
        }
    }

    public static class Cartesian
    implements IGeometry {
        static final long serialVersionUID = 1L;
        public final UnitDouble length;
        public final UnitDouble width;
        public final UnitDouble thickness;

        public Cartesian(UnitDouble unitDouble, UnitDouble unitDouble2) {
            this(unitDouble, unitDouble2, null);
        }

        public Cartesian(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3) {
            this.length = unitDouble;
            this.width = unitDouble2;
            this.thickness = unitDouble3;
        }

        public int hashCode() {
            int n = 7;
            n = 31 * n + theUtil.hashCode(this.length);
            n = 31 * n + theUtil.hashCode(this.width);
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Cartesian)) {
                return false;
            }
            Cartesian cartesian = (Cartesian)object;
            return theUtil.equal(this.length, cartesian.length) && theUtil.equal(this.width, cartesian.width);
        }

        @Override
        public String getName() {
            return Intl.intl("Cartesian");
        }
    }

    public static class Default
    implements IGeometry {
        static final long serialVersionUID = 1L;

        @Override
        public String getName() {
            return Intl.intl("Default");
        }

        private Object readResolve() throws ObjectStreamException {
            return DEFAULT;
        }
    }
}

