/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.domain.boundcond.surf.AOutFlowSurfDesc;
import pyrosim.domain.boundcond.surf.HeatRelease;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;

public class BurnerSurfDesc
extends AOutFlowSurfDesc {
    static final long serialVersionUID = 1L;
    public TempRegulation d_temperature = TempRegulation.newDefault();
    public final HeatRelease d_heatRelease;

    public BurnerSurfDesc() {
        this(new HeatRelease(), null, TempRegulation.newFixedTempTR(SIUS.newud(300.0, 1), TempRegulation.getDefaultEmissivity(), null, TempRegulation.getDefaultLog()), IGeometry.DEFAULT);
    }

    public BurnerSurfDesc(HeatRelease heatRelease, ParticleInjection particleInjection, TempRegulation tempRegulation, IGeometry iGeometry) {
        super(particleInjection, iGeometry);
        this.d_heatRelease = heatRelease;
        this.d_temperature = tempRegulation;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_temperature == null) {
            this.d_temperature = TempRegulation.newDefault();
        }
        if (this.d_geometry == null) {
            try {
                Util.assignFinalField(this, "d_geometry", IGeometry.DEFAULT);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BurnerSurfDesc)) {
            return false;
        }
        BurnerSurfDesc burnerSurfDesc = (BurnerSurfDesc)object;
        return super.equals(object) && this.d_temperature.equals(burnerSurfDesc.d_temperature) && this.d_heatRelease.equals(burnerSurfDesc.d_heatRelease);
    }

    public void setVestigialTempRegData(TempRegulation tempRegulation) {
        this.d_temperature = tempRegulation;
    }

    public TempRegulation getVestigialTempRegData() {
        return this.d_temperature;
    }
}

