/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.Serializable;
import org.jscience.physics.units.SI;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class AirFlow
implements Serializable {
    static final long serialVersionUID = 1L;
    public final Rate d_rate;
    public final IProfile d_profile;

    public AirFlow() {
        this(new VolumeFlux(), new TopHatProf());
    }

    public AirFlow(Rate rate, IProfile iProfile) {
        this.d_rate = rate;
        this.d_profile = iProfile;
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + theUtil.hashCode(this.d_rate);
        n = 31 * n + theUtil.hashCode(this.d_profile);
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AirFlow)) {
            return false;
        }
        AirFlow airFlow = (AirFlow)object;
        return this.d_rate.equals(airFlow.d_rate) && this.d_profile.equals(airFlow.d_profile);
    }

    public static class TopHatProf
    implements IProfile {
        static final long serialVersionUID = 1L;

        public boolean equals(Object object) {
            return object instanceof TopHatProf;
        }
    }

    public static class ParabolicProf
    implements IProfile {
        static final long serialVersionUID = 1L;

        public boolean equals(Object object) {
            return object instanceof ParabolicProf;
        }
    }

    public static class AtmosphericProf
    implements IProfile {
        static final long serialVersionUID = 1L;
        public final double d_exponent;
        public final UnitDouble d_origin;

        public AtmosphericProf() {
            this(0.3, new UnitDouble(10.0, SI.METER));
        }

        public AtmosphericProf(double d, UnitDouble unitDouble) {
            this.d_exponent = d;
            this.d_origin = unitDouble;
        }

        public int hashCode() {
            int n = 7;
            n = 31 * n + theUtil.hashCode(this.d_exponent);
            n = 31 * n + theUtil.hashCode(this.d_origin);
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AtmosphericProf)) {
                return false;
            }
            AtmosphericProf atmosphericProf = (AtmosphericProf)object;
            return this.d_exponent == atmosphericProf.d_exponent && this.d_origin.equals(atmosphericProf.d_origin);
        }
    }

    public static interface IProfile
    extends Serializable {
    }

    public static class ExSpecMassFlux
    extends Rate {
        static final long serialVersionUID = 1L;

        public ExSpecMassFlux() {
            this(SIUS.newud(0.0, 8), SIUS.newud(0.0, 8), TimeFunction.newDefault(), null);
        }

        public ExSpecMassFlux(UnitDouble unitDouble, UnitDouble unitDouble2, TimeFunction timeFunction, SpecInjList specInjList) {
            super(unitDouble, unitDouble2, timeFunction, specInjList);
            assert (ExSpecMassFlux.specInjValid(specInjList));
        }

        @Override
        public int hashCode() {
            int n = 7;
            n = 41 * n + super.hashCode();
            return n;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof ExSpecMassFlux && super.equals(object);
        }

        public static boolean specInjValid(SpecInjList specInjList) {
            return specInjList == null || specInjList.injType == 0;
        }
    }

    public static class TotalMassFlux
    extends ValRate {
        static final long serialVersionUID = 1L;

        public TotalMassFlux() {
            super(SIUS.newud(0.0, 45), SIUS.newud(0.0, 8), SIUS.newud(0.0, 8), TimeFunction.newDefault(), null);
        }

        public TotalMassFlux(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, TimeFunction timeFunction, SpecInjList specInjList) {
            super(unitDouble, unitDouble2, unitDouble3, timeFunction, specInjList);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof TotalMassFlux && super.equals(object);
        }
    }

    public static class VolumeFlux
    extends ValRate {
        static final long serialVersionUID = 1L;

        public VolumeFlux() {
            this(SIUS.newud(0.0, 24), SIUS.newud(0.0, 8), SIUS.newud(0.0, 8), TimeFunction.newDefault(), null);
        }

        public VolumeFlux(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, TimeFunction timeFunction, SpecInjList specInjList) {
            super(unitDouble, unitDouble2, unitDouble3, timeFunction, specInjList);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof VolumeFlux && super.equals(object);
        }
    }

    public static class NormalVel
    extends ValRate {
        static final long serialVersionUID = 1L;

        public NormalVel() {
            this(SIUS.newud(0.0, 8), SIUS.newud(0.0, 8), SIUS.newud(0.0, 8), TimeFunction.newDefault(), null);
        }

        public NormalVel(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, TimeFunction timeFunction, SpecInjList specInjList) {
            super(unitDouble, unitDouble2, unitDouble3, timeFunction, specInjList);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof NormalVel && super.equals(object);
        }
    }

    public static abstract class ValRate
    extends Rate {
        static final long serialVersionUID = 1L;
        public final UnitDouble val;

        public ValRate(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, TimeFunction timeFunction, SpecInjList specInjList) {
            super(unitDouble2, unitDouble3, timeFunction, specInjList);
            assert (ValRate.specInjValid(specInjList));
            this.val = unitDouble;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof ValRate)) {
                return false;
            }
            ValRate valRate = (ValRate)object;
            return super.equals(object) && this.val.equals(valRate.val);
        }

        public static boolean specInjValid(SpecInjList specInjList) {
            return specInjList == null || specInjList.injType == 1;
        }
    }

    public static class Rate
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble tanVelU;
        public final UnitDouble tanVelV;
        public final TimeFunction func;
        public final SpecInjList specInj;

        public Rate(UnitDouble unitDouble, UnitDouble unitDouble2, TimeFunction timeFunction, SpecInjList specInjList) {
            this.tanVelU = unitDouble;
            this.tanVelV = unitDouble2;
            this.func = timeFunction;
            this.specInj = specInjList;
        }

        public int hashCode() {
            int n = 7;
            n = 31 * n + theUtil.hashCode(this.tanVelU);
            n = 31 * n + theUtil.hashCode(this.tanVelV);
            n = 31 * n + theUtil.hashCode(this.func);
            n = 31 * n + theUtil.hashCode(this.specInj);
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Rate)) {
                return false;
            }
            Rate rate = (Rate)object;
            return this.tanVelU.equals(rate.tanVelU) && this.tanVelV.equals(rate.tanVelV) && this.func.equals(rate.func) && theUtil.equal(this.specInj, rate.specInj);
        }
    }
}

