/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.mat;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.Reaction;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class ReacByproducts
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    private final Map<NamedPyroObject, Residue> d_residues = new LinkedIdentityHashMap<NamedPyroObject, Residue>();
    public UnitDouble d_heat;

    public ReacByproducts() {
        this(null, null, null, null, null);
    }

    public ReacByproducts(ReacByproducts reacByproducts) {
        for (Residue residue : reacByproducts.getResidues()) {
            this.d_residues.put(residue.d_type, residue);
        }
        this.d_heat = reacByproducts.d_heat;
    }

    public ReacByproducts(List<Double> list, List<Material> list2, List<Double> list3, List<ExSpec> list4, UnitDouble unitDouble) {
        int n;
        if (list != null && list2 != null && list.size() == list2.size()) {
            for (n = 0; n < list.size(); ++n) {
                this.d_residues.put(list2.get(n), new Residue(list.get(n), list2.get(n)));
            }
        }
        if (list3 != null && list4 != null && list3.size() == list4.size()) {
            for (n = 0; n < list3.size(); ++n) {
                this.d_residues.put(list4.get(n), new Residue(list3.get(n), list4.get(n)));
            }
        }
        this.d_heat = unitDouble;
    }

    public int hashCode() {
        int n = 11;
        n = 31 * n + theUtil.hashCode(this.d_heat);
        n = 31 * n + theUtil.hashCode(this.d_residues);
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReacByproducts)) {
            return false;
        }
        ReacByproducts reacByproducts = (ReacByproducts)object;
        return Objects.equals(this.d_heat, reacByproducts.d_heat) && ReacByproducts.equal(this.d_residues, reacByproducts.d_residues);
    }

    private static boolean equal(Map<NamedPyroObject, Residue> map, Map<NamedPyroObject, Residue> map2) {
        if (map.size() != map2.size()) {
            return false;
        }
        BitSet bitSet = new BitSet(map2.size());
        for (Residue residue : map.values()) {
            boolean bl = false;
            int n = 0;
            for (Residue residue2 : map2.values()) {
                if (bitSet.get(n)) {
                    ++n;
                    continue;
                }
                if (residue.equals(residue2)) {
                    bl = true;
                    bitSet.set(n);
                    ++n;
                    break;
                }
                ++n;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public Collection<Residue> getResidues() {
        return this.d_residues.values();
    }

    public List<Material> getMaterials() {
        ArrayList<Material> arrayList = new ArrayList<Material>();
        for (Residue residue : this.d_residues.values()) {
            if (!(residue.d_type instanceof Material)) continue;
            arrayList.add((Material)residue.d_type);
        }
        return arrayList;
    }

    public List<ExSpec> getSpecies() {
        ArrayList<ExSpec> arrayList = new ArrayList<ExSpec>();
        for (Residue residue : this.d_residues.values()) {
            if (!(residue.d_type instanceof ExSpec)) continue;
            arrayList.add((ExSpec)residue.d_type);
        }
        return arrayList;
    }

    public List<Double> getNuMaterials() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (Residue residue : this.d_residues.values()) {
            if (!(residue.d_type instanceof Material)) continue;
            arrayList.add(residue.d_fraction);
        }
        return arrayList;
    }

    public List<Double> getNuSpecies() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (Residue residue : this.d_residues.values()) {
            if (!(residue.d_type instanceof ExSpec)) continue;
            arrayList.add(residue.d_fraction);
        }
        return arrayList;
    }

    public void addResidue(NamedPyroObject namedPyroObject, double d) {
        this.d_residues.put(namedPyroObject, new Residue(d, namedPyroObject));
    }

    public boolean residueCreatesCycle(Material material) {
        for (Reaction reaction : material.getPyrolysis().getReactions()) {
            ReacByproducts reacByproducts = reaction.d_byproducts;
            if (reacByproducts == this) {
                return true;
            }
            for (Material material2 : reacByproducts.getMaterials()) {
                if (!this.residueCreatesCycle(material2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        for (Residue residue : this.d_residues.values()) {
            depList.add(DLink.WEAK, (IPyroObject)residue.d_type);
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof Material) {
            Util.keepIfNullOr(set, Material.class);
            ArrayList<Material> arrayList = new ArrayList<Material>();
            for (Material material : set) {
                Set<Material> set2;
                if (material == null || !(set2 = material.getResidueMaterials()).contains(t)) continue;
                arrayList.add(material);
            }
            set.removeAll(arrayList);
        }
        if (t instanceof ExSpec) {
            Util.keepIfNullOr(set, ExSpec.class);
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        if (!this.d_residues.containsKey(iPyroObject)) {
            return null;
        }
        return new AUndoableTask(){
            private Map<NamedPyroObject, Residue> d_oldRes;

            @Override
            public void undo() {
                ReacByproducts.this.d_residues.clear();
                ReacByproducts.this.d_residues.putAll(this.d_oldRes);
                this.d_oldRes = null;
            }

            @Override
            public void run() {
                this.d_oldRes = new LinkedIdentityHashMap<NamedPyroObject, Residue>(ReacByproducts.this.d_residues);
                Residue residue = (Residue)ReacByproducts.this.d_residues.remove(iPyroObject);
                Residue residue2 = (Residue)ReacByproducts.this.d_residues.get(iPyroObject2);
                if (residue2 == null && iPyroObject2 != null) {
                    Residue residue3 = new Residue(residue.d_fraction, (NamedPyroObject)iPyroObject2);
                    ReacByproducts.this.d_residues.put((NamedPyroObject)iPyroObject2, residue3);
                } else if (iPyroObject2 != null) {
                    Residue residue4 = new Residue(residue.d_fraction + residue2.d_fraction, (NamedPyroObject)iPyroObject2);
                    ReacByproducts.this.d_residues.put((NamedPyroObject)iPyroObject2, residue4);
                }
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        return EmptyTask.INSTANCE;
    }

    private Object readResolve() throws ObjectStreamException {
        for (Map.Entry<NamedPyroObject, Residue> entry : this.d_residues.entrySet()) {
            if (entry.getKey() != null) continue;
            Residue residue = new Residue(entry.getValue().d_fraction, ExSpecList.getDefaultFuel(true));
            this.d_residues.remove(entry.getKey());
            this.d_residues.put(residue.d_type, residue);
        }
        return this;
    }

    public static final class Residue
    implements Serializable {
        static final long serialVersionUID = -7132955491265279813L;
        public final double d_fraction;
        public final NamedPyroObject d_type;

        public Residue(double d, NamedPyroObject namedPyroObject) {
            this.d_fraction = d;
            this.d_type = namedPyroObject;
        }

        public int hashCode() {
            int n = 7;
            n = 31 * n + theUtil.hashCode(this.d_fraction);
            n = 31 * n + theUtil.hashCode(this.d_type);
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Residue)) {
                return false;
            }
            Residue residue = (Residue)object;
            return this.d_fraction == residue.d_fraction && Objects.equals(this.d_type, residue.d_type);
        }
    }
}

