/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.mat;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.boundcond.mat.IPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.domain.boundcond.mat.Reaction;
import pyrosim.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.domain.boundcond.mat.ThermalProps;
import thunderheadeng.util.LinkedIdentityHashSet;

public class Material
extends NamedPyroObject
implements ICustomFDSPropsContainer {
    static final long serialVersionUID = 1L;
    public static final Object EVT_FYI = new Object();
    private ThermalProps d_thermalProps;
    private IPyrolysis d_pyrolysis;
    private String d_fyi;
    private CustomFDSProps d_customFDSProps;

    public Material(String string) {
        this(string, new SolidPyrolysis(), new ThermalProps());
    }

    public Material(String string, IPyrolysis iPyrolysis, ThermalProps thermalProps) {
        super(string);
        this.d_pyrolysis = iPyrolysis;
        this.d_thermalProps = thermalProps;
        this.d_fyi = "";
        this.d_customFDSProps = CustomFDSProps.EMPTY;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_customFDSProps == null) {
            this.d_customFDSProps = CustomFDSProps.EMPTY;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Material)) {
            return false;
        }
        Material material = (Material)object;
        return super.equals(object) && this.d_thermalProps.equals(material.d_thermalProps) && this.d_pyrolysis.equals(material.d_pyrolysis) && this.d_customFDSProps.equals(material.d_customFDSProps);
    }

    @Override
    public boolean isEquiv(Object object) {
        if (!(object instanceof Material)) {
            return false;
        }
        Material material = (Material)object;
        return super.equals(object) && this.d_thermalProps.equals(material.d_thermalProps) && this.d_pyrolysis.equals(material.d_pyrolysis) && this.d_customFDSProps.equals(material.d_customFDSProps);
    }

    @Override
    public void getCustomFDSTypes(Collection<String> collection) {
        collection.add("MATL");
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String string) {
        return this.d_customFDSProps;
    }

    @Override
    public void setCustomFDSProps(String string, CustomFDSProps customFDSProps) {
        this.d_customFDSProps = customFDSProps;
        this.changedEvt(new Object[0]);
    }

    public boolean isValidResidue(Material material) {
        return !material.getResidueMaterials().contains(this);
    }

    public boolean hasValidResidues() {
        return this.getResidueMaterials() != null;
    }

    public Set<Material> getResidueMaterials() {
        return Material.getResidueMaterials(this);
    }

    private static Set<Material> getResidueMaterials(Material material) {
        LinkedIdentityHashSet<Material> linkedIdentityHashSet = new LinkedIdentityHashSet<Material>();
        Stack<Material> stack = new Stack<Material>();
        stack.push(material);
        while (!stack.isEmpty()) {
            Material material2 = (Material)stack.pop();
            if (!linkedIdentityHashSet.add(material2)) {
                return null;
            }
            for (Reaction reaction : material2.d_pyrolysis.getReactions()) {
                List<Material> list = reaction.d_byproducts.getMaterials();
                for (Material material3 : list) {
                    if (material3 == null) continue;
                    stack.push(material3);
                }
            }
        }
        return linkedIdentityHashSet;
    }

    public Set<ExSpec> getResidueSpecies() {
        return Material.getResidueSpecies(this);
    }

    private static Set<ExSpec> getResidueSpecies(Material material) {
        LinkedIdentityHashSet<ExSpec> linkedIdentityHashSet = new LinkedIdentityHashSet<ExSpec>();
        for (Reaction reaction : material.d_pyrolysis.getReactions()) {
            List<ExSpec> list = reaction.d_byproducts.getSpecies();
            if (list == null) continue;
            linkedIdentityHashSet.addAll(list);
        }
        return linkedIdentityHashSet;
    }

    public boolean isSolid() {
        return this.d_pyrolysis instanceof SolidPyrolysis;
    }

    public boolean isLiquid() {
        return this.d_pyrolysis instanceof LiquidPyrolysis;
    }

    public String getFYI() {
        return this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(new Object[0]);
    }

    public IPyrolysis getPyrolysis() {
        return this.d_pyrolysis;
    }

    public void setPyrolysis(IPyrolysis iPyrolysis) {
        this.d_pyrolysis = iPyrolysis;
        this.changedEvt(new Object[0]);
    }

    public ThermalProps getThermalProps() {
        return this.d_thermalProps;
    }

    public void setThermalProps(ThermalProps thermalProps) {
        this.d_thermalProps = thermalProps;
        this.changedEvt(new Object[0]);
    }
}

