/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.appearance;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.appearance.HashMaterial;
import pyrosim.domain.appearance.Material;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.theTimer;

public class MaterialDB
extends Composite<Material> {
    static final long serialVersionUID = 68132489912485147L;
    public static final int FS_OPTIONS = 3;
    public static final String TEX_DIR_NAME = "textures";
    private static final String INFO_EXTN = "xml";
    private transient File d_dbDir;
    private transient Map<Material, Entry> d_materials;

    public MaterialDB() {
        this((File)null);
    }

    public MaterialDB(File file) {
        super(Intl.intl("Appearances"), Material.class);
        this.d_dbDir = file;
        this.d_materials = new LinkedIdentityHashMap<Material, Entry>();
    }

    public void setDBDir(File file) {
        this.d_dbDir = file;
    }

    public File getDBDir() {
        return this.d_dbDir;
    }

    public void loadFrom(MaterialDB materialDB) {
        this.reset();
        if (materialDB.flatten().isEmpty()) {
            return;
        }
        HashMap<HashMaterial, Material> hashMap = new HashMap<HashMaterial, Material>();
        for (Material material : this.flatten()) {
            hashMap.put(new HashMaterial(material), material);
        }
        for (Material material : materialDB.flatten()) {
            if (!materialDB.isLocal(material)) continue;
            HashMaterial hashMaterial = new HashMaterial(material);
            Material material2 = (Material)hashMap.get(hashMaterial);
            if (material2 != null) {
                this.remove(material2, false);
                this.add(material, false);
                continue;
            }
            this.add(material, true);
        }
    }

    protected void removeLocal() {
        ArrayList<Material> arrayList = new ArrayList<Material>();
        for (Material material : this.flatten()) {
            if (!this.isLocal(material)) continue;
            arrayList.add(material);
        }
        for (Material material : arrayList) {
            this.remove(material, false);
        }
    }

    @Override
    protected boolean getSerializeMembersEnabled() {
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Cloneable cloneable;
        objectOutputStream.writeInt(Version.curr().ordinal());
        Set<Material> set = Collections.EMPTY_SET;
        if (this.getDomain() != null) {
            cloneable = (PyroMod)this.getDomain();
            set = ((PyroMod)cloneable).getInUseAppearances();
        }
        cloneable = new ArrayList();
        for (Material material : this.flatten()) {
            if (!this.isLocal(material) && !set.contains(material)) continue;
            cloneable.add(material);
        }
        objectOutputStream.writeObject(cloneable);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.readInt();
        this.d_materials = new LinkedIdentityHashMap<Material, Entry>();
        Collection collection = (Collection)objectInputStream.readObject();
        for (Material material : collection) {
            this.add(material);
        }
    }

    public File getTexDir() {
        if (this.d_dbDir == null) {
            return null;
        }
        File file = new File(this.d_dbDir, TEX_DIR_NAME);
        if (!file.isDirectory()) {
            if (file.exists()) {
                file.delete();
            }
            file.mkdir();
        }
        return file;
    }

    public FilenameFilter getPropFilenameFilter() {
        final ExampleFileFilter exampleFileFilter = new ExampleFileFilter(INFO_EXTN);
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                return file2.isFile() && exampleFileFilter.accept(file2);
            }
        };
    }

    public void scan() {
        this.scanDir(this.getTexDir());
    }

    private void scanDir(File file) {
        System.out.printf("Scanning materials...", new Object[0]);
        System.out.flush();
        theTimer theTimer2 = new theTimer();
        this.removeAll(new ArrayList<Material>(this.d_materials.keySet()), false);
        File[] fileArray = file.listFiles(this.getPropFilenameFilter());
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            try {
                Material material = this.loadDBMat(file2);
                this.add(material, false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        System.out.printf("done (%g sec)%n", theTimer2.curr());
    }

    protected Material loadDBMat(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        return Material.load(file.getParentFile(), file.getName());
    }

    protected void saveDBMat(Material material) throws IOException {
        File file = this.getDBPropsFile(material);
        material.save(file.getParentFile(), file.getName());
    }

    public static IImage cacheImage(IImage iImage) {
        return iImage.cacheImage();
    }

    public void updateFile(Material material) throws IOException {
        if (this.isPermanent(material)) {
            this.saveDBMat(material);
        }
    }

    public boolean isLocal(Material material) {
        Entry entry = this.d_materials.get(material);
        return entry != null && entry.local;
    }

    public boolean isPermanent(Material material) {
        Entry entry = this.d_materials.get(material);
        return entry != null && !entry.local;
    }

    private File getDBPropsFile(Material material) {
        return MaterialDB.getPropsFile(this.d_dbDir, TEX_DIR_NAME, material.getName());
    }

    private static File getPropsFile(File file, String string, String string2) {
        file = new File(file, string);
        return new File(file, string2 + '.' + INFO_EXTN);
    }

    public String[] getFileFilters() {
        return new String[]{"bmp", "Windows Bitmap", "gif", "Graphics Interchange Format", "jpg", "JPEG File Interchange Format", "jpeg", "JPEG File Interchange Format", "png", "Portable Network Graphics"};
    }

    @Override
    public boolean add(IPyroObject iPyroObject) {
        if (!(iPyroObject instanceof Material)) {
            return false;
        }
        return this.add((Material)iPyroObject, true);
    }

    protected boolean add(Material material, boolean bl) {
        boolean bl2 = super.add(material);
        if (bl2) {
            this.d_materials.put(material, new Entry(bl));
        }
        return bl2;
    }

    public boolean importToDB(Material material) throws Exception {
        if (!this.isLocal(material)) {
            return false;
        }
        List<IImage> list = material.getImages();
        ArrayList<IImage> arrayList = new ArrayList<IImage>(list.size());
        for (IImage iImage : list) {
            boolean bl = true;
            File file = new File(iImage.getFilename());
            File file2 = new File(this.getTexDir(), file.getName());
            if (file2.exists()) {
                IImage iImage2 = MaterialDB.loadImage(file2.getAbsolutePath());
                if (iImage2.makeHashable().equals(iImage)) {
                    bl = false;
                } else {
                    file2 = MaterialDB.findNewFilename(file2);
                }
            }
            if (bl) {
                System.out.print("Copying image to db: \"" + file2.getName() + "\"...");
                int n = 1;
                if (!iImage.save(file2.getAbsolutePath(), n)) {
                    throw new IOException(String.format(Intl.intl("Could not save image to %s."), file2.getAbsolutePath()));
                }
                System.out.println("done");
            }
            arrayList.add(MaterialDB.loadImage(file2.getAbsolutePath()));
        }
        material.setImages(arrayList);
        Object object = this.getDBPropsFile(material);
        if (((File)object).exists()) {
            object = MaterialDB.findNewFilename((File)object);
            material.setName(FilenameManager.splitFilename(((File)object).getName())[0]);
        }
        this.saveDBMat(material);
        this.remove(material, false);
        this.add(material, false);
        return true;
    }

    public static IImage loadImage(String string) {
        return ImageManager.getImage(string, 3, 0);
    }

    private static File findNewFilename(File file) {
        String string;
        File file2 = file.getParentFile();
        String[] stringArray = FilenameManager.splitFilename(file.getName());
        int n = stringArray[0].lastIndexOf(95);
        int n2 = 1;
        if (n > 0) {
            string = stringArray[0].substring(n + 1);
            try {
                n2 = Integer.parseInt(string);
                stringArray[0] = stringArray[0].substring(0, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        while (file.exists()) {
            string = stringArray[0] + "_" + Integer.toString(n2++) + '.' + stringArray[1];
            file = new File(file2, string);
        }
        return file;
    }

    @Override
    public boolean remove(IPyroObject iPyroObject) {
        if (!(iPyroObject instanceof Material)) {
            return false;
        }
        Material material = (Material)iPyroObject;
        return this.remove(material, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Material material, boolean bl) {
        this.pauseUpdates();
        try {
            if (!super.remove(material)) {
                boolean bl2 = false;
                return bl2;
            }
            Entry entry = this.d_materials.remove(material);
            if (entry == null) {
                boolean bl3 = true;
                return bl3;
            }
            if (!entry.local && bl) {
                File file = this.getDBPropsFile(material);
                ArrayList<File> arrayList = new ArrayList<File>();
                arrayList.add(file);
                for (File file2 : arrayList) {
                    file2.delete();
                }
            }
            boolean bl4 = true;
            return bl4;
        }
        finally {
            this.resumeUpdates();
        }
    }

    public void removeAll(Collection<? extends Material> collection, boolean bl) {
        for (Material material : collection) {
            this.remove(material, bl);
        }
    }

    public void reset() {
        this.removeLocal();
    }

    private static class Entry {
        public boolean local;

        public Entry(boolean bl) {
            this.local = bl;
        }
    }

    private static enum Version {
        VERSION_0000;


        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }
}

