/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.appearance;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.NamedPyroObject;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.MatUtil;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;

public class Material
extends NamedPyroObject
implements IMaterial {
    private static final long serialVersionUID = 1L;
    private static final TypedProp<Integer> PROP_VERSION = new TypedProp<Integer>((Object)"version", 0);
    private static final TypedProp<String> PROP_MAT_NAME = new TypedProp<String>((Object)"name", String.class);
    private static final TypedProp<UnitDouble> PROP_WIDTH = new TypedProp<UnitDouble>((Object)"width", new UnitDouble(1.0, SI.METER));
    private static final TypedProp<UnitDouble> PROP_HEIGHT = new TypedProp<UnitDouble>((Object)"height", new UnitDouble(1.0, SI.METER));
    private static final TypedProp<String> PROP_UNITS = new TypedProp<String>((Object)"length_unit", SI.METER.toString());
    private UnitDouble d_width;
    private UnitDouble d_height;
    private IMatAttrs d_material;

    public Material(String string, IMatAttrs iMatAttrs) {
        this(string, iMatAttrs, (UnitDouble)Material.PROP_WIDTH.defVal, (UnitDouble)Material.PROP_HEIGHT.defVal);
    }

    public Material(String string, IMatAttrs iMatAttrs, UnitDouble unitDouble, UnitDouble unitDouble2) {
        super(string);
        this.d_material = iMatAttrs;
        this.d_width = unitDouble;
        this.d_height = unitDouble2;
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    @Override
    public Material clone() {
        Material material = (Material)super.clone();
        return material;
    }

    public boolean pseudoEquals(Material material) {
        return material == this || material != null && this.getName().equals(material.getName()) && this.d_width.epsilonEquals(material.d_width, 1.0E-12) && this.d_height.epsilonEquals(material.d_height, 1.0E-12) && MatUtil.makeImagesHashable(this.d_material).equals(material.d_material);
    }

    public int pseudoHashCode() {
        return this.getName().hashCode() + this.d_width.hashCode() + this.d_height.hashCode() + MatUtil.makeImagesHashable(this.d_material).hashCode();
    }

    public List<IImage> getImages() {
        ArrayList<IImage> arrayList = new ArrayList<IImage>();
        for (MatChannel matChannel : MatChannel.values()) {
            Texture texture = this.d_material.getTexture(matChannel);
            if (texture == null) continue;
            arrayList.add(texture.image);
        }
        return arrayList;
    }

    public void setImages(List<? extends IImage> list) throws IOException {
        if (list.isEmpty() || !(this.d_material instanceof MatAttrs)) {
            return;
        }
        MatAttrs matAttrs = (MatAttrs)this.d_material;
        int n = 0;
        for (MatChannel matChannel : MatChannel.values()) {
            Texture texture = this.d_material.getTexture(matChannel);
            if (texture == null) continue;
            IImage iImage = list.get(n++);
            texture = texture.apply(iImage);
            matAttrs = matAttrs.applyTexture(matChannel, texture);
        }
        this.d_material = matAttrs;
        this.changedEvt(new Object[0]);
    }

    public void setAttributes(IMatAttrs iMatAttrs) {
        this.d_material = iMatAttrs;
        this.changedEvt(new Object[0]);
    }

    @Override
    public IMatAttrs getAttributes() {
        return this.d_material;
    }

    public BufferedImage getBufferedImage(MatChannel matChannel) {
        Texture texture = this.d_material.getTexture(matChannel);
        return texture != null ? texture.image.toBufferedImage() : null;
    }

    public UnitDouble getWidth() {
        return this.d_width;
    }

    protected void setWidth(UnitDouble unitDouble) {
        this.d_width = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getHeight() {
        return this.d_height;
    }

    protected void setHeight(UnitDouble unitDouble) {
        this.d_height = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public void setSize(UnitDouble unitDouble, UnitDouble unitDouble2) {
        if (this.d_width.equals(unitDouble) && this.d_height.equals(unitDouble2)) {
            return;
        }
        this.d_width = unitDouble;
        this.d_height = unitDouble2;
        this.changedEvt(new Object[0]);
    }

    public boolean isValid() {
        for (MatChannel matChannel : MatChannel.values()) {
            Texture texture = this.d_material.getTexture(matChannel);
            if (texture == null || texture.image.isValid()) continue;
            return false;
        }
        return true;
    }

    public static BufferedImage makeSafe(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return null;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, null, 0, 0);
        graphics2D.dispose();
        return bufferedImage2;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[[Texture]");
        for (MatChannel matChannel : MatChannel.values()) {
            if (!MatUtil.isSupported(this.d_material, matChannel)) continue;
            Color color = this.d_material.getColor(matChannel);
            Texture texture = this.d_material.getTexture(matChannel);
            stringBuffer.append(matChannel.name());
            stringBuffer.append(": ");
            if (color != null) {
                stringBuffer.append("color=");
                stringBuffer.append(color.toString());
                stringBuffer.append(" ");
            }
            if (texture == null) continue;
            stringBuffer.append("tex=");
            stringBuffer.append(new File(texture.image.getFilename()).getName());
            stringBuffer.append(" ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(1);
        if (objectOutputStream instanceof IPropertySet) {
            ((IPropertySet)((Object)objectOutputStream)).set(Texture.PROP_CACHE_IN_STREAM, true);
        } else {
            System.err.println("Texture not saved with material: ObjectOutputStream was not an IPropertySet.");
        }
        objectOutputStream.writeObject(this.d_material);
        objectOutputStream.writeObject(this.d_width);
        objectOutputStream.writeObject(this.d_height);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.readInt();
        this.d_material = (IMatAttrs)objectInputStream.readObject();
        this.d_width = (UnitDouble)objectInputStream.readObject();
        this.d_height = (UnitDouble)objectInputStream.readObject();
    }

    public void save(File file, String string) throws IOException {
        TeciProps teciProps = new TeciProps();
        teciProps.set(PROP_MAT_NAME, this.getName());
        teciProps.set(PROP_VERSION, Integer.valueOf(PropVersion.curr().ordinal()));
        teciProps.set(PROP_WIDTH, this.getWidth());
        teciProps.set(PROP_HEIGHT, this.getHeight());
        this.getAttributes().save(teciProps, (IImage iImage) -> {
            File file2 = new File(iImage.getFilename());
            return FilenameManager.getRelativeFilename(file, file2, false, true);
        });
        File file2 = new File(file, string);
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(file2);
            teciProps.storeToXML(fileOutputStream, null);
        }
    }

    public static Material load(File file, String string2) throws IOException {
        File file2 = new File(file, string2);
        TeciProps teciProps = Material.loadProps(file2);
        String string3 = teciProps.getString(PROP_MAT_NAME);
        if (string3 == null) {
            string3 = FilenameManager.splitFilename(string2)[0];
        }
        UnitDouble unitDouble = teciProps.getUnitDouble(PROP_WIDTH);
        UnitDouble unitDouble2 = teciProps.getUnitDouble(PROP_HEIGHT);
        IMatAttrs iMatAttrs = IMatAttrs.load(teciProps, (String string) -> {
            File file2 = new File(file, (String)string);
            return ImageManager.getImage(file2.getAbsolutePath(), 3, 0);
        });
        return new Material(string3, iMatAttrs, unitDouble, unitDouble2);
    }

    private static TeciProps loadProps(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Object object;
            TeciProps teciProps = new TeciProps();
            teciProps.loadFromXML(fileInputStream);
            int n = teciProps.getInt(PROP_VERSION);
            if (n < PropVersion.VERSION_0001.ordinal()) {
                object = FilenameManager.splitFilename(file.getName())[0];
                teciProps.set(PROP_MAT_NAME, object);
                Unit unit = Material.getLenUnit(teciProps);
                double d = teciProps.getDouble((String)Material.PROP_WIDTH.key, ((UnitDouble)Material.PROP_WIDTH.defVal).getValue(unit));
                double d2 = teciProps.getDouble((String)Material.PROP_HEIGHT.key, ((UnitDouble)Material.PROP_HEIGHT.defVal).getValue(unit));
                teciProps.set(PROP_WIDTH, new UnitDouble(d, unit));
                teciProps.set(PROP_HEIGHT, new UnitDouble(d2, unit));
                teciProps.remove(PROP_UNITS);
                teciProps.set(PROP_VERSION, Integer.valueOf(PropVersion.curr().ordinal()));
                String string = file.getName();
                string = FilenameManager.splitFilename(string)[0];
                teciProps.set("diffuse.tex", string);
                IMatAttrs.DIFFUSE_COLOR.save(teciProps, iImage -> "", Color.WHITE);
            }
            if (n < PropVersion.VERSION_0002.ordinal()) {
                IMatAttrs.SPECULAR_COLOR.save(teciProps, iImage -> "", (Color)IMatAttrs.SPECULAR_COLOR.defVal);
            }
            object = teciProps;
            return object;
        }
    }

    private static Unit getLenUnit(TeciProps teciProps) {
        String string = teciProps.getString(PROP_UNITS);
        if (string == null) {
            return SI.METER;
        }
        if (string.equals(Integer.toString(0))) {
            return SI.METER;
        }
        if (string.equals(Integer.toString(1))) {
            return NonSI.FOOT;
        }
        try {
            Unit unit = Unit.valueOf(string);
            if (UnitDouble.areCompatible(unit, SI.METER)) {
                return unit;
            }
            String string2 = String.format(Intl.intl("Incompatible unit: %s"), string);
            System.err.println(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string3 = String.format(Intl.intl("Unrecognized unit: %s"), string);
            System.err.println(string3);
        }
        return SI.METER;
    }

    private static enum PropVersion {
        VERSION_0000,
        VERSION_0001,
        VERSION_0002;


        public static PropVersion curr() {
            return PropVersion.values()[PropVersion.values().length - 1];
        }
    }
}

