/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.Serializable;
import org.jscience.physics.units.SI;
import pyrosim.domain.ramp.Ramp;
import thunderheadeng.units.UnitDouble;

public abstract class TimeFunction<ValType>
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public final ValType val;

    public TimeFunction(ValType ValType) {
        this.val = ValType;
    }

    public static TimeFunction newDefault() {
        return new TanH();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TimeFunction)) {
            return false;
        }
        TimeFunction timeFunction = (TimeFunction)object;
        return this.val.equals(timeFunction.val);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int hashCode() {
        return 9581714 + this.val.hashCode();
    }

    public static class Custom
    extends TimeFunction<Ramp> {
        static final long serialVersionUID = 1L;

        public Custom(Ramp ramp) {
            super(ramp);
        }

        public static boolean isRampValid(Ramp ramp, boolean bl) {
            if (ramp.getTUnitType() != 2 || ramp.getFUnitType() != 28) {
                return false;
            }
            if (!bl) {
                return true;
            }
            UnitDouble unitDouble = new UnitDouble(0.0, SI.SECOND);
            for (Ramp.Entry entry : ramp.getRecords()) {
                if (!entry.t.equals(unitDouble)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Custom && super.equals(object);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 374809418;
        }
    }

    public static class TSquared
    extends TimeFunction<UnitDouble> {
        static final long serialVersionUID = 1L;

        public TSquared() {
            this(new UnitDouble(1.0, SI.SECOND));
        }

        public TSquared(UnitDouble unitDouble) {
            super(unitDouble);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof TSquared && super.equals(object);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 36999738;
        }
    }

    public static class TanH
    extends TimeFunction<UnitDouble> {
        static final long serialVersionUID = 1L;

        public TanH() {
            this(new UnitDouble(1.0, SI.SECOND));
        }

        public TanH(UnitDouble unitDouble) {
            super(unitDouble);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof TanH && super.equals(object);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 337972;
        }
    }
}

