/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroNamesDB;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.FDSClusterOptions;
import pyrosim.domain.FDSRun;
import pyrosim.domain.FloorManager;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.ResultsArchive;
import pyrosim.domain.SimParams;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.bridge.BridgeList;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.ControlMgr;
import pyrosim.domain.devices.DeviceManager;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.SprayModelMgr;
import pyrosim.domain.evac.CorrList;
import pyrosim.domain.evac.DoorList;
import pyrosim.domain.evac.EntrList;
import pyrosim.domain.evac.EvacList;
import pyrosim.domain.evac.EvhoList;
import pyrosim.domain.evac.EvssList;
import pyrosim.domain.evac.ExitList;
import pyrosim.domain.evac.IEvacObj;
import pyrosim.domain.evac.PersList;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.hvac.HvacLeak;
import pyrosim.domain.hvac.HvacList;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.output.Boundaries;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.IsosurfaceMgr;
import pyrosim.domain.output.Plot3d;
import pyrosim.domain.output.ProfList;
import pyrosim.domain.output.ProfRec;
import pyrosim.domain.output.Slice3dList;
import pyrosim.domain.output.SliceList;
import pyrosim.domain.output.StatisticMgr;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewMgr;
import pyrosim.domain.zones.Zone;
import pyrosim.domain.zones.ZoneMgr;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.NameGenerator;

public class Serialized
implements Serializable {
    static final long serialVersionUID = 1L;
    public SimParams simParams;
    public final NameGenerator groupNames;
    public ModelComposite obstructions;
    public final NameGenerator ventNames;
    public final NameGenerator obstNames;
    public final NameGenerator holeNames;
    public final NameGenerator initRegionNames;
    public final NameGenerator partCloudNames;
    public GridList grids;
    public final NameGenerator gridNames;
    public ZoneMgr zones;
    public final NameGenerator zoneNames;
    public FloorManager floors;
    public ParticleList particles;
    public final NameGenerator partNames;
    public MaterialManager matmgr;
    public final NameGenerator matNames;
    public SurfaceManager surfmgr;
    public final NameGenerator surfNames;
    public ReactionList reactions;
    public final NameGenerator reacNames;
    public ExSpecList exSpecs;
    public final NameGenerator specNames;
    public HvacList hvacSystem;
    public final NameGenerator hvacDuctNames;
    public final NameGenerator hvacNodeNames;
    public final NameGenerator hvacFanNames;
    public final NameGenerator hvacFilterNames;
    public final NameGenerator hvacAircoilNames;
    public final NameGenerator hvacLeakNames;
    public BridgeList bridges;
    public boolean enableFdsEvac;
    public PersList perss;
    public ExitList exits;
    public EvacList evacs;
    public EntrList entrs;
    public EvhoList evhos;
    public CorrList corrs;
    public EvssList evsss;
    public DoorList doors;
    public final NameGenerator evacNames;
    public ControlMgr controls;
    public final NameGenerator ctrlNames;
    public HeatLinkModelMgr heatLinkModels;
    public final NameGenerator heatLinkModelNames;
    public SmokeLinkModelMgr smokeLinkModels;
    public final NameGenerator smokeLinkModelNames;
    public SprinklerLinkModelMgr sprkLinkModels;
    public final NameGenerator sprkLinkModelNames;
    public SprayModelMgr sprayModels;
    public final NameGenerator sprayModelNames;
    public DeviceManager devices;
    public final NameGenerator devcNames;
    public Boundaries boundaryOutput;
    public IsosurfaceMgr isosurfaces;
    public Plot3d plot3d;
    public SliceList slices;
    public Slice3dList slices3d;
    public final NameGenerator slice3dNames;
    public ProfList profs;
    public final NameGenerator profNames;
    public StatisticMgr msrStats;
    public final NameGenerator msrStatNames;
    public MaterialDB appearances;
    public final NameGenerator appearanceNames;
    public ViewMgr views;
    public final NameGenerator viewNames;
    public RasterizationOptions rastProps = new RasterizationOptions();
    public String unprocessedRecords;
    public FDSRun lastFDSRun;
    @Nullable
    public FDSClusterOptions clusterOptions;
    public ResultsArchive resultsArchive;
    public boolean d_protect;
    public byte[] d_protectPassHash;

    public Serialized(boolean bl) {
        this.groupNames = new NameGenerator(Intl.intl("Group"), 2, true);
        this.obstructions = new ModelComposite(Intl.intl("Model"));
        this.ventNames = new NameGenerator(Intl.intl("Vent"));
        this.obstNames = new NameGenerator(Intl.intl("Obstruction"), 4, true);
        this.holeNames = new NameGenerator(Intl.intl("Hole"), 2, true);
        this.initRegionNames = new NameGenerator(Intl.intl("Init Region"), 2, true);
        this.partCloudNames = new NameGenerator(Intl.intl("Part Cloud"), 2, true);
        this.grids = new GridList();
        this.gridNames = new NameGenerator(Intl.intl("Mesh"));
        this.zones = new ZoneMgr();
        this.zones.addDefaults();
        this.zoneNames = new NameGenerator(Intl.intl("Zone"));
        this.floors = new FloorManager();
        this.particles = new ParticleList();
        this.partNames = new NameGenerator(Intl.intl("Particle"));
        this.matmgr = new MaterialManager();
        this.matNames = new NameGenerator(Intl.intl("Material"));
        this.surfmgr = new SurfaceManager();
        this.surfmgr.addPredefined();
        this.surfNames = new NameGenerator(Intl.intl("Surface"));
        this.reactions = new ReactionList();
        this.reacNames = new NameGenerator(Intl.intl("Reaction"), 1, false);
        this.exSpecs = new ExSpecList();
        this.specNames = new NameGenerator(Intl.intl("Species"));
        this.hvacSystem = new HvacList();
        this.hvacDuctNames = new NameGenerator(Intl.intl("Duct"));
        this.hvacNodeNames = new NameGenerator(Intl.intl("Node"));
        this.hvacAircoilNames = new NameGenerator(Intl.intl("Aircoil"));
        this.hvacFanNames = new NameGenerator(Intl.intl("Fan"));
        this.hvacFilterNames = new NameGenerator(Intl.intl("Filter"));
        this.hvacLeakNames = new NameGenerator(Intl.intl("Leak"));
        this.bridges = new BridgeList();
        this.enableFdsEvac = false;
        this.perss = new PersList();
        this.exits = new ExitList();
        this.evacs = new EvacList();
        this.entrs = new EntrList();
        this.evhos = new EvhoList();
        this.corrs = new CorrList();
        this.evsss = new EvssList();
        this.doors = new DoorList();
        this.evacNames = new NameGenerator(Intl.intl("Evac"));
        this.heatLinkModels = new HeatLinkModelMgr();
        this.heatLinkModelNames = new NameGenerator(Intl.intl("HDMod"));
        this.smokeLinkModels = new SmokeLinkModelMgr();
        this.smokeLinkModelNames = new NameGenerator(Intl.intl("SDMod"));
        this.sprkLinkModels = new SprinklerLinkModelMgr();
        this.sprkLinkModelNames = new NameGenerator(Intl.intl("SLINKMod"));
        this.sprayModels = new SprayModelMgr();
        this.sprayModelNames = new NameGenerator(Intl.intl("SprayMod"));
        this.devices = new DeviceManager();
        this.devcNames = new NameGenerator(Intl.intl("Device"));
        this.controls = new ControlMgr();
        this.ctrlNames = new NameGenerator(Intl.intl("Control"));
        this.boundaryOutput = new Boundaries(new IQuantity[0]);
        this.isosurfaces = new IsosurfaceMgr();
        this.slices = new SliceList();
        this.slices3d = new Slice3dList();
        this.slice3dNames = new NameGenerator(Intl.intl("Slice3D"));
        this.plot3d = new Plot3d();
        this.profs = new ProfList();
        this.profNames = new NameGenerator(Intl.intl("Profile"));
        this.msrStats = new StatisticMgr();
        this.msrStatNames = new NameGenerator(Intl.intl("Statistic"));
        this.views = new ViewMgr();
        this.viewNames = new NameGenerator(Intl.intl("View"));
        this.simParams = new SimParams(this.surfmgr);
        this.appearances = new MaterialDB();
        this.appearanceNames = new NameGenerator(Intl.intl("Appearance"), 2, true);
        this.unprocessedRecords = "";
        this.lastFDSRun = new FDSRun();
        this.clusterOptions = null;
        this.resultsArchive = new ResultsArchive();
        this.d_protect = false;
        this.d_protectPassHash = new byte[0];
        if (bl) {
            this.initDefaults();
        }
    }

    public void initNewFields(boolean bl2, String ... stringArray) {
        Serialized[] serializedArray = new Serialized[]{null};
        Supplier<Serialized> supplier = () -> {
            if (serializedArray[0] == null) {
                serializedArray[0] = new Serialized(bl2);
            }
            return serializedArray[0];
        };
        BiConsumer<Field, Boolean> biConsumer = (field, bl) -> {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || !bl.booleanValue() && field.isAnnotationPresent(Nullable.class)) {
                return;
            }
            try {
                boolean bl2 = field.isAccessible();
                if (!bl2) {
                    field.setAccessible(true);
                }
                try {
                    if (!bl.booleanValue() && field.get(this) != null) {
                        return;
                    }
                    System.out.println("Initializing Serialized." + field.getName());
                    field.set(this, field.get(supplier.get()));
                }
                finally {
                    field.setAccessible(bl2);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        };
        if (stringArray.length == 0) {
            for (Field field2 : Serialized.class.getDeclaredFields()) {
                biConsumer.accept(field2, false);
            }
        } else {
            for (String string : stringArray) {
                try {
                    Field field3 = Serialized.class.getDeclaredField(string);
                    biConsumer.accept(field3, true);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    public PyroNamesDB generateNamesDB() {
        PyroNamesDB pyroNamesDB = new PyroNamesDB();
        pyroNamesDB.registerType(Composite.class, this.groupNames);
        pyroNamesDB.registerType(Vent.class, this.ventNames);
        pyroNamesDB.registerType(IObstruction.class, this.obstNames);
        pyroNamesDB.registerType(IHole.class, this.holeNames);
        pyroNamesDB.registerType(PartCloud.class, this.partCloudNames);
        pyroNamesDB.registerType(InitRegion.class, this.initRegionNames);
        pyroNamesDB.registerType(Grid.class, this.gridNames);
        pyroNamesDB.registerType(Zone.class, this.zoneNames);
        pyroNamesDB.registerType(Particle.class, this.partNames);
        pyroNamesDB.registerType(pyrosim.domain.boundcond.mat.Material.class, this.matNames);
        pyroNamesDB.registerType(Surface.class, this.surfNames);
        pyroNamesDB.registerType(Reaction.class, this.reacNames);
        pyroNamesDB.registerType(ExSpec.class, this.specNames);
        pyroNamesDB.registerType(HvacDuct.class, this.hvacDuctNames);
        pyroNamesDB.registerType(HvacNode.class, this.hvacNodeNames);
        pyroNamesDB.registerType(HvacFan.class, this.hvacFanNames);
        pyroNamesDB.registerType(HvacFilter.class, this.hvacFilterNames);
        pyroNamesDB.registerType(HvacAircoil.class, this.hvacAircoilNames);
        pyroNamesDB.registerType(HvacLeak.class, this.hvacLeakNames);
        pyroNamesDB.registerType(IEvacObj.class, this.evacNames);
        pyroNamesDB.registerType(ControlBridge.class, this.ctrlNames);
        pyroNamesDB.registerType(HeatLinkModel.class, this.heatLinkModelNames);
        pyroNamesDB.registerType(SmokeLinkModel.class, this.smokeLinkModelNames);
        pyroNamesDB.registerType(SprinklerLinkModel.class, this.sprkLinkModelNames);
        pyroNamesDB.registerType(SprayModel.class, this.sprayModelNames);
        pyroNamesDB.registerType(IDevice.class, this.devcNames);
        pyroNamesDB.registerType(View.class, this.viewNames);
        pyroNamesDB.registerType(VolumeSlice.class, this.slice3dNames);
        pyroNamesDB.registerType(ProfRec.class, this.profNames);
        pyroNamesDB.registerType(IMeasurementStat.class, this.msrStatNames);
        pyroNamesDB.registerType(Material.class, this.appearanceNames);
        return pyroNamesDB;
    }

    public void initDefaults() {
        this.heatLinkModels.addDefaults();
        this.smokeLinkModels.addDefaults();
        this.sprkLinkModels.addDefaults();
        this.floors.addDefaults();
        this.exSpecs.addDefaults();
        this.particles.addDefaults(this.exSpecs);
        this.sprayModels.addDefaults(this.particles);
        this.views.addDefaults();
    }

    public void setDomain(PyroMod pyroMod) {
        block5: {
            try {
                for (Field field : Serialized.class.getFields()) {
                    Object object = field.get(this);
                    assert (field.getName().equals("clusterOptions") || object != null) : "Someone forgot to initialize Serialized." + field.getName();
                    if (object instanceof IPyroObject) {
                        ((IPyroObject)object).setDomain(pyroMod, pyroMod);
                        continue;
                    }
                    if (!(object instanceof IDomainObject)) continue;
                    ((IDomainObject)object).setDomain(pyroMod);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Nullable {
    }
}

