/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import pyrosim.domain.Composite;

public class Property<T> {
    private static final Property N_SUPPORTED = new Property(Composite.NOT_SUPPORTED);
    private static final Property N_UNIFORM = new Property(Composite.NON_UNIFORM);
    private final Object d_val;

    private Property(Object object) {
        this.d_val = object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Property)) {
            return false;
        }
        Property property = (Property)object;
        return Objects.equals(this.d_val, property.d_val);
    }

    public int hashCode() {
        return Objects.hashCode(this.d_val);
    }

    public boolean isUniform() {
        return this.d_val != Composite.NOT_SUPPORTED && this.d_val != Composite.NON_UNIFORM;
    }

    public boolean isSupported() {
        return this.d_val != Composite.NOT_SUPPORTED;
    }

    public T get() {
        if (this.d_val == Composite.NOT_SUPPORTED || this.d_val == Composite.NON_UNIFORM) {
            throw new NoSuchElementException("No value present");
        }
        return (T)this.d_val;
    }

    public T orElse(T t) {
        if (this.d_val == Composite.NOT_SUPPORTED || this.d_val == Composite.NON_UNIFORM) {
            return t;
        }
        return (T)this.d_val;
    }

    public T orElseGet(Supplier<T> supplier) {
        if (this.d_val == Composite.NOT_SUPPORTED || this.d_val == Composite.NON_UNIFORM) {
            return supplier.get();
        }
        return (T)this.d_val;
    }

    public <X extends Throwable> T orElseThrow(Supplier<X> supplier) throws X {
        if (this.d_val == Composite.NOT_SUPPORTED || this.d_val == Composite.NON_UNIFORM) {
            throw (Throwable)supplier.get();
        }
        return (T)this.d_val;
    }

    public void ifUniform(Consumer<T> consumer) {
        if (this.isUniform()) {
            consumer.accept(this.d_val);
        }
    }

    public <U> Property<U> map(Function<? super T, ? extends U> function) {
        if (this.d_val == Composite.NON_UNIFORM) {
            return Property.nonUniform();
        }
        if (this.d_val == Composite.NOT_SUPPORTED) {
            return Property.notSupported();
        }
        return Property.of(function.apply(this.d_val));
    }

    public <U> Property<U> flatMap(Function<? super T, Property<U>> function) {
        if (this.d_val == Composite.NON_UNIFORM) {
            return Property.nonUniform();
        }
        if (this.d_val == Composite.NOT_SUPPORTED) {
            return Property.notSupported();
        }
        return function.apply(this.d_val);
    }

    public static <T> Property<T> of(T t) {
        return new Property<T>(t);
    }

    public static <T> Property<T> ofNullable(T t) {
        if (t == null) {
            return Property.nonUniform();
        }
        return Property.of(t);
    }

    public static <T> Property<T> nonUniform() {
        return N_UNIFORM;
    }

    public static <T> Property<T> notSupported() {
        return N_SUPPORTED;
    }
}

