/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;

public class Hierarchy {
    public static <T extends IPyroObject> Iterator<T> iterateParents(Class<T> clazz, IPyroObject iPyroObject) {
        return new ParentIterator<T>(clazz, iPyroObject);
    }

    public static Set<IPyroObject> getParents(Collection<? extends IPyroObject> collection) {
        LinkedIdentityHashSet<IPyroObject> linkedIdentityHashSet = new LinkedIdentityHashSet<IPyroObject>();
        for (IPyroObject iPyroObject : collection) {
            linkedIdentityHashSet.add(iPyroObject);
        }
        return linkedIdentityHashSet;
    }

    public static boolean isDescendent(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        while (iPyroObject2 != null) {
            if (iPyroObject2 == iPyroObject) {
                return true;
            }
            iPyroObject2 = iPyroObject2.getParent();
        }
        return false;
    }

    public static IPyroObject getCommonParent(Collection<? extends IPyroObject> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        Iterator<? extends IPyroObject> iterator = collection.iterator();
        IPyroObject[] iPyroObjectArray = Hierarchy.getPath(iterator.next());
        int n = iPyroObjectArray.length - 2;
        while (iterator.hasNext() && n >= 0) {
            IPyroObject iPyroObject = iterator.next();
            while (n >= 0 && !Hierarchy.isDescendent(iPyroObjectArray[n], iPyroObject)) {
                --n;
            }
        }
        return n >= 0 ? iPyroObjectArray[n] : null;
    }

    public static IPyroObject[] getPath(IPyroObject iPyroObject) {
        return Hierarchy.getPath(iPyroObject, null, false);
    }

    public static IPyroObject[] getPath(IPyroObject iPyroObject, IPyroObject iPyroObject2, boolean bl) {
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
        Hierarchy.getPath(arrayList, iPyroObject, iPyroObject2, bl);
        return arrayList.toArray(new IPyroObject[arrayList.size()]);
    }

    private static void getPath(List<IPyroObject> list, IPyroObject iPyroObject, IPyroObject iPyroObject2, boolean bl) {
        if (iPyroObject != iPyroObject2) {
            IPyroObject iPyroObject3 = iPyroObject.getParent();
            if (iPyroObject3 != null) {
                Hierarchy.getPath(list, iPyroObject3, iPyroObject2, bl);
            }
            list.add(iPyroObject);
        }
        if (iPyroObject == iPyroObject2 && bl) {
            list.add(iPyroObject);
        }
    }

    public static <T extends IPyroObject> IPyroObject getCategoryRoot(T t) {
        Object object = t;
        IPyroObject iPyroObject = object.getParent();
        while (iPyroObject != null) {
            if (iPyroObject instanceof PyroMod) {
                return object;
            }
            object = iPyroObject;
            iPyroObject = object.getParent();
        }
        return null;
    }

    public static Collection<IPyroObject> flattenComposites(Collection<?> collection) {
        return Hierarchy.flatten(collection, IPyroObject.class, CompositeFilter.INSTANCE);
    }

    public static <T> Collection<T> flatten(Collection<?> collection, Class<T> clazz) {
        return new DeepCollection<T>(collection, clazz, Predicates.alwaysTrue());
    }

    public static <T> Collection<T> flatten(Collection<?> collection, Class<T> clazz, Predicate<? super T> predicate) {
        return new DeepCollection<T>(collection, clazz, predicate);
    }

    public static class ParentIterator<T extends IPyroObject>
    implements Iterator<T> {
        private Class<T> d_parentType;
        private T d_nextParent = null;

        public ParentIterator(Class<T> clazz, IPyroObject iPyroObject) {
            this.d_parentType = clazz;
            this.prefetchNext(iPyroObject);
        }

        private void prefetchNext(IPyroObject iPyroObject) {
            IPyroObject iPyroObject2;
            for (iPyroObject2 = iPyroObject.getParent(); iPyroObject2 != null && !this.d_parentType.isInstance(iPyroObject2); iPyroObject2 = iPyroObject2.getParent()) {
            }
            this.d_nextParent = iPyroObject2 == null ? null : iPyroObject2;
        }

        @Override
        public boolean hasNext() {
            return this.d_nextParent != null;
        }

        @Override
        public T next() {
            T t = this.d_nextParent;
            this.prefetchNext((IPyroObject)t);
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DeepIterator<T>
    implements Iterator<T> {
        private final Class<T> d_typeFilter;
        private final Predicate<? super T> d_filter;
        private final Deque<Iterator<?>> d_iteratorStack;
        private T d_nextObj;

        public DeepIterator(Collection<?> collection, Class<T> clazz, Predicate<? super T> predicate) {
            this.d_typeFilter = clazz;
            this.d_filter = predicate;
            this.d_iteratorStack = new ArrayDeque();
            this.d_iteratorStack.push(collection.iterator());
            this.prefetchNext();
        }

        private void prefetchNext() {
            while (!this.d_iteratorStack.isEmpty()) {
                Iterator<Object> iterator = this.d_iteratorStack.peek();
                while (iterator.hasNext()) {
                    List list;
                    boolean bl = false;
                    Object obj = iterator.next();
                    if (this.d_typeFilter.isInstance(obj) && this.d_filter.test(obj)) {
                        this.d_nextObj = obj;
                        bl = true;
                    }
                    Collection<Object> collection = list = obj instanceof IPyroObject ? ((IPyroObject)obj).getMembers() : Collections.EMPTY_LIST;
                    if (!list.isEmpty()) {
                        iterator = list.iterator();
                        this.d_iteratorStack.push(iterator);
                    }
                    if (!bl) continue;
                    return;
                }
                this.d_iteratorStack.pop();
            }
        }

        @Override
        public boolean hasNext() {
            return !this.d_iteratorStack.isEmpty();
        }

        @Override
        public T next() {
            T t = this.d_nextObj;
            this.prefetchNext();
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class DeepCollection<T>
    extends AbstractCollection<T> {
        private int d_size = -1;
        private final Class<T> d_typeFilter;
        private final Predicate<? super T> d_filter;
        private final Collection<?> d_objs;

        public DeepCollection(Object object, Class<T> clazz, Predicate<? super T> predicate) {
            this(Arrays.asList(object), clazz, predicate);
        }

        public DeepCollection(Collection<?> collection, Class<T> clazz, Predicate<? super T> predicate) {
            this.d_typeFilter = clazz;
            this.d_filter = predicate;
            this.d_objs = collection;
        }

        @Override
        public Iterator<T> iterator() {
            return new DeepIterator<T>(this.d_objs, this.d_typeFilter, this.d_filter);
        }

        @Override
        public int size() {
            if (this.d_size == -1) {
                this.d_size = 0;
                Iterator<T> iterator = this.iterator();
                while (iterator.hasNext()) {
                    ++this.d_size;
                    iterator.next();
                }
            }
            return this.d_size;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public boolean contains(Object object) {
            if (!this.d_typeFilter.isInstance(object) || !this.d_filter.test(object)) {
                return false;
            }
            if (this.d_objs instanceof Set) {
                if (this.d_objs.contains(object)) {
                    return true;
                }
                for (Object obj : this.d_objs) {
                    if (!DeepCollection.containsDeep(obj, object)) continue;
                    return true;
                }
            } else {
                for (Object obj : this.d_objs) {
                    if (obj != object && !DeepCollection.containsDeep(obj, object)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean containsDeep(Object object, Object object2) {
            if (!(object2 instanceof IPyroObject)) {
                return false;
            }
            if (object instanceof Composite) {
                return ((Composite)object).containsDeep((IPyroObject)object2);
            }
            if (object instanceof IPyroObject) {
                for (IPyroObject iPyroObject : ((IPyroObject)object).getMembers()) {
                    if (!DeepCollection.containsDeep(iPyroObject, object2)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return super.containsAll(collection);
        }
    }

    public static class CompositeFilter<T>
    implements Predicate<T> {
        public static final CompositeFilter INSTANCE = new CompositeFilter();

        @Override
        public boolean test(T t) {
            return !(t instanceof Composite);
        }
    }
}

