/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;

public class GridMergeUtil {
    public static final int GRIDFACE_MINX = 0;
    public static final int GRIDFACE_MAXX = 1;
    public static final int GRIDFACE_MINY = 2;
    public static final int GRIDFACE_MAXY = 3;
    public static final int GRIDFACE_MINZ = 4;
    public static final int GRIDFACE_MAXZ = 5;
    private static final int VENT_GROUPID = Integer.MAX_VALUE;

    public static MergeResult mergeGrids(Collection<? extends Grid> collection, Collection<? extends IPyroGeomSrc> collection2) {
        ArrayList<Grid> arrayList = new ArrayList<Grid>(collection);
        ArrayList<AABox> arrayList2 = new ArrayList<AABox>(collection.size());
        for (int i = 0; i < collection.size(); ++i) {
            Grid grid = (Grid)arrayList.get(i);
            arrayList2.add(new AABox(grid.getMinPoint().getPoint3dValue(Geometry.LU), grid.getMaxPoint().getPoint3dValue(Geometry.LU)));
        }
        Model model = GridMergeUtil.mergeBoxes(arrayList2, collection2);
        return new MergeResult(model, GridMergeUtil.getGridBoundary(arrayList, model));
    }

    public static Model mergeBoxes(List<AABox> list, Collection<? extends IPyroGeomSrc> collection) {
        Model model = null;
        ArrayList<Face> arrayList = new ArrayList<Face>();
        for (int i = 0; i < list.size(); ++i) {
            Model model2 = GridMergeUtil.modelFromGrid(list.get(i), i);
            if (i == 0) {
                model = model2;
                continue;
            }
            Model model3 = (Model)model.clone();
            model.merge(model2);
            arrayList.clear();
            for (Face face : model.getFaces()) {
                if (!GridMergeUtil.isMergeDeleteFace(model3, model2, i, model, face)) continue;
                arrayList.add(face);
            }
            for (Face face : arrayList) {
                model.deleteFace(face, true, true);
            }
        }
        if (model != null) {
            GridMergeUtil.deleteVents(model, collection);
        }
        if (model == null) {
            model = new Model();
        }
        return model;
    }

    private static void deleteVents(Model model, Collection<? extends IPyroGeomSrc> collection) {
        for (IPyroGeomSrc iterator2 : collection) {
            List list = thunderheadeng.geometry.objs.GeomUtil.explode(iterator2.getGeom().flatten().getLocalGeom(), IFace.class);
            for (IFace iFace : list) {
                List<IPolygon> list2 = GeomUtil.toPolys(iFace, 0.1, true);
                Iterator<IPolygon> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    IPolygon iPolygon = iterator.next();
                    Point3d[] point3dArray = PolyUtil.getAllVerts(iPolygon, false);
                    model.addPolygonFace(Integer.MAX_VALUE, iPolygon.getPlane(true), point3dArray);
                }
            }
        }
        ArrayList arrayList = new ArrayList(collection.size());
        for (Face face : model.getFaces()) {
            if (!face.partOfGroup(Integer.MAX_VALUE)) continue;
            arrayList.add(face);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Face face = (Face)iterator.next();
            model.deleteFace(face, false, false);
        }
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            Face face = (Face)iterator2.next();
            for (FaceLoop faceLoop : face.edgeLoops) {
                for (EdgeUse edgeUse : faceLoop.edges) {
                    if (!edgeUse.edge.faces.isEmpty() || edgeUse.edge.partOfGroup(Integer.MAX_VALUE) && edgeUse.edge.groups.length != 1) continue;
                    model.deleteEdge(edgeUse.edge, true);
                }
            }
        }
    }

    public static int encodeModelId(int n, int n2) {
        assert (n2 < 6 && n2 >= 0);
        assert (n < (int)Math.pow(2.0, 29.0) && n >= 0);
        int n3 = n2 << 29;
        return n3 |= n;
    }

    public static int[] extractGridFaceId(int n) {
        int n2 = 0x1FFFFFFF & n;
        int n3 = n >>> 29;
        return new int[]{n2, n3};
    }

    private static Model modelFromGrid(AABox aABox, int n) {
        Model model = new Model();
        int[] nArray = new int[]{0, 1, 2, 3, 4, 5};
        Point3d[][] point3dArray = aABox.getFaces();
        assert (point3dArray.length == nArray.length);
        for (int i = 0; i < 6; ++i) {
            Point3d[] point3dArray2 = point3dArray[i];
            Plane3d plane3d = new Plane3d(true, point3dArray2);
            int n2 = GridMergeUtil.encodeModelId(n, nArray[i]);
            model.addPolygonFace(n2, plane3d, point3dArray2);
        }
        return model;
    }

    private static boolean isMergeDeleteFace(Model model, Model model2, int n, Model model3, Face face) {
        boolean bl;
        boolean bl2 = false;
        for (int n2 : face.groups) {
            if (GridMergeUtil.extractGridFaceId(n2)[0] != n) continue;
            bl2 = true;
            break;
        }
        boolean bl3 = bl = !bl2 || face.groups.length > 1;
        if (bl && !bl2 && NmtUtil.faceInSolid(model2, model3, face) || !bl && bl2 && NmtUtil.faceInSolid(model, model3, face)) {
            return true;
        }
        if (bl2 && bl) {
            Point3d point3d = model3.findPointInFace(face);
            if (point3d == null) {
                return false;
            }
            Vector3d vector3d = face.plane.getNormal();
            Point3d point3d2 = GridMergeUtil.findTestPoint(model3, face, point3d, vector3d);
            if (point3d2 == null) {
                return false;
            }
            vector3d.negate();
            Point3d point3d3 = GridMergeUtil.findTestPoint(model3, face, point3d, vector3d);
            if (point3d3 == null) {
                return false;
            }
            return model.contains(point3d2) && model2.contains(point3d3) || model.contains(point3d3) && model2.contains(point3d2);
        }
        return false;
    }

    private static Point3d findTestPoint(Model model, Face face, Point3d point3d, Vector3d vector3d) {
        AABox aABox = model.getBoundingBox();
        double d = aABox.getMin().distance(aABox.getMax()) * 2.0;
        Vector3d vector3d2 = Util3D.scale(vector3d, d);
        Point3d point3d2 = Util3D.add(point3d, (Tuple3d)vector3d2);
        LineSeg3D lineSeg3D = new LineSeg3D(point3d, point3d2);
        double d2 = Double.MAX_VALUE;
        for (Face face2 : model.getFaces()) {
            Pair<Double, Model.FaceClassify>[] pairArray;
            if (face2 == face || (pairArray = model.isect(lineSeg3D, face2, NmtUtil.acceptPointsOnFace(), 1.0E-6)).length <= 0 || !((Double)pairArray[0].v1 < d2)) continue;
            d2 = (Double)pairArray[0].v1;
        }
        return lineSeg3D.get(d2 * 0.5);
    }

    public static List<Face> getGridFaces(Model model, int n) {
        ArrayList<Face> arrayList = new ArrayList<Face>();
        block0: for (Face face : model.getFaces()) {
            for (int n2 : face.groups) {
                if (GridMergeUtil.extractGridFaceId(n2)[0] != n) continue;
                arrayList.add(face);
                continue block0;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Grid, BoundaryInfo> getGridBoundary(List<Grid> list, Model model) {
        void var4_9;
        int n4;
        ArrayList<BoundaryInfo> arrayList = new ArrayList<BoundaryInfo>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new BoundaryInfo(new ArrayList<Face>(0), new ArrayList<Edge>(0)));
        }
        for (Face aModelObj : model.getFaces()) {
            for (int n2 : aModelObj.groups) {
                n4 = GridMergeUtil.extractGridFaceId(n2)[0];
                assert (n4 >= 0 && n4 < list.size());
                ((BoundaryInfo)arrayList.get((int)n4)).faces.add(aModelObj);
            }
        }
        for (Edge edge : model.getEdges()) {
            int n3;
            Plane3d plane3d;
            Object object;
            boolean bl = true;
            if (!edge.partOfGroup(Integer.MAX_VALUE) && edge.faces.size() == 2 && (((Plane3d)(object = (Object)edge.faces.get((int)0).plane)).epsilonEquals(plane3d = edge.faces.get((int)1).plane, 1.0E-6) || new Plane3d((Plane3d)object).negate().epsilonEquals(plane3d, 1.0E-6))) {
                bl = false;
            }
            if (!bl) continue;
            for (int n4 : edge.groups) {
                if (n4 == Integer.MAX_VALUE) continue;
                n3 = GridMergeUtil.extractGridFaceId(n4)[0];
                ((BoundaryInfo)arrayList.get((int)n3)).boundaryEdges.add(edge);
            }
            object = edge.faces.iterator();
            while (object.hasNext()) {
                Face face = (Face)object.next();
                int[] nArray = face.groups;
                n4 = nArray.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    int n5 = nArray[n3];
                    int n6 = GridMergeUtil.extractGridFaceId(n5)[0];
                    ((BoundaryInfo)arrayList.get((int)n6)).boundaryEdges.add(edge);
                }
            }
        }
        LinkedIdentityHashMap linkedIdentityHashMap = new LinkedIdentityHashMap(list.size());
        boolean bl = false;
        while (var4_9 < list.size()) {
            linkedIdentityHashMap.put(list.get((int)var4_9), arrayList.get((int)var4_9));
            ++var4_9;
        }
        return linkedIdentityHashMap;
    }

    public static class BoundaryInfo {
        public final List<Face> faces;
        public final List<Edge> boundaryEdges;

        public BoundaryInfo(List<Face> list, List<Edge> list2) {
            this.faces = list;
            this.boundaryEdges = list2;
        }
    }

    public static class MergeResult {
        public final Model model;
        public final Map<Grid, BoundaryInfo> faces;

        public MergeResult(Model model, Map<Grid, BoundaryInfo> map) {
            this.model = model;
            this.faces = map;
        }
    }
}

