/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.PyroMod;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.geom.Vent;
import pyrosim.geom.Geometry;
import pyrosim.geom.TexCoordGenerator;
import pyrosim.geom.Util;
import pyrosim.io.PyroSimObjectInputStream;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PlanarCoordMapper;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.units.GeomUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class Grid
extends NamedPyroObject
implements IPyroGeomSrc,
ICustomFDSPropsContainer {
    static final long serialVersionUID = 1L;
    public static final int FACE_MIN_X = 0;
    public static final int FACE_MAX_X = 1;
    public static final int FACE_MIN_Y = 2;
    public static final int FACE_MAX_Y = 3;
    public static final int FACE_MIN_Z = 4;
    public static final int FACE_MAX_Z = 5;
    private UnitPoint3D d_minPoint;
    private UnitPoint3D d_maxPoint;
    private UnitDouble[] d_x;
    private UnitDouble[] d_y;
    private UnitDouble[] d_z;
    private List<Vent> d_attachedVents;
    private String d_fyi;
    private Color d_color;
    private boolean d_syncTimeStep = true;
    private boolean d_visible = true;
    private CustomFDSProps d_customProps;
    private boolean d_evacuation = false;
    private boolean d_evacHumans = false;
    private UnitDouble d_evacZOffset = new UnitDouble(1.0, SI.METER);

    public Grid(String string) {
        this(string, Geometry.UP3D_ZERO, new UnitPoint3D(10.0, 10.0, 3.0, SI.METER), 20, 20, 6);
    }

    public Grid(String string, UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, int n, int n2, int n3) {
        this(string, unitPoint3D, unitPoint3D2, Grid.makeUniformDivisions(n, unitPoint3D.xu(), unitPoint3D2.xu()), Grid.makeUniformDivisions(n2, unitPoint3D.yu(), unitPoint3D2.yu()), Grid.makeUniformDivisions(n3, unitPoint3D.zu(), unitPoint3D2.zu()));
    }

    public Grid(String string, GridGeom gridGeom) {
        this(string, gridGeom.min, gridGeom.max, gridGeom.dx, gridGeom.dy, gridGeom.dz);
    }

    public Grid(String string, UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, UnitDouble[] unitDoubleArray, UnitDouble[] unitDoubleArray2, UnitDouble[] unitDoubleArray3) {
        this.d_customProps = CustomFDSProps.EMPTY;
        this.setName(string);
        this.setGeom(unitPoint3D, unitPoint3D2, unitDoubleArray, unitDoubleArray2, unitDoubleArray3);
    }

    private void setGeom(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, UnitDouble[] unitDoubleArray, UnitDouble[] unitDoubleArray2, UnitDouble[] unitDoubleArray3) {
        this.d_minPoint = unitPoint3D;
        this.d_maxPoint = unitPoint3D2;
        this.d_x = unitDoubleArray;
        this.d_y = unitDoubleArray2;
        this.d_z = unitDoubleArray3;
        this.changedEvt(new Object[0]);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 29) {
            this.d_visible = true;
        }
        if (objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 30) {
            this.d_evacuation = false;
            this.d_evacHumans = false;
            this.d_evacZOffset = new UnitDouble(1.0, SI.METER);
        }
        if (objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 84 && this.d_customProps == null) {
            this.d_customProps = CustomFDSProps.EMPTY;
        }
        this.d_attachedVents = null;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getGridGeom());
    }

    public IGeom getGridGeom() {
        return new GridGeom(this.d_minPoint, this.d_maxPoint, this.d_x, this.d_y, this.d_z);
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    public void setGeom(IGeom iGeom) {
        if (iGeom instanceof GridGeom) {
            GridGeom gridGeom = (GridGeom)iGeom;
            this.setGeom(gridGeom.min, gridGeom.max, gridGeom.dx, gridGeom.dy, gridGeom.dz);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        Surface surface = null;
        if (this.getDomain() != null) {
            surface = ((PyroMod)this.getDomain()).getSimParams().getMisc().getSurfDefault();
        }
        IGeomNode iGeomNode = this.getGeom();
        PlanarCoordMapper planarCoordMapper = TexCoordGenerator.newGenerator(iGeomNode, TexOrigin.DEF_WORLD);
        IPropertySet iPropertySet = Elements.newElements("teciuv0x193fa", planarCoordMapper);
        iGeomNode = iGeomNode.applyLocalElements(iPropertySet);
        Color color = Grid.resolveColor(this.getColor(), surface);
        return new DisplayGeom(iGeomNode, (IPrimProps)new IPrimProps.Face(color, surface, 2));
    }

    private static Color resolveColor(Color color, Surface surface) {
        if (color != null) {
            return color;
        }
        return surface.getColor();
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.d_visible != bl) {
            this.d_visible = bl;
            this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
        }
    }

    public TexOrigin getTextureOrigin() {
        return TexOrigin.DEF_WORLD;
    }

    public Task taskImprint(Object object) {
        if (object instanceof Grid) {
            return EmptyTask.INSTANCE;
        }
        final Grid grid = (Grid)object;
        return new AOneTimeTask(){

            @Override
            public void run() {
                Grid.this.imprint(grid);
            }
        };
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getVolume() {
        return Util.calcVolume(this.d_minPoint, this.d_maxPoint);
    }

    public boolean syncTimeStep() {
        return this.d_syncTimeStep;
    }

    public void setSyncTimeStep(boolean bl) {
        this.d_syncTimeStep = bl;
        this.changedEvt(new Object[0]);
    }

    public void setColor(Color color) {
        this.d_color = color;
        this.changedEvt(new Object[0]);
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setEvacuation(boolean bl) {
        if (this.d_evacuation != bl) {
            this.d_evacuation = bl;
            this.changedEvt(new Object[0]);
        }
    }

    public boolean getEvacuation() {
        return this.d_evacuation;
    }

    public void setEvacHumans(boolean bl) {
        if (this.d_evacHumans != bl) {
            this.d_evacHumans = bl;
            this.changedEvt(new Object[0]);
        }
    }

    public boolean getEvacHumans() {
        return this.d_evacHumans;
    }

    public void setEvacZOffset(UnitDouble unitDouble) {
        if (this.d_evacZOffset != unitDouble) {
            this.d_evacZOffset = unitDouble;
            this.changedEvt(new Object[0]);
        }
    }

    public UnitDouble getEvacZOffset() {
        return this.d_evacZOffset;
    }

    private double getMinSpace(UnitDouble[] unitDoubleArray) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < unitDoubleArray.length; ++i) {
            d = Math.min(d, unitDoubleArray[i].getValue(unitDoubleArray[i].getUnit()));
        }
        return d;
    }

    @Override
    public Object clone() {
        Grid grid = (Grid)super.clone();
        grid.imprint(this);
        return grid;
    }

    public Task taskRefine(double d) {
        return new RefineGridTask(this, d);
    }

    private void coarsen(double d) {
        this.d_x = Grid.makeUniformDivisions(this.getRefinedDivisionsN(this.getXDivisions().length, 3, d), this.getMinPoint().xu(), this.getMaxPoint().xu());
        this.d_y = Grid.makeUniformDivisions(this.getRefinedDivisionsN(this.getYDivisions().length, 3, d), this.getMinPoint().yu(), this.getMaxPoint().yu());
        this.d_z = Grid.makeUniformDivisions(this.getRefinedDivisionsN(this.getZDivisions().length, 3, d), this.getMinPoint().zu(), this.getMaxPoint().zu());
        this.changedEvt(new Object[0]);
    }

    private void refine(int n) {
        this.d_x = Grid.getRefinedDivisions(this.getXDivisions(), n);
        this.d_y = Grid.getRefinedDivisions(this.getYDivisions(), n);
        this.d_z = Grid.getRefinedDivisions(this.getZDivisions(), n);
        this.changedEvt(new Object[0]);
    }

    private static UnitDouble[] getRefinedDivisions(UnitDouble[] unitDoubleArray, int n) {
        assert (0 < n);
        Object[] objectArray = new UnitDouble[unitDoubleArray.length * n];
        for (int i = 0; i < unitDoubleArray.length; ++i) {
            UnitDouble unitDouble = unitDoubleArray[i];
            UnitDouble unitDouble2 = new UnitDouble(unitDouble.getValueNoUnit() / (double)n, unitDouble.getUnit());
            int n2 = i * n;
            Arrays.fill(objectArray, n2, n2 + n, unitDouble2);
        }
        return objectArray;
    }

    private int getRefinedDivisionsN(int n, int n2, double d) {
        n2 = Math.min(n, n2);
        return (int)Math.round(Math.max((double)n2, (double)n * d));
    }

    public Task taskImprint(Grid grid) {
        return new ImprintGridTask(this, grid);
    }

    public void imprint(Grid grid) {
        int n;
        assert (this != grid);
        this.pauseUpdates(false);
        this.d_fyi = grid.d_fyi;
        this.setName(grid.getName());
        this.d_minPoint = grid.d_minPoint;
        this.d_maxPoint = grid.d_maxPoint;
        this.d_x = new UnitDouble[grid.d_x.length];
        for (n = 0; n < grid.d_x.length; ++n) {
            this.d_x[n] = grid.d_x[n];
        }
        this.d_y = new UnitDouble[grid.d_y.length];
        for (n = 0; n < grid.d_y.length; ++n) {
            this.d_y[n] = grid.d_y[n];
        }
        this.d_z = new UnitDouble[grid.d_z.length];
        for (n = 0; n < grid.d_z.length; ++n) {
            this.d_z[n] = grid.d_z[n];
        }
        this.d_color = grid.d_color;
        this.d_syncTimeStep = grid.d_syncTimeStep;
        this.d_evacuation = grid.d_evacuation;
        this.d_evacHumans = grid.d_evacHumans;
        this.d_evacZOffset = grid.d_evacZOffset;
        this.d_customProps = grid.d_customProps;
        this.resumeUpdates();
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object object) {
        int n;
        if (!(object instanceof Grid)) {
            return false;
        }
        Grid grid = (Grid)object;
        if (this.d_x.length != grid.d_x.length || this.d_y.length != grid.d_y.length || this.d_z.length != grid.d_z.length) {
            return false;
        }
        for (n = 0; n < this.d_x.length; ++n) {
            if (this.d_x[n].equals(grid.d_x[n])) continue;
            return false;
        }
        for (n = 0; n < this.d_y.length; ++n) {
            if (this.d_y[n].equals(grid.d_y[n])) continue;
            return false;
        }
        for (n = 0; n < this.d_z.length; ++n) {
            if (this.d_z[n].equals(grid.d_z[n])) continue;
            return false;
        }
        n = this.getName().equals(grid.getName()) && (this.d_color == null ? grid.d_color == null : this.d_color.equals(grid.d_color)) && this.d_syncTimeStep == grid.d_syncTimeStep && (this.d_minPoint == null ? grid.d_minPoint == null : this.d_minPoint.equals(grid.d_minPoint)) && (this.d_maxPoint == null ? grid.d_maxPoint == null : this.d_maxPoint.equals(grid.d_maxPoint)) ? 1 : 0;
        return n != 0;
    }

    public static UnitDouble[] makeUniformDivisions(int n, UnitDouble unitDouble, UnitDouble unitDouble2) {
        Object[] objectArray = new UnitDouble[n];
        BaseUnit baseUnit = SI.METER;
        double d = (unitDouble2.getValue(baseUnit) - unitDouble.getValue(baseUnit)) / (double)n;
        Arrays.fill(objectArray, new UnitDouble(d, baseUnit));
        return objectArray;
    }

    public UnitPoint3D getMinPoint() {
        return this.d_minPoint;
    }

    public UnitPoint3D getMaxPoint() {
        return this.d_maxPoint;
    }

    public UnitDouble[] getXDivisions() {
        return this.d_x;
    }

    public UnitDouble[] getYDivisions() {
        return this.d_y;
    }

    public UnitDouble[] getZDivisions() {
        return this.d_z;
    }

    private static UnitDouble[] convertDivisionsToPositions(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble[] unitDoubleArray) {
        UnitDouble[] unitDoubleArray2 = new UnitDouble[unitDoubleArray.length + 1];
        unitDoubleArray2[0] = unitDouble;
        for (int i = 1; i < unitDoubleArray2.length; ++i) {
            unitDoubleArray2[i] = unitDoubleArray2[i - 1];
            unitDoubleArray2[i] = unitDoubleArray2[i].add(unitDoubleArray[i - 1]);
        }
        return unitDoubleArray2;
    }

    private static double[] convertDivisionsToDoublePositions(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble[] unitDoubleArray) {
        double[] dArray = new double[unitDoubleArray.length + 1];
        dArray[0] = unitDouble.getValue(Geometry.LU);
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = dArray[i - 1];
            dArray[i] = dArray[i] + unitDoubleArray[i - 1].getValue(Geometry.LU);
        }
        return dArray;
    }

    public UnitDouble[] getLinePositions(int n) {
        switch (n) {
            case 0: {
                return this.getXLinePositions();
            }
            case 1: {
                return this.getYLinePositions();
            }
        }
        return this.getZLinePositions();
    }

    public UnitDouble[] getXLinePositions() {
        return Grid.convertDivisionsToPositions(this.d_minPoint.xu(), this.d_maxPoint.xu(), this.d_x);
    }

    public UnitDouble[] getYLinePositions() {
        return Grid.convertDivisionsToPositions(this.d_minPoint.yu(), this.d_maxPoint.yu(), this.d_y);
    }

    public UnitDouble[] getZLinePositions() {
        return Grid.convertDivisionsToPositions(this.d_minPoint.zu(), this.d_maxPoint.zu(), this.d_z);
    }

    public String getUniqueID() {
        return this.getName();
    }

    @Override
    public void getAll(Consumer<Object> consumer, IIsectFilter iIsectFilter) {
    }

    @Override
    public String toString() {
        return String.format("Grid[name=%s]", this.getName());
    }

    @Override
    public void getCustomFDSTypes(Collection<String> collection) {
        collection.add("MESH");
    }

    @Override
    public void setCustomFDSProps(String string, CustomFDSProps customFDSProps) {
        this.d_customProps = customFDSProps;
        this.changedEvt(new Object[0]);
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String string) {
        return this.d_customProps;
    }

    private static class RefineGridTask
    implements Task {
        private final Grid d_target;
        private final Grid d_holder;
        private final double d_factor;

        public RefineGridTask(Grid grid, double d) {
            this.d_target = grid;
            this.d_factor = d;
            this.d_holder = new Grid(grid.getName());
            this.d_holder.imprint(grid);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            this.d_target.imprint(this.d_holder);
        }

        @Override
        public int getEst() {
            return 0;
        }

        @Override
        public void run() {
            if (1.0 <= this.d_factor) {
                this.d_target.refine((int)Math.round(this.d_factor));
            } else {
                this.d_target.coarsen(this.d_factor);
            }
        }
    }

    private static class ImprintGridTask
    implements Task {
        private final Grid d_target;
        private final Grid d_holder;
        private final Grid d_newData;

        public ImprintGridTask(Grid grid, Grid grid2) {
            this.d_target = grid;
            this.d_newData = grid2;
            this.d_holder = new Grid(grid.getName());
            this.d_holder.imprint(grid);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            this.d_target.imprint(this.d_holder);
        }

        @Override
        public int getEst() {
            return 0;
        }

        @Override
        public void run() {
            this.d_target.imprint(this.d_newData);
        }
    }

    public static class GridGeom
    implements IGeom,
    IManipulatable {
        private static final long serialVersionUID = -7586528457893615416L;
        private final UnitPoint3D min;
        private final UnitPoint3D max;
        private final UnitDouble[] dx;
        private final UnitDouble[] dy;
        private final UnitDouble[] dz;

        public GridGeom(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, UnitDouble[] unitDoubleArray, UnitDouble[] unitDoubleArray2, UnitDouble[] unitDoubleArray3) {
            this.min = unitPoint3D;
            this.max = unitPoint3D2;
            this.dx = unitDoubleArray;
            this.dy = unitDoubleArray2;
            this.dz = unitDoubleArray3;
        }

        @Override
        public IGeom optimize(IPointOptimizer iPointOptimizer) {
            return this;
        }

        @Override
        public int getNumPrims(int n) {
            return 0;
        }

        @Override
        public boolean isAxisAlignedBlock(TransformInfo transformInfo) {
            return true;
        }

        @Override
        public boolean isShell() {
            return Boolean.FALSE;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public IGeom transform(TransformInfo transformInfo, int n) {
            if (transformInfo.isIdentity()) {
                return this;
            }
            Matrix4d matrix4d = transformInfo.getMatrix();
            UnitPoint3D unitPoint3D = Geometry.xform(matrix4d, this.min);
            UnitPoint3D unitPoint3D2 = Geometry.xform(matrix4d, this.max);
            UnitPoint3D[] unitPoint3DArray = GeomUtil.rectify(unitPoint3D, unitPoint3D2);
            unitPoint3D = unitPoint3DArray[0];
            unitPoint3D2 = unitPoint3DArray[1];
            int[] nArray = this.getSwizzle(matrix4d);
            UnitDouble[][] unitDoubleArray = new UnitDouble[3][];
            unitDoubleArray[nArray[0]] = new UnitDouble[this.dx.length];
            unitDoubleArray[nArray[1]] = new UnitDouble[this.dy.length];
            unitDoubleArray[nArray[2]] = new UnitDouble[this.dz.length];
            this.xform(matrix4d, this.dx, 0, nArray, unitDoubleArray);
            this.xform(matrix4d, this.dy, 1, nArray, unitDoubleArray);
            this.xform(matrix4d, this.dz, 2, nArray, unitDoubleArray);
            return new GridGeom(unitPoint3D, unitPoint3D2, unitDoubleArray[0], unitDoubleArray[1], unitDoubleArray[2]);
        }

        private void xform(Matrix4d matrix4d, UnitDouble[] unitDoubleArray, int n, int[] nArray, UnitDouble[][] unitDoubleArray2) {
            Unit unit = Geometry.LU;
            double[] dArray = new double[]{0.0, 0.0, 0.0};
            double[] dArray2 = new double[3];
            Vector3d vector3d = new Vector3d();
            UnitDouble[] unitDoubleArray3 = unitDoubleArray2[nArray[n]];
            for (int i = 0; i < unitDoubleArray.length; ++i) {
                dArray[n] = unitDoubleArray[i].getValue(unit);
                vector3d.set(dArray);
                matrix4d.transform(vector3d);
                vector3d.get(dArray2);
                Unit unit2 = unitDoubleArray[i].getUnit();
                double d = unit.getConverterTo(unit2).convert(dArray2[nArray[n]]);
                int n2 = i;
                if (d < 0.0) {
                    n2 = unitDoubleArray3.length - i - 1;
                    d = -d;
                }
                unitDoubleArray3[n2] = new UnitDouble(d, unit2);
            }
        }

        private int[] getSwizzle(Matrix4d matrix4d) {
            Vector3d vector3d = new Vector3d(1.0, 0.0, 0.0);
            Vector3d vector3d2 = new Vector3d(0.0, 1.0, 0.0);
            Vector3d vector3d3 = new Vector3d(0.0, 0.0, 1.0);
            matrix4d.transform(vector3d);
            matrix4d.transform(vector3d2);
            matrix4d.transform(vector3d3);
            vector3d.normalize();
            vector3d2.normalize();
            vector3d3.normalize();
            int n = theUtil.eq(Math.abs(vector3d.x), 1.0, 1.0E-6) ? 0 : (theUtil.eq(Math.abs(vector3d.y), 1.0, 1.0E-6) ? 1 : 2);
            int n2 = theUtil.eq(Math.abs(vector3d2.x), 1.0, 1.0E-6) ? 0 : (theUtil.eq(Math.abs(vector3d2.y), 1.0, 1.0E-6) ? 1 : 2);
            int n3 = theUtil.eq(Math.abs(vector3d3.x), 1.0, 1.0E-6) ? 0 : (theUtil.eq(Math.abs(vector3d3.y), 1.0, 1.0E-6) ? 1 : 2);
            assert (n != n2 && n != n3 && n2 != n3);
            return new int[]{n, n2, n3};
        }

        @Override
        public AABox getBoundingBox(AABox aABox) {
            this.min.add(aABox, Geometry.LU);
            this.max.add(aABox, Geometry.LU);
            return aABox;
        }

        @Override
        public boolean canExplode() {
            return false;
        }

        @Override
        public Collection<IGeom> explode(Collection<IGeom> collection) {
            return collection;
        }

        @Override
        public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        }

        @Override
        public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        }

        @Override
        public void find(ITest<AABox> iTest, IResult<? super IPrimitive> iResult) {
        }

        @Override
        public void getAll(IResult<? super IPrimitive> iResult) {
        }

        @Override
        public Collection<? extends IHandle> generateManipHandles() {
            AABoxGeom aABoxGeom = new AABoxGeom(this.min.getPoint3dValue(Geometry.LU), this.max.getPoint3dValue(Geometry.LU), 0);
            Collection<? extends IHandle> collection = aABoxGeom.generateManipHandles();
            ArrayList<Handle> arrayList = new ArrayList<Handle>(collection.size());
            for (IHandle iHandle : collection) {
                arrayList.add(new Handle(this, iHandle));
            }
            return arrayList;
        }

        private static class Handle
        implements IHandle {
            private final GridGeom geom;
            private final IHandle handle;
            private double[] d_x;
            private double[] d_y;
            private double[] d_z;

            public Handle(GridGeom gridGeom, IHandle iHandle) {
                this.geom = gridGeom;
                this.handle = iHandle;
            }

            public boolean equals(Object object) {
                return object == this || object instanceof Handle && ((Handle)object).handle.equals(this.handle);
            }

            @Override
            public IGeomNode getGeom() {
                return this.handle.getGeom();
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return this.handle.getPickFilter();
            }

            @Override
            public ISnapConstraint getConstraint(Point3d point3d) {
                return this.handle.getConstraint(point3d);
            }

            @Override
            public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
                this.handle.begin(point3d, iSnapConstraint);
                this.d_x = Grid.convertDivisionsToDoublePositions(this.geom.min.xu(), this.geom.max.xu(), this.geom.dx);
                this.d_y = Grid.convertDivisionsToDoublePositions(this.geom.min.yu(), this.geom.max.yu(), this.geom.dy);
                this.d_z = Grid.convertDivisionsToDoublePositions(this.geom.min.zu(), this.geom.max.zu(), this.geom.dz);
            }

            @Override
            public Object modify(Point3d point3d) throws ManipException {
                Object object = this.handle.modify(point3d);
                return this.convert(object);
            }

            @Override
            public Object end() {
                GridGeom gridGeom = null;
                try {
                    gridGeom = this.convert(this.handle.end());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.d_z = null;
                this.d_y = null;
                this.d_x = null;
                return gridGeom;
            }

            private GridGeom convert(Object object) throws ManipException {
                if (!(object instanceof AABoxGeom)) {
                    return null;
                }
                AABoxGeom aABoxGeom = (AABoxGeom)object;
                Pair<Double, Integer> pair = this.snapCoordinate(this.d_x, aABoxGeom.min.x);
                Pair<Double, Integer> pair2 = this.snapCoordinate(this.d_x, aABoxGeom.max.x);
                Pair<Double, Integer> pair3 = this.snapCoordinate(this.d_y, aABoxGeom.min.y);
                Pair<Double, Integer> pair4 = this.snapCoordinate(this.d_y, aABoxGeom.max.y);
                Pair<Double, Integer> pair5 = this.snapCoordinate(this.d_z, aABoxGeom.min.z);
                Pair<Double, Integer> pair6 = this.snapCoordinate(this.d_z, aABoxGeom.max.z);
                return new GridGeom(new UnitPoint3D((Double)pair.v1, (Double)pair3.v1, (Double)pair5.v1, Geometry.LU), new UnitPoint3D((Double)pair2.v1, (Double)pair4.v1, (Double)pair6.v1, Geometry.LU), Handle.trimDivs(this.geom.dx, (Integer)pair.v2, (Integer)pair2.v2), Handle.trimDivs(this.geom.dy, (Integer)pair3.v2, (Integer)pair4.v2), Handle.trimDivs(this.geom.dz, (Integer)pair5.v2, (Integer)pair6.v2));
            }

            private Pair<Double, Integer> snapCoordinate(double[] dArray, double d) {
                if (dArray.length < 2) {
                    return new Pair<Double, Integer>(d, 0);
                }
                int n = Arrays.binarySearch(dArray, d);
                if (n >= 0) {
                    return new Pair<Double, Integer>(d, n);
                }
                int n2 = -n - 1;
                if (n2 == 0) {
                    double d2 = dArray[1] - dArray[0];
                    int n3 = (int)Math.round((d - dArray[0]) / d2);
                    return new Pair<Double, Integer>(dArray[0] + d2 * (double)n3, n3);
                }
                if (n2 == dArray.length) {
                    double d3 = dArray[dArray.length - 1] - dArray[dArray.length - 2];
                    int n4 = (int)Math.round((d - dArray[dArray.length - 1]) / d3);
                    return new Pair<Double, Integer>(dArray[dArray.length - 1] + d3 * (double)n4, n4 + dArray.length - 1);
                }
                double d4 = dArray[n2 - 1];
                double d5 = dArray[n2];
                return d - d4 < d5 - d ? new Pair<Double, Integer>(d4, n2 - 1) : new Pair<Double, Integer>(d5, n2);
            }

            private static UnitDouble[] trimDivs(UnitDouble[] unitDoubleArray, int n, int n2) throws ManipException {
                int n3;
                int n4;
                if (unitDoubleArray.length == 0) {
                    return unitDoubleArray;
                }
                if (--n2 < n) {
                    throw new ManipException();
                }
                ArrayList<UnitDouble> arrayList = new ArrayList<UnitDouble>();
                if (n < 0) {
                    n4 = Math.abs(n);
                    for (n3 = 0; n3 < n4; ++n3) {
                        arrayList.add(unitDoubleArray[0]);
                    }
                    n = 0;
                }
                for (n4 = n; n4 <= Math.min(unitDoubleArray.length - 1, n2); ++n4) {
                    arrayList.add(unitDoubleArray[n4]);
                }
                if (n2 >= unitDoubleArray.length) {
                    n4 = Math.abs(n2 + 1 - unitDoubleArray.length);
                    for (n3 = 0; n3 < n4; ++n3) {
                        arrayList.add(unitDoubleArray[unitDoubleArray.length - 1]);
                    }
                }
                return arrayList.toArray(new UnitDouble[arrayList.size()]);
            }
        }
    }
}

