/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.awt.Color;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.output.StatGeom;
import pyrosim.geom.Geometry;
import pyrosim.geom.IGeomSource;
import pyrosim.geom.IPyroDisplayProps;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.IProxyGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.ManifoldSolid;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class GeomUtil
extends thunderheadeng.geometry.objs.GeomUtil {
    public static AABox getBounds(IGeom iGeom) {
        AABox aABox = new AABox();
        iGeom.getBoundingBox(aABox);
        return aABox;
    }

    public static AABox getBounds(IGeomSource iGeomSource) {
        return iGeomSource.getBounds();
    }

    public static AABox getBounds(Collection<? extends IGeomSource> collection) {
        AABox aABox = new AABox();
        for (IGeomSource iGeomSource : collection) {
            aABox.add(iGeomSource.getBounds());
        }
        return aABox;
    }

    public static UnitAABox getUnitBounds(IGeomSource iGeomSource) {
        return new UnitAABox(GeomUtil.getBounds(iGeomSource), Geometry.LU);
    }

    public static UnitAABox getUnitBounds(IGeom iGeom) {
        return new UnitAABox(GeomUtil.getBounds(iGeom), Geometry.LU);
    }

    public static <T> boolean isUniform(T[] TArray, boolean bl) {
        if (TArray.length == 0) {
            return false;
        }
        T t = TArray[0];
        if (bl) {
            for (int i = 1; i < TArray.length; ++i) {
                if (TArray[i] == t) continue;
                return false;
            }
        } else {
            for (int i = 1; i < TArray.length; ++i) {
                if (theUtil.equal(t, TArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    public static <T> T[] optimizeArray(T[] TArray, Class<T> clazz, boolean bl) {
        if (!GeomUtil.isUniform(TArray, bl) || TArray.length <= 1) {
            return TArray;
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, 1);
        objectArray[0] = TArray[0];
        return objectArray;
    }

    public static boolean isUniform(Surface[] surfaceArray) {
        return GeomUtil.isUniform(surfaceArray, true);
    }

    public static Surface[] optimize(Surface[] surfaceArray) {
        return GeomUtil.optimizeArray(surfaceArray, Surface.class, true);
    }

    public static boolean isUniform(Color[] colorArray) {
        return GeomUtil.isUniform(colorArray, false);
    }

    public static Color[] optimize(Color[] colorArray) {
        return GeomUtil.optimizeArray(colorArray, Color.class, false);
    }

    public static Pair<Surface[], Color[]> getSurfsAndColors(int n, IPropsSrc iPropsSrc) {
        Color[] colorArray;
        Surface[] surfaceArray;
        int n2 = iPropsSrc.getUniformCount(0, n);
        if (n2 == n) {
            IPrimProps iPrimProps = iPropsSrc.iterator().next();
            surfaceArray = new Surface[]{(Surface)iPrimProps.getMaterial()};
            colorArray = new Color[]{iPrimProps.getColor()};
        } else {
            surfaceArray = new Surface[n];
            colorArray = new Color[n];
            int n3 = 0;
            for (IPrimProps iPrimProps : iPropsSrc) {
                surfaceArray[n3] = (Surface)iPrimProps.getMaterial();
                colorArray[n3] = iPrimProps.getColor();
                ++n3;
            }
            surfaceArray = GeomUtil.optimize(surfaceArray);
            colorArray = GeomUtil.optimize(colorArray);
        }
        return new Pair<Surface[], Color[]>(surfaceArray, colorArray);
    }

    public static DisplayGeom convertToOutline(DisplayGeom displayGeom) {
        IGeomNode iGeomNode = displayGeom.node.flatten();
        List<IPrimitive> list = thunderheadeng.geometry.objs.GeomUtil.explodeToTypes(iGeomNode.getLocalGeom(), 7);
        IElemSource<Boolean> iElemSource = iGeomNode.getElements(Elements.CREASE);
        IElemSource<Elements.Orient> iElemSource2 = iGeomNode.getElements(Elements.ORIENT);
        ArrayList arrayList = new ArrayList();
        PropsBuilder propsBuilder = new PropsBuilder();
        Elements.processPolys(list, (list2, n, bl) -> {
            if (!bl.booleanValue()) {
                return;
            }
            int n2 = list2.size();
            List<Boolean> list3 = iElemSource.subset((int)n, n2).generate(Boolean.class, (List<IPolygon>)list2, iElemSource2.subset((int)n, n2), displayGeom.props.subset((int)n, n2));
            Iterator<Boolean> iterator = list3.iterator();
            Iterator<IPrimProps> iterator2 = displayGeom.props.subset((int)n, n2).iterator();
            for (IPrimitive iPrimitive : list2) {
                IPolygon iPolygon = (IPolygon)iPrimitive;
                IPrimProps iPrimProps = iterator2.next();
                int n3 = iPolygon.getNumLoops();
                for (int i = 0; i < n3; ++i) {
                    int n4 = iPolygon.getNumPoints(i);
                    for (int j = 0; j < n4; ++j) {
                        Boolean bl2 = iterator.next();
                        if (!bl2.booleanValue()) continue;
                        arrayList.add(iPolygon.getPoint(i, j));
                        arrayList.add(iPolygon.getPoint(i, (j + 1) % n4));
                        propsBuilder.add(iPrimProps);
                    }
                }
            }
        });
        Mesh mesh = new Mesh(theUtil.toArray(arrayList, Point3d.class), theUtil.sequentialList(0, arrayList.size()), 1);
        IPropsSrc iPropsSrc = propsBuilder.finalizeProps();
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(mesh), iPropsSrc);
    }

    public static boolean isCullGeom(IGeomNode iGeomNode) {
        if (GeomUtil.isCullGeom(iGeomNode.getLocalGeom())) {
            return true;
        }
        for (IGeomNode iGeomNode2 : iGeomNode.getChildren()) {
            if (!GeomUtil.isCullGeom(iGeomNode2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCullGeom(IGeom iGeom) {
        if (iGeom instanceof AABoxGeom) {
            return true;
        }
        if (iGeom instanceof IProxyGeom) {
            return GeomUtil.isCullGeom(((IProxyGeom)iGeom).getBase());
        }
        if (iGeom instanceof GeomGroup) {
            for (IGeom iGeom2 : ((GeomGroup)iGeom).children) {
                if (GeomUtil.isCullGeom(iGeom2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<IPolygon> toPolys(IFace iFace, double d, boolean bl) {
        ArrayList<IPolygon> arrayList = new ArrayList<IPolygon>();
        GeomUtil.toPolys(iFace, d, bl, arrayList);
        return arrayList;
    }

    public static void toPolys(IFace iFace, double d, boolean bl, List<IPolygon> list) {
        if (iFace instanceof IPolygon) {
            IPolygon iPolygon = (IPolygon)iFace;
            if (!bl || iPolygon.getNumLoops() <= 1) {
                list.add(iPolygon);
                return;
            }
        }
        list.addAll(thunderheadeng.geometry.objs.GeomUtil.getTriangles(d, iFace));
    }

    public static <T> T[] matchPrimCount(IGeomNode iGeomNode, int n, T[] TArray, Class<T> clazz) {
        return GeomUtil.matchPrimCount(iGeomNode, n, TArray, clazz, false);
    }

    public static <T> T[] matchPrimCount(IGeomNode iGeomNode, int n, T[] TArray, Class<T> clazz, boolean bl) {
        return GeomUtil.matchPrimCount(TArray, clazz, bl, iGeomNode.getNumPrims(n));
    }

    public static <T> T[] matchPrimCount(T[] TArray, Class<T> clazz, boolean bl, int n) {
        if (TArray.length == n) {
            return bl ? (Object[])TArray.clone() : TArray;
        }
        assert (TArray.length == 1);
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = TArray[0];
        }
        return objectArray;
    }

    public static Task taskChanged(IPyroObject iPyroObject) {
        return new ChangedTask(iPyroObject);
    }

    public static IPolygon toPoly(Face face) {
        return GeomUtil.toPoly(face, nArray -> {});
    }

    public static IPolygon toPoly(Face face, Consumer<int[]> consumer) {
        ArrayList<Point3d[]> arrayList = new ArrayList<Point3d[]>();
        for (int i = 0; i < face.edgeLoops.size(); ++i) {
            FaceLoop faceLoop = face.edgeLoops.get(i);
            if (faceLoop.edges.size() < 3) continue;
            Point3d[] point3dArray = new Point3d[faceLoop.edges.size()];
            for (int j = 0; j < faceLoop.edges.size(); ++j) {
                EdgeUse edgeUse = faceLoop.edges.get(j);
                point3dArray[j] = edgeUse.v1().loc;
                consumer.accept(edgeUse.edge.groups);
            }
            arrayList.add(point3dArray);
        }
        return PolyUtil.newPoly(theUtil.toArray(arrayList, Point3d[].class));
    }

    public static DisplayGeom generateClipCaps(IPyroDisplayProps iPyroDisplayProps, DisplayGeom displayGeom, ConvexHull convexHull, IPropsSrc serializable, boolean bl, IElemSource<Point2d> iElemSource) {
        if (iPyroDisplayProps == null) {
            return DisplayGeom.EMPTY;
        }
        try {
            Point3d[] point3dArray;
            Object object;
            if (displayGeom.node.getNumPrims(1) == 0) {
                return DisplayGeom.EMPTY;
            }
            IFilteredCollection<Pair> iFilteredCollection = theUtil.filter(displayGeom.node.quickFlatten(1), pair -> !((IGeom)pair.v2).isShell());
            if (iFilteredCollection.isEmpty()) {
                return DisplayGeom.EMPTY;
            }
            AABox aABox = displayGeom.node.getBoundingBox(new AABox());
            if (convexHull.test(aABox) != Containment.INTERSECTS) {
                return DisplayGeom.EMPTY;
            }
            Model model = null;
            Matrix4d matrix4d = null;
            Matrix4d matrix4d2 = null;
            Point3d point3d = null;
            AABox aABox2 = null;
            Plane3d[] plane3dArray = convexHull.getPlanes();
            for (int i = 0; i < plane3dArray.length; ++i) {
                object = plane3dArray[i];
                double d = Inter3D.testPlaneAABox((Plane3d)object, aABox, 1.0E-6);
                if (d != 0.0) continue;
                if (model == null) {
                    model = new Model();
                    matrix4d = new Matrix4d();
                    matrix4d2 = new Matrix4d();
                    point3d = new Point3d();
                    aABox2 = new AABox();
                } else {
                    aABox2.reset();
                }
                Util.getPlaneTransforms((Plane3d)object, matrix4d, matrix4d2);
                for (int j = 0; j < 8; ++j) {
                    aABox.getCorner(j, point3d);
                    matrix4d.transform(point3d);
                    aABox2.add(point3d);
                }
                aABox2 = aABox2.scale(1.5);
                point3dArray = new Point3d[]{new Point3d(aABox2.getMinX(), aABox2.getMinY(), 0.0), new Point3d(aABox2.getMaxX(), aABox2.getMinY(), 0.0), new Point3d(aABox2.getMaxX(), aABox2.getMaxY(), 0.0), new Point3d(aABox2.getMinX(), aABox2.getMaxY(), 0.0)};
                for (Point3d serializable22 : point3dArray) {
                    matrix4d2.transform(serializable22);
                }
                model.addPolygonFace(i, (Plane3d)object, point3dArray);
            }
            if (model == null || model.getFaces().isEmpty()) {
                return DisplayGeom.EMPTY;
            }
            ArrayList<IGeom> arrayList = new ArrayList<IGeom>(theUtil.map(iFilteredCollection, pair -> ((IGeom)pair.v2).transform((TransformInfo)pair.v1, 0)));
            object = thunderheadeng.geometry.objs.GeomUtil.explode(arrayList, IFace.class);
            ArrayList<Face> arrayList2 = new ArrayList<Face>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2;
                point3dArray = (IFace)iterator.next();
                boolean bl2 = true;
                if (point3dArray instanceof IPolygon && (object2 = (IPolygon)point3dArray).getNumLoops() == 1) {
                    model.addPolygonFace(Integer.MAX_VALUE, object2.getPlane(true), PolyUtil.getAllVerts((IPolygon)object2, false));
                    bl2 = false;
                }
                if (bl2) {
                    object2 = point3dArray.triangulate(iPyroDisplayProps.getFaceError());
                    int n = 0;
                    while (n < ((Mesh)object2).indices.length) {
                        Point3d point3d2 = ((Mesh)object2).vertices[((Mesh)object2).indices[n++]];
                        Point3d point3d3 = ((Mesh)object2).vertices[((Mesh)object2).indices[n++]];
                        Point3d point3d4 = ((Mesh)object2).vertices[((Mesh)object2).indices[n++]];
                        model.addPolygonFace(Integer.MAX_VALUE, new Plane3d(true, point3d2, point3d3, point3d4), point3d2, point3d3, point3d4);
                    }
                }
                arrayList2.clear();
                arrayList2.addAll(model.getFaces(Integer.MAX_VALUE));
                object2 = arrayList2.iterator();
                while (object2.hasNext()) {
                    Face face = (Face)object2.next();
                    if (face.groups.length > 1) continue;
                    model.deleteFace(face, true, true);
                }
            }
            int n = -1;
            if (serializable == null || bl) {
                int n2;
                point3dArray = null;
                int n3 = displayGeom.node.getNumPrims(7);
                for (int i = 0; i < n3; i += n2) {
                    n2 = displayGeom.props.getUniformCount(i, n3 - i);
                    IPrimProps iPrimProps = displayGeom.props.get(i);
                    if (!(iPrimProps instanceof IPrimProps.Face)) continue;
                    point3dArray = new UniformProps(iPrimProps);
                    break;
                }
                if (point3dArray == null) {
                    return DisplayGeom.EMPTY;
                }
                if (serializable == null) {
                    serializable = point3dArray;
                } else {
                    IPrimProps iPrimProps = point3dArray.get(0);
                    if (iPrimProps.getMaterial() == null) {
                        n = iPrimProps.getColor().getAlpha();
                    } else {
                        IMatAttrs iMatAttrs = iPrimProps.getMaterial().getAttributes();
                        n = iMatAttrs.getAlphaFromDiffuseAndOpacity();
                    }
                }
            }
            point3dArray = null;
            ArrayList<IPolygon> arrayList3 = new ArrayList<IPolygon>();
            PropsBuilder propsBuilder = new PropsBuilder();
            for (Face face : model.getFaces()) {
                Object object2;
                point3d = model.findPointInFace(face);
                if (point3d == null || !convexHull.contains(point3d, 1.0E-6)) continue;
                if (face.groups.length == 1) {
                    if (point3dArray == null) {
                        point3dArray = new ArrayList();
                        for (IGeom iGeom : arrayList) {
                            point3dArray.add(new ManifoldSolid(iGeom, false));
                        }
                    }
                    boolean bl2 = false;
                    Iterator iterator2 = point3dArray.iterator();
                    while (iterator2.hasNext()) {
                        object2 = (ManifoldSolid)iterator2.next();
                        if (((ManifoldSolid)object2).classify(point3d, 1.0E-6) == ManifoldSolid.PointClassify.OUTSIDE) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                }
                IPolygon iPolygon = GeomUtil.toPoly(face);
                arrayList3.add(iPolygon);
                Object object3 = -1;
                for (int n2 : face.groups) {
                    if (n2 == Integer.MAX_VALUE) continue;
                    object3 = n2;
                    break;
                }
                assert (object3 != -1);
                object2 = serializable.get((int)object3);
                if (n != -1 && n != object2.getColor().getAlpha()) {
                    Color color = object2.getColor();
                    object2 = object2.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n));
                }
                propsBuilder.add((IPrimProps)object2);
            }
            if (arrayList3.isEmpty()) {
                return DisplayGeom.EMPTY;
            }
            IPropertySet iPropertySet = Elements.newElements("teciuv0x193fa", iElemSource);
            GeomNodeLeaf geomNodeLeaf = GeomNodeUtil.newNode(thunderheadeng.geometry.objs.GeomUtil.group(arrayList3), iPropertySet);
            return new DisplayGeom((IGeomNode)geomNodeLeaf, propsBuilder.finalizeProps());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return DisplayGeom.EMPTY;
        }
    }

    public static List<Pair<TransformInfo, IGeom>> flatten(IGeomNode iGeomNode) {
        return iGeomNode.quickFlatten(1);
    }

    private static Point3d[] calcPointArray(Point3d point3d, Point3d point3d2, int n) {
        Point3d[] point3dArray = new Point3d[n];
        double d = (point3d2.x - point3d.x) / (double)(n - 1);
        double d2 = (point3d2.y - point3d.y) / (double)(n - 1);
        double d3 = (point3d2.z - point3d.z) / (double)(n - 1);
        point3dArray[0] = point3d;
        point3dArray[n - 1] = point3d2;
        for (int i = 1; i < n - 1; ++i) {
            point3dArray[i] = new Point3d(point3d.x + d * (double)i, point3d.y + d2 * (double)i, point3d.z + d3 * (double)i);
        }
        return point3dArray;
    }

    public static DisplayGeom generateLinearArrayDisplayGeom(StatGeom.LinearArrayGeom linearArrayGeom, IPrimProps iPrimProps) {
        Point3d[] point3dArray;
        assert (linearArrayGeom instanceof LineSeg);
        ArrayList<APrimitive> arrayList = new ArrayList<APrimitive>();
        PropsBuilder propsBuilder = new PropsBuilder();
        arrayList.add(linearArrayGeom);
        propsBuilder.add(new IPrimProps.Edge(iPrimProps.getColor(), 3.0, IPrimProps.DEF_STIPPLE, 0));
        for (Point3d point3d : point3dArray = GeomUtil.calcPointArray(linearArrayGeom.p1, linearArrayGeom.p2, linearArrayGeom.d_numPoints)) {
            arrayList.add(new Point(point3d));
            propsBuilder.add(iPrimProps);
        }
        IGeom iGeom = thunderheadeng.geometry.objs.GeomUtil.group(arrayList);
        GeomNodeLeaf geomNodeLeaf = GeomNodeUtil.newNode(iGeom);
        return new DisplayGeom((IGeomNode)geomNodeLeaf, propsBuilder.finalizeProps());
    }

    private static class ChangedTask
    extends AUndoableTask {
        private final IPyroObject d_obj;

        public ChangedTask(IPyroObject iPyroObject) {
            this.d_obj = iPyroObject;
        }

        @Override
        public void run() {
            this.d_obj.changedEvt(new Object[0]);
        }

        @Override
        public void undo() {
            this.d_obj.changedEvt(new Object[0]);
        }
    }
}

