/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxf;
import thunderheadeng.geometry.RTreef;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theTimer;

public class GeomLocator {
    private Set<IDisplayableGeomSrc> d_dirtyGeom = GeomLocator.newDirtySet();
    private final RTreef<IDisplayableGeomSrc> d_finite = new RTreef(2, 16);
    private final Set<IDisplayableGeomSrc> d_infinite = new LinkedIdentityHashSet<IDisplayableGeomSrc>();

    private static Set<IDisplayableGeomSrc> newDirtySet() {
        return new LinkedIdentityHashSet<IDisplayableGeomSrc>();
    }

    public void add(IDisplayableGeomSrc iDisplayableGeomSrc) {
        this.d_dirtyGeom.add(iDisplayableGeomSrc);
    }

    public void remove(IDisplayableGeomSrc iDisplayableGeomSrc) {
        this.d_finite.remove(iDisplayableGeomSrc);
        this.d_infinite.remove(iDisplayableGeomSrc);
        this.d_dirtyGeom.remove(iDisplayableGeomSrc);
    }

    public void update(IDisplayableGeomSrc iDisplayableGeomSrc) {
        this.d_dirtyGeom.add(iDisplayableGeomSrc);
    }

    public void updateDirty() {
        if (this.d_dirtyGeom.isEmpty()) {
            return;
        }
        theTimer theTimer2 = new theTimer();
        for (IDisplayableGeomSrc iDisplayableGeomSrc : this.d_dirtyGeom) {
            this.removeGeometry(iDisplayableGeomSrc);
            this.addGeometry(iDisplayableGeomSrc);
        }
        this.d_dirtyGeom = GeomLocator.newDirtySet();
        if (System.getProperty("dev") != null) {
            System.out.println("updated geom search " + theTimer2.curr());
        }
    }

    private void addGeometry(IDisplayableGeomSrc iDisplayableGeomSrc) {
        AABox aABox = iDisplayableGeomSrc.getBounds();
        if (aABox.isInfinite()) {
            this.d_infinite.add(iDisplayableGeomSrc);
        } else {
            AABoxf aABoxf = aABox.toAABoxf();
            if (aABoxf.isInfinite()) {
                System.err.printf("GeomLocator.addGeometry(geom=%s) - Error: double-precision bounding box can't fit into float.%n", iDisplayableGeomSrc.toString());
                return;
            }
            this.d_finite.insert(aABoxf, iDisplayableGeomSrc);
        }
    }

    private void addGeometry(Collection<? extends IDisplayableGeomSrc> collection) {
        for (IDisplayableGeomSrc iDisplayableGeomSrc : collection) {
            this.addGeometry(iDisplayableGeomSrc);
        }
    }

    private boolean removeGeometry(IDisplayableGeomSrc iDisplayableGeomSrc) {
        this.d_finite.remove(iDisplayableGeomSrc);
        this.d_infinite.remove(iDisplayableGeomSrc);
        return true;
    }

    private boolean removeGeometry(Collection<? extends IDisplayableGeomSrc> collection) {
        boolean bl = true;
        for (IDisplayableGeomSrc iDisplayableGeomSrc : collection) {
            bl &= this.removeGeometry(iDisplayableGeomSrc);
        }
        return bl;
    }

    public void find(final ITest<AABox> iTest, IResult<? super IDisplayableGeomSrc> iResult, boolean bl) {
        ITest<AABoxf> iTest2 = new ITest<AABoxf>(){

            @Override
            public Containment test(AABoxf aABoxf) {
                return iTest.test(new AABox(aABoxf.getMinX(), aABoxf.getMinY(), aABoxf.getMinZ(), aABoxf.getMaxX(), aABoxf.getMaxY(), aABoxf.getMaxZ()));
            }
        };
        this.findf(iTest2, iResult, bl);
    }

    public void findf(ITest<AABoxf> iTest, IResult<? super IDisplayableGeomSrc> iResult, boolean bl) {
        this.updateDirty();
        this.find(iTest, iResult, this.d_finite, bl);
        this.find(iResult, this.d_infinite, bl);
    }

    private void find(ITest<AABoxf> iTest, final IResult<? super IDisplayableGeomSrc> iResult, RTreef<IDisplayableGeomSrc> rTreef, boolean bl) {
        IResult<IDisplayableGeomSrc> iResult2 = iResult;
        if (!bl) {
            iResult2 = new IResult<IDisplayableGeomSrc>(){

                @Override
                public void mark(IDisplayableGeomSrc iDisplayableGeomSrc, Containment containment) {
                    if (!iDisplayableGeomSrc.isVisible()) {
                        return;
                    }
                    iResult.mark(iDisplayableGeomSrc, containment);
                }
            };
        }
        rTreef.find(iTest, iResult2);
    }

    private void find(IResult<? super IDisplayableGeomSrc> iResult, Set<IDisplayableGeomSrc> set, boolean bl) {
        for (IDisplayableGeomSrc iDisplayableGeomSrc : set) {
            if (!bl && !iDisplayableGeomSrc.isVisible()) continue;
            iResult.mark(iDisplayableGeomSrc, Containment.INTERSECTS);
        }
    }

    public static class Collector<T extends IDisplayableGeomSrc>
    extends CollResult<IDisplayableGeomSrc, T> {
        public Collector(Class<T> clazz) {
            this(clazz, Filters.acceptAll(clazz));
        }

        public Collector(Class<T> clazz, Predicate<T> predicate) {
            super(clazz, predicate);
        }
    }
}

