/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Task;

public class ExSpecList
extends Composite<ExSpec> {
    static final long serialVersionUID = 1L;
    public static final String[] RADCAL_SPECS;
    public static final Map<String, ExSpec> PREDEFINED;
    public static final List<String> LUMPED_AIR_COMPS;
    public static final List<String> LUMPED_PRODUCT_COMPS;
    private Collection<String> d_reacDefAlias = new ArrayList<String>();
    public static final String RC_CARBON_DIOXIDE = "CARBON DIOXIDE";
    public static final String RC_CARBON_MONOXIDE = "CARBON_MONOXIDE";
    public static final String RC_ETHANE = "ETHANE";
    public static final String RC_ETHYLENE = "ETHYLENE";
    public static final String RC_MMA = "MMA";
    public static final String RC_METHANE = "METHANE";
    public static final String RC_METHANOL = "METHANOL";
    public static final String RC_N_HEPTANE = "N-HEPTANE";
    public static final String RC_PROPANE = "PROPANE";
    public static final String RC_PROPYLENE = "PROPYLENE";
    public static final String RC_SOOT = "SOOT";
    public static final String RC_TOLUENE = "TOLUENE";
    public static final String RC_WATER_VAPOR = "WATER VAPOR";

    public ExSpecList() {
        this(Intl.intl("Species"));
    }

    public ExSpecList(String string) {
        super(string, ExSpec.class);
    }

    public List<String> getPredefinedSpeciesNamesFree() {
        ArrayList<String> arrayList = new ArrayList<String>(PREDEFINED.keySet());
        for (ExSpec exSpec : this.flatten()) {
            String string = exSpec.getName();
            if (!arrayList.contains(string)) continue;
            arrayList.remove(string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static boolean isPredefinedSpecies(String string) {
        return PREDEFINED.containsKey(string);
    }

    public static boolean equalsPredefinedSpecies(ExSpec exSpec) {
        if (!ExSpecList.isPredefinedSpecies(exSpec.getName())) {
            return false;
        }
        ExSpec exSpec2 = ExSpecList.getPredefinedSpecies(exSpec.getName());
        return exSpec.getMolecularWeight().equals(exSpec2.getMolecularWeight()) && exSpec.getMassFrac0() == exSpec2.getMassFrac0() && exSpec.getPrimParams().equals(exSpec2.getPrimParams()) && exSpec.getCustomFDSProps().equals(exSpec2.getCustomFDSProps());
    }

    public static boolean isImplicitSpecies(String string) {
        return string.equals("AIR") || string.equals("PRODUCTS") || LUMPED_AIR_COMPS.contains(string) || LUMPED_PRODUCT_COMPS.contains(string);
    }

    public static ExSpec getPredefinedSpecies(String string) {
        assert (ExSpecList.isPredefinedSpecies(string));
        return PREDEFINED.get(string);
    }

    public static String[] getRadCalSurrogates() {
        return RADCAL_SPECS;
    }

    public static boolean isRadCalSpecies(String string) {
        for (String string2 : RADCAL_SPECS) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public List<ExSpec> getAllNamedSpecs() {
        ArrayList<ExSpec> arrayList = new ArrayList<ExSpec>(this.flatten());
        for (ExSpec exSpec : PREDEFINED.values()) {
            if (arrayList.contains(exSpec)) continue;
            arrayList.add(exSpec);
        }
        return arrayList;
    }

    public ExSpec getDefaultFuel() {
        for (ExSpec exSpec : this.flatten()) {
            if (exSpec.getType() != 4) continue;
            return exSpec;
        }
        return null;
    }

    public static ExSpec getDefaultFuel(boolean bl) {
        PyroMod pyroMod = PyroSim.getApp().getMediator();
        return ExSpecList.getDefaultFuel(pyroMod.getExSpecList(), pyroMod.getNames(ExSpec.class), bl);
    }

    public static ExSpec getDefaultFuel(ExSpecList exSpecList, NameGenerator nameGenerator, boolean bl) {
        if (exSpecList.getDefaultFuel() != null) {
            return exSpecList.getDefaultFuel();
        }
        String string = "REAC_FUEL";
        string = nameGenerator.generateValidName(string);
        ExSpec exSpec = new ExSpec(string, 4);
        if (bl) {
            exSpecList.add(exSpec);
            exSpecList.setReacDefaultAlias(string);
        }
        return exSpec;
    }

    public void setReacDefaultAlias(String string) {
        this.d_reacDefAlias.add(string);
    }

    public boolean isReacDefaultAlias(String string) {
        return this.d_reacDefAlias.contains(string);
    }

    @Override
    public ExSpec get(String string) {
        ExSpec exSpec = (ExSpec)super.get(string);
        if (exSpec == null && this.isReacDefaultAlias(string)) {
            return ExSpecList.getDefaultFuel(true);
        }
        return exSpec;
    }

    public void addDefaults() {
        this.addImplicitSpecs();
    }

    public Collection<ExSpec> getInitialFractions() {
        ArrayList<ExSpec> arrayList = new ArrayList<ExSpec>();
        for (ExSpec exSpec : this.flatten()) {
            if (!(exSpec.getMassFrac0() > 0.0)) continue;
            arrayList.add(exSpec);
        }
        return arrayList;
    }

    public void addImplicitSpecs() {
        this.addAirSpecs();
        this.addProductSpecs();
    }

    public void addAirSpecs() {
        this.addDefault(new ExSpec(ExSpecList.getPredefinedSpecies("AIR")));
        for (String string : LUMPED_AIR_COMPS) {
            this.addDefault(new ExSpec(ExSpecList.getPredefinedSpecies(string)));
        }
    }

    public void addProductSpecs() {
        this.addDefault(new ExSpec(ExSpecList.getPredefinedSpecies("PRODUCTS")));
        for (String string : LUMPED_PRODUCT_COMPS) {
            this.addDefault(new ExSpec(ExSpecList.getPredefinedSpecies(string)));
        }
    }

    public static boolean shouldRenderExplicit(ExSpec exSpec, boolean bl, boolean bl2, boolean bl3) {
        if (exSpec.isForceWrite()) {
            return true;
        }
        if (!bl3) {
            if (!bl && !bl2 && LUMPED_AIR_COMPS.contains(exSpec.getName())) {
                return false;
            }
            if (bl && (LUMPED_AIR_COMPS.contains(exSpec.getName()) || LUMPED_PRODUCT_COMPS.contains(exSpec.getName())) && ExSpecList.equalsPredefinedSpecies(exSpec)) {
                return false;
            }
        }
        return exSpec.getType() != 5 || !(exSpec.getName().equals(Predefined.AIR.getName()) && !bl2 ? ExSpecList.equalsPredefinedSpecies(exSpec) : exSpec.getName().equals(Predefined.PRODUCTS.getName()) && bl && ExSpecList.equalsPredefinedSpecies(exSpec));
    }

    @Override
    public <T extends IPyroObject> T find(String string, Class<T> clazz, boolean bl) {
        T t = super.find(string, clazz, bl);
        if (t == null && clazz.isAssignableFrom(ExSpec.class) && this.isReacDefaultAlias(string)) {
            return (T)ExSpecList.getDefaultFuel(false);
        }
        return t;
    }

    public Task taskSetBackgroundSpecies(final ExSpec exSpec) {
        final ExSpec exSpec2 = this.getBackgroundSpecies();
        return new AUndoableTask(){

            @Override
            public void undo() {
                ExSpecList.this.pauseUpdates();
                if (exSpec != null) {
                    exSpec.setIsBackgroundSpec(false);
                }
                if (exSpec2 != null) {
                    exSpec2.setIsBackgroundSpec(true);
                }
                ExSpecList.this.resumeUpdates();
            }

            @Override
            public void run() {
                ExSpecList.this.pauseUpdates();
                if (exSpec2 != null) {
                    exSpec2.setIsBackgroundSpec(false);
                }
                if (exSpec != null) {
                    exSpec.setIsBackgroundSpec(true);
                }
                ExSpecList.this.resumeUpdates();
            }
        };
    }

    public ExSpec getBackgroundSpecies() {
        for (ExSpec exSpec : this.flatten()) {
            if (!exSpec.isBackgroundSpec()) continue;
            return exSpec;
        }
        return null;
    }

    public void setBackgroundSpecies(ExSpec exSpec) {
        ExSpec exSpec2 = this.getBackgroundSpecies();
        if (exSpec2 != null) {
            exSpec2.setIsBackgroundSpec(false);
        }
        if (exSpec != null) {
            exSpec.setIsBackgroundSpec(true);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.d_reacDefAlias == null) {
            this.d_reacDefAlias = new ArrayList<String>();
            this.d_reacDefAlias.add("REAC_FUEL");
        }
        objectInputStream.defaultReadObject();
    }

    static {
        PREDEFINED = new LinkedHashMap<String, ExSpec>();
        for (Predefined predefined : Predefined.values()) {
            PREDEFINED.put(predefined.spec.getName(), predefined.spec);
        }
        RADCAL_SPECS = new String[]{RC_CARBON_DIOXIDE, RC_CARBON_MONOXIDE, RC_ETHANE, RC_ETHYLENE, RC_MMA, RC_METHANE, RC_METHANOL, RC_N_HEPTANE, RC_PROPANE, RC_PROPYLENE, RC_SOOT, RC_TOLUENE, RC_WATER_VAPOR};
        LUMPED_AIR_COMPS = new ArrayList<String>();
        LUMPED_AIR_COMPS.add("NITROGEN");
        LUMPED_AIR_COMPS.add("OXYGEN");
        LUMPED_AIR_COMPS.add(RC_CARBON_DIOXIDE);
        LUMPED_AIR_COMPS.add(RC_WATER_VAPOR);
        LUMPED_PRODUCT_COMPS = new ArrayList<String>();
        LUMPED_PRODUCT_COMPS.add(RC_CARBON_DIOXIDE);
        LUMPED_PRODUCT_COMPS.add(RC_WATER_VAPOR);
        LUMPED_PRODUCT_COMPS.add("CARBON MONOXIDE");
        LUMPED_PRODUCT_COMPS.add(RC_SOOT);
        LUMPED_PRODUCT_COMPS.add("NITROGEN");
    }

    public static enum Predefined {
        AIR("AIR", 0.0, 3.711, 78.6, "air", false),
        PRODUCTS("PRODUCTS", 0.0, 0.0, 0.0, "products", false),
        ACETONE("ACETONE", 58.07914, 4.6, 560.2, "C3H6O", true),
        ACETYLENE("ACETYLENE", 26.03728, 4.033, 231.8, "C2H2", false),
        ACROLEIN("ACROLEIN", 56.03728, 4.549, 576.7, "C3H4O", true),
        ARGON("ARGON", 39.948, 3.42, 124.0, "Ar", true),
        BENZENE("BENZENE", 78.11184, 5.349, 412.3, "C6H6", true),
        BUTANE("BUTANE", 58.1222, 4.687, 531.4, "C4H10", true),
        CARBON("CARBON", 12.0107, 2.84, 74.8, "C", false),
        CARBON_DIOXIDE("CARBON DIOXIDE", 44.0095, 3.941, 195.2, "CO2", false),
        CARBON_MONOXIDE("CARBON MONOXIDE", 28.0101, 3.69, 91.7, "CO", true),
        DODECANE("DODECANE", 170.33484, 4.701, 205.78, "C2H26", true),
        ETHANE("ETHANE", 30.06904, 4.443, 215.7, "C2H6", true),
        ETHANOL("ETHANOL", 46.06844, 4.53, 362.6, "C2H5OH", true),
        ETHYLENE("ETHYLENE", 28.05316, 4.163, 224.7, "C2H4", true),
        FORMALDEHYDE("FORMALDEHYDE", 30.06904, 3.626, 481.8, "CH2O", true),
        HELIUM("HELIUM", 4.002602, 2.551, 10.22, "He", true),
        HYDROGEN("HYDROGEN", 2.02699, 2.827, 59.7, "H2", true),
        HYDROGEN_A("HYDROGEN ATOM", 1.00794, 2.31, 123.6, "H", false),
        HYDROGEN_BROMIDE("HYDROGEN BROMIDE", 80.91194, 3.353, 449.0, "HBr", true),
        HYDROGEN_CHLORIDE("HYDROGEN CHLORIDE", 36.46094, 3.339, 344.7, "HCl", true),
        HYDROGEN_CYANIDE("HYDROGEN CYANIDE", 27.02534, 3.63, 569.1, "HCN", true),
        HYDROGEN_FLOURIDE("HYDROGEN FLOURIDE", 20.006343, 3.148, 330.0, "HF", true),
        HYDROGEN_PEROXIDE("HYDROGEN PEROXIDE", 34.01468, 3.02, 106.5, "H2O2", true),
        HYDROPEROXY_RADICAL("HYDROPEROXY RADICAL", 33.00674, 3.02, 106.5, "HO2", false),
        HYDROXYL_RADICAL("HYDROXYL RADICAL", 17.00734, 2.66, 92.1, "OH", false),
        ISOPROPANOL("ISOPROPANOL", 60.09502, 4.549, 576.7, "C3H7OH", true),
        METHANE("METHANE", 16.04246, 3.758, 148.6, "CH4", true),
        METHANOL("METHANOL", 32.04186, 3.626, 481.8, "CH2OH", true),
        N_DECANE("N-DECANE", 142.28168, 5.233, 226.46, "C10H22", false),
        N_HEPTANE("N-HEPTANE", 100.20194, 4.701, 205.75, "C7H16", true),
        N_HEXANE("N-HEXANE", 86.17536, 4.524, 199.41, "C6H12", true),
        N_OCTANE("N-OCTANE", 114.22852, 4.892, 231.16, "C8H18", true),
        NITRIC_OXIDE("NITRIC OXIDE", 44.0128, 3.492, 116.7, "NO", true),
        NITROGEN("NITROGEN", 28.0134, 3.798, 71.4, "N2", true),
        NITROGEN_A("NITROGEN ATOM", 14.0067, 2.66, 92.1, "N", false),
        NITROGEN_DIOXIDE("NITROGEN DIOXIDE", 46.055, 3.992, 204.88, "NO2", true),
        NITROUS_OXIDE("NITROUS OXIDE", 44.0128, 3.828, 232.4, "N2O", true),
        OXYGEN("OXYGEN", 31.9988, 3.467, 106.7, "O2", true),
        OXYGEN_A("OXYGEN ATOM", 15.9994, 2.66, 92.1, "O", false),
        PROPANE("PROPANE", 44.0128, 5.118, 237.1, "C3H8", true),
        PROPYLENE("PROPYLENE", 42.07974, 4.678, 298.9, "C3H6", true),
        SOOT("SOOT", 10.91042, 3.798, 71.4, "C0.9H0.1", false),
        SULFUR_DIOXIDE("SULFUR DIOXIDE", 64.0638, 4.112, 335.4, "SO2", true),
        SULFUR_HEXAFLUORIDE("SULFUR HEXAFLUORIDE", 146.055419, 5.128, 146.0, "SF6", false),
        TOLUENE("TOLUENE", 92.13842, 5.698, 480.0, "C6H5CH3", true),
        WATER_VAPOR("WATER VAPOR", 18.01528, 2.641, 809.1, "H2O", true),
        XENON("XENON", 131.293, 4.047, 231.0, "Xe", true);

        public final ExSpec spec;

        private Predefined(String string2, double d, double d2, double d3, String string3, boolean bl) {
            this.spec = new ExSpec(string2, 0);
            if (string2.equals("AIR") || string2.equals("PRODUCTS")) {
                this.spec.setType(5);
            } else {
                this.spec.setMolecularWeight(new UnitDouble(d, SI.GRAM.divide(SI.MOLE)));
                this.spec.setChemFormula(string3);
            }
        }

        public String getName() {
            return this.spec.getName();
        }
    }
}

