/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.variant.ConstProfile;
import pyrosim.domain.variant.DefRampProfile;
import pyrosim.domain.variant.DefaultProfile;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.variant.VariantProfile;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class ExSpec
extends NamedPyroObject
implements Serializable,
Cloneable,
ICustomFDSPropsContainer,
IDirectDependent {
    static final long serialVersionUID = 1L;
    public static final int TYPE_PREDEFINED = 0;
    public static final int TYPE_PRIMITIVE = 1;
    public static final int TYPE_LUMPED_MASS = 2;
    public static final int TYPE_LUMPED_VOLUME = 3;
    public static final int TYPE_REAC_FUEL = 4;
    public static final int TYPE_PREDEFINED_LUMPED = 5;
    public static final int WT_NO_WEIGHT_SET = 0;
    public static final int WT_MOL_WEIGHT_SET = 1;
    public static final int WT_FORMULA_SET = 2;
    public static final int ID_NONE = 0;
    public static final VariantProfile SPECHEAT_PROFILE = ExSpec.newVarProf(11, DefRampProfile.Input.HEAT, 0.0);
    public static final VariantProfile DIFFUSIVITY_PROFILE = ExSpec.newVarProf(27, DefRampProfile.Input.TIME, 0.0);
    public static final VariantProfile VISCOSITY_PROFILE = ExSpec.newVarProf(41, DefRampProfile.Input.TIME, 0.0);
    private String d_fyi;
    private int d_type;
    private boolean d_isStatic;
    private UnitDouble d_molWt;
    private double d_massFrac0;
    private String d_formula;
    private int d_wtType;
    private Map<ExSpec, Double> d_composition;
    private LUMPED_RULE d_lumpedOnlyRule;
    private boolean d_background;
    private PrimitiveParams d_primParams;
    private CustomFDSProps d_advancedProps;

    private static VariantProfile newVarProf(int n, DefRampProfile.Input input, double d) {
        return new VariantProfile(new DefaultProfile(Intl.intl("Default")), new ConstProfile(Intl.intl("Constant"), n, SIUS.newud(d, n)), new DefRampProfile(Intl.intl("Custom"), n, input));
    }

    public ExSpec(String string, int n) {
        this(string, n, false);
    }

    public ExSpec(String string, int n, boolean bl) {
        super(string);
        SIUS sIUS = SIUS.getInstance();
        this.d_type = n;
        this.d_fyi = "";
        this.d_isStatic = bl;
        this.d_massFrac0 = 0.0;
        this.d_molWt = new UnitDouble(29.0, sIUS.getMolecularWeightUnit());
        this.d_formula = "";
        this.d_wtType = 1;
        this.d_background = false;
        this.d_composition = new LinkedHashMap<ExSpec, Double>();
        this.d_lumpedOnlyRule = LUMPED_RULE.AUTO;
        this.d_primParams = new PrimitiveParams(this);
        this.d_advancedProps = CustomFDSProps.EMPTY;
    }

    public ExSpec(ExSpec exSpec) {
        this.d_isStatic = false;
        this.setName(exSpec.getName());
        this.setFYI(exSpec.getFYI());
        this.setMassFrac0(exSpec.getMassFrac0());
        this.setMolecularWeight(exSpec.getMolecularWeight());
        this.setChemFormula(exSpec.getChemFormula());
        this.setWtType(exSpec.getWtType());
        this.setComposition(exSpec.getType(), new LinkedHashMap<ExSpec, Double>(exSpec.getComposition()));
        this.setType(exSpec.getType());
        this.setLumpedComponentOnlyRule(exSpec.getLumpedComponentOnlyRule());
        this.setPrimParams(exSpec.getPrimParams());
        this.setCustomFDSProps(exSpec.getCustomFDSProps());
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getWtType() == 0 && this.getChemFormula().length() > 0) {
            this.setWtType(2);
        }
        if (this.isStaticInstance()) {
            return ExSpecList.getPredefinedSpecies(this.getName());
        }
        if (this.d_lumpedOnlyRule == null) {
            this.d_lumpedOnlyRule = LUMPED_RULE.AUTO;
        }
        return this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isStaticInstance() {
        return this.d_isStatic;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.d_primParams.d_spec = this;
        if (this.d_composition == null) {
            this.d_composition = new LinkedHashMap<ExSpec, Double>();
        } else if (!(this.d_composition instanceof LinkedHashMap)) {
            this.d_composition = new LinkedHashMap<ExSpec, Double>(this.d_composition);
        }
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object clone() {
        return new ExSpec(this);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ExSpec)) {
            return false;
        }
        ExSpec exSpec = (ExSpec)object;
        return this.getName().equals(exSpec.getName()) && this.getFYI().equals(exSpec.getFYI()) && this.getMolecularWeight().equals(exSpec.getMolecularWeight()) && this.getMassFrac0() == exSpec.getMassFrac0() && this.getPrimParams().equals(exSpec.getPrimParams()) && this.getLumpedComponentOnlyRule().equals((Object)exSpec.getLumpedComponentOnlyRule()) && Util.isObjMapEqual(this.getComposition(), exSpec.getComposition()) && this.getCustomFDSProps().equals(exSpec.getCustomFDSProps());
    }

    public int getType() {
        return this.d_type;
    }

    public void setType(int n) {
        this.d_type = n;
        this.changedEvt(new Object[0]);
    }

    public void setComposition(int n, Map<ExSpec, Double> map) {
        this.d_type = n;
        this.d_composition = map;
        this.changedEvt(new Object[0]);
    }

    public Map<ExSpec, Double> getComposition() {
        return this.d_composition;
    }

    public double getMassFrac0() {
        return this.d_massFrac0;
    }

    public void setMassFrac0(double d) {
        this.d_massFrac0 = d;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getMolecularWeight() {
        return this.d_molWt;
    }

    public void setMolecularWeight(UnitDouble unitDouble) {
        this.d_molWt = unitDouble;
        this.d_wtType = unitDouble.getValueNoUnit() > 0.0 ? 1 : 0;
        this.changedEvt(new Object[0]);
    }

    public String getChemFormula() {
        return this.d_formula;
    }

    public void setChemFormula(String string) {
        this.d_formula = string;
        if (string.length() > 0) {
            this.d_wtType = 2;
        }
        this.changedEvt(new Object[0]);
    }

    public int getWtType() {
        return this.d_wtType;
    }

    public void setWtType(int n) {
        this.d_wtType = n;
    }

    public LUMPED_RULE getLumpedComponentOnlyRule() {
        return this.d_lumpedOnlyRule;
    }

    public void setLumpedComponentOnlyRule(LUMPED_RULE lUMPED_RULE) {
        this.d_lumpedOnlyRule = lUMPED_RULE;
        this.changedEvt(new Object[0]);
    }

    public boolean isBackgroundSpec() {
        return this.d_background;
    }

    public void setIsBackgroundSpec(boolean bl) {
        this.d_background = bl;
        this.changedEvt(new Object[0]);
    }

    public boolean isAdvancedRecBackgroundSpec() {
        return this.d_advancedProps.getProps().containsKey("BACKGROUND") && this.d_advancedProps.getProps().get("BACKGROUND").equals(".TRUE.");
    }

    @Override
    public void getCustomFDSTypes(Collection<String> collection) {
        collection.add("SPEC");
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String string) {
        return this.d_advancedProps;
    }

    @Override
    public void setCustomFDSProps(String string, CustomFDSProps customFDSProps) {
        this.d_advancedProps = customFDSProps;
        this.changedEvt(new Object[0]);
    }

    public PrimitiveParams getPrimParams() {
        return this.d_primParams;
    }

    private void setPrimParams(PrimitiveParams primitiveParams) {
        this.d_primParams = primitiveParams.clone(this);
        this.changedEvt(new Object[0]);
    }

    public int compareTo(ExSpec exSpec) {
        if (this.isFirstPrimitive() && exSpec.isFirstPrimitive()) {
            return ExSpec.defaultCompare(this, exSpec);
        }
        if (this.isFirstPrimitive()) {
            return -1;
        }
        if (exSpec.isFirstPrimitive()) {
            return 1;
        }
        if (this.getType() == 0 && exSpec.getType() == 0) {
            return ExSpec.defaultCompare(this, exSpec);
        }
        if (this.getType() == 0) {
            return -1;
        }
        if (exSpec.getType() == 0) {
            return 1;
        }
        if (this.getType() == 1 && exSpec.getType() == 1) {
            return ExSpec.defaultCompare(this, exSpec);
        }
        if (this.getType() == 1) {
            return -1;
        }
        if (exSpec.getType() == 1) {
            return 1;
        }
        if (this.isFirstLumped()) {
            return -1;
        }
        if (exSpec.isFirstLumped()) {
            return 1;
        }
        return ExSpec.defaultCompare(this, exSpec);
    }

    private static int defaultCompare(ExSpec exSpec, ExSpec exSpec2) {
        return Integer.compare(System.identityHashCode(exSpec), System.identityHashCode(exSpec2));
    }

    public boolean isPredefined() {
        return this.d_type == 0 || this.d_type == 5;
    }

    public boolean isPrimitive() {
        return this.d_type == 1;
    }

    public boolean isLumped() {
        return this.d_type == 2 || this.d_type == 3 || this.d_type == 5;
    }

    private boolean isFirstPrimitive() {
        return !(this.d_type != 0 && this.d_type != 1 || !this.isBackgroundSpec() && !this.isAdvancedRecBackgroundSpec());
    }

    private boolean isFirstLumped() {
        return this.isLumped() && (this.isBackgroundSpec() || this.isAdvancedRecBackgroundSpec());
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        for (ExSpec exSpec : this.d_composition.keySet()) {
            depList.add(DLink.WEAK, (IPyroObject)exSpec);
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        Util.keepIfNullOr(set, iPyroObject -> iPyroObject instanceof ExSpec && !((ExSpec)iPyroObject).isLumped());
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        return new AReplaceRefTask<ExSpec>((Object)iPyroObject, (Object)iPyroObject2){
            private double oldVal;
            private double replacementValOld;
            {
                super(object, object2);
                this.oldVal = (Double)ExSpec.this.d_composition.get(iPyroObject);
                this.replacementValOld = Double.NaN;
            }

            @Override
            protected void set(ExSpec exSpec) {
                if (exSpec == iPyroObject2) {
                    if (Double.isNaN(this.replacementValOld)) {
                        this.replacementValOld = ExSpec.this.d_composition.getOrDefault(iPyroObject2, 0.0);
                    }
                    ExSpec.this.d_composition.remove(iPyroObject);
                    if (iPyroObject2 != null) {
                        ExSpec.this.d_composition.put(exSpec, this.oldVal + this.replacementValOld);
                    }
                } else if (exSpec == iPyroObject) {
                    if (this.replacementValOld > 0.0) {
                        ExSpec.this.d_composition.put((ExSpec)iPyroObject2, this.replacementValOld);
                    } else {
                        ExSpec.this.d_composition.remove(iPyroObject2);
                    }
                    ExSpec.this.d_composition.put((ExSpec)iPyroObject, this.oldVal);
                }
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        return EmptyTask.INSTANCE;
    }

    @Override
    public String toString() {
        return String.format("ExSpec[name=%s, type=%s, isStatic=%s]", this.getName(), this.d_type, this.d_isStatic);
    }

    public static class PrimitiveParams
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private ExSpec d_spec;
        private Variant d_diffusivityVar;
        private Variant d_viscosityVar;
        private double d_sigmaLJ;
        private boolean d_sigmaLJSet;
        private double d_epsilonKLJ;
        private boolean d_epsilonKLJSet;
        private String d_radCalSurrogate;
        private boolean d_aerosol;
        private UnitDouble d_densitySolid;
        private UnitDouble d_conductivitySolid;
        private UnitDouble d_meanDiameter;
        private Variant d_specHeat;
        private UnitDouble d_refTemp;
        private boolean d_refTempSet;
        private Variant d_refEnthalpyVar;
        private Variant d_densityLiquidVar;
        private Variant d_specHeatLiquidVar;
        private Variant d_vapTempVar;
        private Variant d_meltTempVar;
        private Variant d_HoVaporizationVar;
        private Variant d_EoFormationVar;
        private Variant d_hvRefTempVar;

        public PrimitiveParams(ExSpec exSpec) {
            this.d_spec = exSpec;
            this.d_diffusivityVar = DIFFUSIVITY_PROFILE.getDefault();
            this.d_viscosityVar = VISCOSITY_PROFILE.getDefault();
            this.d_sigmaLJ = 0.0;
            this.d_sigmaLJSet = false;
            this.d_epsilonKLJ = 0.0;
            this.d_epsilonKLJSet = false;
            this.d_radCalSurrogate = "";
            this.d_aerosol = false;
            this.d_densitySolid = new UnitDouble(1800.0, SI.KILOGRAM.divide(SI.METER.pow(3)));
            this.d_conductivitySolid = new UnitDouble(0.26, SI.WATT.divide(SI.METER).divide(SI.KELVIN));
            this.d_meanDiameter = new UnitDouble(1.0E-6, SI.METER);
            this.d_specHeat = SPECHEAT_PROFILE.getDefault();
            this.d_refTemp = new UnitDouble(25.0, SI.CELSIUS);
            this.d_refTempSet = false;
            this.d_refEnthalpyVar = Variant.DEFAULT;
            this.d_densityLiquidVar = Variant.DEFAULT;
            this.d_specHeatLiquidVar = SPECHEAT_PROFILE.getDefault();
            this.d_vapTempVar = Variant.DEFAULT;
            this.d_meltTempVar = Variant.DEFAULT;
            this.d_HoVaporizationVar = Variant.DEFAULT;
            this.d_EoFormationVar = Variant.DEFAULT;
            this.d_hvRefTempVar = Variant.DEFAULT;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PrimitiveParams)) {
                return false;
            }
            PrimitiveParams primitiveParams = (PrimitiveParams)object;
            return theUtil.equal(this.getDiffusivity(), primitiveParams.getDiffusivity()) && theUtil.equal(this.getViscosity(), primitiveParams.getViscosity()) && this.compareBoolDoublePair(this.isSigmaLJSet(), primitiveParams.isSigmaLJSet(), this.getSigmaLJ(), primitiveParams.getSigmaLJ()) && this.compareBoolDoublePair(this.isEpsilonKLJSet(), primitiveParams.isEpsilonKLJSet(), this.getEpsilonKLJ(), primitiveParams.getEpsilonKLJ()) && theUtil.equal(this.getRadCalSurrogate(), primitiveParams.getRadCalSurrogate()) && theUtil.equal(this.isAerosol(), primitiveParams.isAerosol()) && theUtil.equal(this.getDensitySolid(), primitiveParams.getDensitySolid()) && theUtil.equal(this.getConductivitySolid(), primitiveParams.getConductivitySolid()) && theUtil.equal(this.getMeanDiameter(), primitiveParams.getMeanDiameter()) && theUtil.equal(this.getSpecHeat(), primitiveParams.getSpecHeat()) && theUtil.equal(this.getRefTemp(), primitiveParams.getRefTemp()) && theUtil.equal(this.getRefEnthalpy(), primitiveParams.getRefEnthalpy()) && theUtil.equal(this.getDensityLiquid(), primitiveParams.getDensityLiquid()) && theUtil.equal(this.getSpecHeatLiquid(), primitiveParams.getSpecHeatLiquid()) && theUtil.equal(this.getVapTemp(), primitiveParams.getVapTemp()) && theUtil.equal(this.getMeltTemp(), primitiveParams.getMeltTemp()) && theUtil.equal(this.getHoVaporization(), primitiveParams.getHoVaporization()) && theUtil.equal(this.getEoFormation(), primitiveParams.getEoFormation()) && theUtil.equal(this.getHVRefTemp(), primitiveParams.getHVRefTemp());
        }

        public int hashCode() {
            int n = 7;
            n = 31 * n + theUtil.hashCode(this.d_diffusivityVar);
            n = 31 * n + theUtil.hashCode(this.d_viscosityVar);
            n = 31 * n + theUtil.hashCode(this.d_sigmaLJ);
            n = 31 * n + theUtil.hashCode(this.d_sigmaLJSet);
            n = 31 * n + theUtil.hashCode(this.d_epsilonKLJ);
            n = 31 * n + theUtil.hashCode(this.d_epsilonKLJSet);
            n = 31 * n + theUtil.hashCode(this.d_radCalSurrogate);
            n = 31 * n + theUtil.hashCode(this.d_aerosol);
            n = 31 * n + theUtil.hashCode(this.d_densitySolid);
            n = 31 * n + theUtil.hashCode(this.d_conductivitySolid);
            n = 31 * n + theUtil.hashCode(this.d_meanDiameter);
            n = 31 * n + theUtil.hashCode(this.d_specHeat);
            n = 31 * n + theUtil.hashCode(this.d_refTemp);
            n = 31 * n + theUtil.hashCode(this.d_refTempSet);
            n = 31 * n + theUtil.hashCode(this.d_refEnthalpyVar);
            n = 31 * n + theUtil.hashCode(this.d_densityLiquidVar);
            n = 31 * n + theUtil.hashCode(this.d_specHeatLiquidVar);
            n = 31 * n + theUtil.hashCode(this.d_vapTempVar);
            n = 31 * n + theUtil.hashCode(this.d_meltTempVar);
            n = 31 * n + theUtil.hashCode(this.d_HoVaporizationVar);
            n = 31 * n + theUtil.hashCode(this.d_EoFormationVar);
            n = 31 * n + theUtil.hashCode(this.d_hvRefTempVar);
            return n;
        }

        public boolean compareBoolDoublePair(boolean bl, boolean bl2, double d, double d2) {
            if (bl) {
                if (bl2) {
                    return d == d2;
                }
                return d == 0.0;
            }
            if (bl2) {
                return d2 == 0.0;
            }
            return true;
        }

        public PrimitiveParams clone(ExSpec exSpec) {
            try {
                PrimitiveParams primitiveParams = (PrimitiveParams)super.clone();
                primitiveParams.d_spec = exSpec;
                return primitiveParams;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                assert (false);
                return null;
            }
        }

        protected void changedEvt() {
            this.d_spec.changedEvt(new Object[0]);
        }

        public Variant getDiffusivity() {
            return this.d_diffusivityVar;
        }

        public void setDiffusivity(Variant variant) {
            this.d_diffusivityVar = variant;
            this.changedEvt();
        }

        public boolean isDiffusivitySet() {
            return !this.d_diffusivityVar.isDefault();
        }

        public Variant getViscosity() {
            return this.d_viscosityVar;
        }

        public void setViscosity(Variant variant) {
            this.d_viscosityVar = variant;
            this.changedEvt();
        }

        public boolean isViscositySet() {
            return !this.d_viscosityVar.isDefault();
        }

        public double getSigmaLJ() {
            return this.d_sigmaLJ;
        }

        public void setSigmaLJ(double d, boolean bl) {
            this.d_sigmaLJ = d;
            this.d_sigmaLJSet = bl;
            this.changedEvt();
        }

        public boolean isSigmaLJSet() {
            return this.d_sigmaLJSet;
        }

        public double getEpsilonKLJ() {
            return this.d_epsilonKLJ;
        }

        public void setEpsilonKLJ(double d, boolean bl) {
            this.d_epsilonKLJ = d;
            this.d_epsilonKLJSet = bl;
            this.changedEvt();
        }

        public boolean isEpsilonKLJSet() {
            return this.d_epsilonKLJSet;
        }

        public String getRadCalSurrogate() {
            return this.d_radCalSurrogate;
        }

        public void setRadCalSurrogate(String string) {
            this.d_radCalSurrogate = string;
            this.changedEvt();
        }

        public boolean isAerosol() {
            return this.d_aerosol;
        }

        public void setAerosol(boolean bl) {
            this.d_aerosol = bl;
            this.changedEvt();
        }

        public UnitDouble getDensitySolid() {
            return this.d_densitySolid;
        }

        public void setDensitySolid(UnitDouble unitDouble) {
            this.d_densitySolid = unitDouble;
            this.changedEvt();
        }

        public UnitDouble getConductivitySolid() {
            return this.d_conductivitySolid;
        }

        public void setConductivitySolid(UnitDouble unitDouble) {
            this.d_conductivitySolid = unitDouble;
            this.changedEvt();
        }

        public UnitDouble getMeanDiameter() {
            return this.d_meanDiameter;
        }

        public void setMeanDiameter(UnitDouble unitDouble) {
            this.d_meanDiameter = unitDouble;
            this.changedEvt();
        }

        public Variant getSpecHeat() {
            return this.d_specHeat;
        }

        public void setSpecHeat(Variant variant) {
            this.d_specHeat = variant;
            this.changedEvt();
        }

        public boolean isSpecHeatSet() {
            return !this.d_specHeat.isDefault();
        }

        public UnitDouble getRefTemp() {
            return this.d_refTemp;
        }

        public void setRefTemp(UnitDouble unitDouble, boolean bl) {
            this.d_refTemp = unitDouble;
            this.d_refTempSet = bl;
            this.changedEvt();
        }

        public boolean isRefTempSet() {
            return this.d_refTempSet;
        }

        public Variant getRefEnthalpy() {
            return this.d_refEnthalpyVar;
        }

        public void setRefEnthalpy(UnitDouble unitDouble) {
            this.d_refEnthalpyVar = unitDouble != null ? Variant.constant(unitDouble) : Variant.DEFAULT;
            this.changedEvt();
        }

        public boolean isRefEnthalpySet() {
            return !this.d_refEnthalpyVar.isDefault();
        }

        public Variant getDensityLiquid() {
            return this.d_densityLiquidVar;
        }

        public void setDensityLiquid(UnitDouble unitDouble) {
            this.d_densityLiquidVar = unitDouble != null ? Variant.constant(unitDouble) : Variant.DEFAULT;
            this.changedEvt();
        }

        public boolean isDensityLiquidSet() {
            return !this.d_densityLiquidVar.isDefault();
        }

        public Variant getSpecHeatLiquid() {
            return this.d_specHeatLiquidVar;
        }

        public void setSpecHeatLiquid(Variant variant) {
            this.d_specHeatLiquidVar = variant;
            this.changedEvt();
        }

        public boolean isSpecHeatLiquidSet() {
            return !this.d_specHeatLiquidVar.isDefault();
        }

        public Variant getVapTemp() {
            return this.d_vapTempVar;
        }

        public void setVapTemp(UnitDouble unitDouble) {
            this.d_vapTempVar = unitDouble != null ? Variant.constant(unitDouble) : Variant.DEFAULT;
            this.changedEvt();
        }

        public boolean isVapTempSet() {
            return !this.d_vapTempVar.isDefault();
        }

        public Variant getMeltTemp() {
            return this.d_meltTempVar;
        }

        public void setMeltingTemp(UnitDouble unitDouble) {
            this.d_meltTempVar = unitDouble != null ? Variant.constant(unitDouble) : Variant.DEFAULT;
            this.changedEvt();
        }

        public boolean isMeltingTempSet() {
            return !this.d_meltTempVar.isDefault();
        }

        public Variant getHoVaporization() {
            return this.d_HoVaporizationVar;
        }

        public void setHoVaporization(UnitDouble unitDouble) {
            this.d_HoVaporizationVar = unitDouble != null ? Variant.constant(unitDouble) : Variant.DEFAULT;
            this.changedEvt();
        }

        public boolean isHoVaporizationSet() {
            return !this.d_HoVaporizationVar.isDefault();
        }

        public Variant getEoFormation() {
            return this.d_EoFormationVar;
        }

        public void setEoFormation(UnitDouble unitDouble) {
            this.d_EoFormationVar = unitDouble != null ? Variant.constant(unitDouble) : Variant.DEFAULT;
            this.changedEvt();
        }

        public boolean isEoFormationSet() {
            return !this.d_EoFormationVar.isDefault();
        }

        public Variant getHVRefTemp() {
            return this.d_hvRefTempVar;
        }

        public void setHVRefTemp(UnitDouble unitDouble) {
            this.d_hvRefTempVar = unitDouble != null ? Variant.constant(unitDouble) : Variant.DEFAULT;
            this.changedEvt();
        }

        public boolean isHVRefTempSet() {
            return !this.d_hvRefTempVar.isDefault();
        }
    }

    public static enum LUMPED_RULE {
        AUTO(Intl.intl("AUTO")),
        TRUE(Intl.intl("TRUE")),
        FALSE(Intl.intl("FALSE"));

        public final String id;

        private LUMPED_RULE(String string2) {
            this.id = string2;
        }
    }
}

