/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.awt.Color;
import javax.vecmath.Point3d;
import junit.framework.TestCase;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISlip;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;

public class CompTestMod
extends PyroMod {
    static final long serialVersionUID = 1L;
    public static final String HEAT0 = "HEAT #0";
    public static final String HEAT1 = "HEAT #1";
    public static final String HEAT2 = "HEAT #2";
    public static final String PART1 = "PART #1";
    public static final String PART2 = "PART #2";
    public static final String PART3 = "PART #3";
    public static final String PART4 = "PART #4";
    public static final String REAC1 = "REAC #1";
    public static final String REAC2 = "REAC #2";
    public static final String REAC3 = "REAC #3";
    public static final String MAT1 = "MAT #1";
    public static final String MAT2 = "MAT #2";
    public static final String MAT3 = "MAT #3";
    public static final String MAT4 = "MAT #4";
    public static final String MAT5 = "MAT #5";
    public static final String SPEC1 = "SPEC #1";
    public static final String SPRK1 = "SPRK #1";
    public static final String SPRK2 = "SPRK #2";
    public static final String WALL1 = "WALL #1";
    public static final String AB1 = "OBST #1";
    public static final String VENT1 = "VENT #1";
    public static final String HOLE1 = "HOLE #1";
    public Vent d_vent1;
    public Obstruction d_wall1;
    public Obstruction d_ab1;
    public Hole d_hole1;

    public CompTestMod() {
        this.setDebugPrintingEnabled(false);
        ExSpecList exSpecList = this.getExSpecList();
        ExSpec exSpec = new ExSpec(SPEC1, 1);
        exSpecList.add(exSpec);
        ParticleList particleList = this.getPartList();
        Particle particle = new Particle(PART1, Particle.Type.LIQUID, new Output(10), null);
        Particle particle2 = new Particle(PART2, Particle.Type.LIQUID, new Output(10), null);
        Particle particle3 = new Particle(PART3, Particle.Type.LIQUID, new Output(10), null);
        Particle particle4 = new Particle(PART4, Particle.Type.LIQUID, new Output(10), null);
        particle.setSpecies(exSpec);
        particle2.setSpecies(exSpec);
        particle3.setSpecies(exSpec);
        particle4.setSpecies(exSpec);
        particleList.add(new Particle(PART1, Particle.Type.LIQUID, new Output(10), null));
        particleList.add(new Particle(PART2, Particle.Type.LIQUID, new Output(10), null));
        particleList.add(new Particle(PART3, Particle.Type.LIQUID, new Output(10), null));
        particleList.add(new Particle(PART4, Particle.Type.LIQUID, new Output(10), null));
        ReactionList reactionList = this.getReactions();
        reactionList.add(new Reaction(REAC1, false, Reaction.ReacType.SIMPLE));
        reactionList.add(new Reaction(REAC2, false, Reaction.ReacType.SIMPLE));
        reactionList.add(new Reaction(REAC3, false, Reaction.ReacType.SIMPLE));
        SurfaceManager surfaceManager = this.getSurfaceMgr();
        Surface surface = new Surface(MAT1, new Color(50, 50, 50), null);
        surface.setSurfDesc(CompTestMod.newPartInfSurf(new ParticleInjection((Particle)particleList.get(PART1), 1, null, null)));
        Surface surface2 = new Surface(MAT2, new Color(50, 50, 50), null);
        surface2.setSurfDesc(CompTestMod.newPartInfSurf(new ParticleInjection((Particle)particleList.get(PART2), 1, null, null)));
        Surface surface3 = new Surface(MAT3, new Color(50, 50, 50), null);
        surface3.setSurfDesc(CompTestMod.newPartInfSurf(new ParticleInjection((Particle)particleList.get(PART3), 1, null, null)));
        Surface surface4 = new Surface(MAT4, new Color(50, 50, 50), null);
        surface4.setSurfDesc(CompTestMod.newPartInfSurf(new ParticleInjection((Particle)particleList.get(PART4), 1, null, null)));
        Surface surface5 = new Surface(MAT5, new Color(50, 50, 50), null);
        Surface surface6 = surfaceManager.get(PredefSurf.INERT);
        surfaceManager.add(surface);
        surfaceManager.add(surface2);
        surfaceManager.add(surface3);
        surfaceManager.add(surface4);
        surfaceManager.add(surface5);
        ModelComposite modelComposite = this.getObstructions();
        LineSeg lineSeg = new LineSeg(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 0.0, 0.0));
        WallGeom wallGeom = new WallGeom(lineSeg, WallGeom.Alignment.LEFT, 0.0, 0.0);
        this.d_wall1 = new Obstruction(WALL1, GeomNodeUtil.newNode(wallGeom), new Surface[]{(Surface)surfaceManager.get(MAT1), surface6, surface6, surface6, surface6, surface6});
        AABoxGeom aABoxGeom = new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0);
        this.d_ab1 = new Obstruction(AB1, GeomNodeUtil.newNode(aABoxGeom), new Surface[]{(Surface)surfaceManager.get(MAT2), (Surface)surfaceManager.get(MAT1), (Surface)surfaceManager.get(MAT3), surface6, surface6, surface6});
        AARectangle aARectangle = new AARectangle(1, 0.0, 0.0, 0.0, 1.0, 1.0, false);
        this.d_vent1 = new Vent(VENT1, (Surface)surfaceManager.get(MAT3), aARectangle);
        this.d_hole1 = new Hole(HOLE1, GeomNodeUtil.newNode(aABoxGeom));
        modelComposite.add(this.d_wall1);
        modelComposite.add(this.d_ab1);
        modelComposite.add(this.d_vent1);
        modelComposite.add(this.d_hole1);
    }

    private static LayeredSurfDesc newPartInfSurf(ParticleInjection particleInjection) {
        return new LayeredSurfDesc(IGeometry.DEFAULT, ISlip.NO_SLIP, new Fuel.MaterialReac(), new SurfComposition(), null, particleInjection, false, null, TempRegulation.newDefault());
    }

    private static String getPartID(SurfaceManager surfaceManager, String string) {
        Surface surface = (Surface)surfaceManager.get(string);
        ParticleInjection particleInjection = ((LayeredSurfDesc)surface.getSurfDesc()).d_partInj;
        return particleInjection.getParticle().getName();
    }

    public static abstract class ATest
    extends TestCase {
        private CompTestMod d_mod;

        protected void setUp() throws Exception {
            super.setUp();
            this.d_mod = new CompTestMod();
        }

        public CompTestMod getMod() {
            return this.d_mod;
        }

        public void assertIsInOriginalState() {
            ParticleList particleList = this.d_mod.getPartList();
            ATest.assertSame((Object)4, (Object)particleList.getMembers().size());
            ATest.assertTrue((particleList.get(CompTestMod.PART1) != null ? 1 : 0) != 0);
            ATest.assertTrue((particleList.get(CompTestMod.PART2) != null ? 1 : 0) != 0);
            ATest.assertTrue((particleList.get(CompTestMod.PART3) != null ? 1 : 0) != 0);
            ATest.assertTrue((particleList.get(CompTestMod.PART4) != null ? 1 : 0) != 0);
            ReactionList reactionList = this.d_mod.getReactions();
            ATest.assertSame((Object)3, (Object)reactionList.getMembers().size());
            ATest.assertTrue((reactionList.get(CompTestMod.REAC1) != null ? 1 : 0) != 0);
            ATest.assertTrue((reactionList.get(CompTestMod.REAC2) != null ? 1 : 0) != 0);
            ATest.assertTrue((reactionList.get(CompTestMod.REAC3) != null ? 1 : 0) != 0);
            SurfaceManager surfaceManager = new SurfaceManager();
            surfaceManager.addPredefined();
            SurfaceManager surfaceManager2 = this.d_mod.getSurfaceMgr();
            ATest.assertSame((Object)(surfaceManager.getMembers().size() + 5), (Object)surfaceManager2.getMembers().size());
            ATest.assertTrue((surfaceManager2.get(CompTestMod.MAT1) != null ? 1 : 0) != 0);
            ATest.assertTrue((surfaceManager2.get(CompTestMod.MAT2) != null ? 1 : 0) != 0);
            ATest.assertTrue((surfaceManager2.get(CompTestMod.MAT3) != null ? 1 : 0) != 0);
            ATest.assertTrue((surfaceManager2.get(CompTestMod.MAT4) != null ? 1 : 0) != 0);
            ATest.assertTrue((surfaceManager2.get(CompTestMod.MAT5) != null ? 1 : 0) != 0);
            ATest.assertTrue((boolean)CompTestMod.getPartID(surfaceManager2, CompTestMod.MAT1).equals(CompTestMod.PART1));
            ATest.assertTrue((boolean)CompTestMod.getPartID(surfaceManager2, CompTestMod.MAT2).equals(CompTestMod.PART2));
            ATest.assertTrue((boolean)CompTestMod.getPartID(surfaceManager2, CompTestMod.MAT3).equals(CompTestMod.PART3));
            ATest.assertTrue((boolean)CompTestMod.getPartID(surfaceManager2, CompTestMod.MAT4).equals(CompTestMod.PART4));
            ModelComposite modelComposite = this.d_mod.getObstructions();
            ATest.assertSame((Object)4, (Object)modelComposite.getMembers().size());
            assert (modelComposite.contains(this.d_mod.d_wall1));
            assert (modelComposite.contains(this.d_mod.d_ab1));
            assert (modelComposite.contains(this.d_mod.d_vent1));
            assert (modelComposite.contains(this.d_mod.d_hole1));
            ATest.assertTrue((boolean)this.d_mod.d_wall1.getSurfaces()[0].equals(surfaceManager2.get(CompTestMod.MAT1)));
            ATest.assertTrue((boolean)this.d_mod.d_ab1.getSurfaces()[0].equals(surfaceManager2.get(CompTestMod.MAT2)));
            ATest.assertTrue((boolean)this.d_mod.d_ab1.getSurfaces()[1].equals(surfaceManager2.get(CompTestMod.MAT1)));
            ATest.assertTrue((boolean)this.d_mod.d_ab1.getSurfaces()[2].equals(surfaceManager2.get(CompTestMod.MAT3)));
            ATest.assertTrue((boolean)this.d_mod.d_vent1.getSurface().equals(surfaceManager2.get(CompTestMod.MAT3)));
        }

        static {
            new PyroSim();
        }
    }
}

