/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.geom.IGeomSource;
import thunderheadeng.gui.ADomainObject;
import thunderheadeng.util.theUtil;

public abstract class APyroObject
extends ADomainObject<PyroMod>
implements IPyroObject {
    static final long serialVersionUID = 1L;
    @SkipDep
    private transient IPyroObject d_parent = null;
    private boolean d_enabled = true;

    @Override
    public Object clone() {
        APyroObject aPyroObject = (APyroObject)super.clone();
        aPyroObject.d_parent = null;
        return aPyroObject;
    }

    protected void removeFromDomain(PyroMod pyroMod) {
        for (IPyroObject iPyroObject : this.getMembers()) {
            iPyroObject.setDomain(null, null);
        }
        if (this instanceof IGeomSource) {
            pyroMod.getGeomLocator().remove((IGeomSource)((Object)this));
            if (this.registerProximity()) {
                pyroMod.getGeomProx().remove((IGeomSource)((Object)this));
            }
        }
        if (this instanceof INamed) {
            pyroMod.getNames(this).unregisterName(((INamed)((Object)this)).getName());
        }
        this.removedEvt((Object)this);
        this.d_parent = null;
    }

    protected void addToDomain(PyroMod pyroMod, IPyroObject iPyroObject) {
        this.d_parent = iPyroObject;
        this.addedEvt((Object)this);
        if (this instanceof INamed) {
            pyroMod.getNames(this).registerName(((INamed)((Object)this)).getName());
        }
        if (this instanceof IGeomSource) {
            pyroMod.getGeomLocator().add((IGeomSource)((Object)this));
            if (this.registerProximity()) {
                pyroMod.getGeomProx().add((IGeomSource)((Object)this));
            }
        }
        for (IPyroObject iPyroObject2 : this.getMembers()) {
            iPyroObject2.setDomain(pyroMod, this);
        }
    }

    @Override
    @Deprecated
    public void setDomain(PyroMod pyroMod) {
        super.setDomain(pyroMod);
    }

    @Override
    public void setDomain(PyroMod pyroMod, IPyroObject iPyroObject) {
        if (this.getDomain() == pyroMod) {
            return;
        }
        if (this.getDomain() != null) {
            this.pauseUpdates();
            this.removeFromDomain((PyroMod)this.getDomain());
            this.resumeUpdates();
        }
        super.setDomain(pyroMod);
        if (pyroMod != null) {
            this.pauseUpdates();
            this.addToDomain((PyroMod)this.getDomain(), iPyroObject);
            this.resumeUpdates();
        }
    }

    @Override
    public IPyroObject getParent() {
        return this.d_parent;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.d_enabled == bl) {
            return;
        }
        this.d_enabled = bl;
        if (this.getDomain() != null) {
            ((PyroMod)this.getDomain()).getEvents().changed(this, PyroMod.EVT_ENABLED_CHANGED);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.d_enabled;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.d_enabled = true;
        objectInputStream.defaultReadObject();
    }

    protected boolean registerProximity() {
        return false;
    }

    @Override
    public boolean changedEvt(Object ... objectArray) {
        this.pauseUpdates();
        IPyroObject iPyroObject = this.getParent();
        if (iPyroObject instanceof Composite && !APyroObject.changesExclusiveTo(objectArray, PyroMod.EVT_SEL)) {
            ((Composite)iPyroObject).changedEvt(new Object[0]);
        }
        if (this.getDomain() != null && this instanceof IGeomSource && ((PyroMod)this.getDomain()).isListening() && !APyroObject.changesExclusiveTo(objectArray, PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_APPEARANCE, PyroMod.EVT_PARENT_CHANGED)) {
            ((PyroMod)this.getDomain()).getGeomLocator().update((IGeomSource)((Object)this));
            if (this.registerProximity()) {
                ((PyroMod)this.getDomain()).getGeomProx().update((IGeomSource)((Object)this));
            }
        }
        boolean bl = super.changedEvt(objectArray);
        this.resumeUpdates();
        return bl;
    }

    protected static boolean changesExclusiveTo(Object[] objectArray, Object ... objectArray2) {
        if (objectArray.length == 0) {
            return false;
        }
        for (Object object : objectArray) {
            boolean bl = false;
            for (Object object2 : objectArray2) {
                if (object != object2) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<? extends IPyroObject> getMembers() {
        return Collections.EMPTY_LIST;
    }

    public <T> Collection<T> getMembers(Class<T> clazz) {
        return theUtil.filter(this.getMembers(), clazz);
    }

    public <T> Collection<T> getMembers(Class<T> clazz, Predicate<? super T> predicate) {
        return theUtil.filter(this.getMembers(), clazz, predicate);
    }

    public <T> Collection<T> flatten(Class<T> clazz) {
        return Hierarchy.flatten(this.getMembers(), clazz);
    }

    public <T> Collection<T> flatten(Class<T> clazz, Predicate<? super T> predicate) {
        return Hierarchy.flatten(this.getMembers(), clazz, predicate);
    }
}

