/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.awt.Color;
import java.util.Arrays;
import java.util.Set;
import javax.vecmath.Point3d;
import junit.framework.Assert;
import junit.framework.TestCase;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.TestListener;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Obstruction;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;

public class TestEvents
extends TestCase {
    private PyroSim d_pyrosim;
    private PyroMod d_pyMod;

    public TestEvents(String string) {
        super(string);
    }

    protected void setUp() {
        this.d_pyrosim = new PyroSim();
        this.d_pyMod = this.d_pyrosim.getMediator();
    }

    public void test_AddEventsMerged() {
        final ModelComposite modelComposite = new ModelComposite();
        GeomNodeLeaf geomNodeLeaf = GeomNodeUtil.newNode(new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0));
        Surface surface = this.d_pyMod.getDefaultSurface();
        final Obstruction obstruction = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        final Obstruction obstruction2 = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        final Obstruction obstruction3 = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        final Obstruction obstruction4 = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        Obstruction[] obstructionArray = new Obstruction[]{obstruction3, obstruction4};
        TestListener testListener = new TestListener(){

            @Override
            public void update(Events events) {
                super.update(events);
                Set<EventChannel<ModelComposite>> set = events.getAffectedChannels(ModelComposite.class, new Class[0]);
                Assert.assertEquals((int)1, (int)set.size());
                EventChannel<ModelComposite> eventChannel = set.iterator().next();
                Assert.assertEquals((int)1, (int)eventChannel.getAddedObjs().size());
                Assert.assertTrue((boolean)eventChannel.getAddedObjs().contains(modelComposite));
                Set<EventChannel<FDSObject>> set2 = events.getAffectedChannels(FDSObject.class, ModelComposite.class);
                Assert.assertEquals((int)1, (int)set2.size());
                EventChannel<FDSObject> eventChannel2 = set2.iterator().next();
                Assert.assertEquals((int)4, (int)eventChannel2.getAddedObjs().size());
                Assert.assertTrue((boolean)eventChannel2.getAddedObjs().contains(obstruction));
                Assert.assertTrue((boolean)eventChannel2.getAddedObjs().contains(obstruction2));
                Assert.assertTrue((boolean)eventChannel2.getAddedObjs().contains(obstruction3));
                Assert.assertTrue((boolean)eventChannel2.getAddedObjs().contains(obstruction4));
                Assert.assertEquals((int)1, (int)events.getAffectedChannels(FDSObject.class, new Class[0]).size());
                Assert.assertFalse((boolean)eventChannel2.hasRemovedObjs());
                Assert.assertFalse((boolean)eventChannel2.hasChangedObjs());
            }
        };
        this.d_pyMod.getEvents().addObserver(testListener);
        this.d_pyMod.pauseUpdates();
        this.d_pyMod.getObstructions().add(modelComposite);
        modelComposite.add(obstruction);
        modelComposite.add(obstruction2);
        this.d_pyMod.getObstructions().addAll(Arrays.asList(obstructionArray));
        this.d_pyMod.resumeUpdates();
        testListener.ensureEvent();
    }

    public void test_AddEventsCancelledByRemove() {
        final ModelComposite modelComposite = new ModelComposite();
        GeomNodeLeaf geomNodeLeaf = GeomNodeUtil.newNode(new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0));
        Surface surface = this.d_pyMod.getDefaultSurface();
        final Obstruction obstruction = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        final Obstruction obstruction2 = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        final Obstruction obstruction3 = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        final Obstruction obstruction4 = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        final Obstruction obstruction5 = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        TestListener testListener = new TestListener(){

            @Override
            public void update(Events events) {
                super.update(events);
                EventChannel<ModelComposite> eventChannel = events.getAffectedChannels(ModelComposite.class, new Class[0]).iterator().next();
                Assert.assertTrue((boolean)eventChannel.getAddedObjs().contains(modelComposite));
                EventChannel<FDSObject> eventChannel2 = events.getAffectedChannels(FDSObject.class, ModelComposite.class).iterator().next();
                Assert.assertFalse((boolean)eventChannel2.getAddedObjs().contains(obstruction));
                Assert.assertTrue((boolean)eventChannel2.getAddedObjs().contains(obstruction2));
                Assert.assertTrue((boolean)eventChannel2.getAddedObjs().contains(obstruction3));
                Assert.assertFalse((boolean)eventChannel2.getAddedObjs().contains(obstruction4));
                Assert.assertFalse((boolean)eventChannel2.getAddedObjs().contains(obstruction5));
                Assert.assertFalse((boolean)eventChannel2.hasRemovedObjs());
                Assert.assertFalse((boolean)eventChannel2.hasChangedObjs());
            }
        };
        this.d_pyMod.getEvents().addObserver(testListener);
        this.d_pyMod.pauseUpdates();
        this.d_pyMod.getObstructions().add(modelComposite);
        modelComposite.add(obstruction);
        modelComposite.add(obstruction2);
        this.d_pyMod.getObstructions().addAll(Arrays.asList(obstruction3, obstruction4));
        modelComposite.add(obstruction5);
        modelComposite.removeAll(Arrays.asList(obstruction5, obstruction));
        this.d_pyMod.getObstructions().remove(obstruction4);
        this.d_pyMod.resumeUpdates();
        testListener.ensureEvent();
    }

    public void test_RemoveEventsCancelledByAdd() {
        ModelComposite modelComposite = new ModelComposite();
        GeomNodeLeaf geomNodeLeaf = GeomNodeUtil.newNode(new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0));
        Surface surface = this.d_pyMod.getDefaultSurface();
        final Obstruction obstruction = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        final Obstruction obstruction2 = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        Obstruction obstruction3 = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        Obstruction obstruction4 = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        final Obstruction obstruction5 = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        TestListener testListener = new TestListener(){

            @Override
            public void update(Events events) {
                super.update(events);
                EventChannel<FDSObject> eventChannel = events.getAffectedChannels(FDSObject.class, ModelComposite.class).iterator().next();
                Assert.assertEquals((int)1, (int)eventChannel.getAddedObjs().size());
                Assert.assertEquals((int)1, (int)eventChannel.getRemovedObjs().size());
                Assert.assertEquals((int)1, (int)eventChannel.getChangedObjs(new Object[0]).size());
                Assert.assertTrue((boolean)eventChannel.getAddedObjs().contains(obstruction2));
                Assert.assertTrue((boolean)eventChannel.getRemovedObjs().contains(obstruction5));
                Assert.assertTrue((boolean)eventChannel.getChangedObjs(new Object[0]).contains(obstruction));
            }
        };
        this.d_pyMod.pauseUpdates();
        this.d_pyMod.getObstructions().add(modelComposite);
        modelComposite.add(obstruction);
        this.d_pyMod.getObstructions().addAll(Arrays.asList(obstruction3, obstruction4));
        modelComposite.add(obstruction5);
        this.d_pyMod.resumeUpdates();
        this.d_pyMod.getEvents().addObserver(testListener);
        this.d_pyMod.pauseUpdates();
        modelComposite.removeAll(Arrays.asList(obstruction5, obstruction));
        modelComposite.addAll(Arrays.asList(obstruction2, obstruction));
        this.d_pyMod.resumeUpdates();
        testListener.ensureEvent();
    }

    public void test_ChangeEventsEatenByPreviousAdd() {
        ModelComposite modelComposite = new ModelComposite();
        GeomNodeLeaf geomNodeLeaf = GeomNodeUtil.newNode(new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0));
        Surface surface = this.d_pyMod.getDefaultSurface();
        final Obstruction obstruction = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        final Obstruction obstruction2 = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        TestListener testListener = new TestListener(){

            @Override
            public void update(Events events) {
                super.update(events);
                EventChannel<FDSObject> eventChannel = events.getAffectedChannels(FDSObject.class, ModelComposite.class).iterator().next();
                Assert.assertEquals((int)2, (int)eventChannel.getAddedObjs().size());
                Assert.assertFalse((boolean)eventChannel.hasChangedObjs());
                Assert.assertFalse((boolean)eventChannel.hasRemovedObjs());
                Assert.assertTrue((boolean)eventChannel.getAddedObjs().contains(obstruction));
                Assert.assertTrue((boolean)eventChannel.getAddedObjs().contains(obstruction2));
            }
        };
        this.d_pyMod.getEvents().addObserver(testListener);
        this.d_pyMod.pauseUpdates();
        this.d_pyMod.getObstructions().add(modelComposite);
        modelComposite.add(obstruction);
        modelComposite.add(obstruction2);
        obstruction.setColors(Color.RED);
        this.d_pyMod.resumeUpdates();
        testListener.ensureEvent();
    }

    public void test_ChangeEventsEatenByNextDelete() {
        ModelComposite modelComposite = new ModelComposite();
        GeomNodeLeaf geomNodeLeaf = GeomNodeUtil.newNode(new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0));
        Surface surface = this.d_pyMod.getDefaultSurface();
        final Obstruction obstruction = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        final Obstruction obstruction2 = new Obstruction("test", geomNodeLeaf, new Surface[]{surface});
        TestListener testListener = new TestListener(){

            @Override
            public void update(Events events) {
                super.update(events);
                EventChannel<FDSObject> eventChannel = events.getAffectedChannels(FDSObject.class, ModelComposite.class).iterator().next();
                Assert.assertEquals((int)1, (int)eventChannel.getChangedObjs(new Object[0]).size());
                Assert.assertEquals((int)1, (int)eventChannel.getRemovedObjs().size());
                Assert.assertFalse((boolean)eventChannel.hasAddedObjs());
                Assert.assertTrue((boolean)eventChannel.getChangedObjs(new Object[0]).contains(obstruction2));
                Assert.assertTrue((boolean)eventChannel.getRemovedObjs().contains(obstruction));
            }
        };
        this.d_pyMod.pauseUpdates();
        this.d_pyMod.getObstructions().add(modelComposite);
        modelComposite.add(obstruction2);
        modelComposite.add(obstruction);
        this.d_pyMod.resumeUpdates();
        this.d_pyMod.getEvents().addObserver(testListener);
        this.d_pyMod.pauseUpdates();
        obstruction.setColors(Color.RED);
        modelComposite.remove(obstruction);
        obstruction2.setOptions(1, true);
        this.d_pyMod.resumeUpdates();
        testListener.ensureEvent();
    }
}

