/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.view.View;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.gui.CrashCatcher;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Task;
import thunderheadeng.util.TaskManager;

public class PyroTaskManager
extends TaskManager {
    private final PyroMod d_pyMod;
    public static final int OPT_RETAIN_CURR_TOOL = 1;
    public static final int OPT_RESET_CAMERA = 2;
    public static final int OPT_IGNORE_WRITE_PROTECT = 4;
    public static final int OPT_RETAIN_VIEW_CAMERA = 8;
    public static final int OPT_BYPASS_UNDO = 16;
    public static final int OPT_SELECT_SELECTION_TOOL = 32;

    public PyroTaskManager(PyroMod pyroMod) {
        this.d_pyMod = pyroMod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(int n, Runnable runnable) {
        Object object = this.d_pyMod.getLockObj();
        synchronized (object) {
            if (!this.d_pyMod.isWriteProtected() || PyroTaskManager.test(n, 4)) {
                if (!PyroTaskManager.test(n, 1)) {
                    this.cancelModelessOps();
                }
                this.d_pyMod.pauseUpdates();
                runnable.run();
                this.d_pyMod.resumeUpdates();
                if (PyroTaskManager.test(n, 2)) {
                    this.resetCurrentCamera(PyroTaskManager.test(n, 8));
                }
                if (PyroTaskManager.test(n, 32)) {
                    this.selectTool(View.NavTool.SELECT);
                }
            } else {
                this.showPreventModsError();
            }
        }
    }

    private static boolean test(int n, int n2) {
        return (n & n2) == n2;
    }

    @Override
    public void exec(Task task, String string) {
        String string2 = PyroTaskManager.getCallSourceName(0);
        this.exec(task, string, string2, 0);
    }

    public void exec(Task task, String string, String string2) {
        this.exec(task, string, string2, 0);
    }

    public void exec(Task task, String string, int n) {
        String string2 = PyroTaskManager.getCallSourceName(0);
        this.exec(task, string, string2, n);
    }

    private static String getCallSourceName(int n) {
        List<StackTraceElement> list = PyroTaskManager.getCallSources(n + 1, 3);
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(stackTraceElement.toString());
        }
        return stringBuilder.toString();
    }

    private static List<StackTraceElement> getCallSources(int n, int n2) {
        n += 2;
        try {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                if (!stackTraceElement.getClassName().equals(PyroTaskManager.class.getName()) || !stackTraceElement.getMethodName().equals("getCallSources")) continue;
                ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
                for (int j = i + n; j < i + n + n2 && j < stackTraceElementArray.length; ++j) {
                    arrayList.add(stackTraceElementArray[j]);
                }
                return arrayList;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return Collections.EMPTY_LIST;
    }

    public void exec(final Task task, final String string, String string2, final int n) {
        CrashCatcher.logAction(string2);
        this.run(n, new Runnable(){

            @Override
            public void run() {
                RunWithDependenciesTask runWithDependenciesTask = new RunWithDependenciesTask(PyroTaskManager.this.d_pyMod, task);
                if (PyroTaskManager.test(n, 16)) {
                    PyroTaskManager.super.run(runWithDependenciesTask);
                } else {
                    PyroTaskManager.super.exec(runWithDependenciesTask, string);
                }
            }
        });
    }

    @Override
    public void redo() {
        CrashCatcher.logAction("Redo");
        this.run(0, new Runnable(){

            @Override
            public void run() {
                PyroTaskManager.super.redo();
            }
        });
    }

    @Override
    public void undo() {
        CrashCatcher.logAction("Undo");
        this.run(0, new Runnable(){

            @Override
            public void run() {
                PyroTaskManager.super.undo();
            }
        });
    }

    private void cancelModelessOps() {
        if (PyroSim.getApp().get3DView() != null) {
            PyroSim.getApp().get3DView().cancelCurrentTool();
        }
    }

    private void resetCurrentCamera(boolean bl) {
        if (!(PyroSim.getApp().get3DView() == null || bl && this.d_pyMod.getViews().getActiveView().get(View.PROP_CAMERA) != null)) {
            PyroSim.getApp().get3DView().resetCurrentCamera();
        }
    }

    private void selectTool(View.NavTool navTool) {
        if (PyroSim.getApp().get3DView() != null) {
            PyroSim.getApp().get3DView().setNavTool(navTool);
        }
    }

    private void showPreventModsError() {
        PyroSim pyroSim = PyroSim.getApp();
        JFrame jFrame = pyroSim.getMainFrame();
        JOptionPane.showMessageDialog(jFrame, "This model is write-protected. Operation aborted.");
    }

    private static class RunWithDependenciesTask
    implements Task {
        private final PyroMod d_domain;
        private final Task d_baseTask;
        private List<Task> d_updateTasks;

        public RunWithDependenciesTask(PyroMod pyroMod, Task task) {
            this.d_domain = pyroMod;
            this.d_baseTask = task;
            this.d_updateTasks = new ArrayList<Task>();
        }

        @Override
        public boolean canUndo() {
            return this.d_baseTask.canUndo();
        }

        @Override
        public int getEst() {
            return this.d_baseTask.getEst();
        }

        @Override
        public void run() {
            int n;
            Events events = this.d_domain.getEvents();
            IdentityHashSet identityHashSet = Collections.EMPTY_SET;
            Object object = this.d_baseTask;
            for (n = 0; n < 10; ++n) {
                Set<IDirectDependent> set;
                Object object22;
                object.run();
                this.d_domain.updateGeom();
                if (events.getEvents(PyroMod.class, new Class[0]).containsChange(PyroMod.EVT_MODEL_CHANGED)) break;
                ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
                IEventRecord<IPyroObject> iEventRecord = events.getEvents(IPyroObject.class, new Class[0]);
                for (IPyroObject iPyroObject : iEventRecord.getChangedNotOfType(PyroMod.EVT_SEL)) {
                    if (identityHashSet.contains(iPyroObject) || !TVEntryPoints.ep(iPyroObject).getDependentsMayNeedUpdate(this.d_domain, iPyroObject)) continue;
                    arrayList.add(iPyroObject);
                }
                if (arrayList.isEmpty()) break;
                ArrayList arrayList2 = new ArrayList();
                DepSnapshot object32 = this.d_domain.getDependencies(arrayList);
                for (Object object22 : arrayList) {
                    set = object32.findAllDependents(IDirectDependent.class, object22);
                    if (set.isEmpty()) continue;
                    ArrayList<Object> arrayList3 = new ArrayList<Object>();
                    iEventRecord.getChanges(object22, arrayList3);
                    for (IDirectDependent iDirectDependent : set) {
                        Task task = iDirectDependent.taskUpdateDep((IPyroObject)object22, arrayList3);
                        if (task == EmptyTask.INSTANCE) continue;
                        arrayList2.add(task);
                    }
                }
                if (arrayList2.isEmpty()) break;
                CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(this.d_domain);
                object22 = arrayList2.iterator();
                while (object22.hasNext()) {
                    set = (Task)object22.next();
                    compositeTask.addTask((Task)((Object)set));
                }
                object = compositeTask;
                if (n == 0) {
                    identityHashSet = new IdentityHashSet();
                }
                identityHashSet.addAll(arrayList);
                this.d_updateTasks.add((Task)object);
            }
            if (System.getProperty("dev") != null) {
                System.out.println("num update iterations = " + n);
            }
            if (n == 10) {
                assert (false);
                System.err.println("Dependency update halted early - took too many iterations.");
            }
        }

        @Override
        public void undo() {
            for (int i = this.d_updateTasks.size() - 1; i >= 0; --i) {
                this.d_updateTasks.get(i).undo();
            }
            this.d_baseTask.undo();
        }
    }

    public static interface BypassWriteProtection {
    }
}

