/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pyrosim.Accelerators;
import pyrosim.CrashHandler;
import pyrosim.FDSVersion;
import pyrosim.FloatingWaitDlg;
import pyrosim.Intl;
import pyrosim.OpenModelTask;
import pyrosim.PSMBackupHandler;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSimColors;
import pyrosim.PyroSimLM;
import pyrosim.ResetModelTask;
import pyrosim.ScriptAction;
import pyrosim.Version;
import pyrosim.domain.FDSRun;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.rasterization.FDSObjectRasterization;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewMode;
import pyrosim.event.EventUtil;
import pyrosim.gui.FDSRunMonitor;
import pyrosim.gui.PreferencesDialog;
import pyrosim.gui.PromptingFDSRenderProps;
import pyrosim.gui.PyroCheckForUpdatesDlg;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.SnapshotDialog;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.actions.ExportPyroFloorsAction;
import pyrosim.gui.actions.ExportPyroViewsAction;
import pyrosim.gui.actions.ExportSmokeINIFileAction;
import pyrosim.io.IOUtil;
import pyrosim.io.ImportFDSFile;
import pyrosim.io.PyroSimObjectOutputStream;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.mv.ModelView;
import pyrosim.recordview.RecordView;
import pyrosim.treeview.PyroTreeView;
import pyrosim.unitsystem.EnglishUS;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.CrashCatcher;
import thunderheadeng.gui.Document;
import thunderheadeng.gui.DropDownButton;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.MRUListener;
import thunderheadeng.gui.MRUMenu;
import thunderheadeng.gui.ModelBackup;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.MutuallyExclusiveAction;
import thunderheadeng.gui.OutputLog;
import thunderheadeng.gui.ResourcePaths;
import thunderheadeng.gui.SelectableAction;
import thunderheadeng.gui.SelectableActionListener;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.colorscheme.ColorMgrMenu;
import thunderheadeng.gui.colorscheme.ColorScheme;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiExceptionError;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMenu;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiURLLabel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.MRUFileList;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.license3.ActivationDlg;
import thunderheadeng.license3.LicensePrompt;
import thunderheadeng.scene3d.gui.GPUInfoPnl;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.util.Disposable;
import thunderheadeng.util.DisposableCounter;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;

public class PyroSim
extends Application
implements Disposable {
    public static final boolean FDS7 = System.getProperty("FDS7") != null;
    private final ResourcePaths d_docPaths;
    private PyroSimLM d_licenseMgr;
    private PyroMod d_mediator;
    private String d_filename;
    private boolean d_forceSavePrompt;
    private MRUFileList d_mruModelFiles;
    private MRUMenu d_mruModelMenu;
    private MRUFileList d_mruFDSFiles;
    private MRUMenu d_mruFDSMenu;
    private PyroSimColors d_colorManager;
    private ColorMgrMenu d_colorMenu;
    private ModifiedDomainListener d_modifiedTracker;
    private PyroTreeView d_treeView;
    private ModelView d_3dView;
    private RecordView d_recordView;
    private JTabbedPane d_mainView;
    private static final int VIEW_3D = 0;
    private static final int VIEW_2D = 1;
    private static final int VIEW_RECORD = 2;
    private JPanel d_3DPanel;
    private JPanel d_recordPanel;
    private ViewChangeListener d_viewChangeListener;
    private NewAction d_newAction;
    private OpenAction d_openAction;
    private SaveAction d_saveAction;
    private SaveAsAction d_saveAsAction;
    private PreferencesAction d_prefsAction;
    private ScreenShotAction d_screenShotAction;
    private ExortFDSFileAction d_writeFDSFileAction;
    private ExportSmokeINIFileAction d_writeSmokeviewINIFileAction;
    private ExportPyroViewsAction d_exportPyroViewsAction;
    private ExportPyroFloorsAction d_exportPyroFloorsAction;
    private ExportSurfaceDatabaseFileAction d_exportMatDBFileAction;
    private ExportReactionDatabaseFileAction d_exportReacDBFileAction;
    private Collection<Action> d_customActions;
    private JMenuBar d_mainMenuBar;
    private JMenu d_fileMenu;
    private JMenu d_editMenu;
    private JMenu d_modelMenu;
    private JMenu d_deviceMenu;
    private JMenu d_outputMenu;
    private JMenu d_fdsMenu;
    private JMenu d_viewMenu;
    private JMenu d_helpMenu;
    private JToolBar d_mainToolbar;
    private DropDownButton d_fdsRunDropdown;
    private UnitSystem d_unitSystem;
    public static final String SKETCH_GRID_NAME;
    private Pair<Integer, Integer> size = null;
    private Pair<Integer, Integer> location = null;
    private static String file;
    private static final int TRIAL_VER = 8;
    private static final int DATE_LEVEL = 24;
    private DisposableCounter d_dc = new DisposableCounter();
    private final ModelBackup d_backup = new ModelBackup("PyroSim", "psm", new PSMBackupHandler());
    private BackupEvtListener d_autosaveListener;
    private final FDSRenderProps d_fdsRenderProps = new FDSRenderProps();
    private final FilenameManager d_filenames;
    private int d_fdsFullLength;

    public static void main(final String[] stringArray) {
        final PyroSim pyroSim = new PyroSim(stringArray, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        pyroSim.procArgs(stringArray[i]);
                        continue;
                    }
                    catch (Throwable throwable) {
                        String string = Intl.intl("Error processing command line parameter:\n") + stringArray[i] + "\n" + String.format("%s%s", throwable.getClass().getSimpleName(), throwable.getMessage() == null ? "" : "- " + throwable.getMessage());
                        JOptionPane.showMessageDialog(null, string);
                        throwable.printStackTrace();
                    }
                }
                pyroSim.showApp();
                if (file != null) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            PyroMod pyroMod = pyroSim.getMediator();
                            OpenModelTask openModelTask = new OpenModelTask(pyroSim, pyroMod, file);
                            pyroMod.getTaskManager().exec((Task)openModelTask, Intl.intl("Open PyroSim File"), 10);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
                EventQueue.invokeLater(() -> pyroSim.d_3dView.showIntelWarning(() -> pyroSim.editPreferences(PreferencesDialog.Tabs.RENDERING)));
            }
        });
    }

    public PyroSim() {
        this(false);
    }

    public PyroSim(boolean bl) {
        this(new String[]{"-DShowSplash=false"}, bl);
    }

    public PyroSim(String string, String string2, JFrame jFrame) {
        super(string, string2, jFrame);
        this.d_filenames = new FilenameManager();
        this.d_docPaths = new ResourcePaths(this, new String[0]);
    }

    @Override
    public boolean isInstallFolder(File file) {
        int n = 0;
        for (File file2 : IOUtil.listFiles(file)) {
            if (file2.getName().equalsIgnoreCase("pyrosim.exe")) {
                ++n;
            }
            if (file2.getName().equalsIgnoreCase("lib")) {
                ++n;
            }
            if (!file2.getName().equalsIgnoreCase("fds")) continue;
            ++n;
        }
        return n == 3;
    }

    private static native void setNativeInstallDir(String var0);

    private static native void addNativeResourceDir(String var0);

    public static <T> void setPref(TypedProp<T> typedProp, T t, boolean bl) {
        TeciProps teciProps = PyroSim.getApp().getPrefs();
        T t2 = teciProps.get(typedProp);
        if (Objects.equals(t, t2)) {
            return;
        }
        PyroPrefs.set(typedProp, t, bl);
        PyroMod pyroMod = PyroSim.getApp().getMediator();
        pyroMod.getEvents().changed(pyroMod, PyroMod.EVT_PREFS_CHANGED);
    }

    public static <T> void setPrefs(TeciProps teciProps, boolean bl) {
        boolean bl2 = false;
        for (Map.Entry<Object, Object> object : teciProps.entrySet()) {
            Object object2 = PyroPrefs.instance().put(object.getKey(), object.getValue());
            bl2 = bl2 || !Objects.equals(object2, object.getValue());
        }
        PyroSim pyroSim = PyroSim.getApp();
        if (bl2) {
            PyroMod pyroMod = pyroSim.getMediator();
            pyroMod.getEvents().changed(pyroMod, PyroMod.EVT_PREFS_CHANGED);
        }
        if (bl) {
            pyroSim.superSavePreferences();
        }
    }

    @Override
    public String getInstallDir() {
        return super.getInstallDir();
    }

    public ResourcePaths getDocPaths() {
        return this.d_docPaths;
    }

    private static String getFrameTitleBase() {
        boolean bl = PyroSim.is64Bit();
        return "PyroSim" + (bl ? " x64 Edition" : "");
    }

    public PyroSim(String[] stringArray, boolean bl) {
        super("PyroSim", stringArray, PyroSim.class.getResource("PyroSimSplash.png"));
        File file;
        PyroSim.setNativeInstallDir(this.getInstallDir());
        this.d_docPaths = new ResourcePaths(this, "", "doc/en", "../Results/doc/PyroSim");
        Stream.of("../Results/lib", "../thunderheadeng/lib").forEach(string -> {
            this.getResourcePaths().addDir((String)string);
            PyroSim.addNativeResourceDir(string);
        });
        this.getMainFrame().setTitle(PyroSim.getFrameTitleBase());
        String string2 = PyroPrefs.getString(PyroPrefs.UnitSystemProp);
        this.d_unitSystem = string2.equals(EnglishUS.getInstance().getSystemName()) ? EnglishUS.getInstance() : SIUS.getInstance();
        this.d_mruModelFiles = new MRUFileList();
        this.d_mruModelFiles.load(this.d_props);
        this.d_mruFDSFiles = new MRUFileList();
        this.d_mruFDSFiles.setEntryPrefix("MRU_FDS.");
        this.d_mruFDSFiles.load(this.d_props);
        String string3 = this.getWorkingDir();
        File file2 = file = string3 != null ? new File(string3) : null;
        while (file != null && !file.exists()) {
            file = file.getParentFile();
        }
        this.d_filenames = new FilenameManager(file);
        this.d_colorManager = new PyroSimColors();
        this.d_colorManager.load(this.d_props);
        this.d_modifiedTracker = new ModifiedDomainListener();
        this.d_mediator.getEvents().addObserver(this.d_modifiedTracker);
        Actions.init(this.d_mediator);
        this.d_newAction = new NewAction();
        this.d_openAction = new OpenAction();
        this.d_saveAction = new SaveAction();
        this.d_saveAsAction = new SaveAsAction();
        this.d_prefsAction = new PreferencesAction();
        this.d_screenShotAction = new ScreenShotAction();
        this.d_writeFDSFileAction = new ExortFDSFileAction();
        this.d_exportPyroViewsAction = new ExportPyroViewsAction();
        this.d_exportPyroFloorsAction = new ExportPyroFloorsAction();
        this.d_writeSmokeviewINIFileAction = new ExportSmokeINIFileAction();
        this.d_exportMatDBFileAction = new ExportSurfaceDatabaseFileAction();
        this.d_exportReacDBFileAction = new ExportReactionDatabaseFileAction();
        this.d_customActions = null;
        this.d_fdsRenderProps.setDecimalFormatter(PyroSim.getFormatterFromProps());
        Actions.applicationActivated(this);
        this.getMainFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                PyroSim.this.windowActivated(windowEvent);
            }
        });
        if (bl) {
            this.d_autosaveListener = new BackupEvtListener();
            this.d_mediator.getEvents().addObserver(this.d_autosaveListener);
            this.updateBackup();
        }
        if (System.getProperty("debug") == null) {
            String string4 = String.format("%s %s", "2018.3.1210", PyroSim.is64Bit() ? "x64" : "x86");
            CrashCatcher.install("PyroSim", string4, CrashHandler.INSTANCE, 2, new Thread[0]);
        }
    }

    private static FDSRenderProps.IDecimalFormatter getFormatterFromProps() {
        int n;
        int n2 = PyroPrefs.getInt(PyroPrefs.FDSFormatProp);
        if (n2 == 1) {
            int n3 = PyroPrefs.getInt(PyroPrefs.FDSFormatAlignedWidth);
            int n4 = PyroPrefs.getInt(PyroPrefs.FDSFormatAlignedDec);
            int n5 = 1;
            int n6 = n4 + 3;
            if (n3 >= n6 && n4 >= n5) {
                return new FDSRenderProps.AlignedFormatter(n3, n4);
            }
        } else if (n2 == 2 && (n = PyroPrefs.getInt(PyroPrefs.FDSFormatGenPrecision)) > 2) {
            return new FDSRenderProps.GeneralFormatter(n);
        }
        return new FDSRenderProps.ScientificFormatter();
    }

    private static void setFormatterToProps(FDSRenderProps.IDecimalFormatter iDecimalFormatter) {
        if (iDecimalFormatter instanceof FDSRenderProps.AlignedFormatter) {
            FDSRenderProps.AlignedFormatter alignedFormatter = (FDSRenderProps.AlignedFormatter)iDecimalFormatter;
            PyroPrefs.set(PyroPrefs.FDSFormatProp, 1, false);
            PyroPrefs.set(PyroPrefs.FDSFormatAlignedWidth, alignedFormatter.width, false);
            PyroPrefs.set(PyroPrefs.FDSFormatAlignedDec, alignedFormatter.numDecimals, false);
        } else if (iDecimalFormatter instanceof FDSRenderProps.GeneralFormatter) {
            FDSRenderProps.GeneralFormatter generalFormatter = (FDSRenderProps.GeneralFormatter)iDecimalFormatter;
            PyroPrefs.set(PyroPrefs.FDSFormatProp, 2, false);
            PyroPrefs.set(PyroPrefs.FDSFormatGenPrecision, generalFormatter.precision, false);
        } else {
            PyroPrefs.set(PyroPrefs.FDSFormatProp, 0, false);
        }
    }

    @Override
    protected void loadSafeModeProps(TeciProps teciProps) {
        super.loadSafeModeProps(teciProps);
        for (PyroPrefs.SafeModeProp safeModeProp : PyroPrefs.getSafeModeProps()) {
            System.out.printf("Setting preference \"%s\"=%s%n", safeModeProp.key, safeModeProp.safeVal);
            teciProps.set(safeModeProp, safeModeProp.safeVal);
        }
    }

    public FilenameManager getFilenameManager() {
        return this.d_filenames;
    }

    public static FilenameManager getFilenames() {
        return PyroSim.getApp().getFilenameManager();
    }

    public void procArgs(String string) {
        if (string.substring(0, 3).equals("-sz") && this.size == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(3, string.length()), ",");
            this.size = new Pair<Integer, Integer>(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            return;
        }
        if (string.substring(0, 4).equals("-loc") && this.location == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(4, string.length()), ",");
            this.location = new Pair<Integer, Integer>(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            return;
        }
        if (file == null && !string.startsWith("-")) {
            File file = new File(string);
            if (file.exists()) {
                PyroSim.file = string;
                return;
            }
            System.out.println("Invalid File Name: " + string);
            return;
        }
        if (string.startsWith("-D")) {
            return;
        }
        System.out.println("Unused Parameter: " + string);
    }

    @Override
    public void acquire() {
        this.d_dc.acquire(this);
    }

    @Override
    public void release() {
        this.d_dc.release(this);
    }

    @Override
    public void dispose() {
        theUtil.release(this.d_mediator);
        theUtil.release(this.d_3dView);
    }

    public static PyroSim getApp() {
        return (PyroSim)Application.getApp();
    }

    public void setFDSCompability(FDSVersion fDSVersion) {
        this.getPrefs().set(PyroPrefs.PREF_FDSCOMPABILITY, fDSVersion.toString());
    }

    public FDSVersion getFDSCompability() {
        String string = this.getPrefs().getString(PyroPrefs.PREF_FDSCOMPABILITY);
        try {
            return FDSVersion.parse(string);
        }
        catch (Exception exception) {
            return Version.FDS_DESIGN;
        }
    }

    public File getDatabaseDir() {
        String string = this.getInstallDir() + "\\fds";
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("PyroMod Warning: unable to loacate DB directory: /fds");
            String string2 = System.getProperty("java.io.tmpdir");
            file = new File(string2);
        }
        return file;
    }

    public File getTextureDBDir() {
        String string = this.getPreference("texture.dir");
        if (string != null) {
            File file = new File(string);
            if (file.isDirectory() && file.canRead()) {
                return file;
            }
            System.err.println("rejecting invalid texture dir: " + string);
        }
        return this.getDatabaseDir();
    }

    public ModelBackup getBackup() {
        return this.d_backup;
    }

    public FDSRenderProps getFDSRenderProps() {
        return this.d_fdsRenderProps;
    }

    public void showApp() {
        Serializable serializable;
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JFrame jFrame = this.getMainFrame();
        if (this.size != null) {
            serializable = new Dimension((Integer)this.size.v1, (Integer)this.size.v2);
            jFrame.setSize((Dimension)serializable);
        }
        if (this.location != null) {
            serializable = new Point((Integer)this.location.v1, (Integer)this.location.v2);
            jFrame.setLocation((Point)serializable);
        }
        try {
            jFrame.setIconImages(Arrays.asList(ImageIO.read(this.getClass().getResource("/pyrosim/icons/PyroSimIcon16.png")), ImageIO.read(this.getClass().getResource("/pyrosim/icons/PyroSimIcon32.png"))));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.d_mediator.getEvents().addObserver(new FrameDomainListener(jFrame));
        serializable = this.createTreeView();
        Component component = this.createViewModes();
        this.d_mediator.updateGeomSearchesEnabled(this.d_3dView.isHoleCuttingEnabled());
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1, true, (Component)serializable, component);
        container.add((Component)jSplitPane, "Center");
        jSplitPane.setDividerLocation(250);
        jSplitPane.setDividerSize(9);
        this.nowCreateMenuBar();
        container.add((Component)this.createToolbar(), "North");
        jFrame.setVisible(true);
        this.initActiveView();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2005, 10, 1);
        try {
            this.d_licenseMgr = PyroSimLM.getInstance();
            boolean bl = this.d_licenseMgr.startFromPrefs(this.getPrefs(), PyroPrefs.LicenseDirProp, PyroPrefs.LicenseServerProp);
            if (!bl) {
                this.showActivationDialog();
            }
            if (this.d_licenseMgr.inQueue()) {
                FloatingWaitDlg floatingWaitDlg = new FloatingWaitDlg(this.getMainFrame(), this.d_licenseMgr);
                floatingWaitDlg.doModal();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(-1);
        }
        if (!this.d_licenseMgr.isAuthorized()) {
            this.quit(false);
        }
        LicensePrompt.checkRenewPrompt(this.getMainFrame(), this.d_licenseMgr, "PyroSim", "www.pyrosim.com", PyroGuiUtil.loadPyroSimIcon("PyroSplash2.jpg"), new RegisterAction(), 30, this.getSplash());
        if (PyroPrefs.getBoolean(PyroPrefs.PREF_CHECKLATEST)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    final PyroCheckForUpdatesDlg pyroCheckForUpdatesDlg = new PyroCheckForUpdatesDlg((Window)PyroSim.getApp().getMainFrame(), true);
                    if (!pyroCheckForUpdatesDlg.isUpToDate() && pyroCheckForUpdatesDlg.isConnected()) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (pyroCheckForUpdatesDlg.doModal() == 1) {
                                    PyroPrefs.set(PyroPrefs.PREF_CHECKLATEST, pyroCheckForUpdatesDlg.isCheckOnStart(), true);
                                }
                            }
                        });
                    }
                }
            }).start();
        }
        this.updateFDSMenu();
        this.updateToolbar();
        this.checkFDSVersions();
    }

    /*
     * WARNING - void declaration
     */
    private void checkFDSVersions() {
        String string = PyroPrefs.getLastVersion();
        if (!string.equals("2018.3.1210")) {
            void var6_12;
            String[] stringArray = new String[]{"location", "sv.location"};
            ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
            String[] object = stringArray;
            int n = object.length;
            boolean bl = false;
            while (var6_12 < n) {
                String string2 = object[var6_12];
                String string3 = PyroPrefs.getFDSLoc(string, string2, false);
                if (string3 != null) {
                    arrayList.add(new Pair<String, String>(string2, string3));
                }
                ++var6_12;
            }
            if (!arrayList.isEmpty()) {
                void var4_6;
                String string4 = String.format(Intl.intl("Your previous PyroSim installation (%s) used custom FDS executables.%nWould you like to continue using these?"), string);
                for (Pair pair : arrayList) {
                    String string5 = (String)var4_6 + "\n\t" + (String)pair.v2;
                }
                int n2 = JOptionPane.showConfirmDialog(this.getActiveFrame(), var4_6, Intl.intl("Use Custom FDS Executables?"), 0);
                if (n2 == 0) {
                    for (Pair pair : arrayList) {
                        PyroPrefs.setFDSLoc((String)pair.v1, (String)pair.v2);
                    }
                }
            }
        }
        PyroPrefs.updateLastVersion();
    }

    public File getLastDir(String string) {
        String string2 = this.getPreference(string);
        if (string2 == null) {
            return null;
        }
        return new File(string2);
    }

    public void setLastDir(String string, File file) {
        File file2;
        if (file != null && (file2 = file.getParentFile()) != null) {
            this.setPreference(string, file2.getAbsolutePath());
        }
    }

    public void setCurrentDir(File file) {
        if (file != null) {
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            if (file != null) {
                this.getFilenameManager().getFileChooser().setCurrentDirectory(file);
            }
        }
    }

    private void windowActivated(WindowEvent windowEvent) {
        Actions.applicationActivated(this);
    }

    private JToolBar createToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setMinimumSize(new Dimension(0, 0));
        jToolBar.setFloatable(false);
        this.d_mainToolbar = jToolBar;
        this.updateToolbar();
        return jToolBar;
    }

    private void updateToolbar() {
        JToolBar jToolBar = this.d_mainToolbar;
        jToolBar.removeAll();
        jToolBar.add(this.getNewAction());
        jToolBar.add(this.getOpenAction());
        jToolBar.add(this.getSaveAction());
        jToolBar.addSeparator();
        jToolBar.add(Actions.IMPORT_ACTION);
        jToolBar.add(this.getWriteFDSFileAction());
        jToolBar.addSeparator();
        jToolBar.add(Actions.getUndoAction());
        jToolBar.add(Actions.getRedoAction());
        jToolBar.add(Actions.getCutAction());
        jToolBar.add(Actions.getCopyAction());
        jToolBar.add(Actions.getPasteAction());
        jToolBar.add(Actions.getDeleteAction());
        jToolBar.addSeparator();
        jToolBar.add(Actions.getEditNodeAction());
        jToolBar.addSeparator();
        jToolBar.add(Actions.getAddWallAction());
        jToolBar.add(Actions.getAddHoleAction());
        jToolBar.add(Actions.getAddVentAction());
        jToolBar.add(Actions.getAddSlabAction());
        jToolBar.add(Actions.getAddPartCloudAction());
        jToolBar.add(Actions.ADD_PART_LOC_ACTION);
        jToolBar.add(Actions.ADD_INIT_REGION_ACTION);
        jToolBar.add(Actions.GLOBAL_ADD_GROUP_ACTION);
        jToolBar.addSeparator();
        this.d_fdsRunDropdown = new DropDownButton(Actions.getRunFDSAction(), Actions.getRunFDSmpiAction(), Actions.getRunFDSClusterAction());
        this.d_fdsRunDropdown.setHideActionText(true);
        jToolBar.add(this.d_fdsRunDropdown);
        DropDownButton dropDownButton = new DropDownButton(Actions.VIEW_HRR_RESULTS_ACTION, Actions.VIEW_DEVC_RESULTS_ACTION, Actions.VIEW_CTRL_RESULTS_ACTION, Actions.TC_PLOTS_ACTION);
        dropDownButton.setHideActionText(true);
        jToolBar.add(dropDownButton);
        jToolBar.add(Actions.VIEW_RESULTS_ACTION);
        if (this.d_customActions == null) {
            this.d_customActions = this.getCustomActions();
        }
        if (!this.d_customActions.isEmpty()) {
            jToolBar.addSeparator();
            for (Action action : this.d_customActions) {
                jToolBar.add(action);
            }
        }
        Component[] componentArray = jToolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ((Component)componentArray[i]).setFocusable(false);
        }
    }

    private Collection<Action> getCustomActions() {
        File file = new File(this.getInstallDir());
        File file2 = new File(file, "plugins");
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".js");
            }
        };
        ArrayList<Action> arrayList = new ArrayList<Action>();
        File[] fileArray = file2.listFiles(filenameFilter);
        if (fileArray == null) {
            return Collections.EMPTY_LIST;
        }
        for (File file3 : fileArray) {
            try {
                ScriptAction scriptAction = new ScriptAction(file3);
                arrayList.add(scriptAction);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return arrayList;
    }

    public void quitScriptSafe() {
        EventQueue.invokeLater(() -> {
            this.d_modifiedTracker.reset();
            this.quit(false);
        });
    }

    @Override
    public void quit(boolean bl) {
        if (this.promptSaveIfModified(bl) && this.promptComfirmIfRunning(bl) || !bl) {
            this.d_licenseMgr.closeLM();
            OutputLog.end();
            super.quit(bl);
        }
    }

    public void superSavePreferences() {
        super.savePreferences();
    }

    @Override
    public void savePreferences() {
        this.d_mruModelFiles.store(this.d_props);
        this.d_mruFDSFiles.store(this.d_props);
        this.d_colorManager.store(this.d_props);
        PyroPrefs.set(PyroPrefs.UnitSystemProp, this.d_unitSystem.getSystemName(), false);
        this.d_3dView.savePreferences();
        PyroSim.setFormatterToProps(this.d_fdsRenderProps.getDecimalFormatter());
        this.superSavePreferences();
    }

    public boolean promptSaveIfModified(boolean bl) {
        if (this.d_modifiedTracker.isModified()) {
            int n = bl ? 1 : 0;
            int n2 = JOptionPane.showConfirmDialog(this.getMainFrame(), Intl.intl("Save file now") + "?", Intl.intl("File Modified"), n);
            if (n2 == 0) {
                return this.doSave(!bl);
            }
            return n2 == 1;
        }
        return true;
    }

    private boolean promptComfirmIfRunning(boolean bl) {
        if (FDSRunMonitor.isFDSRunning()) {
            String string = Intl.intl("Simulation in Progress");
            if (bl) {
                String string2 = Intl.intl("Exit and terminate FDS simulation?");
                int n = 2;
                return JOptionPane.showConfirmDialog(this.getMainFrame(), string2, string, n) == 0;
            }
            String string3 = Intl.intl("FDS Simulation will be terminated.");
            JOptionPane.showMessageDialog(this.getMainFrame(), string3, string, 2);
            return true;
        }
        return true;
    }

    @Override
    public Document createDocument() {
        theUtil.release(this.d_mediator);
        this.d_mediator = new PyroMod(true);
        File file = this.getTextureDBDir();
        this.d_mediator.initializeDatabases(file);
        return null;
    }

    public PyroMod getMediator() {
        return this.d_mediator;
    }

    public ModelView get3DView() {
        return this.d_3dView;
    }

    public PyroTreeView getTreeView() {
        return this.d_treeView;
    }

    public ColorScheme getColorScheme() {
        return this.d_colorManager.getCurrentColorScheme();
    }

    public PyroSimColors getColorManager() {
        return this.d_colorManager;
    }

    @Override
    public JMenuBar createMenuBar() {
        return new JMenuBar();
    }

    public JMenuBar nowCreateMenuBar() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.createFileMenu();
        this.createEditMenu();
        this.createModelMenu();
        this.createDeviceMenu();
        this.createOutputMenu();
        this.updateFDSMenu();
        this.d_viewMenu = new JMenu();
        this.createHelpMenu();
        this.updateMainMenuBar();
        return this.d_mainMenuBar;
    }

    private JMenuBar updateMainMenuBar() {
        this.d_mainMenuBar = new JMenuBar();
        this.d_mainMenuBar.add(this.d_fileMenu);
        this.d_mainMenuBar.add(this.d_editMenu);
        this.d_mainMenuBar.add(this.d_modelMenu);
        this.d_mainMenuBar.add(this.d_deviceMenu);
        this.d_mainMenuBar.add(this.d_outputMenu);
        this.d_mainMenuBar.add(this.d_fdsMenu);
        this.d_mainMenuBar.add(this.d_viewMenu);
        this.d_mainMenuBar.add(this.d_helpMenu);
        JFrame jFrame = this.getMainFrame();
        jFrame.setJMenuBar(this.d_mainMenuBar);
        jFrame.getRootPane().getInputMap(1).put(Accelerators.CRASH, Actions.CRASH_PYROSIM);
        jFrame.getRootPane().getActionMap().put(Actions.CRASH_PYROSIM, Actions.CRASH_PYROSIM);
        jFrame.setVisible(true);
        return this.d_mainMenuBar;
    }

    public JMenu createFileMenu() {
        this.d_fileMenu = new guiMenu(Intl.intl("&File"));
        this.d_fileMenu.add(this.d_newAction);
        this.d_fileMenu.add(this.d_openAction);
        this.d_fileMenu.add(this.d_saveAction);
        this.d_fileMenu.add(this.d_saveAsAction);
        this.d_fileMenu.addSeparator();
        this.d_fileMenu.add(Actions.getProtectAction());
        this.d_fileMenu.add(this.d_prefsAction);
        this.d_fileMenu.addSeparator();
        this.d_fileMenu.add(Actions.IMPORT_ACTION);
        guiMenu guiMenu2 = new guiMenu(Intl.intl("Export"));
        guiMenu2.add(this.d_writeFDSFileAction);
        guiMenu2.add(this.d_exportPyroViewsAction);
        guiMenu2.add(this.d_exportPyroFloorsAction);
        guiMenu2.add(this.d_writeSmokeviewINIFileAction);
        guiMenu2.add(this.d_exportMatDBFileAction);
        guiMenu2.add(this.d_exportReacDBFileAction);
        this.d_fileMenu.add(guiMenu2);
        this.d_fileMenu.add(this.d_screenShotAction);
        this.d_fileMenu.addSeparator();
        this.d_mruModelMenu = new MRUMenu(Intl.intl("Recent PyroSim Files"), this.d_mruModelFiles, new MRUListener(){

            @Override
            public boolean itemSelected(int n, String string) {
                if (!PyroSim.this.promptSaveIfModified(true)) {
                    return true;
                }
                PyroMod pyroMod = PyroSim.this.getMediator();
                OpenModelTask openModelTask = new OpenModelTask(PyroSim.this, pyroMod, string);
                pyroMod.getTaskManager().exec((Task)openModelTask, Intl.intl("Open PyroSim File"), 10);
                return openModelTask.success();
            }
        });
        this.d_fileMenu.add(this.d_mruModelMenu);
        this.d_mruFDSMenu = new MRUMenu(Intl.intl("Recent FDS Files"), this.d_mruFDSFiles, new MRUListener(){

            @Override
            public boolean itemSelected(int n, String string) {
                if (!PyroSim.this.promptSaveIfModified(true)) {
                    return true;
                }
                PyroMod pyroMod = PyroSim.this.getMediator();
                ImportFDSFile importFDSFile = new ImportFDSFile(PyroSim.this, pyroMod, string);
                pyroMod.getTaskManager().exec((Task)importFDSFile, Intl.intl("Import FDS File"), 2);
                return importFDSFile.getSuccess();
            }
        });
        this.d_fileMenu.add(this.d_mruFDSMenu);
        this.d_fileMenu.addSeparator();
        this.d_fileMenu.add(new ExitAction());
        return this.d_fileMenu;
    }

    public JMenu createEditMenu() {
        this.d_editMenu = new guiMenu(Intl.intl("&Edit"));
        this.d_editMenu.add(Actions.getUndoAction());
        this.d_editMenu.add(Actions.getRedoAction());
        this.d_editMenu.addSeparator();
        this.d_editMenu.add(Actions.getCutAction());
        this.d_editMenu.add(Actions.getCopyAction());
        this.d_editMenu.add(Actions.getCopyFDSAction());
        this.d_editMenu.add(Actions.getPasteAction());
        Actions.getDeleteAction().addToMenu(this.d_editMenu);
        this.d_editMenu.add(Actions.getFindAction());
        return this.d_editMenu;
    }

    public JMenu createModelMenu() {
        this.d_modelMenu = new guiMenu(Intl.intl("&Model"));
        this.d_modelMenu.add(Actions.EDIT_LIBRARIES_ACTION);
        this.d_modelMenu.add(Actions.APPEARANCE_MANAGER_ACTION);
        this.d_modelMenu.addSeparator();
        this.d_modelMenu.add(Actions.getGridAction());
        this.d_modelMenu.add(Actions.ZONES_ACTION);
        this.d_modelMenu.add(Actions.getExSpecListAction());
        this.d_modelMenu.add(Actions.getReactionManagerAction());
        this.d_modelMenu.add(Actions.getMaterialManagerAction());
        this.d_modelMenu.add(Actions.getSurfaceManagerAction());
        this.d_modelMenu.add(Actions.getParticleAction());
        this.d_modelMenu.add(Actions.getHvacListAction());
        this.d_modelMenu.addSeparator();
        this.d_modelMenu.add(Actions.getAddWallAction());
        this.d_modelMenu.add(Actions.getAddHoleAction());
        this.d_modelMenu.add(Actions.getAddVentAction());
        this.d_modelMenu.add(Actions.getAddSlabAction());
        this.d_modelMenu.add(Actions.getAddPartCloudAction());
        this.d_modelMenu.add(Actions.ADD_PART_LOC_ACTION);
        this.d_modelMenu.add(Actions.ADD_INIT_REGION_ACTION);
        this.d_modelMenu.add(Actions.ADD_HVAC_NODE_ACTION);
        this.d_modelMenu.add(Actions.ADD_HVAC_DUCT_ACTION);
        this.d_modelMenu.add(Actions.GLOBAL_ADD_GROUP_ACTION);
        this.d_modelMenu.addSeparator();
        this.d_modelMenu.add(Actions.CHANGE_GROUP);
        this.d_modelMenu.add(Actions.getTranslateAction());
        this.d_modelMenu.add(Actions.getMirrorAction());
        this.d_modelMenu.add(Actions.getScaleAction());
        this.d_modelMenu.add(Actions.getRotateAction());
        this.d_modelMenu.add(Actions.getRasterizeAction());
        this.d_modelMenu.addSeparator();
        this.d_modelMenu.add(Actions.getEditNodeAction());
        return this.d_modelMenu;
    }

    public JMenu createDeviceMenu() {
        this.d_deviceMenu = new guiMenu(Intl.intl("&Devices"));
        this.d_deviceMenu.add(Actions.CONTROLS_ACTION);
        this.d_deviceMenu.addSeparator();
        this.d_deviceMenu.add(Actions.NEW_SIMCTRL_ACTION);
        this.d_deviceMenu.add(Actions.NEW_TIME_DEVC_ACTION);
        this.d_deviceMenu.addSeparator();
        this.d_deviceMenu.add(Actions.NEW_ASPIRATOR_SAMPLER_ACTION);
        this.d_deviceMenu.add(Actions.NEW_ASPIRATOR_ACTION);
        this.d_deviceMenu.addSeparator();
        this.d_deviceMenu.add(Actions.NEW_GAS_POINT_DEVICES_ACTION);
        this.d_deviceMenu.add(Actions.NEW_SOLID_POINT_DEVICES_ACTION);
        this.d_deviceMenu.addSeparator();
        this.d_deviceMenu.add(Actions.NEW_THERMOCOUPLE_ACTION);
        this.d_deviceMenu.add(Actions.NEW_FLOW_MEASURER_ACTION);
        this.d_deviceMenu.add(Actions.NEW_HEAT_RELEASE_RATE_MEASURER_ACTION);
        this.d_deviceMenu.add(Actions.NEW_LAYER_INFORMATION_MEASURER_ACTION);
        this.d_deviceMenu.add(Actions.NEW_PATH_OBSCURATION_MEASURER_ACTION);
        this.d_deviceMenu.addSeparator();
        this.d_deviceMenu.add(Actions.NEW_HEAT_DETECTOR_DEVICE_ACTION);
        this.d_deviceMenu.add(Actions.getHeatLinkModelManagerAction());
        this.d_deviceMenu.add(Actions.NEW_SMOKE_DETECTOR_ACTION);
        this.d_deviceMenu.add(Actions.getSmokeDetectorModelsAction());
        this.d_deviceMenu.addSeparator();
        this.d_deviceMenu.add(Actions.NEW_HVAC_DUCT_DEVICE_ACTION);
        this.d_deviceMenu.add(Actions.NEW_HVAC_NODE_DEVICE_ACTION);
        this.d_deviceMenu.addSeparator();
        this.d_deviceMenu.add(Actions.NEW_SPRINKLER_DEVICE_ACTION);
        this.d_deviceMenu.add(Actions.NEW_NOZZLE_ACTION);
        this.d_deviceMenu.add(Actions.NEW_SPRINKLER_LINK_ACTION);
        this.d_deviceMenu.add(Actions.getSprayModelManagerAction());
        this.d_deviceMenu.add(Actions.getSprinklerLinkModelManagerAction());
        this.d_deviceMenu.add(Actions.NEW_DRY_PIPE_ACTION);
        return this.d_deviceMenu;
    }

    public JMenu createOutputMenu() {
        this.d_outputMenu = new guiMenu(Intl.intl("&Output"));
        this.d_outputMenu.add(Actions.getProfListAction());
        this.d_outputMenu.add(Actions.getSliceAction());
        this.d_outputMenu.add(Actions.getSlice3DAction());
        this.d_outputMenu.add(Actions.getBoundaryConditionAction());
        this.d_outputMenu.add(Actions.getIsosurfaceAction());
        this.d_outputMenu.add(Actions.getPlot3DAction());
        this.d_outputMenu.add(Actions.MSR_STATS_ACTION);
        return this.d_outputMenu;
    }

    public JMenu updateFDSMenu() {
        if (this.d_fdsMenu == null) {
            this.d_fdsMenu = new guiMenu(Intl.intl("&Analysis"));
        } else {
            this.d_fdsMenu.removeAll();
        }
        this.d_fdsMenu.add(Actions.getEditSimulationPropertiesAction());
        this.d_fdsMenu.add(Actions.getEditOpenMpAction());
        this.d_fdsMenu.addSeparator();
        this.d_fdsMenu.add(Actions.getRunFDSAction());
        this.d_fdsMenu.add(Actions.getResumeFDSAction());
        this.d_fdsMenu.add(Actions.getRunFDSmpiAction());
        this.d_fdsMenu.add(Actions.getResumeFDSmpiAction());
        this.d_fdsMenu.add(new JPopupMenu.Separator());
        this.d_fdsMenu.add(Actions.getRunFDSClusterAction());
        this.d_fdsMenu.add(Actions.getResumeFDSClusterAction());
        this.d_fdsMenu.addSeparator();
        this.d_fdsMenu.add(Actions.getResultsPreviewAction());
        this.d_fdsMenu.add(Actions.RUN_RESULTS_ACTION);
        this.d_fdsMenu.add(Actions.RUN_SMOKEVIEW_ACTION);
        this.d_fdsMenu.add(Actions.getTCPlotsAction());
        this.d_fdsMenu.addSeparator();
        this.d_fdsMenu.add(Actions.ARCHIVE_RESULTS);
        this.d_fdsMenu.add(Actions.RESTORE_RESULTS);
        this.d_fdsFullLength = this.d_fdsMenu.getItemCount();
        return this.d_fdsMenu;
    }

    public JMenu updateViewMenu(ViewMode viewMode) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        this.d_viewMenu = new guiMenu(Intl.intl("&View"));
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new SelectViewModeAction(Intl.intl("Show 3D View"), ViewMode.MV_3D));
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(new SelectViewModeAction(Intl.intl("Show 2D View"), ViewMode.MV_2D));
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(new SelectViewModeAction(Intl.intl("Show Record View"), ViewMode.RECORD));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem3);
        this.d_viewMenu.add(jRadioButtonMenuItem);
        this.d_viewMenu.add(jRadioButtonMenuItem2);
        this.d_viewMenu.add(jRadioButtonMenuItem3);
        switch (viewMode) {
            case MV_2D: {
                jRadioButtonMenuItem2.setSelected(true);
                break;
            }
            case MV_3D: {
                jRadioButtonMenuItem.setSelected(true);
                break;
            }
            case RECORD: {
                jRadioButtonMenuItem3.setSelected(true);
            }
        }
        this.d_viewMenu.addSeparator();
        if (viewMode.isModelView) {
            this.d_viewMenu.add(Actions.GLOBAL_ADD_VIEW);
            this.d_viewMenu.add(Actions.GLOBAL_ADD_SECTION_BOX);
            this.d_viewMenu.add(Actions.GLOBAL_RESET_SECTION_BOX);
            this.d_viewMenu.add(Actions.GLOBAL_SAVE_VIEW_CAMERA);
            this.d_viewMenu.add(Actions.GLOBAL_SHOW_VIEW_CAMERA);
            this.d_viewMenu.addSeparator();
            for (BooleanAction serializable32 : this.d_3dView.getClipFilterActions()) {
                this.d_viewMenu.add(new JCheckBoxMenuItem(serializable32));
            }
            this.d_viewMenu.addSeparator();
        }
        if (viewMode == ViewMode.MV_3D) {
            object = this.d_3dView.getUseSVNavAction();
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem((Action)object);
            ((AbstractAction)object).addPropertyChangeListener(new SelectableActionListener(jCheckBoxMenuItem, (SelectableAction)object));
            this.d_viewMenu.add(jCheckBoxMenuItem);
            this.d_viewMenu.addSeparator();
        }
        if (viewMode.isModelView) {
            object = this.d_3dView.getCutHolesAction();
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem((Action)object);
            ((AbstractAction)object).addPropertyChangeListener(new SelectableActionListener(jCheckBoxMenuItem, (SelectableAction)object));
            this.d_viewMenu.add(jCheckBoxMenuItem);
            this.d_viewMenu.addSeparator();
        }
        if (viewMode == ViewMode.MV_2D) {
            object = this.d_3dView.getNoGridAction();
            JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem((Action)object);
            jRadioButtonMenuItem4.addItemListener((ItemListener)object);
            serializable2 = this.d_3dView.getSketchGridAction();
            serializable = new JRadioButtonMenuItem((Action)((Object)serializable2));
            ((AbstractButton)serializable).addItemListener((ItemListener)((Object)serializable2));
            MutuallyExclusiveAction mutuallyExclusiveAction = this.d_3dView.getModelGridsAction();
            JRadioButtonMenuItem jRadioButtonMenuItem5 = new JRadioButtonMenuItem(mutuallyExclusiveAction);
            jRadioButtonMenuItem5.addItemListener(mutuallyExclusiveAction);
            this.d_viewMenu.add((JMenuItem)serializable);
            this.d_viewMenu.add(jRadioButtonMenuItem5);
            this.d_viewMenu.add(jRadioButtonMenuItem4);
            this.d_viewMenu.add(this.d_3dView.getEditSnapSizeAction());
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.d_3dView.getShowOriginAction());
            this.d_3dView.getShowOriginAction().addPropertyChangeListener(new SelectableActionListener(jCheckBoxMenuItem, this.d_3dView.getShowOriginAction()));
            this.d_viewMenu.add(jCheckBoxMenuItem);
            this.d_viewMenu.addSeparator();
        }
        if (viewMode.isModelView) {
            object = new JCheckBoxMenuItem(this.d_3dView.getShowGuidesAction());
            this.d_3dView.getShowGuidesAction().addPropertyChangeListener(new SelectableActionListener((AbstractButton)object, this.d_3dView.getShowGuidesAction()));
            this.d_viewMenu.add((JMenuItem)object);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.d_3dView.getShowPointerAction());
            this.d_3dView.getShowPointerAction().addPropertyChangeListener(new SelectableActionListener(jCheckBoxMenuItem, this.d_3dView.getShowPointerAction()));
            this.d_viewMenu.add(jCheckBoxMenuItem);
            this.d_viewMenu.addSeparator();
        }
        if (viewMode == ViewMode.RECORD) {
            // empty if block
        }
        if (viewMode.isModelView) {
            this.d_colorMenu = new ColorMgrMenu(Intl.intl("&Color Scheme"), this.d_colorManager);
            this.d_viewMenu.add(this.d_colorMenu);
        }
        object = new guiMenu(Intl.intl("&Units"));
        JRadioButtonMenuItem jRadioButtonMenuItem6 = new JRadioButtonMenuItem(new UnitsAction(SIUS.getInstance()));
        serializable2 = new JRadioButtonMenuItem(new UnitsAction(EnglishUS.getInstance()));
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(jRadioButtonMenuItem6);
        ((ButtonGroup)serializable).add((AbstractButton)serializable2);
        if (this.getUnitSystem() instanceof SIUS) {
            jRadioButtonMenuItem6.setSelected(true);
        } else if (this.getUnitSystem() instanceof EnglishUS) {
            ((AbstractButton)serializable2).setSelected(true);
        }
        ((JMenu)object).add(jRadioButtonMenuItem6);
        ((JMenu)object).add((JMenuItem)serializable2);
        this.d_viewMenu.add((JMenuItem)object);
        this.d_viewMenu.addSeparator();
        this.d_viewMenu.add(Actions.getHideNodeAction());
        this.d_viewMenu.add(Actions.getShowNodeAction());
        this.d_viewMenu.add(Actions.getHideUnselectedNodeAction());
        this.d_viewMenu.add(Actions.getShowAllNodesAction());
        if (viewMode.isModelView) {
            this.d_viewMenu.addSeparator();
            this.d_viewMenu.add(this.d_3dView.getResetToAllAction());
            this.d_viewMenu.add(this.d_3dView.getResetToSelectedAction());
            this.d_viewMenu.add(this.d_3dView.getFillViewAction());
        }
        return this.d_viewMenu;
    }

    public void showActivationDialog() {
        ActivationDlg activationDlg = new ActivationDlg(this.getMainFrame(), this.d_licenseMgr, "PyroSim", null, this.getPrefs(), PyroPrefs.LicenseDirProp, PyroPrefs.LicenseServerProp, new Color(0.61f, 0.76f, 0.93f));
        activationDlg.doModal();
        this.updateFDSMenu();
        this.updateToolbar();
        this.savePreferences();
    }

    public JMenu createHelpMenu() {
        this.d_helpMenu = new guiMenu(Intl.intl("&Help"));
        String string = String.format("%s/%s", this.getInstallDir(), "fds/FDS_Technical_Reference_Guide.pdf");
        String string2 = String.format("%s/%s", this.getInstallDir(), "fds/FDS_User_Guide.pdf");
        String string3 = String.format("%s/%s", this.getInstallDir(), "fds/SMV_User_Guide.pdf");
        String string4 = "http://www.thunderheadeng.com/pyrosim/support/";
        String string5 = "http://www.thunderheadeng.net/forum/index.php/board,1.0.html";
        String string6 = "http://groups.google.com/group/fds-smv";
        String string7 = "https://github.com/firemodels/fds";
        ResourcePaths resourcePaths = this.getDocPaths();
        OpenExternalFileAction openExternalFileAction = new OpenExternalFileAction(Intl.intl("Pyrosim &Manual"), null, resourcePaths.get("PyroSimManualPl.pdf"), resourcePaths.get("PyroSimManualJP.pdf"), resourcePaths.get("PyroSimManual.pdf"));
        OpenExternalFileAction openExternalFileAction2 = new OpenExternalFileAction(Intl.intl("PyroSim &Results Manual"), null, resourcePaths.get("results_users_guide.pdf"));
        OpenExternalUrlAction openExternalUrlAction = new OpenExternalUrlAction(Intl.intl("&Online Help"), null, string4);
        guiMenu guiMenu2 = new guiMenu(Intl.intl("More &Help"));
        guiMenu2.add(new OpenExternalFileAction(Intl.intl("&FDS User Guide"), null, string2));
        guiMenu2.add(new OpenExternalFileAction(Intl.intl("FDS &Technical Reference"), null, string));
        guiMenu2.add(new OpenExternalFileAction(Intl.intl("&Smokeview User Guide"), null, string3));
        guiMenu2.addSeparator();
        guiMenu2.add(new OpenExternalUrlAction(Intl.intl("P&yroSim Forum"), null, string5));
        guiMenu2.add(new OpenExternalUrlAction(Intl.intl("FDS-SMV Discussion &Group"), null, string6));
        guiMenu2.add(new OpenExternalUrlAction(Intl.intl("FDS-SMV &Development Home"), null, string7));
        this.d_helpMenu.add(openExternalFileAction);
        this.d_helpMenu.add(openExternalFileAction2);
        this.d_helpMenu.add(openExternalUrlAction);
        this.d_helpMenu.add(guiMenu2);
        this.d_helpMenu.addSeparator();
        RegisterAction registerAction = new RegisterAction();
        this.d_helpMenu.add(registerAction);
        this.d_helpMenu.add(new RemoveLicenseAction());
        if (System.getProperty("debug") != null) {
            guiAction guiAction2 = new guiAction(Intl.intl("Run Java Garbage Collector")){
                private static final long serialVersionUID = 4614702983731840826L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.gc();
                }
            };
            guiAction2.putValue("AcceleratorKey", Accelerators.GARBAGE_COLLECTOR);
            this.d_helpMenu.addSeparator();
            this.d_helpMenu.add(guiAction2);
        }
        this.d_helpMenu.addSeparator();
        this.d_helpMenu.add(new SaveOutputLogAction());
        this.d_helpMenu.add(new CheckForUpdatesAction());
        this.d_helpMenu.add(new HelpAboutAction());
        return this.d_helpMenu;
    }

    private void setMode(ViewMode viewMode) {
        if (viewMode == ViewMode.RECORD) {
            this.d_viewChangeListener.updateActiveView(viewMode);
        } else {
            this.d_viewChangeListener.updateActiveView(viewMode);
            this.d_3dView.setMode(viewMode);
        }
    }

    private void initActiveView() {
        ViewMode viewMode = this.d_mediator.getViews().getActiveView().getViewMode().orElse(ViewMode.getDefault());
        this.d_viewChangeListener.updateActiveView(viewMode);
    }

    private void updateActiveView() {
        this.d_mediator.getViews().getActiveView().getViewMode().ifPresent(viewMode -> this.d_viewChangeListener.updateActiveView((ViewMode)((Object)viewMode)));
    }

    public void setView(CameraState cameraState, View.NavTool navTool) {
        this.d_viewChangeListener.updateActiveView(cameraState.getViewMode());
        this.d_3dView.setView(cameraState, navTool);
    }

    public Component createTreeView() {
        this.d_treeView = new PyroTreeView(this.getMediator());
        JScrollPane jScrollPane = new JScrollPane(this.d_treeView);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        guiPanel guiPanel2 = new guiPanel();
        JToolBar jToolBar = new JToolBar();
        JToolBar jToolBar2 = new JToolBar(0);
        jToolBar2.add(this.d_treeView.getAutoExpandButton());
        jToolBar2.addSeparator();
        jToolBar2.add(this.d_treeView.getCollapseAllButton());
        jToolBar2.add(this.d_treeView.getExpandAllButton());
        jToolBar2.setFloatable(false);
        Utils.noToolBarFocus(jToolBar2);
        jToolBar.add(jToolBar2);
        jToolBar.setFloatable(false);
        guiPanel2.add((Component)jToolBar, "North");
        guiPanel2.add((Component)jScrollPane, "Center");
        return guiPanel2;
    }

    public Component createViewModes() {
        this.d_3dView = new ModelView(this.d_mediator, this.d_colorManager);
        this.d_3dView.reset();
        this.d_modifiedTracker.addTarget(this.d_3dView.getSketchGrid());
        this.d_3DPanel = this.d_3dView.getViewComponent();
        this.d_recordView = new RecordView(this.d_mediator);
        this.d_colorManager.addColorChangedListener(this.d_recordView);
        this.d_modifiedTracker.addTarget(this.d_recordView);
        this.d_mainView = new JTabbedPane(3);
        this.d_mainView.setBorder(BorderFactory.createEmptyBorder(-2, -2, -1, -4));
        this.d_mainView.add(Intl.intl("3D View"), this.d_3DPanel);
        this.d_mainView.add(Intl.intl("2D View"), null);
        this.d_mainView.add(Intl.intl("Record View"), this.d_recordView);
        this.d_viewChangeListener = new ViewChangeListener();
        this.d_mainView.addChangeListener(this.d_viewChangeListener);
        this.d_mediator.getEvents().addObserver(this.d_viewChangeListener);
        return this.d_mainView;
    }

    public RecordView getRecordView() {
        return this.d_recordView;
    }

    public void setUnitSystem(UnitSystem unitSystem) {
        this.d_unitSystem = unitSystem;
    }

    public UnitSystem getUnitSystem() {
        return this.d_unitSystem;
    }

    public static PyroSimLM getLicenseManager() {
        return ((PyroSim)Application.getApp()).d_licenseMgr;
    }

    public static boolean is64Bit() {
        String string = System.getProperty("sun.arch.data.model", null);
        if (string == null) {
            return System.getProperty("java.vm.name").toLowerCase().indexOf("64") >= 0;
        }
        return string.equals("64");
    }

    @Override
    protected void loadLibraries() {
        PyroSim.loadLib("FreeImage");
        PyroSim.loadLib("PyroSim");
    }

    private void updateTitle() {
        String string = PyroSim.getFrameTitleBase() + " - ";
        if (this.d_modifiedTracker.isModified()) {
            string = string + "*";
        }
        string = this.d_filename == null ? string + "Untitled" : string + this.d_filename;
        if (this.d_mediator.isWriteProtected()) {
            string = string + " " + Intl.intl("(write-protected)");
        }
        this.getMainFrame().setTitle(string);
    }

    public void setFDSRunMode(FDSRun.Mode mode) {
        Action action;
        switch (mode) {
            case PARALLEL: {
                action = Actions.getRunFDSmpiAction();
                break;
            }
            case CLUSTER: {
                action = Actions.getRunFDSClusterAction();
                break;
            }
            default: {
                action = Actions.getRunFDSAction();
            }
        }
        this.d_fdsRunDropdown.setSelectedAction(action);
    }

    public DropDownButton getFDSRunDropdown() {
        return this.d_fdsRunDropdown;
    }

    private void resetView() {
        double d = PyroPrefs.getDouble(PyroPrefs.DefaultSnapSpacing);
        this.d_3dView.setSketchGridSpacing(d);
        this.d_3dView.getShowBGImagesAction().setSelected(true);
        this.d_3dView.setActiveSnapper(1);
        this.setFilename(null, false);
    }

    public void setFilename(String string, boolean bl) {
        this.d_filename = string;
        this.d_forceSavePrompt = bl;
        if (this.d_filename != null) {
            this.setCurrentDir(new File(string));
        }
    }

    public void setSnapToSpacing(double d) {
        this.d_3dView.setSketchGridSpacing(d);
    }

    public ModelView getModelView() {
        return this.d_3dView;
    }

    public MRUMenu getMRUMenu() {
        return this.d_mruModelMenu;
    }

    public MRUMenu getFDSMRUMenu() {
        return this.d_mruFDSMenu;
    }

    public String getFilename() {
        return this.d_filename;
    }

    public boolean getPromptOnNextSave() {
        return this.d_filename == null || this.d_forceSavePrompt;
    }

    public File suggestFile(String string) {
        String string2 = this.d_filename;
        return string2 == null ? new File(String.format(Intl.intl("untitled.%s"), string)) : new File(FilenameManager.changeExtension(string2, string));
    }

    public File getFDSSaveFile() {
        File file = PyroSim.getFilenames().getSaveFile((Component)PyroSim.getApp().getMainFrame(), Intl.intl("Choose a Location to Save the FDS Data File"), this.suggestFile("fds"), "fds", Intl.intl("FDS 6 Input Files"));
        return file;
    }

    public boolean writeFDSFile(File file, boolean bl) {
        try {
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException(Intl.intl("Unable to create new file"));
            }
            this.beginWaitCursor();
            FDSRenderer fDSRenderer = FDS.newRenderer(this.getMediator(), bl ? this.d_fdsRenderProps : new PromptingFDSRenderProps(this.d_mediator, this.d_fdsRenderProps));
            fDSRenderer.renderFile(file);
            this.endWaitCursor();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this.getMainFrame(), Intl.intl("An error occurred creating the file") + ":\n" + iOException.getMessage(), Intl.intl("File Error"), 0);
            return false;
        }
    }

    public boolean saveIfModified() {
        if (this.d_modifiedTracker.isModified()) {
            return this.doSave(false);
        }
        return true;
    }

    public File promptSaveFile() {
        return PyroSim.getFilenames().getSaveFile((Component)PyroSim.getApp().getMainFrame(), this.suggestFile("psm"), "psm", Intl.intl("PyroSim Model Files"));
    }

    public boolean doSave(boolean bl) {
        File file;
        if (bl || this.getPromptOnNextSave()) {
            file = this.promptSaveFile();
            if (file == null) {
                return false;
            }
        } else {
            file = new File(this.d_filename);
        }
        return this.doSave(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doSave(File file) {
        this.beginWaitCursor();
        this.d_recordView.applyChanges();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new PyroSimObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            this.writeModel(this.d_mediator, objectOutputStream);
            this.d_forceSavePrompt = false;
            this.d_mruModelMenu.usedFile(file.getAbsolutePath());
            this.d_filename = file.getAbsolutePath();
            this.d_mediator.getEvents().changed(this.d_mediator, PyroMod.EVT_FILENAME_CHANGED);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.error(new guiExceptionError(iOException));
            boolean bl = false;
            return bl;
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.error(iOException.getMessage());
                    return false;
                }
            }
            this.endWaitCursor();
        }
    }

    public void writeModel(PyroMod pyroMod, ObjectOutputStream objectOutputStream) throws IOException {
        if (this.d_3dView == null) {
            throw new IOException("ModelView required for saving model.");
        }
        pyroMod.saveModel(objectOutputStream);
        objectOutputStream.writeDouble(this.d_3dView.getSketchGridSpacing());
        objectOutputStream.writeBoolean(this.d_3dView.getShowBGImagesAction().isSelected());
        int n = this.d_3dView.getCurrentSnapper();
        objectOutputStream.writeInt(n);
        objectOutputStream.writeObject(this.d_3dView.getFilterProps());
    }

    private void editPreferences(PreferencesDialog.Tabs tabs) {
        PreferencesDialog preferencesDialog = new PreferencesDialog(this.d_3dView::getDefaultPrefs, this.d_3dView::getCompatibilityPrefs, tabs);
        if (preferencesDialog.doModal() == 1) {
            preferencesDialog.saveData();
        }
    }

    private void updateViewLayout(ViewMode viewMode) {
        if (viewMode == ViewMode.RECORD) {
            this.d_3DPanel.setVisible(false);
            return;
        }
        this.d_recordView.setVisible(false);
        this.d_3DPanel.setVisible(true);
    }

    public NewAction getNewAction() {
        return this.d_newAction;
    }

    public OpenAction getOpenAction() {
        return this.d_openAction;
    }

    public SaveAction getSaveAction() {
        return this.d_saveAction;
    }

    public ScreenShotAction getScreenShotAction() {
        return this.d_screenShotAction;
    }

    public SaveAsAction getSaveAsAction() {
        return this.d_saveAsAction;
    }

    public ExortFDSFileAction getWriteFDSFileAction() {
        return this.d_writeFDSFileAction;
    }

    private void updateBackup() {
        TeciProps teciProps = this.getPrefs();
        this.d_backup.setFilename(this.d_filename);
        this.d_backup.setAutosaveEnabled(teciProps.getBoolean(PyroPrefs.PREF_USEAUTOSAVE));
        this.d_backup.setAutosavePeriod(PyroPrefs.getUnitDouble(PyroPrefs.PREF_AUTOSAVE_INTERVAL));
        this.d_backup.setBackupEnabled(PyroPrefs.getBoolean(PyroPrefs.PREF_CREATE_BACKUP_ON_OPEN));
    }

    static {
        OutputLog.begin("PyroSim");
        TeciLogging.initToSplitHandler(Logger.getLogger(""), Level.CONFIG, Level.WARNING, TeciLogging.getDefaultLogFormat(), System.out, System.err);
        SKETCH_GRID_NAME = Intl.intl("Sketch Grid");
        file = null;
    }

    private class BackupEvtListener
    implements IEventObserver {
        private BackupEvtListener() {
        }

        @Override
        public void update(Events events) {
            if (events.getEvents(PyroMod.class, new Class[0]).hasChangedObjs(PyroMod.EVT_MODEL_CHANGED, PyroMod.EVT_FILENAME_CHANGED, PyroMod.EVT_PREFS_CHANGED)) {
                PyroSim.this.updateBackup();
            }
        }
    }

    private static class HelpAboutAction
    extends guiAction {
        private static final long serialVersionUID = 7878803891449394855L;

        public HelpAboutAction() {
            super(Intl.intl("About..."));
        }

        private static void addEmptyRow(GridBagHelper gridBagHelper) {
            gridBagHelper.addRow(Box.createVerticalStrut(12), 0);
        }

        private static JComponent lbl(String string) {
            string = "<html>" + string.replaceAll("[\n]", "<br>");
            return new guiLabel(string);
        }

        private static <T extends Component> T init(T t) {
            t.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
            return t;
        }

        private static guiPanel newCanvas(boolean bl) {
            guiPanel guiPanel2 = new guiPanel();
            guiPanel2.setBackground(Color.WHITE);
            Border border = BorderFactory.createLineBorder(Color.BLACK);
            if (bl) {
                border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(6, 6, 6, 6));
            }
            guiPanel2.setBorder(border);
            return guiPanel2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = PyroSim.getApp();
            final guiDialog guiDialog2 = new guiDialog((Window)pyroSim.getMainFrame(), "PyroSim - Version 2018.3.1210", 1);
            guiPanel guiPanel2 = HelpAboutAction.newCanvas(false);
            guiPanel guiPanel3 = new guiPanel();
            guiPanel3.setBackground(new Color(0, 0, 0, 0));
            guiPanel2.add(guiPanel3);
            GridBagHelper gridBagHelper = new GridBagHelper(guiPanel3, true);
            gridBagHelper.d_rowSpace = 0;
            gridBagHelper.addRow(Intl.intl("Revision:  ") + "2018.3.1210", 0);
            HelpAboutAction.addEmptyRow(gridBagHelper);
            JLabel jLabel = new JLabel(PyroGuiUtil.loadPyroSimIcon("PyroSimLogo60.png"));
            gridBagHelper.addRow(jLabel, 0);
            HelpAboutAction.addEmptyRow(gridBagHelper);
            gridBagHelper.addRow(String.format(Intl.intl("PyroSim is a preprocessor for FDS %s and later."), Version.FDS_DESIGN), 0);
            HelpAboutAction.addEmptyRow(gridBagHelper);
            gridBagHelper.addRow(Intl.intl("Developed by Thunderhead Engineering Consultants, Inc."), 0);
            gridBagHelper.addRow(HelpAboutAction.init(new guiURLLabel("http://www.thunderheadeng.com")), 0);
            HelpAboutAction.addEmptyRow(gridBagHelper);
            String string = Intl.intl("Localization Credit");
            if (!string.equals("Localization Credit")) {
                gridBagHelper.addFilledRow(HelpAboutAction.lbl(string));
                HelpAboutAction.addEmptyRow(gridBagHelper);
            }
            int n = Calendar.getInstance().get(1);
            gridBagHelper.addRow(String.format(Intl.intl("Copyright (c) 2002-%d All Rights Reserved."), n), 0);
            gridBagHelper.addFilledRow(HelpAboutAction.lbl(PyroSim.getLicenseManager().getDescription()));
            HelpAboutAction.addEmptyRow(gridBagHelper);
            Runtime runtime = Runtime.getRuntime();
            String string2 = String.format(Intl.intl("Free Java Memory:  %d MB\nJava Memory Limit: %d MB\nJava Max Memory:   %d MB"), runtime.freeMemory() / 1024L / 1024L, runtime.totalMemory() / 1024L / 1024L, runtime.maxMemory() / 1024L / 1024L);
            gridBagHelper.addFilledRow(HelpAboutAction.lbl(string2));
            HelpAboutAction.addEmptyRow(gridBagHelper);
            gridBagHelper.addTitle(Intl.intl("GPU Information"));
            HelpAboutAction.addEmptyRow(gridBagHelper);
            Supplier<IRenderSurface.OpenGLInfo> supplier = () -> PyroSim.getApp().get3DView().getRenderComp().getOpenGLInfo();
            GPUInfoPnl gPUInfoPnl = new GPUInfoPnl(supplier, true);
            gridBagHelper.addIdentRow(gPUInfoPnl, 0, 1.0);
            HelpAboutAction.addEmptyRow(gridBagHelper);
            gridBagHelper.addRow(new guiLabel(guiUtil.loadTeciIcon("teci_logo.png")), 0);
            guiDialog2.getDialogPane().add((Component)guiPanel2, "Center");
            JButton jButton = guiDialog2.getButton(1);
            JButton jButton2 = new JButton(Intl.intl("Disclaimer"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JOptionPane.showMessageDialog(guiDialog2, "Thunderhead Engineering makes no warranty, expressed or implied, to \nusers of PyroSim, and accepts no responsibility for its use. Users of PyroSim\nassume sole responsibility under Federal law for determining the appropriateness\nof its use in any particular application, for any conclusions drawn from the\nresults of its use, and for any actions taken or not taken as a result of\nanalyses performed using these tools.\n\nThe US Department of Commerce makes no warranty, expressed or \nimplied, to users of the Fire Dynamics Simulator (FDS), and accepts no \nresponsibility for its use. Users of FDS assume sole responsibility under\nFederal law for determining the appropriateness of its use in any \nparticular application; for any conclusions drawn from the results of \nits use; and for any actions taken or not taken as a result of analyses \nperformed using these tools.", Intl.intl("Disclaimer"), 1);
                }
            });
            JButton jButton3 = new JButton(Intl.intl("Credits"));
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String[] stringArray = new String[]{"FreeImage v3.11.0", "FreeType v2.2.1", "FTGL v2.15", "JSON.simple v1.1.1"};
                    StringBuilder stringBuilder = new StringBuilder(Intl.intl("PyroSim uses the following open source libraries:\n"));
                    for (String string : stringArray) {
                        stringBuilder.append('\n');
                        stringBuilder.append("        ");
                        stringBuilder.append(string);
                    }
                    JOptionPane.showMessageDialog(guiDialog2, stringBuilder.toString(), Intl.intl("Credits"), 1);
                }
            });
            guiDialog2.setButtons(jButton2, jButton3, jButton);
            guiDialog2.getRootPane().setDefaultButton(jButton);
            guiDialog2.pack();
            guiDialog2.doModal();
        }
    }

    private static class CheckForUpdatesAction
    extends guiAction {
        private static final long serialVersionUID = -7743518332575962275L;

        public CheckForUpdatesAction() {
            super(Intl.intl("Check for Updates..."));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim pyroSim = PyroSim.getApp();
            PyroCheckForUpdatesDlg pyroCheckForUpdatesDlg = new PyroCheckForUpdatesDlg((Window)pyroSim.getMainFrame(), PyroPrefs.getBoolean(PyroPrefs.PREF_CHECKLATEST));
            if (pyroCheckForUpdatesDlg.doModal() == 1) {
                PyroPrefs.set(PyroPrefs.PREF_CHECKLATEST, pyroCheckForUpdatesDlg.isCheckOnStart(), true);
            }
        }
    }

    private static class SaveOutputLogAction
    extends guiAction {
        private static final long serialVersionUID = 8839198657863594353L;

        public SaveOutputLogAction() {
            super(Intl.intl("Save Output Log..."));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PyroSim.getApp() == null) {
                return;
            }
            PyroSim pyroSim = PyroSim.getApp();
            FilenameManager filenameManager = pyroSim.getFilenameManager();
            guiFileChooser guiFileChooser2 = filenameManager.getFileChooser("TXT", "Text Document");
            if (guiFileChooser2.showSaveDialog(pyroSim.getMainFrame()) == 0) {
                File file = guiFileChooser2.getSelectedFile();
                if (file == null) {
                    return;
                }
                try {
                    System.out.printf("Copying log file to: %s%n", file);
                    CopyFile.copy(OutputLog.logFile, file);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    JOptionPane.showMessageDialog(pyroSim.getMainFrame(), iOException.getLocalizedMessage());
                }
            }
        }
    }

    private static class OpenExternalFileAction
    extends guiAction {
        private static final long serialVersionUID = 4531052540220155597L;
        private Collection<String> d_targets;

        public OpenExternalFileAction(String string, Icon icon, String ... stringArray) {
            super(string, icon);
            this.d_targets = Arrays.asList(stringArray);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = null;
            for (String object : this.d_targets) {
                File file2 = new File(object);
                if (!file2.exists()) continue;
                file = file2;
                break;
            }
            System.out.println("Opening " + file);
            if (file == null) {
                JFrame jFrame = PyroSim.getApp() == null ? null : PyroSim.getApp().getMainFrame();
                JOptionPane.showMessageDialog(jFrame, Intl.intl("Unable to open file. File not found."), Intl.intl("Error Opening File"), 0);
                return;
            }
            try {
                Desktop.getDesktop().open(file);
            }
            catch (Exception exception) {
                void var4_8;
                Object var4_6 = null;
                if (PyroSim.getApp() != null) {
                    JFrame jFrame = PyroSim.getApp().getMainFrame();
                }
                exception.printStackTrace();
                JOptionPane.showMessageDialog((Component)var4_8, exception.getLocalizedMessage(), Intl.intl("Error Opening File"), 0);
            }
        }
    }

    private static class OpenExternalUrlAction
    extends guiAction {
        private static final long serialVersionUID = 5010076194463905665L;
        private String d_target;

        public OpenExternalUrlAction(String string, Icon icon, String string2) {
            super(string, icon);
            this.d_target = string2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Desktop.getDesktop().browse(URI.create(this.d_target));
            }
            catch (Exception exception) {
                JFrame jFrame = null;
                if (PyroSim.getApp() != null) {
                    jFrame = PyroSim.getApp().getMainFrame();
                }
                exception.printStackTrace();
                JOptionPane.showMessageDialog(jFrame, exception.getLocalizedMessage(), Intl.intl("Error Opening URL"), 0);
            }
        }
    }

    class SelectViewModeAction
    extends guiAction {
        private static final long serialVersionUID = 490338083450292036L;
        private final ViewMode d_mode;

        public SelectViewModeAction(String string, ViewMode viewMode) {
            super(string);
            this.d_mode = viewMode;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim.this.setMode(this.d_mode);
        }
    }

    class UnitsAction
    extends guiAction {
        private static final long serialVersionUID = 4087419751549900242L;
        public UnitSystem d_unitSys;

        public UnitsAction(UnitSystem unitSystem) {
            super(unitSystem.getSystemName());
            this.putValue("ShortDescription", Intl.intl("Show values in") + " " + unitSystem + " " + Intl.intl("units"));
            this.d_unitSys = unitSystem;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim.this.d_unitSystem = this.d_unitSys;
            PyroSim.this.d_mediator.getEvents().changed(PyroSim.this.d_mediator, PyroMod.EVT_UNITSYSTEM_CHANGED);
        }
    }

    private class ExitAction
    extends guiAction {
        private static final long serialVersionUID = 1505224990952234402L;

        public ExitAction() {
            super(Intl.intl("E&xit"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim.this.quit(true);
        }
    }

    private class RemoveLicenseAction
    extends guiAction {
        private static final long serialVersionUID = 3921008626534333576L;

        public RemoveLicenseAction() {
            super(Intl.intl("&Remove License..."), Actions.createIcon("pyrosim/icons/blank16.gif"));
        }

        public boolean isPyroSimLicenseFile(File file) {
            if (file.isDirectory() || !file.getPath().endsWith(".lic")) {
                return false;
            }
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                StringBuffer stringBuffer = new StringBuffer();
                while (bufferedReader.ready()) {
                    stringBuffer.append(bufferedReader.readLine());
                }
                bufferedReader.close();
                return stringBuffer.toString().contains("LICENSE theng pyrosim");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }

        private void redirectStream(final InputStream inputStream, final OutputStream outputStream) {
            new Thread(){

                @Override
                public void run() {
                    FDSRunMonitor.redirectStream(outputStream, inputStream);
                }
            }.start();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block7: {
                String string = PyroSim.this.d_licenseMgr.getLicenseLocation();
                if (string.contains("@")) {
                    JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), Intl.intl("Unable to remove floating license."), Intl.intl("Invalid License Type"), 0);
                    return;
                }
                int n = JOptionPane.showConfirmDialog(PyroSim.getApp().getMainFrame(), Intl.intl("Permenantly remove license?"), Intl.intl("Remove License"), 2);
                if (n == 0) {
                    try {
                        String[] stringArray = string.split(";");
                        String[] stringArray2 = new String[stringArray.length + 1];
                        stringArray2[0] = String.format("\"%s\"", PyroSim.getApp().getInstallDir() + File.separator + "uacAwareDelete.exe");
                        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                        Process process = Runtime.getRuntime().exec(stringArray2, null, null);
                        this.redirectStream(process.getInputStream(), System.out);
                        this.redirectStream(process.getErrorStream(), System.err);
                        int n2 = process.waitFor();
                        System.out.printf("uacAwareDelete.exe returned with exit code: %s%n", n2);
                        boolean bl = true;
                        for (String string2 : stringArray) {
                            File file = new File(string2);
                            bl &= !file.exists();
                        }
                        if (bl) {
                            String[] stringArray3 = new String[]{"4180 0800 79", "F702 9441 09", "0596 6901 89", "6397 3748 90", "0862 9511 36", "7803 8309 91", "E728 9052 64", "4941 0445 46", "D956 2798 04", "D469 5095 05"};
                            int n3 = (int)((double)stringArray3.length * Math.random()) % stringArray3.length;
                            JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), Intl.intl("License successfully removed.\n\nConfirmation code:  " + stringArray3[n3]), Intl.intl("Remove License"), 2);
                            PyroSim.this.d_licenseMgr.closeLM();
                            PyroSim.this.d_licenseMgr.startFromPrefs(PyroSim.this.getPrefs(), PyroPrefs.LicenseDirProp, PyroPrefs.LicenseServerProp);
                            if (!PyroSim.this.d_licenseMgr.isAuthorized()) {
                                JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), Intl.intl("PyroSim is not Licensed and will close."), Intl.intl("PyroSim (Unlicensed)"), 0);
                                PyroSim.getApp().quit();
                                System.exit(0);
                            }
                            break block7;
                        }
                        JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), Intl.intl("Unable to remove license."), Intl.intl("Operation Failed"), 0);
                        return;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    class PreferencesAction
    extends guiAction {
        private static final long serialVersionUID = -4195888250080653592L;

        public PreferencesAction() {
            super(Intl.intl("&Preferences") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim.this.editPreferences(PreferencesDialog.Tabs.PYROSIM);
        }
    }

    class ExportReactionDatabaseFileAction
    extends guiAction
    implements IEventObserver {
        private static final long serialVersionUID = -3794092544985096221L;

        public ExportReactionDatabaseFileAction() {
            super(Intl.intl("Reaction Database") + "...", PyroGuiUtil.loadPyroSimIcon("reaction16.gif"));
            this.putValue("ShortDescription", Intl.intl("Export Reaction Database"));
            this.setEnabledUpdator(() -> !PyroSim.this.d_mediator.getReactions().flatten().isEmpty());
            PyroSim.this.d_mediator.getEvents().addObserver(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = PyroSim.this.getMediator();
            ReactionList reactionList = pyroMod.getReactions();
            Actions.exportToFile(PyroSim.this.getMainFrame(), null, pyroMod, reactionList.flatten(), PyroPrefs.LastFDSDatabaseDirProp.key.toString());
        }

        @Override
        public void update(Events events) {
            if (!events.getAffectedChannels(Reaction.class, new Class[0]).isEmpty()) {
                this.updateEnabled();
            }
        }
    }

    class ExportSurfaceDatabaseFileAction
    extends guiAction
    implements IEventObserver {
        private static final long serialVersionUID = 8282010341995972716L;

        public ExportSurfaceDatabaseFileAction() {
            super(Intl.intl("Surface Database") + "...", PyroGuiUtil.loadPyroSimIcon("surf2.gif"));
            this.putValue("ShortDescription", Intl.intl("Export Surface Database"));
            this.setEnabledUpdator(() -> !PyroSim.this.d_mediator.getSurfaceMgr().flatten().isEmpty());
            PyroSim.this.d_mediator.getEvents().addObserver(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod = PyroSim.this.getMediator();
            SurfaceManager surfaceManager = pyroMod.getSurfaceMgr();
            Actions.exportToFile(PyroSim.this.getMainFrame(), null, pyroMod, surfaceManager.flatten(), PyroPrefs.LastFDSDatabaseDirProp.key.toString());
        }

        @Override
        public void update(Events events) {
            if (!events.getAffectedChannels(Surface.class, new Class[0]).isEmpty()) {
                this.updateEnabled();
            }
        }
    }

    class ExortFDSFileAction
    extends guiAction {
        private static final long serialVersionUID = -9165823869304520671L;

        public ExortFDSFileAction() {
            super(Intl.intl("FDS File") + "...", PyroGuiUtil.loadTeciIcon("Export16.gif"));
            this.putValue("ShortDescription", Intl.intl("Write FDS File"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroMod pyroMod;
            PyroSim pyroSim = PyroSim.getApp();
            if (!Actions.validateModel(pyroSim, pyroMod = pyroSim.getMediator())) {
                return;
            }
            File file = pyroSim.getFDSSaveFile();
            if (file == null) {
                return;
            }
            PyroSim.this.writeFDSFile(file, false);
        }
    }

    class SaveAsAction
    extends guiAction {
        private static final long serialVersionUID = -5573502808869847714L;

        public SaveAsAction() {
            super(Intl.intl("S&ave As") + "...", PyroGuiUtil.loadTeciIcon("SaveAs16.gif"));
            this.putValue("ShortDescription", Intl.intl("Save As"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim.this.doSave(true);
        }
    }

    class SaveAction
    extends guiAction {
        private static final long serialVersionUID = -3394671309391787050L;

        public SaveAction() {
            super(Intl.intl("&Save"), PyroGuiUtil.loadTeciIcon("Save16.gif"));
            this.putValue("AcceleratorKey", Accelerators.SAVE);
            this.putValue("ShortDescription", Intl.intl("Save"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PyroSim.this.doSave(false);
        }
    }

    private class OpenAction
    extends guiAction {
        private static final long serialVersionUID = -314777515582078033L;

        public OpenAction() {
            super(Intl.intl("&Open") + "...", Actions.createIcon("thunderheadeng/gui/graphics/Open16.gif"));
            this.putValue("AcceleratorKey", Accelerators.OPEN);
            this.putValue("ShortDescription", Intl.intl("Open"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PyroSim.this.promptSaveIfModified(true)) {
                return;
            }
            File file = PyroSim.getFilenames().getOpenFile((Component)PyroSim.getApp().getMainFrame(), "psm", Intl.intl("PyroSim Model Files"));
            if (file == null) {
                return;
            }
            PyroMod pyroMod = PyroSim.this.getMediator();
            OpenModelTask openModelTask = new OpenModelTask(PyroSim.this, pyroMod, file.getAbsolutePath());
            pyroMod.getTaskManager().exec((Task)openModelTask, Intl.intl("Open Model"), 14);
        }
    }

    public class ScreenShotAction
    extends guiAction {
        private static final long serialVersionUID = -4214631769979609605L;

        public ScreenShotAction() {
            super(Intl.intl("Snapshot") + "...", (Icon)null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = PyroSim.getFilenames().getSaveFile((Component)PyroSim.this.getActiveFrame(), PyroSim.getApp().suggestFile("png"), "jpg", Intl.intl("JPEG Files"), "bmp", Intl.intl("BMP Files"), "png", "Portable Network Graphics", "tif", Intl.intl("TIFF Files"), "tga", Intl.intl("TARGA Files"), "gif", "Graphics Interchange Format", "ppm", Intl.intl("PPM Files"));
            if (file == null) {
                return;
            }
            SnapshotDialog snapshotDialog = new SnapshotDialog(PyroSim.this.getActiveFrame(), (PyroSim)Application.getApp(), PyroSim.this.d_3dView, file);
            snapshotDialog.doModal();
        }
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = -1379000806342902795L;

        public NewAction() {
            super(Intl.intl("&New"), PyroGuiUtil.loadTeciIcon("New16.gif"));
            this.putValue("AcceleratorKey", Accelerators.NEW);
            this.putValue("ShortDescription", Intl.intl("New"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PyroSim.this.promptSaveIfModified(true)) {
                PyroSim.this.getMediator().pauseUpdates(false);
                PyroSim.this.resetView();
                PyroMod pyroMod = PyroSim.this.getMediator();
                ResetModelTask resetModelTask = new ResetModelTask(pyroMod);
                pyroMod.getTaskManager().exec((Task)resetModelTask, Intl.intl("New Model"), 6);
                PyroSim.this.getMediator().resumeUpdates();
                PyroSim.this.getMediator().getEvents().changed(PyroSim.this.getMediator(), PyroMod.EVT_MODEL_CHANGED, PyroMod.EVT_FILENAME_CHANGED);
            }
        }
    }

    private class ModifiedDomainListener
    implements IEventObserver {
        private boolean d_modified = false;
        private Vector<Modifiable> d_targets = new Vector();

        private boolean isModifiedEvt(IEventRecord<?> iEventRecord) {
            return iEventRecord.hasAddedObjs() || iEventRecord.hasRemovedObjs() || iEventRecord.hasChangedObjs() && iEventRecord.areChangesExclusiveTo(EventUtil.acceptOnlyModifying());
        }

        @Override
        public void update(Events events) {
            boolean bl = false;
            boolean bl2 = false;
            IEventRecord<PyroMod> iEventRecord = events.getEvents(PyroMod.class, new Class[0]);
            bl = bl || iEventRecord.containsChange(PyroMod.EVT_FILENAME_CHANGED);
            boolean bl3 = bl2 = bl2 || this.isModifiedEvt(iEventRecord);
            if (iEventRecord.containsChange(PyroMod.EVT_FDS_RUN_CHANGED) || iEventRecord.containsChange(PyroMod.EVT_MODEL_CHANGED)) {
                PyroSim.this.setFDSRunMode(((PyroSim)PyroSim.this).d_mediator.getLastFDSRun().mode);
            }
            IEventRecord<Object> iEventRecord2 = events.getEvents(Object.class, FDSObjectRasterization.class, PyroMod.class);
            boolean bl4 = bl2 = bl2 || this.isModifiedEvt(iEventRecord2);
            if (bl) {
                this.reset();
            } else if (bl2) {
                this.setModified();
            }
        }

        private void reset() {
            this.d_modified = PyroSim.this.d_forceSavePrompt;
            for (Modifiable modifiable : this.d_targets) {
                modifiable.setModified(false);
            }
            PyroSim.this.updateTitle();
            PyroSim.this.d_backup.setModified(false);
        }

        private void setModified() {
            this.d_modified = true;
            PyroSim.this.d_backup.setModified(true);
            PyroSim.this.updateTitle();
        }

        public void addTarget(Modifiable modifiable) {
            this.d_targets.add(modifiable);
        }

        public boolean isModified() {
            if (this.d_modified) {
                return true;
            }
            for (Modifiable modifiable : this.d_targets) {
                if (!modifiable.isModified()) continue;
                return true;
            }
            return false;
        }
    }

    class FrameDomainListener
    implements IEventObserver {
        private JFrame d_frame;

        public FrameDomainListener(JFrame jFrame) {
            this.d_frame = jFrame;
            PyroSim.this.updateTitle();
        }

        @Override
        public void update(Events events) {
            for (EventChannel<PyroMod> eventChannel : events.getAffectedChannels(PyroMod.class, new Class[0])) {
                if (!eventChannel.containsChange(PyroMod.EVT_FILENAME_CHANGED)) continue;
                PyroSim.this.updateTitle();
                break;
            }
        }
    }

    class ViewChangeListener
    implements ChangeListener,
    IEventObserver {
        private final Semaphore d_tabLock = new Semaphore(1);

        ViewChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!this.d_tabLock.tryAcquire()) {
                return;
            }
            switch (PyroSim.this.d_mainView.getSelectedIndex()) {
                case 0: {
                    PyroSim.this.setMode(ViewMode.MV_3D);
                    break;
                }
                case 1: {
                    PyroSim.this.setMode(ViewMode.MV_2D);
                    break;
                }
                default: {
                    PyroSim.this.setMode(ViewMode.RECORD);
                }
            }
            this.d_tabLock.release();
        }

        @Override
        public void update(Events events) {
            if (events.getEvents(PyroMod.class, new Class[0]).hasChangedObjs(PyroMod.EVT_MODEL_CHANGED)) {
                PyroSim.this.initActiveView();
            } else if (View.isCamChanged(PyroSim.this.d_mediator, events)) {
                PyroSim.this.updateActiveView();
            }
        }

        public void updateActiveView(ViewMode viewMode) {
            PyroSim.this.updateViewMenu(viewMode);
            PyroSim.this.updateMainMenuBar();
            PyroSim.this.updateViewLayout(viewMode);
            if (this.d_tabLock.tryAcquire()) {
                switch (viewMode) {
                    case MV_2D: {
                        PyroSim.this.d_mainView.setSelectedIndex(1);
                        break;
                    }
                    case MV_3D: {
                        PyroSim.this.d_mainView.setSelectedIndex(0);
                        break;
                    }
                    case RECORD: {
                        PyroSim.this.d_mainView.setSelectedIndex(2);
                    }
                }
                this.d_tabLock.release();
            }
        }
    }

    private class RegisterAction
    extends guiAction {
        private static final long serialVersionUID = -223740323501920782L;

        public RegisterAction() {
            super(Intl.intl("&License") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PyroSim.this.d_licenseMgr == null) {
                System.err.println("null license manager");
                return;
            }
            PyroSim.this.showActivationDialog();
        }
    }
}

