/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import pyrosim.PyroSim;
import pyrosim.Version;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.ModelBackup;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;

public class PyroPrefs {
    public static final TypedProp<Boolean> PREF_CHECKLATEST = new TypedProp<Boolean>((Object)"CheckLatest", true);
    public static final TypedProp<String> PREF_LASTLIBRARY = new TypedProp<String>((Object)"LastLib", PyroPrefs.defDatabase());
    public static final TypedProp<Boolean> PREF_FDSPARALLEL_USEMPI = new TypedProp<Boolean>((Object)"FDSParallelUseMpi", true);
    public static final TypedProp<String> PREF_FDSCOMPABILITY = new TypedProp<String>((Object)"FDS.Compability", Version.FDS_DESIGN.toString());
    public static final TypedProp<String> PREF_MPOVLOCATION = new TypedProp<String>((Object)"MPOVLocation", "C:\\Documents and Settings\\birkey\\My Documents\\megapov-1.2.1-windows\\bin\\megapov.exe");
    public static final TypedProp<String> PREF_DXFLOCATION = new TypedProp<String>((Object)"DXFLocation", Application.getApp().getInstallDir() + File.separator + "dxf2fds" + File.separator + "DXF2FDS.exe");
    public static final TypedProp<Boolean> PREF_RUNSV = new TypedProp<Boolean>((Object)"RunSV", true);
    public static final TypedProp<Boolean> PREF_CUT_HOLES = new TypedProp<Boolean>((Object)"Display.cutHoles", true);
    public static final TypedProp<Boolean> PREF_USEAUTOSAVE = new TypedProp<Boolean>((Object)"UseAutosave", true);
    public static final TypedProp<Boolean> PREF_CREATE_BACKUP_ON_OPEN = new TypedProp<Boolean>((Object)"CreateBackupOnOpen", true);
    public static final UDProp PREF_AUTOSAVE_INTERVAL = new UDProp("AutosaveInterval", ModelBackup.DEF_AUTOSAVE_PERIOD, NonSI.MINUTE);
    public static final TypedProp<Boolean> AUTOSAVE_ON_RUN_FDS = new TypedProp<Boolean>((Object)"AutosaveOnRunFDS", false);
    public static final TypedProp<Boolean> PREF_RECORD_PREVIEW = new TypedProp<Boolean>((Object)"EnableRecordPreview", true);
    public static final TypedProp<Integer> PREF_CLUSTER_NUMHOSTS = new TypedProp<Integer>((Object)"NumHosts", 0);
    public static final TypedProp<Boolean> PREF_DRAWCOLORBUFFER = new SafeModeProp<Boolean>("EnableColorBufferDrawing", false, false);
    public static final TypedProp<Boolean> PREF_DRAWDEPTHBUFFER = new SafeModeProp<Boolean>("EnableDepthBufferDrawing", false, false);
    public static final TypedProp<Boolean> PREF_USEVERTEXBUFFERS = new SafeModeProp<Boolean>("UseVertexBuffers", false, false);
    public static final TypedProp<Boolean> PREF_SCENESHADERS = new SafeModeProp<Boolean>("UseSceneShaders", true, false);
    public static final TypedProp<Boolean> ShowGridProp = new TypedProp<Boolean>((Object)"3D.showGrid", true);
    public static final TypedProp<Boolean> ShowBoundaryProp = new TypedProp<Boolean>((Object)"3D.showBoundary", true);
    public static final TypedProp<Boolean> ShowBoundaryLinesProp = new TypedProp<Boolean>((Object)"3D.showBoundaryLines", false);
    public static final TypedProp<Boolean> UseSVNavProp = new TypedProp<Boolean>((Object)"3D.useSVNav", false);
    public static final TypedProp<Double> DefaultSnapSpacing = new TypedProp<Double>((Object)"FPE.snap.defaultSpacing", 1.0);
    public static final TypedProp<Boolean> ShowSystemMouseProp = new TypedProp<Boolean>((Object)"FPE.mouse.showSystem", true);
    public static final TypedProp<Boolean> ShowGuidesProp = new TypedProp<Boolean>((Object)"FPE.mouse.showGuides", true);
    public static final TypedProp<Boolean> ShowOriginProp = new TypedProp<Boolean>((Object)"FPE.showOrigin", true);
    public static final TypedProp<Boolean> ShowAppearancesProp2D = new TypedProp<Boolean>((Object)"FPE.showTextures", true);
    public static final TypedProp<Boolean> ShowAppearancesProp3D = new TypedProp<Boolean>((Object)"3D.showTextures", true);
    public static final TypedProp<Boolean> ShowOutlinesProp2D = new TypedProp<Boolean>((Object)"FPE.showOutlines", true);
    public static final TypedProp<Boolean> ShowOutlinesProp3D = new TypedProp<Boolean>((Object)"3D.showOutlines", true);
    public static final TypedProp<Boolean> DrawWireframeProp2D = new TypedProp<Boolean>((Object)"FPE.drawWireframe", false);
    public static final TypedProp<Boolean> DrawWireframeProp3D = new TypedProp<Boolean>((Object)"3D.drawWireframe", false);
    public static final TypedProp<Boolean> UseSmoothLightingProp2D = new TypedProp<Boolean>((Object)"FPE.useSmoothLighting", false);
    public static final TypedProp<Boolean> UseSmoothLightingProp3D = new TypedProp<Boolean>((Object)"3D.useSmoothLighting", true);
    public static final TypedProp<Float> RECORD_VIEW_FONTSIZE = new TypedProp<Float>((Object)"RecordViewFontsize", Float.valueOf(12.0f));
    public static final TypedProp<Boolean> SYNTAX_HIGHLIGHT_ENABLE = new TypedProp<Boolean>((Object)"SyntaxHighlightEnable", Boolean.TRUE);
    public static final TypedProp<Integer> SYNTAX_HIGHLIGHT_OBSTHOLELIMIT = new TypedProp<Integer>((Object)"SyntaxHighlightObstHoleLimit", 4000);
    public static final TypedProp<Boolean> RESULTS_DISPLAYGE1 = new TypedProp<Boolean>((Object)"InitSmokeViewGE1", false);
    public static final TypedProp<Boolean> RESULTS_MESHBOUNDS = new TypedProp<Boolean>((Object)"WriteGE1Meshes", true);
    public static final TypedProp<Boolean> RESULTS_WRITEGE1 = new TypedProp<Boolean>((Object)"WriteGE1", false);
    public static final TypedProp<Boolean> RESULTS_WRITEPYROGEOM = new TypedProp<Boolean>((Object)"WritePyroGeom", true);
    public static final TypedProp<Boolean> RESULTS_WRITESMVINI = new TypedProp<Boolean>((Object)"WriteINI", true);
    public static final TypedProp<Boolean> RESULTS_WRITEVIEWS = new TypedProp<Boolean>((Object)"WriteViews", true);
    public static final TypedProp<Boolean> RESULTS_WRITEFLOORS = new TypedProp<Boolean>((Object)"WriteFloors", true);
    public static final TypedProp<Double> DISPLAY_EDGE_ERROR = new TypedProp<Double>((Object)"Display.edgeError", 0.01);
    public static final TypedProp<Double> DISPLAY_FACE_ERROR = new TypedProp<Double>((Object)"Display.faceError", 0.1);
    public static final TypedProp<Integer> LastSlcfDlgSizeX = new TypedProp<Integer>((Object)"Dialog.size.x.slcf", -1);
    public static final TypedProp<Integer> LastSlcfDlgSizeY = new TypedProp<Integer>((Object)"Dialog.size.y.slcf", -1);
    public static final TypedProp<Integer> LastPl3dDlgSizeX = new TypedProp<Integer>((Object)"Dialog.size.x.pl3d", -1);
    public static final TypedProp<Integer> LastPl3dDlgSizeY = new TypedProp<Integer>((Object)"Dialog.size.y.pl3d", -1);
    public static final TypedProp<Integer> LastBndfDlgSizeX = new TypedProp<Integer>((Object)"Dialog.size.x.bndf", -1);
    public static final TypedProp<Integer> LastBndfDlgSizeY = new TypedProp<Integer>((Object)"Dialog.size.y.bndf", -1);
    public static final TypedProp<Integer> LastIsofDlgSizeX = new TypedProp<Integer>((Object)"Dialog.size.x.isof", -1);
    public static final TypedProp<Integer> LastIsofDlgSizeY = new TypedProp<Integer>((Object)"Dialog.size.y.isof", -1);
    public static final TypedProp<Integer> LastRampDlgSizeX = new TypedProp<Integer>((Object)"Dialog.size.x.ramp", -1);
    public static final TypedProp<Integer> LastRampDlgSizeY = new TypedProp<Integer>((Object)"Dialog.size.y.ramp", -1);
    public static final TypedProp<Integer> LastManageFloorsDlgSizeX = new TypedProp<Integer>((Object)"Dialog.size.x.manageFloors", -1);
    public static final TypedProp<Integer> LastManageFloorsDlgSizeY = new TypedProp<Integer>((Object)"Dialog.size.x.manageFloors", -1);
    public static final int FDSFORMAT_SCIENTIFIC = 0;
    public static final int FDSFORMAT_ALIGNED = 1;
    public static final int FDSFORMAT_GENERAL = 2;
    public static final TypedProp<Integer> FDSFormatProp = new TypedProp<Integer>((Object)"FDS.format", 2);
    public static final TypedProp<Integer> FDSFormatGenPrecision = new TypedProp<Integer>((Object)"FDS.format.general.precision", 6);
    public static final TypedProp<Integer> FDSFormatAlignedDec = new TypedProp<Integer>((Object)"FDS.format.aligned.numDecimals", 2);
    public static final TypedProp<Integer> FDSFormatAlignedWidth = new TypedProp<Integer>((Object)"FDS.format.aligned.width", 10);
    public static final TypedProp<String> UnitSystemProp = new TypedProp<String>((Object)"PyroSim.UnitSystem", SIUS.getInstance().getSystemName());
    public static final TypedProp<String> LicenseDirProp = new TypedProp<String>((Object)"PyroSim.licenseDir", PyroPrefs.defLicenseDir());
    public static final TypedProp<String> LicenseServerProp = new TypedProp<String>((Object)"PyroSim.licenseServer", "");
    public static final TypedProp<String> LastFDSDatabaseDirProp = new TypedProp<String>((Object)"File.lastDir.FDSDatabase", Application.getApp().getInstallDir() + File.separator + "fds");
    public static final TypedProp<Integer> LastScreenShotWidth = new TypedProp<Integer>((Object)"File.screenShot.width", 1024);
    public static final TypedProp<Integer> LastScreenShotHeight = new TypedProp<Integer>((Object)"File.screenShot.height", 768);
    public static final TypedProp<Boolean> LastScreenShotPyroButton = new TypedProp<Boolean>((Object)"File.screenShot.pyroButton", true);
    public static final TypedProp<Boolean> POVScreenShotAntiAlias = new TypedProp<Boolean>((Object)"File.screenShot.AntiAlias", true);
    public static final TypedProp<Boolean> POVScreenShotShadows = new TypedProp<Boolean>((Object)"File.screenShot.Shadows", true);
    public static final TypedProp<Boolean> POVScreenShotPOVFile = new TypedProp<Boolean>((Object)"File.screenShot.POVFile", false);
    public static final TypedProp<String> VIDEO_ADAPTER = new TypedProp<String>((Object)"System.videoAdapter", "");
    public static final TypedProp<Integer> ADAPTER_VERSION = new TypedProp<Integer>((Object)"System.videoAdapter.version", -1);
    public static final TypedProp<Boolean> INTEL_WARNING_SHOWN = new TypedProp<Boolean>((Object)"System.intelWarningShown", false);
    public static final String FDS_SINGLE = "location";
    public static final String FDS_OPENMP = "openMPLocation";
    public static final String FDS_RUNFDS = "runFDSLocation";
    public static final String FDS_MPIEXEC = "mpiExecLocation";
    public static final String FDS_SMOKEVIEW = "sv.location";
    public static final String FDS_SMPDPORT = "SMPDPort";
    public static final String FDS_CLUSTERPORT = "clusterPort";
    public static final TypedProp<Boolean> RESULTS_OPEN_THROUGH_SOCKET = new TypedProp<Boolean>((Object)"Results.openThroughSocket", true);
    private static final Map<String, String> s_fdsLocPrefs = new HashMap<String, String>();

    private static String fds(String string) {
        File file = new File(Application.getApp().getInstallDir(), "fds");
        return new File(file, string).getAbsolutePath();
    }

    private static String defDatabase() {
        String string = "property_library.fds";
        String string2 = Application.getApp().getInstallDir();
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(File.separator);
        stringBuffer.append(string);
        return stringBuffer.toString().replaceAll("/", File.separator);
    }

    private static String defLicenseDir() {
        String string = File.separator;
        String string2 = System.getenv("ALLUSERSPROFILE");
        return string2 + string + "Application Data" + string + "PyroSim" + string + "license";
    }

    public static TeciProps instance() {
        return PyroSim.getApp().getPrefs();
    }

    public static double getDouble(TypedProp<Double> typedProp) {
        return PyroPrefs.instance().getDouble(typedProp);
    }

    public static UnitDouble getUnitDouble(UDProp uDProp) {
        return new UnitDouble(PyroPrefs.instance().getDouble(uDProp), uDProp.d_storeUnit);
    }

    public static float getFloat(TypedProp<Float> typedProp) {
        return PyroPrefs.instance().getFloat(typedProp);
    }

    public static String getString(TypedProp<String> typedProp) {
        return PyroPrefs.instance().getString(typedProp);
    }

    public static int getInt(TypedProp<Integer> typedProp) {
        return PyroPrefs.instance().getInt(typedProp);
    }

    public static boolean getBoolean(TypedProp<Boolean> typedProp) {
        return PyroPrefs.instance().getBoolean(typedProp);
    }

    public static <T> void set(TypedProp<T> typedProp, T t, boolean bl) {
        PyroSim pyroSim = PyroSim.getApp();
        pyroSim.getPrefs().set(typedProp, t);
        if (bl) {
            pyroSim.superSavePreferences();
        }
    }

    public static void set(UDProp uDProp, UnitDouble unitDouble, boolean bl) {
        PyroPrefs.set(uDProp, unitDouble.getValue(uDProp.d_storeUnit), bl);
    }

    public static List<SafeModeProp> getSafeModeProps() {
        ArrayList<SafeModeProp> arrayList = new ArrayList<SafeModeProp>();
        try {
            for (Field field : PyroPrefs.class.getFields()) {
                Object object = field.get(null);
                if (!(object instanceof SafeModeProp)) continue;
                arrayList.add((SafeModeProp)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static String getLastVersion() {
        String string = PyroSim.is64Bit() ? "LastVersion.64" : "LastVersion.32";
        return PyroPrefs.instance().getString(string, "2018.3.1210");
    }

    public static void updateLastVersion() {
        String string = PyroSim.is64Bit() ? "LastVersion.64" : "LastVersion.32";
        PyroPrefs.instance().set(string, "2018.3.1210");
    }

    private static String getToolPref(TypedProp<String> typedProp, TypedProp<String> typedProp2) {
        TypedProp<String> typedProp3 = PyroPrefs.getToolPrefKey(typedProp, typedProp2);
        return PyroPrefs.getString(typedProp3);
    }

    private static <T> TypedProp<T> getToolPrefKey(TypedProp<T> typedProp, TypedProp<T> typedProp2) {
        return PyroSim.is64Bit() ? typedProp2 : typedProp;
    }

    public static String getFDSLocation() {
        return PyroPrefs.getFDSLoc(FDS_SINGLE, true);
    }

    public static String getRunFDSLocation() {
        return PyroPrefs.getFDSLoc(FDS_RUNFDS, true);
    }

    public static String getMPIExecLocation() {
        return PyroPrefs.getFDSLoc(FDS_MPIEXEC, true);
    }

    public static String getSmokeviewLocation() {
        return PyroPrefs.getFDSLoc(FDS_SMOKEVIEW, true);
    }

    public static String getResultsLocation() {
        boolean bl;
        String string = Application.getApp().getInstallDir();
        String string2 = "";
        if (string != null) {
            string2 = string;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = bl = System.getProperty("debug") != null;
        if (bl) {
            arrayList.add("PyroSimResults64_d.exe");
        }
        arrayList.add("PyroSimResults64.exe");
        arrayList.add("PyroSimResults.exe");
        for (String string3 : arrayList) {
            File file = new File(string2, string3);
            if (!file.exists()) continue;
            System.out.println("Results Loc: " + file.getAbsolutePath());
            return file.getAbsolutePath();
        }
        assert (false);
        return null;
    }

    public static String getFDSLoc(String string, boolean bl) {
        return PyroPrefs.getFDSLoc("2018.3.1210", string, bl);
    }

    public static String getFDSLoc(String string, String string2, boolean bl) {
        String string3 = PyroPrefs.fdsKey(string, string2, PyroSim.is64Bit());
        String string4 = PyroPrefs.instance().getString(string3, null);
        if (string4 == null && bl) {
            string4 = s_fdsLocPrefs.get(string3);
            assert (string4 != null);
        }
        return string4;
    }

    public static void setFDSLoc(String string, String string2) {
        PyroPrefs.setFDSLoc("2018.3.1210", string, string2);
    }

    public static void setFDSLoc(String string, String string2, String string3) {
        String string4 = PyroPrefs.fdsKey(string, string2, PyroSim.is64Bit());
        if (string3 == null || string3.equals(s_fdsLocPrefs.get(string4))) {
            PyroPrefs.instance().remove(string4);
        } else {
            PyroPrefs.instance().set(string4, string3);
        }
    }

    private static String fdsKey(String string, boolean bl) {
        return PyroPrefs.fdsKey("2018.3.1210", string, bl);
    }

    private static String fdsKey(String string, String string2, boolean bl) {
        String string3 = bl ? "64" : "32";
        String string4 = "PyroSim_" + string + ".FDS." + string3 + "." + string2;
        return string4;
    }

    static {
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_SINGLE, false), PyroPrefs.fds("fds.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_SINGLE, true), PyroPrefs.fds("fds.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_RUNFDS, false), PyroPrefs.fds("runfds.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_RUNFDS, true), PyroPrefs.fds("runfds.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_MPIEXEC, false), PyroPrefs.fds("mpiexec.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_MPIEXEC, true), PyroPrefs.fds("mpiexec.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_SMOKEVIEW, false), PyroPrefs.fds("smokeview.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_SMOKEVIEW, true), PyroPrefs.fds("smokeview.exe"));
    }

    public static class UDProp
    extends TypedProp<Double> {
        public final Unit d_storeUnit;

        public UDProp(String string, UnitDouble unitDouble, Unit unit) {
            super((Object)string, unitDouble.getValue(unit));
            this.d_storeUnit = unit;
        }
    }

    public static class SafeModeProp<T>
    extends TypedProp<T> {
        public final T safeVal;

        public SafeModeProp(String string, T t, T t2) {
            super((Object)string, t);
            this.safeVal = t2;
        }
    }
}

