/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.PyroNamesDB;
import pyrosim.PyroSimSelectionModel;
import pyrosim.PyroTaskManager;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.FDSClusterOptions;
import pyrosim.domain.FDSRun;
import pyrosim.domain.FloorManager;
import pyrosim.domain.GeomLocator;
import pyrosim.domain.GeomProximity;
import pyrosim.domain.GridList;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.ResultsArchive;
import pyrosim.domain.Serialized;
import pyrosim.domain.SimParams;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.bridge.BridgeList;
import pyrosim.domain.controls.ControlMgr;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.devices.DeviceManager;
import pyrosim.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.domain.devices.sprayers.SprayModelMgr;
import pyrosim.domain.evac.CorrList;
import pyrosim.domain.evac.DoorList;
import pyrosim.domain.evac.EntrList;
import pyrosim.domain.evac.EvacList;
import pyrosim.domain.evac.EvhoList;
import pyrosim.domain.evac.EvssList;
import pyrosim.domain.evac.ExitList;
import pyrosim.domain.evac.PersList;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.hvac.HvacList;
import pyrosim.domain.output.Boundaries;
import pyrosim.domain.output.IsosurfaceMgr;
import pyrosim.domain.output.Plot3d;
import pyrosim.domain.output.ProfList;
import pyrosim.domain.output.Slice3dList;
import pyrosim.domain.output.SliceList;
import pyrosim.domain.output.StatisticMgr;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.view.ViewMgr;
import pyrosim.domain.zones.ZoneMgr;
import pyrosim.event.NonModifyingEvent;
import pyrosim.io.BimImporter;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParser;
import pyrosim.io.pyrosimV4V5.Convert;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.scene3d.geom.PropsUtil;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Task;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;

public class PyroMod
extends Mediator
implements Serializable,
IPyroObject {
    static final long serialVersionUID = 1L;
    public static final Object EVT_CHANGED = new Object();
    public static final Object EVT_SEL = new NonModifyingEvent();
    public static final Object EVT_CHILDREN_CHANGED = new Object();
    public static final Object EVT_PARENT_CHANGED = "PARENT_CHANGED";
    public static final Object EVT_ENABLED_CHANGED = new Object();
    public static final Object EVT_VISIBILITY_CHANGED = new Object();
    public static final Object EVT_FORCEWRITE_CHANGED = new Object();
    public static final Object EVT_CHILDREN_ADDED = new Object();
    public static final Object EVT_CHILDREN_REMOVED = new Object();
    public static final Object EVT_FILENAME_CHANGED = new NonModifyingEvent();
    public static final Object EVT_FDS_RUN_CHANGED = new Object();
    public static final Object EVT_FDS_CLUSTER_OPTIONS_CHANGED = new Object();
    public static final Object EVT_MODEL_CHANGED = new Object();
    public static final Object EVT_PREFS_CHANGED = new NonModifyingEvent();
    public static final Object EVT_UNITSYSTEM_CHANGED = new NonModifyingEvent();
    public static final Object EVT_UNPROC_RECS_CHANGED = new Object();
    public static final Object EVT_APPEARANCE = new Object();
    public static final Object EVT_FDS_EVAC_CHANGED = new Object();
    public static final Object EVT_RAST_PROPS = new Object();
    public static final Object EVT_NAME_CHANGED = new Object();
    private Serialized ser;
    private final transient PyroTaskManager d_taskMan;
    private transient PyroSimSelectionModel d_selModel;
    private final transient FDSRasterization d_rasterizations = new FDSRasterization(this);
    private boolean d_autoProxUpdate = true;
    private final transient GeomProximity d_geomProx;
    private final transient GeomLocator d_geomLocator;
    private PyroNamesDB d_names;

    public PyroMod() {
        this(false);
    }

    public PyroMod(boolean bl) {
        this(null, bl, true);
    }

    public PyroMod(Serialized serialized) {
        this(serialized, false, true);
    }

    public PyroMod(Serialized serialized, boolean bl, boolean bl2) {
        if (bl2) {
            this.setEvents(new PyroEvents());
        } else {
            this.setEvents(new NilEvents());
        }
        this.d_selModel = new PyroSimSelectionModel(this);
        this.d_taskMan = new PyroTaskManager(this);
        this.d_geomLocator = new GeomLocator();
        this.d_geomProx = new GeomProximity(this);
        if (serialized == null) {
            this.setSerialized(new Serialized(bl));
        } else {
            this.setSerialized(serialized);
        }
        this.ser.setDomain(this);
    }

    @Override
    public Collection<? extends IPyroObject> getMembers() {
        return PyroMod.getMembers(this.ser, this.getFdsEvacEnabled());
    }

    public static Collection<? extends IPyroObject> getMembers(Serialized serialized, boolean bl) {
        ArrayList<APyroObject> arrayList = new ArrayList<APyroObject>();
        List<APyroObject> list = Arrays.asList(serialized.boundaryOutput, serialized.controls, serialized.devices, serialized.exSpecs, serialized.floors, serialized.grids, serialized.heatLinkModels, serialized.hvacSystem, serialized.isosurfaces, serialized.matmgr, serialized.msrStats, serialized.obstructions, serialized.particles, serialized.plot3d, serialized.profs, serialized.reactions, serialized.simParams, serialized.slices, serialized.slices3d, serialized.smokeLinkModels, serialized.sprayModels, serialized.sprkLinkModels, serialized.surfmgr, serialized.appearances, serialized.zones, serialized.bridges, serialized.views);
        arrayList.addAll(list);
        if (bl) {
            List<Composite> list2 = Arrays.asList(serialized.corrs, serialized.doors, serialized.entrs, serialized.evacs, serialized.evhos, serialized.evsss, serialized.exits, serialized.perss);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public Collection<? extends IPyroObject> getSelectableMembers() {
        return PyroMod.getSelectableMembers(this.ser);
    }

    public static Collection<? extends IPyroObject> getSelectableMembers(Serialized serialized) {
        LinkedHashSet<IPyroObject> linkedHashSet = new LinkedHashSet<IPyroObject>();
        linkedHashSet.add(serialized.views);
        linkedHashSet.addAll(serialized.views.getDeepMembers());
        linkedHashSet.add(serialized.grids);
        linkedHashSet.addAll(serialized.grids.getDeepMembers());
        linkedHashSet.add(serialized.zones);
        linkedHashSet.addAll(serialized.zones.getDeepMembers());
        linkedHashSet.add(serialized.reactions);
        linkedHashSet.addAll(serialized.reactions.getDeepMembers());
        linkedHashSet.add(serialized.matmgr);
        linkedHashSet.addAll(serialized.matmgr.getDeepMembers());
        linkedHashSet.add(serialized.surfmgr);
        linkedHashSet.addAll(serialized.surfmgr.getDeepMembers());
        linkedHashSet.add(serialized.exSpecs);
        linkedHashSet.addAll(serialized.exSpecs.getDeepMembers());
        linkedHashSet.add(serialized.particles);
        linkedHashSet.addAll(serialized.particles.getDeepMembers());
        linkedHashSet.add(serialized.devices);
        linkedHashSet.addAll(serialized.devices.getDeepMembers());
        linkedHashSet.add(serialized.controls);
        linkedHashSet.addAll(serialized.controls.getDeepMembers());
        linkedHashSet.add(serialized.msrStats);
        linkedHashSet.addAll(serialized.msrStats.getDeepMembers());
        linkedHashSet.add(serialized.slices);
        linkedHashSet.addAll(serialized.slices.getDeepMembers());
        linkedHashSet.add(serialized.slices3d);
        linkedHashSet.addAll(serialized.slices3d.getDeepMembers());
        linkedHashSet.add(serialized.hvacSystem);
        linkedHashSet.addAll(serialized.hvacSystem.getDeepMembers());
        linkedHashSet.add(serialized.obstructions);
        linkedHashSet.addAll(serialized.obstructions.getDeepMembers());
        return linkedHashSet;
    }

    public void initializeDatabases(File file) {
        this.ser.appearances.setDBDir(file);
        this.ser.appearances.scan();
    }

    public Set<Material> getInUseAppearances() {
        LinkedIdentityHashSet<Material> linkedIdentityHashSet = new LinkedIdentityHashSet<Material>();
        for (Object object : this.getSurfaceMgr().flatten()) {
            Material namedPyroObject = ((Surface)object).getAppearance();
            if (namedPyroObject == null) continue;
            linkedIdentityHashSet.add(namedPyroObject);
        }
        LinkedIdentityHashSet linkedIdentityHashSet2 = new LinkedIdentityHashSet();
        for (GenericGeomSrc genericGeomSrc : ((APyroObject)this.getObstructions()).flatten(GenericGeomSrc.class)) {
            PropsUtil.getReferencedMaterials(genericGeomSrc.getGeom(), genericGeomSrc.getDisplayProps(), linkedIdentityHashSet2);
        }
        linkedIdentityHashSet.addAll(theUtil.filter(linkedIdentityHashSet2, Material.class));
        return linkedIdentityHashSet;
    }

    public void setAutoProxUpdate(boolean bl) {
        this.d_autoProxUpdate = bl;
    }

    public GeomLocator getGeomLocator() {
        return this.d_geomLocator;
    }

    public GeomProximity getGeomProx() {
        return this.d_geomProx;
    }

    public void updateGeomSearchesEnabled(boolean bl) {
        this.d_geomProx.setEnabled(bl);
        if (bl) {
            Collection<? extends IPyroGeomSrc> collection = this.getAllGeom();
            for (IPyroGeomSrc iPyroGeomSrc : collection) {
                this.d_geomProx.add(iPyroGeomSrc);
            }
            this.pauseUpdates(false);
            this.d_geomProx.update();
            this.resumeUpdates();
        }
    }

    public void updateGeom() {
        if (this.d_autoProxUpdate) {
            boolean bl = this.getEvents().getEvents(PyroMod.class, new Class[0]).containsChange(EVT_MODEL_CHANGED);
            if (bl) {
                this.pauseUpdates(false);
            }
            this.d_geomProx.update();
            if (bl) {
                this.resumeUpdates();
            }
        }
    }

    public FDSRasterization getRasterizations() {
        return this.d_rasterizations;
    }

    public PyroTaskManager getTaskManager() {
        return this.d_taskMan;
    }

    public PyroSimSelectionModel getSelectionModel() {
        return this.d_selModel;
    }

    public void resetModel(boolean bl) {
        this.pauseUpdates(false);
        this.d_selModel.clearSelection();
        this.setSerialized(new Serialized(bl));
        this.resumeUpdates();
        this.getEvents().changed(this, EVT_MODEL_CHANGED, EVT_FILENAME_CHANGED);
    }

    public RasterizationOptions getRastOptions() {
        return this.ser.rastProps;
    }

    public void setRastProps(RasterizationOptions rasterizationOptions) {
        if (this.ser.rastProps.equals(rasterizationOptions)) {
            return;
        }
        this.ser.rastProps = rasterizationOptions;
        this.getEvents().changed(this, EVT_RAST_PROPS);
    }

    public ModelComposite getObstructions() {
        return this.ser.obstructions;
    }

    public SimParams getSimParams() {
        return this.ser.simParams;
    }

    public MaterialManager getMaterialMgr() {
        return this.ser.matmgr;
    }

    public SurfaceManager getSurfaceMgr() {
        return this.ser.surfmgr;
    }

    public ReactionList getReactions() {
        return this.ser.reactions;
    }

    public String getUnprocessedRecords() {
        return this.ser.unprocessedRecords;
    }

    public void setUnprocessedRecords(String string) {
        this.ser.unprocessedRecords = string;
        this.changedEvt(EVT_UNPROC_RECS_CHANGED);
    }

    public boolean fromLegacy(File file, pyrosim.legacy_2006_2.PyroMod pyroMod, WarningReport<Warning> warningReport) {
        pyrosim.legacy_2006_2.Serialized serialized = pyroMod.ser;
        this.pauseUpdates(false);
        this.resetModel(false);
        Convert convert = new Convert(file, warningReport);
        pyrosim.legacy_2012_1.domain.Serialized serialized2 = new pyrosim.legacy_2012_1.domain.Serialized(false);
        serialized2 = convert.fromLegacy(serialized2, serialized);
        this.resumeUpdates();
        pyrosim.legacy_2012_1.PyroMod pyroMod2 = new pyrosim.legacy_2012_1.PyroMod(serialized2);
        return this.fromLegacy(file, pyroMod2, warningReport);
    }

    public boolean fromLegacy(File file, pyrosim.legacy_2012_1.PyroMod pyroMod, WarningReport<Warning> warningReport) {
        pyrosim.legacy_2012_1.domain.Serialized serialized = pyroMod.ser;
        this.pauseUpdates(false);
        this.resetModel(false);
        pyrosim.io.pyrosimV5V6.Convert convert = new pyrosim.io.pyrosimV5V6.Convert(file, warningReport);
        Serialized serialized2 = new Serialized(false);
        serialized2 = convert.fromLegacy(serialized2, serialized, this.getAppearances());
        this.setSerialized(serialized2);
        this.resumeUpdates();
        this.getEvents().changed(this, EVT_MODEL_CHANGED, EVT_FILENAME_CHANGED);
        return true;
    }

    private static void showWarnings(WarningReport<Warning> warningReport, boolean bl) {
        if (!warningReport.isEmpty()) {
            if (!bl) {
                WarningDlg<Warning> warningDlg = new WarningDlg<Warning>((Window)Application.getApp().getMainFrame(), Intl.intl("PSM Warnings"), Intl.intl("There were some problems reading the PyroSim file.  The following table lists the problems and how they were resolved."), warningReport);
                warningDlg.doModal();
            } else {
                System.out.println("Warnings:\n" + warningReport.prepareReport());
            }
        }
    }

    public void openModel(PyroSimObjectInputStream pyroSimObjectInputStream, boolean bl) throws IOException, ClassNotFoundException, Exception {
        this.pauseUpdates(false);
        try {
            Serialized serialized = pyroSimObjectInputStream.readModel();
            this.setSerialized(serialized);
            PyroMod.showWarnings(pyroSimObjectInputStream.getWarnings(), bl);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            this.resumeUpdates();
        }
        this.getEvents().changed(this, EVT_MODEL_CHANGED, EVT_FILENAME_CHANGED);
    }

    public void saveModel(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.ser);
    }

    public boolean readBIMFile(String string) {
        boolean bl = true;
        this.pauseUpdates();
        try {
            BimImporter.open(this.ser, string);
        }
        catch (Throwable throwable) {
            bl = false;
            throwable.printStackTrace();
        }
        this.resumeUpdates();
        return bl;
    }

    public boolean readFDS6File(String string, boolean bl) throws Exception {
        this.pauseUpdates(false);
        try {
            PyroMod pyroMod = new PyroMod();
            pyroMod.setAutoProxUpdate(false);
            FDSParser fDSParser = FDS.newParser(6);
            FDSParseResult fDSParseResult = fDSParser.parseFile(string, pyroMod);
            fDSParseResult.warningReport.showWarnings(bl);
            pyroMod.ser.initDefaults();
            this.setSerialized(pyroMod.ser);
            this.getFloorManager().addDefaults();
            pyroMod = null;
            this.resumeUpdates();
            this.getEvents().changed(this, EVT_MODEL_CHANGED, EVT_FILENAME_CHANGED);
            return true;
        }
        catch (Exception exception) {
            this.resumeUpdates();
            throw exception;
        }
    }

    public PyroNamesDB getNames() {
        return this.d_names;
    }

    public NameGenerator getNames(Object object) {
        return this.d_names.getNames(object);
    }

    public NameGenerator getNames(Class clazz) {
        return this.d_names.getNames(clazz);
    }

    public void setSerialized(PyroMod pyroMod) {
        this.pauseUpdates();
        try {
            pyroMod.ser.setDomain(null);
            this.setSerialized(pyroMod.ser);
        }
        finally {
            this.resumeUpdates();
        }
    }

    public void setSerialized(Serialized serialized) {
        MaterialDB materialDB = null;
        MaterialDB materialDB2 = serialized.appearances;
        if (this.ser != null) {
            this.ser.setDomain(null);
            materialDB = this.ser.appearances;
        }
        this.ser = serialized;
        this.d_names = this.ser.generateNamesDB();
        if (materialDB != null) {
            this.ser.appearances = materialDB;
        }
        this.ser.setDomain(this);
        if (materialDB != null) {
            materialDB.loadFrom(materialDB2);
        }
        this.d_selModel.clearSelection();
        this.getEvents().resetEvents();
    }

    public GridList getGridManager() {
        return this.ser.grids;
    }

    public ZoneMgr getZoneMgr() {
        return this.ser.zones;
    }

    public BridgeList getBridges() {
        return this.ser.bridges;
    }

    public FloorManager getFloorManager() {
        return this.ser.floors;
    }

    public void setPL3DRecord(Plot3d plot3d) {
        this.ser.plot3d = plot3d;
        this.getEvents().changed(this.ser.plot3d, new Object[0]);
    }

    public void setSimParams(SimParams simParams) {
        this.ser.simParams = simParams;
        this.getEvents().changed(this.ser.simParams, new Object[0]);
    }

    public SmokeLinkModelMgr getSmokeLinkModels() {
        return this.ser.smokeLinkModels;
    }

    public HeatLinkModelMgr getHeatLinkModels() {
        return this.ser.heatLinkModels;
    }

    public SprinklerLinkModelMgr getSprinklerLinkModels() {
        return this.ser.sprkLinkModels;
    }

    public SprayModelMgr getSprayModels() {
        return this.ser.sprayModels;
    }

    public DeviceManager getDevices() {
        return this.ser.devices;
    }

    public ControlMgr getControls() {
        return this.ser.controls;
    }

    public Boundaries getBoundaryOutput() {
        return this.ser.boundaryOutput;
    }

    public void setBoundaries(Boundaries boundaries) {
        this.ser.boundaryOutput = boundaries;
        this.getEvents().changed(this.ser.boundaryOutput, new Object[0]);
    }

    public IsosurfaceMgr getIsofList() {
        return this.ser.isosurfaces;
    }

    public SliceList getSlcfList() {
        return this.ser.slices;
    }

    public Slice3dList getSlcf3dList() {
        return this.ser.slices3d;
    }

    public ParticleList getPartList() {
        return this.ser.particles;
    }

    public ExSpecList getExSpecList() {
        return this.ser.exSpecs;
    }

    public HvacList getHvacList() {
        return this.ser.hvacSystem;
    }

    public boolean getFdsEvacEnabled() {
        return this.ser.enableFdsEvac;
    }

    private Task taskSetFdsEvacEnabled(final boolean bl) {
        return new AUndoableTask(){

            @Override
            public void undo() {
                this.set(!bl);
            }

            @Override
            public void run() {
                this.set(bl);
            }

            private void set(boolean bl2) {
                ((PyroMod)PyroMod.this).ser.enableFdsEvac = bl2;
                PyroMod.this.getEvents().changed(PyroMod.this, EVT_FDS_EVAC_CHANGED);
            }
        };
    }

    public void setEvacEnabled(boolean bl) {
        Task task = this.taskSetFdsEvacEnabled(bl);
        String string = bl ? Intl.intl("Enable FDS+EVAC") : Intl.intl("Disable FDS+Evac");
        this.getTaskManager().exec(task, string);
    }

    public EvacList getEvacList() {
        return this.ser.evacs;
    }

    public EntrList getEntrList() {
        return this.ser.entrs;
    }

    public EvhoList getEvhoList() {
        return this.ser.evhos;
    }

    public CorrList getCorrList() {
        return this.ser.corrs;
    }

    public EvssList getEvssList() {
        return this.ser.evsss;
    }

    public ExitList getExitList() {
        return this.ser.exits;
    }

    public PersList getPersList() {
        return this.ser.perss;
    }

    public DoorList getDoorList() {
        return this.ser.doors;
    }

    public Plot3d getPlot3d() {
        return this.ser.plot3d;
    }

    public ProfList getProfList() {
        return this.ser.profs;
    }

    public StatisticMgr getMsrStatMgr() {
        return this.ser.msrStats;
    }

    public ViewMgr getViews() {
        return this.ser.views;
    }

    public MaterialDB getAppearances() {
        return this.ser.appearances;
    }

    public Surface getDefaultSurface() {
        return this.getSurfaceMgr().get(PredefSurf.INERT);
    }

    public ResultsArchive getResultsArchive() {
        return this.ser.resultsArchive;
    }

    public Collection<? extends IPyroGeomSrc> getAllGeom() {
        return Hierarchy.flatten(this.getMembers(), IPyroGeomSrc.class);
    }

    public DepSnapshot getDependencies(IPyroObject ... iPyroObjectArray) {
        return this.getDependencies(Arrays.asList(iPyroObjectArray));
    }

    public DepSnapshot getDependencies(Collection<? extends IPyroObject> collection) {
        DepSnapshot depSnapshot = new DepSnapshot(collection);
        this.collectDeps(depSnapshot);
        return depSnapshot;
    }

    private void collectDeps(DepSnapshot depSnapshot) {
        depSnapshot.start(this, this.ser);
    }

    public Object getLockObj() {
        return this.ser;
    }

    public void setLastFDSRun(FDSRun fDSRun) {
        if (!theUtil.equal(fDSRun, this.ser.lastFDSRun)) {
            this.ser.lastFDSRun = fDSRun;
            this.getEvents().changed(this, EVT_FDS_RUN_CHANGED);
        }
    }

    public FDSRun getLastFDSRun() {
        return this.ser.lastFDSRun;
    }

    public FDSClusterOptions getClusterOptions() {
        return this.ser.clusterOptions;
    }

    public void setClusterOptions(FDSClusterOptions fDSClusterOptions) {
        this.ser.clusterOptions = fDSClusterOptions;
        this.getEvents().changed(this, EVT_FDS_CLUSTER_OPTIONS_CHANGED);
    }

    public void setWriteProtected(boolean bl, byte[] byArray) {
        assert (byArray != null);
        this.ser.d_protect = bl;
        this.ser.d_protectPassHash = byArray;
    }

    public boolean isWriteProtected() {
        return this.ser.d_protect;
    }

    public byte[] getWriteProtectedPassHash() {
        return this.ser.d_protectPassHash;
    }

    @Override
    public PyroMod getDomain() {
        return this;
    }

    @Override
    public boolean changedEvt(Object ... objectArray) {
        return this.getEvents().changed(this, objectArray);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    @Override
    public void setDomain(PyroMod pyroMod) {
    }

    @Override
    public void setDomain(PyroMod pyroMod, IPyroObject iPyroObject) {
    }

    @Override
    public IPyroObject getParent() {
        return null;
    }

    @Override
    public Object clone() {
        assert (false);
        return null;
    }

    @Override
    public boolean isEquiv(Object object) {
        return this == object;
    }

    private static class NilEvents
    extends Events {
        private NilEvents() {
        }

        @Override
        public void addObserver(IEventObserver iEventObserver) {
        }

        @Override
        public void removeObserver(IEventObserver iEventObserver) {
        }

        @Override
        public void clearObservers() {
        }

        @Override
        public void resetEvents() {
        }

        public Set<EventChannel> getAffectedChannels(Class clazz, Class ... classArray) {
            return Collections.EMPTY_SET;
        }

        @Override
        public void pause() {
        }

        @Override
        public void pause(boolean bl) {
        }

        @Override
        public boolean resume() {
            return false;
        }

        @Override
        public boolean willFireOnResume() {
            return false;
        }

        @Override
        public Collection<EventChannel> getChannels() {
            return Collections.EMPTY_SET;
        }

        @Override
        public boolean added(Object object) {
            return false;
        }

        @Override
        public boolean added(Object ... objectArray) {
            return false;
        }

        @Override
        public boolean added(Collection<?> collection) {
            return false;
        }

        @Override
        public boolean removed(Object object) {
            return false;
        }

        @Override
        public boolean removed(Object ... objectArray) {
            return false;
        }

        @Override
        public boolean removed(Collection<?> collection) {
            return false;
        }

        @Override
        public boolean changed(Object object, Object ... objectArray) {
            return false;
        }

        @Override
        public boolean changed(Collection<?> collection, Object ... objectArray) {
            return false;
        }
    }

    private class PyroEvents
    extends Events {
        private PyroEvents() {
        }

        @Override
        protected void fireNotification() {
            PyroMod.this.updateGeom();
            PyroMod.this.pauseUpdates(false);
            for (EventChannel eventChannel : this.getChannels()) {
                PyroMod.this.d_selModel.deselectAll(eventChannel.getRemovedObjs());
            }
            PyroMod.this.resumeUpdates();
            PyroMod.this.d_rasterizations.update(this);
            super.fireNotification();
        }
    }

    public static class PasteOption {
        public static final int PASTE_ADD_INCOMING = 0;
        public static final int PASTE_REPLACE_EXISTING = 1;
        public static final int PASTE_KEEP_EXISTING = 2;
        public static final int PASTE_MAKE_INCOMING_UNIQUE = 3;
        public final int command;
        public final Object param;

        public PasteOption(int n, Object object) {
            this.command = n;
            this.param = object;
        }
    }
}

