/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.OpenModel;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.PyroTaskManager;
import pyrosim.mv.ModelView;
import thunderheadeng.io.CopyFile;
import thunderheadeng.util.Task;

public class OpenModelTask
implements Task,
PyroTaskManager.BypassWriteProtection {
    private final PyroSim d_pySim;
    private final PyroMod d_pyMod;
    private final String d_fn;
    private boolean d_success;
    private Throwable d_errOpenModel = null;

    public OpenModelTask(PyroSim pyroSim, PyroMod pyroMod, String string) {
        this.d_pySim = pyroSim;
        this.d_pyMod = pyroMod;
        this.d_fn = string;
        this.d_success = false;
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public void undo() {
        assert (this.canUndo());
    }

    @Override
    public int getEst() {
        return 1;
    }

    public boolean success() {
        return this.d_success;
    }

    @Override
    public void run() {
        this.d_pyMod.pauseUpdates();
        OpenModel.Callbacks callbacks = new OpenModel.Callbacks(){

            @Override
            public void setSnapToSpacing(double d) {
                OpenModelTask.this.d_pySim.setSnapToSpacing(d);
            }

            @Override
            public void setShowBgImagesSelected(boolean bl) {
                OpenModelTask.this.d_pySim.get3DView().getShowBGImagesAction().setSelected(bl);
            }

            @Override
            public void setError(Throwable throwable) {
                OpenModelTask.this.d_errOpenModel = throwable;
            }

            @Override
            public void setActiveSnapper(int n) {
                OpenModelTask.this.d_pySim.getModelView().setActiveSnapper(n);
            }

            @Override
            public void setModelViewFilters(ModelView.ModelViewFilterProps modelViewFilterProps) {
                OpenModelTask.this.d_pySim.getModelView().setViewFilters(modelViewFilterProps);
            }

            @Override
            public boolean doBackup() {
                return OpenModelTask.this.doBackup(OpenModelTask.this.d_fn);
            }

            @Override
            public boolean confirmOpenUnsupported(int n) {
                return OpenModelTask.this.confirmOpenUnsupported(n);
            }
        };
        int n = OpenModel.openModel(this.d_pyMod, new File(this.d_fn), true, callbacks);
        if (n == 0) {
            this.commitOpen();
            this.d_pySim.getBackup().createBackupFile(this.d_fn);
            this.d_success = true;
        } else if (n == 3) {
            this.showError(String.format(Intl.intl("Could not open %s.  The file was made with a newer version of PyroSim."), this.d_fn));
        } else if (n == 2) {
            this.showError(String.format(Intl.intl("Could not open %s.  The file was made with an old version of PyroSim."), this.d_fn));
        } else if (n == 4 || n == 6) {
            if (this.d_errOpenModel != null) {
                this.d_errOpenModel.printStackTrace();
            }
            File file = this.d_pySim.getBackup().getBackupFile(this.d_fn);
            String string = "";
            if (n == 4) {
                string = "The file may be corrupt.";
            } else if (n == 6) {
                string = "The file could not be found.";
            }
            if (file == null) {
                this.showError(String.format(Intl.intl("Could not open %s.  %s"), this.d_fn, string));
            } else {
                int n2 = JOptionPane.showConfirmDialog(PyroSim.getApp().getActiveFrame(), String.format(Intl.intl("Could not open %s.  %s\nWould you like to open the backup file, %s?"), this.d_fn, string, file.getAbsolutePath()), Intl.intl("Open Backup File?"), 0);
                if (n2 == 0) {
                    new OpenModelTask(this.d_pySim, this.d_pyMod, file.getAbsolutePath()).run();
                }
            }
        }
        System.gc();
        this.d_pySim.savePreferences();
        this.d_pyMod.resumeUpdates();
    }

    private void showError(String string) {
        JFrame jFrame = this.d_pySim.getActiveFrame();
        JOptionPane.showMessageDialog(jFrame, string, Intl.intl("File Error"), 0);
    }

    private void commitOpen() {
        boolean bl = this.d_pySim.getBackup().isReservedPath(this.d_fn);
        this.d_pySim.setFilename(this.d_fn, bl);
        if (!bl) {
            this.d_pySim.getMRUMenu().usedFile(this.d_fn);
        }
        this.d_pyMod.getEvents().changed(this.d_pyMod, PyroMod.EVT_FILENAME_CHANGED, PyroMod.EVT_MODEL_CHANGED);
    }

    private boolean confirmOpenUnsupported(int n) {
        String string = String.format(Intl.intl("Unsupported Version (%d)"), n);
        String string2 = Intl.intl("This model was made with a version of PyroSim that is not supported.\nData may be lost during the conversion process, subtle errors may appear\nin the model, and PyroSim may crash.\n\nAttempt to load unsupported data?");
        JFrame jFrame = this.d_pySim.getActiveFrame();
        int n2 = JOptionPane.showConfirmDialog(jFrame, string2, string, 2);
        return n2 == 0;
    }

    private boolean doBackup(String string) {
        String string2 = Intl.intl("Create Backup File");
        String string3 = Intl.intl("This model was made with a previous version of PyroSim.\nSome data may be lost during the conversion process.\nWould you like to create a backup of the original data?");
        JFrame jFrame = this.d_pySim.getActiveFrame();
        int n = JOptionPane.showConfirmDialog(jFrame, string3, string2, 1);
        if (n == 0) {
            File file = new File(string);
            File file2 = new File(string + ".bak");
            try {
                CopyFile.copy(file, file2);
                String string4 = Intl.intl("Success");
                String string5 = Intl.intl("Backup created: " + file2.getName());
                int n2 = 1;
                JOptionPane.showMessageDialog(jFrame, string5, string4, n2);
                return true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                String string6 = Intl.intl("Error");
                String string7 = Intl.intl("PyroSim has encountered an error while trying to \ncreate the backup file.  Open operation aborted. \nError details:\n") + iOException.getLocalizedMessage();
                int n3 = 2;
                JOptionPane.showMessageDialog(jFrame, string7, string6, n3);
                return false;
            }
        }
        return n == 1;
    }
}

