/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.output.AMeasurementSet;
import pyrosim.gui.actions.Actions;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.thunderheadeng.util.Warning;
import pyrosim.mv.ModelView;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.util.WarningReport;

public class OpenModel {
    public static final int SUCCEEDED = 0;
    public static final int CANCELLED = 1;
    public static final int TOO_OLD = 2;
    public static final int TOO_NEW = 3;
    public static final int FAILED = 4;
    public static final int UNSUPPORTED = 5;
    public static final int NO_EXIST = 6;

    private static InputStream createFileStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static int openModel(pyrosim.PyroMod pyroMod, File file, boolean bl, Callbacks callbacks) {
        System.out.println(String.format("Opening file: %s", file.getPath()));
        if (!file.exists()) {
            return 6;
        }
        try {
            String[] stringArray = new String[]{Intl.intl("Record"), Intl.intl("Action")};
            WarningReport<thunderheadeng.util.Warning> warningReport = new WarningReport<thunderheadeng.util.Warning>(thunderheadeng.util.Warning.class, thunderheadeng.util.Warning.getWarningInfoTypes(), stringArray, 0);
            int n = OpenModel.openCurrentModel(pyroMod, OpenModel.createFileStream(file), warningReport, bl, callbacks);
            if (n == 2 && (n = OpenModel.openLegacyModel_2012_1(pyroMod, OpenModel.createFileStream(file), warningReport, bl, callbacks)) == 2) {
                n = OpenModel.openLegacyModel_2006_2(pyroMod, OpenModel.createFileStream(file), warningReport, bl, callbacks);
            }
            if (!warningReport.isEmpty()) {
                if (bl) {
                    WarningDlg<thunderheadeng.util.Warning> warningDlg = new WarningDlg<thunderheadeng.util.Warning>((Window)PyroSim.getApp().getActiveFrame(), Intl.intl("File Conversion Warnings"), Intl.intl("Please review the following items in your updated model to verify proper conversion."), warningReport);
                    warningDlg.doModal();
                } else {
                    System.out.println("Warnings:\n" + warningReport.prepareReport());
                }
            }
            return n;
        }
        catch (Throwable throwable) {
            callbacks.setError(throwable);
            System.err.println(throwable.getMessage());
            if (throwable instanceof NullPointerException) {
                throwable.printStackTrace();
            }
            return 4;
        }
    }

    private static int openCurrentModel(pyrosim.PyroMod pyroMod, InputStream inputStream, WarningReport warningReport, boolean bl, Callbacks callbacks) throws Throwable {
        PyroSimObjectInputStream pyroSimObjectInputStream = null;
        try {
            pyroSimObjectInputStream = new PyroSimObjectInputStream(inputStream);
            if (!pyroSimObjectInputStream.canOpenVersion()) {
                int n = 2;
                return n;
            }
            if (pyroSimObjectInputStream.isNewer()) {
                int n = 3;
                return n;
            }
            if (!pyroSimObjectInputStream.isSupported() && !callbacks.confirmOpenUnsupported(pyroSimObjectInputStream.getVersion())) {
                int n = 5;
                return n;
            }
            pyroMod.openModel(pyroSimObjectInputStream, !bl);
            OpenModel.postRead(pyroSimObjectInputStream, pyroSimObjectInputStream.getVersion(), callbacks);
            int n = 0;
            return n;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (pyroSimObjectInputStream != null) {
                try {
                    pyroSimObjectInputStream.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private static int openLegacyModel_2006_2(pyrosim.PyroMod pyroMod, InputStream inputStream, WarningReport warningReport, boolean bl, Callbacks callbacks) throws Throwable {
        pyrosim.legacy_2006_2.PyroSimObjectInputStream pyroSimObjectInputStream = null;
        try {
            pyroSimObjectInputStream = new pyrosim.legacy_2006_2.PyroSimObjectInputStream(inputStream);
            if (!pyroSimObjectInputStream.canOpenVersion()) {
                int n = 3;
                return n;
            }
            if (!callbacks.doBackup()) {
                int n = 1;
                return n;
            }
            System.out.println("Reading legacy 2006.2 file...");
            pyrosim.legacy_2006_2.PyroMod pyroMod2 = new pyrosim.legacy_2006_2.PyroMod();
            pyroMod2.openModel(pyroSimObjectInputStream, bl);
            System.out.println("Converting legacy 2006.2 file...");
            File file = null;
            if (Application.getApp() != null) {
                file = new File(Application.getApp().getInstallDir(), "fds");
            }
            for (thunderheadeng.util.Warning warning : pyroSimObjectInputStream.getWarnings().getWarnings()) {
                warningReport.addWarning(warning);
            }
            pyroMod.fromLegacy(file, pyroMod2, (WarningReport<thunderheadeng.util.Warning>)warningReport);
            OpenModel.postRead(pyroSimObjectInputStream, pyroSimObjectInputStream.getVersion(), callbacks);
            int n = 0;
            return n;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw throwable;
        }
        finally {
            if (pyroSimObjectInputStream != null) {
                try {
                    pyroSimObjectInputStream.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private static int openLegacyModel_2012_1(pyrosim.PyroMod pyroMod, InputStream inputStream, WarningReport warningReport, boolean bl, Callbacks callbacks) throws Throwable {
        ObjectInputStream objectInputStream = null;
        try {
            Object object222;
            HashSet<String> hashSet = new HashSet<String>();
            for (Object object222 : pyroMod.getAppearances().flatten()) {
                hashSet.add(((NamedPyroObject)object222).getName());
            }
            objectInputStream = new pyrosim.legacy_2012_1.io.PyroSimObjectInputStream(inputStream, hashSet);
            if (!((pyrosim.legacy_2012_1.io.PyroSimObjectInputStream)objectInputStream).canOpenVersion()) {
                int n = 2;
                return n;
            }
            if (((pyrosim.legacy_2012_1.io.PyroSimObjectInputStream)objectInputStream).isNewer()) {
                int n = 3;
                return n;
            }
            if (!callbacks.doBackup()) {
                int n = 1;
                return n;
            }
            System.out.println("Reading legacy 2012.1 file...");
            PyroMod pyroMod2 = new PyroMod();
            pyroMod2.openModel((pyrosim.legacy_2012_1.io.PyroSimObjectInputStream)objectInputStream, !bl);
            for (Warning object3 : ((pyrosim.legacy_2012_1.io.PyroSimObjectInputStream)objectInputStream).getWarnings().getWarnings()) {
                warningReport.addWarning(new thunderheadeng.util.Warning(object3.getWarning(), object3.getActionTaken()));
            }
            System.out.println("Converting legacy 2012.1 file...");
            object222 = Application.getApp() != null ? new File(Application.getApp().getInstallDir(), "fds") : null;
            pyrosim.PyroMod pyroMod3 = new pyrosim.PyroMod(false);
            pyroMod3.fromLegacy((File)object222, pyroMod2, (WarningReport<thunderheadeng.util.Warning>)warningReport);
            OpenModel.validateDisabledStatus(pyroMod3, warningReport);
            pyroMod.setSerialized(pyroMod3);
            OpenModel.postRead(objectInputStream, ((pyrosim.legacy_2012_1.io.PyroSimObjectInputStream)objectInputStream).getVersion(), callbacks);
            int n = 0;
            return n;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private static void validateDisabledStatus(pyrosim.PyroMod pyroMod, WarningReport warningReport) {
        Predicate<IPyroObject> predicate = new Predicate<IPyroObject>(){

            @Override
            public boolean test(IPyroObject iPyroObject) {
                return !iPyroObject.isEnabled() && !(iPyroObject instanceof AMeasurementSet);
            }
        };
        Collection<IPyroObject> collection = Hierarchy.flatten(pyroMod.getMembers(), IPyroObject.class, predicate);
        DepSnapshot depSnapshot = pyroMod.getDependencies(new IPyroObject[0]);
        for (IPyroObject iPyroObject : collection) {
            if (!Actions.isObjectInUse(pyroMod, Arrays.asList(iPyroObject), depSnapshot)) continue;
            String string = iPyroObject instanceof NamedPyroObject ? "\"" + ((NamedPyroObject)iPyroObject).getName() + "\"" : "" + iPyroObject.hashCode();
            String string2 = String.format(Intl.intl("%s: %s is disabled, but is also in use."), iPyroObject.getClass().getSimpleName(), string);
            warningReport.addWarning(new thunderheadeng.util.Warning(string2, Intl.intl("Object enabled.")));
            iPyroObject.setEnabled(true);
        }
    }

    private static void postRead(ObjectInputStream objectInputStream, int n, Callbacks callbacks) throws IOException, ClassNotFoundException {
        Serializable serializable;
        if (n >= 7) {
            double d = objectInputStream.readDouble();
            callbacks.setSnapToSpacing(d);
        }
        boolean bl = true;
        if (n >= 11) {
            bl = objectInputStream.readBoolean();
        }
        callbacks.setShowBgImagesSelected(bl);
        int n2 = 1;
        if (n >= 18 && objectInputStream instanceof pyrosim.legacy_2006_2.PyroSimObjectInputStream) {
            serializable = (pyrosim.legacy_2006_2.domain.Grid)objectInputStream.readObject();
            int n3 = n2 = serializable == null ? 1 : 2;
        }
        if (n > 19) {
            n2 = objectInputStream instanceof pyrosim.legacy_2012_1.io.PyroSimObjectInputStream && ((pyrosim.legacy_2012_1.io.PyroSimObjectInputStream)objectInputStream).getVersion() < 29 ? ((serializable = (Grid)objectInputStream.readObject()) == null ? 1 : 2) : objectInputStream.readInt();
        }
        callbacks.setActiveSnapper(n2);
        serializable = new ModelView.ModelViewFilterProps();
        if (n > 92 && objectInputStream instanceof PyroSimObjectInputStream) {
            serializable = (ModelView.ModelViewFilterProps)objectInputStream.readObject();
        }
        callbacks.setModelViewFilters((ModelView.ModelViewFilterProps)serializable);
    }

    public static interface Callbacks {
        public void setError(Throwable var1);

        public boolean doBackup();

        public void setSnapToSpacing(double var1);

        public void setShowBgImagesSelected(boolean var1);

        public void setActiveSnapper(int var1);

        public void setModelViewFilters(ModelView.ModelViewFilterProps var1);

        public boolean confirmOpenUnsupported(int var1);
    }
}

