/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pyrosim.Intl;
import pyrosim.Version;

public class FDSVersion
implements Comparable<FDSVersion> {
    private static final Pattern PATTERN_V612 = Pattern.compile(" Version          : FDS ([0-9]).([0-9]).([0-9])");
    public static final FDSVersion V5_0_0 = new FDSVersion(5, 0, 0, 0);
    public static final FDSVersion V5_5_0 = new FDSVersion(5, 5, 0, 0);
    public static final FDSVersion V5_5_2 = new FDSVersion(5, 5, 2, 0);
    public static final FDSVersion V5_5_3 = new FDSVersion(5, 5, 3, 0);
    public static final FDSVersion V6_0_0_3 = new FDSVersion(6, 0, 0, 3);
    public static final FDSVersion V6_0_0 = new FDSVersion(6, 0, 0, 0);
    public static final FDSVersion V6_0_1 = new FDSVersion(6, 0, 1, 0);
    public static final FDSVersion V6_1_0 = new FDSVersion(6, 1, 0, 0);
    public static final FDSVersion V6_1_1 = new FDSVersion(6, 1, 1, 0);
    public static final FDSVersion V6_1_2 = new FDSVersion(6, 1, 2, 0);
    public static final FDSVersion V6_2_0 = new FDSVersion(6, 2, 0, 0);
    public static final FDSVersion V6_3_0 = new FDSVersion(6, 3, 0, 0);
    public static final FDSVersion V6_3_1 = new FDSVersion(6, 3, 1, 0);
    public static final FDSVersion V6_3_2 = new FDSVersion(6, 3, 2, 0);
    public static final FDSVersion V6_4_0 = new FDSVersion(6, 4, 0, 0);
    public static final FDSVersion V6_5_1 = new FDSVersion(6, 5, 1, 0);
    public static final FDSVersion V6_5_3 = new FDSVersion(6, 5, 3, 0);
    public static final FDSVersion V6_6_0 = new FDSVersion(6, 6, 0, 0);
    public static final FDSVersion V6_7_0 = new FDSVersion(6, 7, 0, 0);
    public final int major;
    public final int minor;
    public final int maintenance;
    public final int rc;

    public static Collection<FDSVersion> getSupported() {
        return Arrays.asList(Version.FDS_DESIGN);
    }

    public FDSVersion(int n, int n2, int n3, int n4) {
        this.major = n;
        this.minor = n2;
        this.maintenance = n3;
        this.rc = n4;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FDSVersion)) {
            return false;
        }
        FDSVersion fDSVersion = (FDSVersion)object;
        return fDSVersion.major == this.major && fDSVersion.minor == this.minor && fDSVersion.maintenance == this.maintenance && fDSVersion.rc == this.rc;
    }

    @Override
    public int compareTo(FDSVersion fDSVersion) {
        if (this.major == fDSVersion.major) {
            if (this.minor == fDSVersion.minor) {
                if (this.maintenance == fDSVersion.maintenance) {
                    return this.rc - fDSVersion.rc;
                }
                return this.maintenance - fDSVersion.maintenance;
            }
            return this.minor - fDSVersion.minor;
        }
        return this.major - fDSVersion.major;
    }

    public static FDSVersion parse(String string) throws ParseException {
        Matcher matcher = PATTERN_V612.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(string3);
            int n3 = Integer.parseInt(string4);
            return new FDSVersion(n, n2, n3, 0);
        }
        if (string.startsWith("Version:")) {
            int n = string.indexOf(59);
            String string5 = string.substring(9, n).trim().toLowerCase();
            boolean bl = (string5 = string5.replace("fds", "")).contains("release candidate");
            if (bl) {
                string5 = string5.replace("release candidate", "");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string5, " ,.;");
            ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayDeque.add(stringTokenizer.nextToken());
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            n4 = Integer.parseInt((String)arrayDeque.removeFirst());
            if (bl) {
                n7 = Integer.parseInt((String)arrayDeque.removeLast());
            }
            if (!arrayDeque.isEmpty()) {
                n5 = Integer.parseInt((String)arrayDeque.removeFirst());
            }
            if (!arrayDeque.isEmpty()) {
                n6 = Integer.parseInt((String)arrayDeque.removeFirst());
            }
            return new FDSVersion(n4, n5, n6, n7);
        }
        throw new ParseException(Intl.intl("Could not parse FDS version."), 0);
    }

    public String toString() {
        if (this.rc == 0) {
            return String.format("Version %d.%d.%d", this.major, this.minor, this.maintenance);
        }
        if (this.minor == 0 && this.maintenance == 0) {
            return String.format("Version %d RC%d", this.major, this.rc);
        }
        if (this.maintenance == 0) {
            return String.format("Version %d.%d RC%d", this.major, this.minor, this.rc);
        }
        return String.format("Version %d.%d.%d RC%d", this.major, this.minor, this.maintenance, this.rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FDSVersion detectCompability(File file, int n) throws IOException {
        if (!file.exists()) {
            throw new IOException(String.format(Intl.intl("File not found: %s"), file.getAbsolutePath()));
        }
        try {
            String[] stringArray = new String[]{file.getAbsolutePath()};
            Process process = Runtime.getRuntime().exec(stringArray);
            FDSVersion[] fDSVersionArray = new FDSVersion[]{null};
            TextMonitor textMonitor = new TextMonitor(fDSVersionArray, process.getErrorStream());
            TextMonitor textMonitor2 = new TextMonitor(fDSVersionArray, process.getInputStream());
            textMonitor.start();
            textMonitor2.start();
            FDSVersion[] fDSVersionArray2 = fDSVersionArray;
            synchronized (fDSVersionArray) {
                if (fDSVersionArray[0] == null) {
                    try {
                        fDSVersionArray.wait(n);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                // ** MonitorExit[var7_9] (shouldn't be in output)
                if (fDSVersionArray[0] == null) {
                    if (textMonitor.d_caughtException != null) {
                        throw textMonitor.d_caughtException;
                    }
                    if (textMonitor2.d_caughtException != null) {
                        throw textMonitor2.d_caughtException;
                    }
                    throw new IOException(String.format(Intl.intl("Could not determine FDS version from executable: %n%s."), file.getAbsoluteFile()));
                }
                return fDSVersionArray[0];
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception.getLocalizedMessage());
        }
    }

    private static class TextMonitor
    extends Thread {
        private final FDSVersion[] d_result;
        private final InputStream d_stream;
        private IOException d_caughtException;

        public TextMonitor(FDSVersion[] fDSVersionArray, InputStream inputStream) {
            this.d_result = fDSVersionArray;
            this.d_stream = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                String string;
                FDSVersion[] fDSVersionArray = new InputStreamReader(this.d_stream);
                BufferedReader bufferedReader = new BufferedReader((Reader)fDSVersionArray);
                while (this.d_result[0] == null && (string = bufferedReader.readLine()) != null) {
                    try {
                        FDSVersion fDSVersion;
                        this.d_result[0] = fDSVersion = FDSVersion.parse(string);
                        return;
                    }
                    catch (Exception exception) {
                        if (string == null || string.trim().length() == 0) continue;
                        stringBuilder.append(String.format("%s: %s (%s)%n", exception.getClass().getName(), exception.getMessage(), string));
                    }
                }
                if (this.d_result[0] != null) return;
            }
            catch (IOException iOException) {
                if (stringBuilder.length() == 0) {
                    System.err.printf("%s: %s%n", iOException.getClass().getName(), iOException.getMessage());
                } else {
                    System.err.println(stringBuilder.toString());
                }
                this.d_caughtException = iOException;
                return;
            }
            finally {
                FDSVersion[] fDSVersionArray = this.d_result;
                synchronized (this.d_result) {
                    try {
                        this.d_result.notify();
                    }
                    catch (Exception exception) {}
                }
            }
            throw new IOException("Unable to detect version.");
        }
    }
}

