/*
 * Decompiled with CFR 0.152.
 */
package montecarlo;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.montecarlo.SimulationInputList;
import org.apache.commons.io.FileUtils;

public class CleanResults {
    public static void main(String[] args) throws Exception {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException("Simulation list is required.");
            }
            File file = new File(args[0]).getAbsoluteFile();
            SimulationInputList simulations = null;
            try (FileReader fileReader = new FileReader(file);
                 BufferedReader bufferedReader = new BufferedReader(fileReader);){
                Gson gson = new Gson();
                simulations = gson.fromJson((Reader)bufferedReader, SimulationInputList.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not parse simulation list");
            }
            Path outputDir = file.getParentFile().toPath();
            System.out.println(Intl.intl("WARNING: This will delete all subdirectories and PTH files in this directory that were not created by the last simulation. Press ENTER to continue, or exit to cancel."));
            Scanner scanner = new Scanner(System.in);
            scanner.nextLine();
            System.out.println(Intl.intl("Cleaning results..."));
            CleanResults.cleanResults(simulations, outputDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void cleanResults(SimulationInputList simulations, Path outputDir) throws Exception {
        Set allowedPthFiles = simulations.streamRunningVariations().map(var -> outputDir.resolve(var.inputFile())).collect(Collectors.toSet());
        Set allowedDirectories = simulations.streamRunningVariations().mapMulti((var, consumer) -> {
            consumer.accept(outputDir.resolve(var.inputFile()).getParent());
            consumer.accept(outputDir.resolve(var.resultsFile()).getParent());
        }).collect(Collectors.toSet());
        try (Stream<Path> tree = Files.walk(outputDir, new FileVisitOption[0]);){
            tree.forEach(file -> {
                try {
                    if ((Files.isDirectory(file, new LinkOption[0]) && !allowedDirectories.contains(file) || Files.isRegularFile(file, new LinkOption[0]) && file.toString().endsWith(".pth") && !allowedPthFiles.contains(file)) && !Files.isSameFile(file, outputDir) && !FileUtils.deleteQuietly(file.toFile())) {
                        throw new RuntimeException(String.format(Intl.intl("Could not delete file %s."), file));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

