/*
 * Decompiled with CFR 0.152.
 */
package merlin.util;

import java.awt.Component;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;

public class MerlinSelectionLogic {
    public void handleSelectionSingle(MerlinApp app, MerlinData data, Component owner, Point ptScreen, boolean addToSel, boolean selectParent, boolean editObjs, boolean showMeta, Collection<? extends Object> hitObjs) {
        try (MerlinData.WriteLock lock = data.lockWrite();){
            Object selObj = null;
            if (!hitObjs.isEmpty()) {
                selObj = hitObjs.iterator().next();
            }
            if (!showMeta || showMeta && (selObj == null || !data.selection.isSelected(selObj))) {
                this.handleSelection(addToSel, selectParent, Arrays.asList(selObj));
            }
        }
        if (showMeta) {
            this.showContextMenu(app, data, owner, ptScreen);
        }
    }

    public void handleSelectionMultiple(MerlinApp app, MerlinData data, Component owner, Point ptScreen, boolean addToSel, boolean selectParent, boolean editObjs, boolean showMeta, Collection<?> hitObjs) {
        try (MerlinData.WriteLock lock = data.lockWrite();){
            this.handleSelection(addToSel, selectParent, hitObjs);
        }
        if (showMeta) {
            this.showContextMenu(app, data, owner, ptScreen);
        }
    }

    private void showContextMenu(MerlinApp app, MerlinData md, Component owner, Point ptScreen) {
        JPopupMenu menu = MerlinApp.getContextMenu();
        if (menu != null) {
            md.ui(() -> {
                Point pt = new Point(ptScreen.x, ptScreen.y);
                SwingUtilities.convertPointFromScreen(pt, owner);
                menu.show(owner, pt.x, pt.y);
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleSelection(boolean addToSel, boolean selectParent, Collection<? extends Object> objs) {
        Undo.begin(Intl.intl("Select Objects"));
        MerlinData data = MerlinApp.getApp().getData();
        boolean modified = false;
        Undo.insertUndoEntry_restoreSelection(data);
        if (!addToSel) {
            if (!data.selection.isEmpty()) {
                modified = true;
            }
            data.selection.clear();
        }
        if (objs != null) {
            IdentityHashSet<? extends Object> hitObjs = new IdentityHashSet<Object>(objs);
            LinkedIdentityHashSet objsToSelect = new LinkedIdentityHashSet();
            LinkedIdentityHashSet objsToDeselect = new LinkedIdentityHashSet();
            for (Object object : objs) {
                void var10_10;
                Object parent;
                if (object == null) continue;
                boolean select = true;
                if (selectParent && (parent = data.hierarchy.getParent(object)) != null) {
                    Object object2 = parent;
                }
                if (addToSel) {
                    Object[] pathFromRoot = data.hierarchy.getPath(var10_10);
                    pathFromRoot = Arrays.copyOf(pathFromRoot, pathFromRoot.length - 1);
                    boolean foundSelectedParent = false;
                    if (pathFromRoot != null && !selectParent) {
                        for (int j = 0; j < pathFromRoot.length; ++j) {
                            if (!foundSelectedParent && !data.selection.isSelected(pathFromRoot[j])) continue;
                            foundSelectedParent = true;
                            objsToSelect.remove(pathFromRoot[j]);
                            objsToDeselect.add(pathFromRoot[j]);
                            for (Object member : data.hierarchy.getChildren(pathFromRoot[j])) {
                                if ((j >= pathFromRoot.length - 1 || member == pathFromRoot[j + 1]) && (j != pathFromRoot.length - 1 || hitObjs.contains(member))) continue;
                                objsToDeselect.remove(member);
                                objsToSelect.add(member);
                            }
                        }
                        select = false;
                    }
                    if (!foundSelectedParent) {
                        boolean bl = select = !data.selection.isSelected(var10_10);
                    }
                }
                if (select) {
                    objsToDeselect.remove(var10_10);
                    objsToSelect.add(var10_10);
                    continue;
                }
                objsToSelect.remove(var10_10);
                objsToDeselect.add(var10_10);
            }
            if (!objsToSelect.isEmpty() || !objsToDeselect.isEmpty()) {
                modified = true;
                data.selection.deselectAll(objsToDeselect);
                data.selection.selectAll(objsToSelect);
            }
        }
        Undo.end(data, modified);
    }
}

