/*
 * Decompiled with CFR 0.152.
 */
package merlin.util;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import merlin.EntryPointFactory;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.scenario.Scenario;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DepSnapshot;
import thunderheadeng.geometry.nmt.AModelObj;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class MerlinDepSnapshot
extends DepSnapshot<MerlinData> {
    public static final Predicate<? super Scenario> ACTIVE_SCENARIO = Filters.rejectAll();
    public static final Predicate<? super Scenario> ALL_SCENARIOS = Filters.acceptAll();

    public MerlinDepSnapshot(MerlinData md, Predicate<? super Scenario> scenarios) {
        this(md, scenarios, Predicates.alwaysTrue());
    }

    public MerlinDepSnapshot(MerlinData md, Predicate<? super Scenario> scenarios, Collection<?> interestingDepOns) {
        this(md, scenarios, MerlinDepSnapshot.accept(interestingDepOns));
    }

    public MerlinDepSnapshot(MerlinData md, Predicate<? super Scenario> scenarios, Predicate<Object> interestingDepOns) {
        super(md, (DepSnapshot.ICallback)new Callback(md, obj -> {
            Scenario scenario;
            return !(obj instanceof Scenario) || scenarios.test(scenario = (Scenario)obj);
        }), interestingDepOns);
    }

    private record Callback(MerlinData d_data, Predicate<Object> childFilter) implements DepSnapshot.ICallback
    {
        @Override
        public Iterable<?> getChildren(Object obj) {
            if (obj instanceof IMerlinObj) {
                IMerlinObj mobj = (IMerlinObj)obj;
                return theUtil.filter(mobj.getChildren(), Object.class, this.childFilter);
            }
            return Collections.emptyList();
        }

        @Override
        public boolean isSkippable(Class<?> clazz) {
            return UnitDouble.class.isAssignableFrom(clazz) || Unit.class.isAssignableFrom(clazz) || IGeom.class.isAssignableFrom(clazz) || IGeomNode.class.isAssignableFrom(clazz) || IElemSource.class.isAssignableFrom(clazz) || IPropsSrc.class.isAssignableFrom(clazz) || Model.class.isAssignableFrom(clazz) || AModelObj.class.isAssignableFrom(clazz);
        }

        @Override
        public boolean getDomainRequiresAtLeastOne(Object o) {
            return EntryPointFactory.get(o).getDomainRequiredType(this.d_data, o) != null;
        }
    }
}

