/*
 * Decompiled with CFR 0.152.
 */
package merlin.treeview;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.treeview.Model;
import merlin.treeview.Util;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;

public class SelectionHandler
implements TreeSelectionListener {
    private final MerlinData d_data;
    private final TreeSelectionModel d_tsm;
    private final Model d_ptm;
    private final Semaphore d_sema;

    public SelectionHandler(MerlinData md, TreeSelectionModel tsm, Model model) {
        this.d_data = md;
        this.d_tsm = tsm;
        this.d_ptm = model;
        this.d_sema = new Semaphore(1);
        tsm.addTreeSelectionListener(this);
    }

    public boolean lock() {
        return this.d_sema.tryAcquire();
    }

    public void unlock() {
        this.d_sema.release();
    }

    private boolean isSelectable(Object obj) {
        return this.d_data.selection.isSelected(obj) && !Util.objectsParentIsSelected(this.d_data, obj);
    }

    public void update(Events events) {
        if (!this.lock()) {
            return;
        }
        ArrayList<Object> addedSel = new ArrayList<Object>();
        ArrayList<Object> removedSel = new ArrayList<Object>();
        for (EventChannel<Object> channel : events.getAffectedChannels(Object.class, new Class[0])) {
            for (Object o : channel.getChangedObjs(MerlinData.SELECTION_CHANGED)) {
                if (this.d_data.selection.isSelected(o) && !Util.objectsParentIsSelected(this.d_data, o)) {
                    addedSel.add(o);
                    continue;
                }
                removedSel.add(o);
            }
            for (Object o : channel.getRemovedObjs()) {
                if (this.d_data.selection.isSelected(o)) continue;
                removedSel.add(o);
            }
            for (Object o : channel.getAddedObjs()) {
                if (!this.isSelectable(o)) continue;
                addedSel.add(o);
            }
            for (Object o : channel.getChangedObjs(MerlinData.PARENT_CHANGED)) {
                if (!this.isSelectable(o)) continue;
                addedSel.add(o);
            }
        }
        if (addedSel.isEmpty() && removedSel.isEmpty()) {
            this.unlock();
            return;
        }
        TreePath[] removedPaths = this.d_ptm.getPaths(removedSel);
        TreePath[] addedPaths = this.d_ptm.getPaths(addedSel);
        this.d_tsm.removeSelectionPaths(removedPaths);
        this.d_tsm.addSelectionPaths(addedPaths);
        this.unlock();
    }

    @Override
    public void valueChanged(final TreeSelectionEvent evt) {
        if (this.d_ptm.isDragging()) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                TreePath[] changedNodes = evt.getPaths();
                if (changedNodes.length == 0) {
                    return;
                }
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    Object treeObj;
                    int i;
                    Undo.begin(Intl.intl("Select Objects"));
                    Undo.insertUndoEntry_restoreSelection(md);
                    for (i = 0; i < changedNodes.length; ++i) {
                        assert (changedNodes[i] != null);
                        treeObj = changedNodes[i].getLastPathComponent();
                        if (evt.isAddedPath(i) || Util.objectsParentIsSelected(SelectionHandler.this.d_data, treeObj)) continue;
                        SelectionHandler.this.d_data.selection.deselect(treeObj);
                    }
                    for (i = 0; i < changedNodes.length; ++i) {
                        assert (changedNodes[i] != null);
                        treeObj = changedNodes[i].getLastPathComponent();
                        if (!evt.isAddedPath(i)) continue;
                        SelectionHandler.this.d_data.selection.select(treeObj);
                    }
                    Undo.end(md);
                }
            }
        };
        UIHook.run(UIHook.getComponent(evt), "merlin.treeview.SelectionHandler.valueChanged", op, 0);
        this.unlock();
    }
}

