/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools.behaviors;

import java.awt.Component;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.builders.GotoActionBuilder;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.Geometry;
import merlin.mv.ModelView;
import merlin.mv.tools.RoomLocFunc;
import merlin.mv.tools.behaviors.BehaviorActionTool;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class GotoWaypointTool
extends BehaviorActionTool<GotoActionBuilder> {
    public GotoWaypointTool(ModelView mv) {
        super(mv, new RoomLocFunc<GotoWaypointTool>((tool, room, normal, loc) -> ((GotoActionBuilder)tool.props()).setWaypointDest((IEgressOccupiable)room, (Vector3d)normal, new UnitPoint3D((Point3d)loc, Geometry.LENGTH_UNIT)), tool -> {
            Point3d p0 = ((GotoActionBuilder)tool.props()).getDestLoc().getPoint3dValue(Geometry.LENGTH_UNIT);
            Vector3d roomNorm = ((GotoActionBuilder)tool.props()).getRoomNormal();
            return new Plane3d(roomNorm, p0);
        }, (tool, p1) -> {
            if (tool.isWaypoint()) {
                Point3d p0 = ((GotoActionBuilder)tool.props()).getDestLoc().getPoint3dValue(Geometry.LENGTH_UNIT);
                double dist = p0.distance((Point3d)p1);
                ((GotoActionBuilder)tool.props()).setArriveRadius(new UnitDouble(dist, Geometry.LENGTH_UNIT));
            }
        }, (tool, comp) -> {
            if (tool.isWaypoint() && ((GotoActionBuilder)tool.props()).isValid()) {
                ((GotoActionBuilder)tool.props()).commit((Component)comp);
                tool.finish();
            }
        }));
        this.clearSnapInfo();
    }

    private boolean isWaypoint() {
        return ((GotoActionBuilder)this.props()).getType() == GotoActionBuilder.Type.WAYPOINT;
    }
}

