/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.MerlinApp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.mv.tools.RoomSnapConstraint;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.util.Pair;
import thunderheadeng.util.QuadConsumer;

public class RoomLocFunc<T extends CursorTool>
extends AToolFunction<T> {
    private boolean d_p0Set = false;
    private final Function<T, Plane3d> d_getP0Plane;
    private final QuadConsumer<T, IEgressOccupiable, Vector3d, Point3d> d_setLoc;
    private final BiConsumer<T, Component> d_createIfValid;
    private final BiConsumer<T, Point3d> d_updateDrag;

    public RoomLocFunc(QuadConsumer<T, IEgressOccupiable, Vector3d, Point3d> d_setLoc, BiConsumer<T, Component> d_createIfValid) {
        this(d_setLoc, null, null, d_createIfValid);
    }

    public RoomLocFunc(QuadConsumer<T, IEgressOccupiable, Vector3d, Point3d> d_setLoc, Function<T, Plane3d> getP0Plane, BiConsumer<T, Point3d> d_updateDrag, BiConsumer<T, Component> d_createIfValid) {
        this.d_getP0Plane = getP0Plane;
        this.d_setLoc = d_setLoc;
        this.d_createIfValid = d_createIfValid;
        this.d_updateDrag = d_updateDrag;
    }

    @Override
    public Pair<SnapMode, IIsectFilter> getSnapInfo(T tool) {
        return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter());
    }

    @Override
    public Cursor getCursor(T tool) {
        return null;
    }

    private boolean isDragModeEnabled(T tool) {
        return this.d_getP0Plane != null && this.d_updateDrag != null;
    }

    private boolean isSettingMeta(T tool) {
        return this.isDragModeEnabled(tool) && this.d_p0Set && ((CursorTool)tool).isDragging(1) && ((CursorTool)tool).dragAboveTolerance(0);
    }

    @Override
    public ISnapConstraint getSnapConstraint(T tool) {
        if (!this.isSettingMeta(tool)) {
            return new RoomSnapConstraint(MerlinApp.getAppData(), null);
        }
        Plane3d plane = this.d_getP0Plane.apply(tool);
        return new PlanarConstraint(plane);
    }

    private void updateLocation(T tool) {
        IsectInfo snap = ((CursorTool)tool).getP1().getFinalSnap();
        if (snap != null) {
            assert (snap.obj instanceof IEgressOccupiable);
            if (snap.obj instanceof IEgressOccupiable && snap.getFaceNormal != null) {
                this.d_setLoc.accept(tool, (IEgressOccupiable)snap.obj, snap.getFaceNormal.get(), snap.isectPoint);
                this.d_p0Set = true;
                return;
            }
        }
        this.d_setLoc.accept(tool, null, GeomConstants.VEC3D_ZPOS, ((CursorTool)tool).getP1().referenceSnap);
    }

    @Override
    public void mouseMoved(T tool, MouseEvent e) {
        this.updateLocation(tool);
    }

    @Override
    public void mousePressed(T tool, MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.updateLocation(tool);
    }

    @Override
    public void mouseReleased(T tool, MouseEvent e) {
        if (e.getButton() == 3) {
            ((CursorTool)tool).cancel();
            return;
        }
        if (!this.d_p0Set || e.getButton() != 1) {
            return;
        }
        this.d_createIfValid.accept(tool, e.getComponent());
        this.d_p0Set = false;
    }

    @Override
    public void mouseDragged(T tool, MouseEvent e) {
        if (!this.isSettingMeta(tool)) {
            if (!this.isDragModeEnabled(tool)) {
                this.updateLocation(tool);
            }
            return;
        }
        Point3d p1 = ((CursorTool)tool).getP1().getFinalSnapLocation();
        if (p1 != null) {
            this.d_updateDrag.accept(tool, p1);
        }
    }
}

