/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Component;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.builders.OccTargetBuilder;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.Geometry;
import merlin.mv.ModelView;
import merlin.mv.tools.MerlinTool;
import merlin.mv.tools.RoomLocFunc;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.units.UnitDouble;

public class NewSingleOccTargetTool
extends MerlinTool<OccTargetBuilder> {
    public NewSingleOccTargetTool(ModelView mv) {
        super(mv, new RoomLocFunc<NewSingleOccTargetTool>((tool, room, normal, loc) -> ((OccTargetBuilder)tool.props()).setLocation((IEgressOccupiable)room, (Vector3d)normal, (Point3d)loc), tool -> {
            Point3d p0 = ((OccTargetBuilder)tool.props()).get(OccTarget.LOCATION);
            Vector3d roomNorm = ((OccTargetBuilder)tool.props()).get(OccTarget.ROOM_NORMAL);
            return new Plane3d(roomNorm, p0);
        }, (tool, p1) -> {
            Point3d p0 = ((OccTargetBuilder)tool.props()).get(OccTarget.LOCATION);
            Vector3d dir = Util3D.vector(p0, p1);
            dir.z = 0.0;
            if (Util3D.safeNormalize(dir, 1.0E-9) != 0.0) {
                double orient = Util3D.angle(GeomConstants.VEC3D_XPOS, dir, GeomConstants.VEC3D_ZPOS);
                ((OccTargetBuilder)tool.props()).set(OccTarget.ORIENT, new UnitDouble(orient, Geometry.ANGLE_UNIT));
            }
        }, (tool, comp) -> {
            if (((OccTargetBuilder)tool.props()).isValid()) {
                ((OccTargetBuilder)tool.props()).create((Component)comp);
                tool.finish();
            }
        }));
        this.clearSnapInfo();
    }
}

