/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.builders.RectBuilder;
import merlin.mv.ModelView;
import merlin.mv.tools.ANewTwoPointTool;

public class NewRectTool<T extends RectBuilder>
extends ANewTwoPointTool<T> {
    public NewRectTool(ModelView mv) {
        super(mv);
    }

    public NewRectTool(ModelView mv, ANewTwoPointTool.Func<T> func) {
        super(mv, func);
    }

    @Override
    protected int getTolMode() {
        return 1;
    }

    @Override
    protected String getShapeName() {
        return Intl.intl("Rectangle");
    }

    @Override
    protected String getOnePointMessage(Point3d p1) {
        if (p1 != null) {
            return String.format(Intl.intl("Rectangle - First corner: %s"), this.toString(p1));
        }
        return "";
    }

    @Override
    protected String getTwoPointMessage(Point3d p1, Point3d p2) {
        if (p1 != null && p2 != null) {
            double width = Math.abs(p2.x - p1.x);
            double height = Math.abs(p2.y - p1.y);
            return String.format(Intl.intl("Rectangle - Second corner: %1$s - width=%2$s, height=%3$s"), this.toString(p2), this.toString(width), this.toString(height));
        }
        return "";
    }
}

