/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Collection;
import merlin.builders.DoorBuilder;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.mv.ModelView;
import merlin.mv.tools.MerlinTool;
import merlin.util.MerlinUtil;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapInfo;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IsectInfo;

public class NewDoorTool
extends MerlinTool<DoorBuilder> {
    private SnapInfo d_p1;

    public NewDoorTool(ModelView mv) {
        super(mv, (IToolFunction<? extends CursorTool>)new Func());
        this.setSnapInfo(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(IEgressOccupiable.class));
    }

    @Override
    public boolean cancel() {
        this.resetData();
        return super.cancel();
    }

    @Override
    public void finish() {
        this.resetData();
        super.finish();
    }

    private void resetData() {
        this.d_p1 = null;
        ((DoorBuilder)this.props()).setP2(null);
    }

    @Override
    protected void toggleModifier() {
        ((DoorBuilder)this.props()).setMaxWidth(((DoorBuilder)this.props()).getMaxWidth().negate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDoorOnePoint() {
        ((DoorBuilder)this.props()).pause();
        try {
            ((DoorBuilder)this.props()).setP2(null);
            Collection<IsectInfo> isects = this.getP1().snaps;
            for (IsectInfo ii : isects) {
                ((DoorBuilder)this.props()).setP1(MerlinUtil.getUPoint3D(ii.isectPoint));
                if (!((DoorBuilder)this.props()).isValidDoor()) continue;
                return;
            }
            ((DoorBuilder)this.props()).setP1(MerlinUtil.getUPoint3D(this.getP1().referenceSnap));
        }
        finally {
            ((DoorBuilder)this.props()).resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDoorTwoPoint() {
        ((DoorBuilder)this.props()).pause();
        try {
            if (this.d_p1 == null) {
                this.d_p1 = this.getP0();
            }
            Collection<IsectInfo> isects0 = this.d_p1.snaps;
            Collection<IsectInfo> isects1 = this.getP1().snaps;
            for (IsectInfo loc1 : isects0) {
                ((DoorBuilder)this.props()).setP1(MerlinUtil.getUPoint3D(loc1.isectPoint));
                for (IsectInfo loc2 : isects1) {
                    ((DoorBuilder)this.props()).setP2(MerlinUtil.getUPoint3D(loc2.isectPoint));
                    if (!((DoorBuilder)this.props()).isValidDoor()) continue;
                    return;
                }
            }
            ((DoorBuilder)this.props()).setP1(MerlinUtil.getUPoint3D(this.getP1().referenceSnap));
        }
        finally {
            ((DoorBuilder)this.props()).resume();
        }
    }

    protected static class Func
    extends AToolFunction<NewDoorTool> {
        protected Func() {
        }

        @Override
        public Cursor getCursor(NewDoorTool tool) {
            return null;
        }

        @Override
        public void mouseMoved(NewDoorTool tool, MouseEvent e) {
            if (!tool.isDragging()) {
                tool.createDoorOnePoint();
            }
        }

        @Override
        public void mouseDragged(NewDoorTool tool, MouseEvent e) {
            tool.createDoorTwoPoint();
        }

        @Override
        public void mousePressed(NewDoorTool tool, MouseEvent e) {
            tool.createDoorTwoPoint();
        }

        @Override
        public void mouseReleased(NewDoorTool tool, MouseEvent e) {
            ((DoorBuilder)tool.props()).pause();
            if (!tool.aboveTolerance(0)) {
                tool.createDoorOnePoint();
            }
            if (((DoorBuilder)tool.props()).isValidDoor()) {
                ((DoorBuilder)tool.props()).addDoor(e.getComponent());
            }
            ((DoorBuilder)tool.props()).resume();
            tool.finish();
        }
    }
}

