/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.event.KeyEvent;
import java.util.Collections;
import javax.swing.KeyStroke;
import merlin.Intl;
import merlin.actions.AddObject;
import merlin.actions.MerlinActionMap;
import merlin.actions.MerlinOpImpl;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.mv.ModelView;
import merlin.mv.tools.NewNavMeshRegionTool;
import merlin.util.MerlinProps;
import thunderheadeng.geometry.objs.node.IGeomNode;

public class NewBlockageTool
extends NewNavMeshRegionTool<MerlinProps> {
    public NewBlockageTool(ModelView mv, MerlinData data) {
        super(mv, data, Intl.intl("Obstacle"), Intl.intl("Click+drag to create an axis-aligned block obstacle or single-click multiple points to create a polygonal obstacle."), Intl.intl("Release to create an axis-aligned block obstacle."), Intl.intl("Continue left-clicking to add more points, or right-click to close the polygon and create the obstacle."), (props, shape) -> {
            MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    Undo.begin(Intl.intl("Add Obstacle"));
                    String blockageName = md.blockageNameGen.getCurrentName();
                    EgressBlockage blockage = new EgressBlockage(blockageName);
                    blockage.setSearchGeom((IGeomNode)shape);
                    AddObject.add(md, md.blockages, Collections.singleton(blockage));
                    md.blockageNameGen.nextName();
                    Undo.end(md);
                }
            });
            UIHook.run(null, "NewBlockageTool.finish", op, 4);
        });
    }

    @Override
    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        switch (e.getKeyCode()) {
            case 10: {
                this.finish();
            }
        }
        if (NewBlockageTool.isToolUndoEvent(e, this)) {
            this.undo();
            this.repaintSurface();
        }
        if (NewBlockageTool.isToolRedoEvent(e, this)) {
            this.redo();
            this.repaintSurface();
        }
    }

    @Override
    protected boolean consumeKeyEvent(KeyEvent e) {
        return super.consumeKeyEvent(e) || NewBlockageTool.isToolUndoEvent(e, this) || NewBlockageTool.isToolRedoEvent(e, this);
    }

    private static boolean isToolUndoEvent(KeyEvent evt, NewNavMeshRegionTool tool) {
        MerlinActionMap.MerlinCustomUIHelper actionKeyFinder = new MerlinActionMap.MerlinCustomUIHelper();
        KeyStroke ksUndo = actionKeyFinder.getKeyStrokeForID(MerlinActionMap.Shortcut.UNDO.key);
        KeyStroke ksRecv = KeyStroke.getKeyStrokeForEvent(evt);
        return ksUndo != null && ksUndo.equals(ksRecv) && tool.isUndoAvailable();
    }

    private static boolean isToolRedoEvent(KeyEvent evt, NewNavMeshRegionTool tool) {
        MerlinActionMap.MerlinCustomUIHelper actionKeyFinder = new MerlinActionMap.MerlinCustomUIHelper();
        KeyStroke ksRedo = actionKeyFinder.getKeyStrokeForID(MerlinActionMap.Shortcut.REDO.key);
        KeyStroke ksRecv = KeyStroke.getKeyStrokeForEvent(evt);
        return ksRedo != null && ksRedo.equals(ksRecv) && tool.isRedoAvailable();
    }
}

