/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import merlin.Intl;
import merlin.builders.AgentRegionDropper;
import merlin.data.MerlinData;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.GeomUtil;
import merlin.mv.ModelView;
import merlin.mv.tools.NewNavMeshRegionTool;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.search.ITest;

public class NewAgentRegionTool
extends NewNavMeshRegionTool<AgentRegionDropper> {
    public NewAgentRegionTool(ModelView mv, MerlinData data) {
        super(mv, data, Intl.intl("Occupant Region"), Intl.intl("Click+drag to create an axis-aligned block region or single-click multiple points to create a polygonal region."), Intl.intl("Release to create an axis-aligned block region."), Intl.intl("Continue left-clicking to add more points, or right-click to close the polygon and create the occupants."), (props, shape) -> {
            Model shapeModel = GeomUtil.toNmtModel(data, shape, 0);
            try (MerlinData.ReadLock lock = data.lockRead();){
                Collection<IEgressOccupiable> rooms = data.geomLocation.getLocator().find((ITest<AABox>)shape.getBoundingBox(new AABox()), IEgressOccupiable.class, 0);
                ArrayList<Model> isectModels = new ArrayList<Model>();
                for (IEgressOccupiable room : rooms) {
                    Model roomModel = room.getModel().clone();
                    GeomUtil.RoomObjectIsectInfo<IGeomNode> result = GeomUtil.isectRoomWithObjects(roomModel, Collections.singleton(shape), s -> shapeModel);
                    if (result.isEmpty()) continue;
                    Model tModel = new Model();
                    for (Face face : result.getFaces((IGeomNode)shape)) {
                        tModel.addFace(face);
                    }
                    isectModels.add(tModel);
                }
                if (!isectModels.isEmpty()) {
                    props.create(mv.getMainPanel(), isectModels);
                }
            }
        });
    }
}

